<?php


namespace WBCR\Titan\Client\Entity;


use WBCR\Titan\Client\Loader;

/**
 * Class Vulnerability
 * @package WBCR\Titan\Client\Entity
 *
 * @author  Alexander Gorenkov <g.a.androidjc2@ya.ru>
 */
class Vulnerability extends Loader {
	/**
	 * @var string
	 */
	public $name;
	/**
	 * @var string|null
	 */
	public $description;
	/**
	 * @var string
	 */
	public $safe_version;
	/**
	 * @var string[]|null
	 */
	public $cve;
	/**
	 * @var string|null
	 */
	public $slug;
	/**
-	 * @var string|null
-	 */
	public $path;
	/**
	 * @var string
	 */
	public $min_affected_version;
	/**
	 * @var string
	 */
	public $max_affected_version;

	/**
	 * Vulnerability constructor.
	 *
	 * @param string        $name
	 * @param string|null   $description
	 * @param string        $min_affected_version
	 * @param string        $max_affected_version
	 * @param string        $safe_version
	 * @param string[]|null $cve
	 * @param string|null   $slug
	 */
	public function __construct( $name, $description, $min_affected_version, $max_affected_version, $safe_version, $cve, $slug ) {
		$this->name         = $name;
		$this->description  = $description;
		$this->safe_version = $safe_version;
		$this->min_affected_version = $min_affected_version;
		$this->max_affected_version = $max_affected_version;
		$this->cve          = $cve;
		$this->slug         = $slug;
	}
}