<?php
include_once($_SERVER['DOCUMENT_ROOT'].'/wp-load.php');
global $wpdb, $blog_id;
//Set time for everything
$spam_master_time = current_time('mysql');
//only get the last 1 day of threats/ips
$spam_master_time_week = date("Y-m-d H:i:s",strtotime($spam_master_time."-7 days"));
if( is_multisite() ){
	$response_key = get_blog_option( $blog_id, 'spam_master_status');
	$admin_email = get_blog_option($blog_id, 'admin_email');
	$blogname = get_blog_option($blog_id, 'blogname');
	if(empty($blogname)){
		$blogname = 'your blog';
	}
	$spam_master_emails_weekly_email_date = get_blog_option($blog_id, 'spam_master_emails_weekly_email_date');
	$spam_master_alert_level = get_blog_option($blog_id, 'spam_master_alert_level');
	$spam_master_alert_level_p_text = get_blog_option($blog_id, 'spam_master_alert_level_p_text');
	$spam_master_protection_total_number = get_blog_option($blog_id, 'spam_master_protection_total_number');
	$spam_master_block_count = get_blog_option($blog_id, 'spam_master_block_count');
	$spam_master_comments_status = get_blog_option($blog_id, 'default_comment_status');
	$spam_master_contacts_status = get_blog_option($blog_id, 'spam_master_integrations_contact_form_7');
	$contact_text_override = get_blog_option($blog_id, 'contact_text_override');
	$spam_master_registration_status = get_blog_option($blog_id, 'users_can_register');
	$spam_master_firewall_on = get_blog_option($blog_id, 'spam_master_firewall_on');
	$spam_master_learning_active = get_blog_option($blog_id, 'spam_master_learning_active');
	$comment_russian_char = get_blog_option($blog_id, 'comment_russian_char');
	$comment_chinese_char = get_blog_option($blog_id, 'comment_chinese_char');
	$comment_asian_char = get_blog_option($blog_id, 'comment_asian_char');
	$comment_arabic_char = get_blog_option($blog_id, 'comment_arabic_char');
	$comment_spam_char = get_blog_option($blog_id, 'comment_spam_char');
	$contact_russian_char = get_blog_option($blog_id, 'contact_russian_char');
	$contact_chinese_char = get_blog_option($blog_id, 'contact_chinese_char');
	$contact_asian_char = get_blog_option($blog_id, 'contact_asian_char');
	$contact_arabic_char = get_blog_option($blog_id, 'contact_arabic_char');
	$contact_spam_char = get_blog_option($blog_id, 'contact_spam_char');
	$spam_master_emails_extra_email = get_blog_option($blog_id, 'spam_master_emails_extra_email');
	$spam_master_emails_extra_email_list = get_blog_option($blog_id, 'spam_master_emails_extra_email_list');
	$spam_master_integrations_woocommerce = get_blog_option($blog_id, 'spam_master_integrations_woocommerce');
	$spam_master_recaptcha_registration = get_blog_option($blog_id, 'spam_master_recaptcha_registration');
	$spam_master_recaptcha_login = get_blog_option($blog_id, 'spam_master_recaptcha_login');
	$spam_master_recaptcha_comments = get_blog_option($blog_id, 'spam_master_recaptcha_comments');
	$spam_master_honeypot_timetrap = get_blog_option($blog_id, 'spam_master_honeypot_timetrap');
	
	//Prepare Tables
	$table_prefix = $wpdb->base_prefix;
	$table_threats = $wpdb->get_blog_prefix($blog_id)."spam_master_threats";
	$table_white = $wpdb->get_blog_prefix($blog_id)."spam_master_white";
	$table_keys = $wpdb->get_blog_prefix($blog_id)."spam_master_keys";
	//Get users
	$spam_master_user_registrations = $wpdb->get_var("SELECT COUNT(umeta_id) FROM {$table_prefix}usermeta WHERE meta_key='primary_blog' AND meta_value={$blog_id}");
	//All Firewall
	$spam_master_total_block_count = $wpdb->get_var("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Firewall' OR spamkey = 'Registration' OR spamkey = 'Woocommerce' OR spamkey = 'Comment' OR spamkey = 'Contact-Form'");
	$spam_master_weekly_block_count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Firewall' OR spamkey = 'Registration' OR spamkey = 'Woocommerce' OR spamkey = 'Comment' OR spamkey = 'Contact-Form' AND (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//Registration
	$spam_master_total_users_block_count = $wpdb->get_var("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Registration' OR spamkey = 'Woocommerce'");
	$spam_master_weekly_users_block_count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Registration' OR spamkey = 'Woocommerce' AND (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//Comments
	$spam_master_total_comment_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Comment'");
	$spam_master_weekly_comment_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Comment' AND (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//Contacts
	$spam_master_total_contact_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Contact-Form'");
	$spam_master_weekly_contact_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Contact-Form' AND (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//System
	$spam_master_total_system_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'System'");
	$spam_master_weekly_system_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'System' AND (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//All Logging
	$spam_master_total_logging_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_keys");
	$spam_master_weekly_logging_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//Spam Buffer
	$spam_master_total_buffer_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_threats");
	$spam_master_weekly_buffer_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_threats WHERE (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//WhiteList
	$spam_master_total_white_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_white");
	$spam_master_weekly_white_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_white WHERE (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
}
else{
	$response_key = get_option('spam_master_status');
	$admin_email = get_option('admin_email');
	$blogname = get_option('blogname');
	if(empty($blogname)){
		$blogname = 'your blog';
	}
	$spam_master_emails_weekly_email_date = get_option('spam_master_emails_weekly_email_date');
	$spam_master_alert_level = get_option('spam_master_alert_level');
	$spam_master_alert_level_p_text = get_option('spam_master_alert_level_p_text');
	$spam_master_protection_total_number = get_option('spam_master_protection_total_number');
	$spam_master_block_count = get_option('spam_master_block_count');
	$spam_master_comments_status = get_option('default_comment_status');
	$spam_master_contacts_status = get_option('spam_master_integrations_contact_form_7');
	$contact_text_override = get_option('contact_text_override');
	$spam_master_registration_status = get_option('users_can_register');
	$spam_master_firewall_on = get_option('spam_master_firewall_on');
	$spam_master_learning_active = get_option('spam_master_learning_active');
	$comment_russian_char = get_option('comment_russian_char');
	$comment_chinese_char = get_option('comment_chinese_char');
	$comment_asian_char = get_option('comment_asian_char');
	$comment_arabic_char = get_option('comment_arabic_char');
	$comment_spam_char = get_option('comment_spam_char');
	$contact_russian_char = get_option('contact_russian_char');
	$contact_chinese_char = get_option('contact_chinese_char');
	$contact_asian_char = get_option('contact_asian_char');
	$contact_arabic_char = get_option('contact_arabic_char');
	$contact_spam_char = get_option('contact_spam_char');
	$spam_master_emails_extra_email = get_option('spam_master_emails_extra_email');
	$spam_master_emails_extra_email_list = get_option('spam_master_emails_extra_email_list');
	$spam_master_integrations_woocommerce = get_option('spam_master_integrations_woocommerce');
	$spam_master_recaptcha_registration = get_option('spam_master_recaptcha_registration');
	$spam_master_recaptcha_login = get_option('spam_master_recaptcha_login');
	$spam_master_recaptcha_comments = get_option('spam_master_recaptcha_comments');
	$spam_master_honeypot_timetrap = get_option('spam_master_honeypot_timetrap');
	
	//Prepare Tables
	$table_threats = $wpdb->prefix."spam_master_threats";
	$table_white = $wpdb->prefix."spam_master_white";
	$table_keys = $wpdb->prefix."spam_master_keys";
	//Get users
	$spam_master_user_registrations = $wpdb->get_var("SELECT COUNT(ID) FROM $wpdb->users");
	//All Firewall
	$spam_master_total_block_count = $wpdb->get_var("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Firewall' OR spamkey = 'Registration' OR spamkey = 'Woocommerce' OR spamkey = 'Comment' OR spamkey = 'Contact-Form'");
	$spam_master_weekly_block_count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Firewall' OR spamkey = 'Registration' OR spamkey = 'Woocommerce' OR spamkey = 'Comment' OR spamkey = 'Contact-Form' AND (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//Registration
	$spam_master_total_users_block_count = $wpdb->get_var("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Registration' OR spamkey = 'Woocommerce'");
	$spam_master_weekly_users_block_count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Registration' OR spamkey = 'Woocommerce' AND (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//Comments
	$spam_master_total_comment_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Comment' OR spamkey = 'Contact-Form'");
	$spam_master_weekly_comment_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'Comment' OR spamkey = 'Contact-Form' AND (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//System
	$spam_master_total_system_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'System'");
	$spam_master_weekly_system_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE spamkey = 'System' AND (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//All Logging
	$spam_master_total_logging_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_keys");
	$spam_master_weekly_logging_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_keys WHERE (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//Spam Buffer
	$spam_master_total_buffer_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_threats");
	$spam_master_weekly_buffer_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_threats WHERE (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));
	//WhiteList
	$spam_master_total_white_count =  $wpdb->get_var("SELECT COUNT(*) FROM $table_white");
	$spam_master_weekly_white_count =  $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_white WHERE (time BETWEEN %s AND %s)", $spam_master_time_week, $spam_master_time ));

}
if($spam_master_alert_level == 'ALERT_0'){
	$spam_master_alert_level_deconstructed = '0';
}
if($spam_master_alert_level == 'ALERT_1'){
	$spam_master_alert_level_deconstructed = '1';
}
if($spam_master_alert_level == 'ALERT_2'){
	$spam_master_alert_level_deconstructed = '2';
}
if($response_key == 'VALID'){
	$spam_master_warning = false;
	$spam_master_warning_signature = '<p>All is good.</p>';
}
if($response_key == 'MALFUNCTION_1'){
	$spam_master_warning = '<li>Warnings: <b>Malfunction 1, please update Spam Master to the latest version</b></li>';
	$spam_master_warning_signature = '<p>Please correct the warnings.</p>';
}
if($response_key == 'MALFUNCTION_2'){
	$spam_master_warning = '<li>Warnings: <b>Malfunction 2, urgently update Spam Master, your installed version is extremely old</b></li>';
	$spam_master_warning_signature = '<p>Please correct the warnings.</p>';
}
if($spam_master_block_count <= '10'){
	$spam_master_block_count_result = '<li>Total Blocks: <b>good, less than 10 since beginning of time</b></li>';
}
if($spam_master_block_count >= '11'){
	$spam_master_block_count_result = '<li>Total Blocks: <b>'.number_format($spam_master_block_count).' since beginning of time</b></li>';
}
if($spam_master_firewall_on == 'true'){
	$spam_master_firewall_on_result = 'Online';
}
else{
	$spam_master_firewall_on_result = 'Offline';
}
if($spam_master_learning_active == 'true'){
	$spam_master_learning_active_result = 'Online';
}
else{
	$spam_master_learning_active_result = 'Offline';
}
if(empty($spam_master_total_comment_count) || $spam_master_total_comment_count == '0'){
	$spam_master_total_comment_count_text = 'Good no entries';
}
else{
	$spam_master_total_comment_count_text = number_format($spam_master_total_comment_count);
}
if(empty($spam_master_weekly_comment_count) || $spam_master_weekly_comment_count == '0'){
	$spam_master_weekly_comment_count_text = 'Good no Weekly entries';
}
else{
	$spam_master_weekly_comment_count_text = number_format($spam_master_weekly_comment_count);
}
//Comment
if($spam_master_comments_status == 'open'){
	$spam_master_comments_status_result = '<li>Comments Scan: <b>Active</b>';
	//Comment Spam Char
	if($comment_russian_char == 'true'){
		$comment_russian_char_result = 'Scan Active';
	}
	else{
		$comment_russian_char_result = 'Scan not active';
	}
	if($comment_chinese_char == 'true'){
		$comment_chinese_char_result = 'Scan Active';
	}
	else{
		$comment_chinese_char_result = 'Scan not active';
	}
	if($comment_asian_char == 'true'){
		$comment_asian_char_result = 'Scan Active';
	}
	else{
		$comment_asian_char_result = 'Scan not active';
	}
	if($comment_arabic_char == 'true'){
		$comment_arabic_char_result = 'Scan Active';
	}
	else{
		$comment_arabic_char_result = 'Scan not active';
	}
	if($comment_spam_char == 'true'){
		$comment_spam_char_result = 'Scan Active';
	}
	else{
		$comment_spam_char_result = 'Scan not active';
	}
}
else{
	$spam_master_comments_status_result = '<li>Comments Scan: <b>Inactive</b>';
	$comment_russian_char_result = 'Scan not active';
	$comment_chinese_char_result = 'Scan not active';
	$comment_asian_char_result = 'Scan not active';
	$comment_arabic_char_result = 'Scan not active';
	$comment_spam_char_result = 'Scan not active';
}
//Contact
if($spam_master_contacts_status == 'true'){
	$spam_master_contacts_status_result = '<li>Contact Form Scan: <b>Active</b>';
	if($contact_text_override == 'true'){
		$contact_text_override_result = 'Active';
		$contact_russian_char_result = 'Scan not active';
		$contact_chinese_char_result = 'Scan not active';
		$contact_asian_char_result = 'Scan not active';
		$contact_arabic_char_result = 'Scan not active';
		$contact_spam_char_result = 'Scan not active';
	}
	else{
		$contact_text_override_result = 'Inactive';
		//Contact Spam Char
		if($contact_russian_char == 'true'){
			$contact_russian_char_result = 'Scan Active';
		}
		else{
			$contact_russian_char_result = 'Scan not active';
		}
		if($contact_chinese_char == 'true'){
			$contact_chinese_char_result = 'Scan Active';
		}
		else{
			$contact_chinese_char_result = 'Scan not active';
		}
		if($contact_asian_char == 'true'){
			$contact_asian_char_result = 'Scan Active';
		}
		else{
			$contact_asian_char_result = 'Scan not active';
		}
		if($contact_arabic_char == 'true'){
			$contact_arabic_char_result = 'Scan Active';
		}
		else{
			$contact_arabic_char_result = 'Scan not active';
		}
		if($contact_spam_char == 'true'){
			$contact_spam_char_result = 'Scan Active';
		}
		else{
			$contact_spam_char_result = 'Scan not active';
		}
	}
}
else{
	$spam_master_contacts_status_result = '<li>Contact Form Scan: <b>Inactive</b>';
	$contact_text_override_result = 'Inactive';
	$contact_russian_char_result = 'Scan not active';
	$contact_chinese_char_result = 'Scan not active';
	$contact_asian_char_result = 'Scan not active';
	$contact_arabic_char_result = 'Scan not active';
	$contact_spam_char_result = 'Scan not active';
}
if(empty($spam_master_total_contact_count) || $spam_master_total_contact_count == '0'){
	$spam_master_total_contact_count_text = 'Good no entries';
}
else{
	$spam_master_total_contact_count_text = number_format($spam_master_total_contact_count);
}
if(empty($spam_master_weekly_contact_count) || $spam_master_weekly_contact_count == '0'){
	$spam_master_weekly_contact_count_text = 'Good no Weekly entries';
}
else{
	$spam_master_weekly_contact_count_text = number_format($spam_master_weekly_contact_count);
}
//Prepare Woocommerce
if($spam_master_integrations_woocommerce == 'true'){
	$woocommerce_scan_result = '<li>Woocommerce Scan: <b>Active</b></li>';
}
else{
	$woocommerce_scan_result = '';
}
//Prepare Firewall
if(empty($spam_master_total_block_count) || $spam_master_total_block_count == '0'){
	$spam_master_total_block_count_text = 'Good no entries';
}
else{
	$spam_master_total_block_count_text = number_format($spam_master_total_block_count);
}
if(empty($spam_master_weekly_block_count) || $spam_master_weekly_block_count == '0'){
	$spam_master_weekly_block_count_text = 'Good no Weekly entries';
}
else{
	$spam_master_weekly_block_count_text = number_format($spam_master_weekly_block_count);
}
//Prepare Buffer
if(empty($spam_master_total_buffer_count) || $spam_master_total_buffer_count == '0'){
	$spam_master_total_buffer_count_text = 'Good no entries';
}
else{
	$spam_master_total_buffer_count_text = number_format($spam_master_total_buffer_count);
}
if(empty($spam_master_weekly_buffer_count) || $spam_master_weekly_buffer_count == '0'){
	$spam_master_weekly_buffer_count_text = 'Good no Weekly entries';
}
else{
	$spam_master_weekly_buffer_count_text = number_format($spam_master_weekly_buffer_count);
}
//Prepare White
if(empty($spam_master_total_white_count) || $spam_master_total_white_count == '0'){
	$spam_master_total_white_count_text = 'No Exclusions';
}
else{
	$spam_master_total_white_count_text = number_format($spam_master_total_white_count);
}
if(empty($spam_master_weekly_white_count) || $spam_master_weekly_white_count == '0'){
	$spam_master_weekly_white_count_text = 'No Weekly Exclusions';
}
else{
	$spam_master_weekly_white_count_text = number_format($spam_master_weekly_white_count);
}
//Registrations
if($spam_master_registration_status == '1'){
	$spam_master_registration_status_result = '<li>Registration Status: <b>Open</b>';
}
else{
	$spam_master_registration_status_result = '<li>Registration Status: <b>Closed</b>';
}
if(empty($spam_master_total_users_block_count) || $spam_master_total_users_block_count == '0'){
	$spam_master_total_users_block_count_text = 'Good no entries';
}
else{
	$spam_master_total_users_block_count_text = number_format($spam_master_total_users_block_count);
}
if(empty($spam_master_weekly_users_block_count) || $spam_master_weekly_users_block_count == '0'){
	$spam_master_weekly_users_block_count_text = 'Good no Weekly entries';
}
else{
	$spam_master_weekly_users_block_count_text = number_format($spam_master_weekly_users_block_count);
}
//System
if(empty($spam_master_total_system_count) || $spam_master_total_system_count == '0'){
	$spam_master_total_system_count_text = 'Good no entries';
}
else{
	$spam_master_total_system_count_text = number_format($spam_master_total_system_count);
}
if(empty($spam_master_weekly_system_count) || $spam_master_weekly_system_count == '0'){
	$spam_master_weekly_system_count_text = 'Good no Weekly entries';
}
else{
	$spam_master_weekly_system_count_text = number_format($spam_master_weekly_system_count);
}
//All Logs
if(empty($spam_master_total_logging_count) || $spam_master_total_logging_count == '0'){
	$spam_master_total_logging_count_text = 'Good no entries';
}
else{
	$spam_master_total_logging_count_text = number_format($spam_master_total_logging_count);
}
if(empty($spam_master_weekly_logging_count) || $spam_master_weekly_logging_count == '0'){
	$spam_master_weekly_logging_count_text = 'Good no Weekly entries';
}
else{
	$spam_master_weekly_logging_count_text = number_format($spam_master_weekly_logging_count);
}
//Recaptcha
if($spam_master_recaptcha_registration == 'true'){
	$spam_master_recaptcha_registration_status = 'Active';
}
else{
	$spam_master_recaptcha_registration_status = 'Inactive';
}
if($spam_master_recaptcha_login == 'true'){
	$spam_master_recaptcha_login_status = 'Active';
}
else{
	$spam_master_recaptcha_login_status = 'Inactive';
}
if($spam_master_recaptcha_comments == 'true'){
	$spam_master_recaptcha_comments_status = 'Active';
}
else{
	$spam_master_recaptcha_comments_status = 'Inactive';
}
//Hoenypot
if($spam_master_honeypot_timetrap == 'true'){
	$spam_master_honeypot_timetrap_status = 'Active';
}
else{
	$spam_master_honeypot_timetrap_status = 'Inactive';
}
//get extra emails
if($spam_master_emails_extra_email == 'true'){
	if(!empty($spam_master_emails_extra_email_list)){
		$spam_master_more_emails = ','.$spam_master_emails_extra_email_list;
	}
	else{
		$spam_master_more_emails = false;
	}
}
else{
	$spam_master_more_emails = false;
}
//set date
$spam_master_emails_current_email_date = current_time('Y-m-d');
//only run if dates !=
if($spam_master_emails_current_email_date != $spam_master_emails_weekly_email_date){
	if($response_key == 'VALID' || $response_key == 'MALFUNCTION_1' || $response_key == 'MALFUNCTION_2'){
		//email user
		//set mail html
		add_filter( 'wp_mail_content_type', 'spam_master_send_weekly_report_html' );
		function spam_master_send_weekly_report_html(){
			return 'text/html';
		}
		//Email Subject Title Header
		$spam_master_subject_title = 'Weekly Report';
		$spam_master_html = '<!DOCTYPE html><html>';
		$spam_master_header = '<head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><title>'.$spam_master_subject_title.'</title></head>';
		$spam_master_body = '<body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" style="background-color: #f6f6f6; font-family: &apos;Helvetica Neue&apos;, Helvetica, Arial, &apos;Lucida Grande&apos;, sans-serif;">';
		$spam_master_table_header = '<div style="width:100%; -webkit-text-size-adjust:none !important; margin:0; padding: 70px 0 70px 0;">
<table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%">
<tr>
<td align="center" valign="top">
<table border="0" cellpadding="0" cellspacing="0" width="520" id="template_container" style="box-shadow:0 0 0 1px #f3f3f3 !important; border-radius:3px !important; background-color: #ffffff; border: 1px solid #e9e9e9; border-radius:3px !important; padding: 20px;">
<tr>
<td align="center" valign="top">
<table border="0" cellpadding="0" cellspacing="0" width="520" id="template_header" style=" color: #00000; border-top-left-radius:3px !important; border-top-right-radius:3px !important; border-bottom: 0; font-weight:bold; line-height:100%; text-align: center; vertical-align:middle;" bgcolor="#ffffff">
<tr>
<td>
<h1 style="color: #000000; margin:0; padding: 28px 24px; display:block; font-family: &apos;Helvetica Neue&apos;, Helvetica, Arial, &apos;Lucida Grande&apos;, sans-serif; font-size:32px; font-weight: 500; line-height: 1.2;">
'.$spam_master_subject_title.'
</h1></td></tr></table></td></tr>';
$spam_master_table_body = '<tr>
<td align="center" valign="top">
<table border="0" cellpadding="0" cellspacing="0" width="520" id="template_body">
<tr>
<td valign="top" style="border-radius:3px !important; font-family: &apos;Helvetica Neue&apos;, Helvetica, Arial, &apos;Lucida Grande&apos;, sans-serif;">
<table border="0" cellpadding="20" cellspacing="0" width="100%">
<tr>
<td valign="top">
<div style="color: #000000; font-size:14px; font-family: &apos;Helvetica Neue&apos;, Helvetica, Arial, &apos;Lucida Grande&apos;, sans-serif; line-height:150%; text-align:left;">';
//Email Content
$spam_master_table_content = '<p>Spam Master Weekly Report for '.$blogname.'</p>
<ul>
'.$spam_master_warning.'
<li>Alert Level: <b>'.$spam_master_alert_level_deconstructed.'</b></li>
<li>Spam Probability: <b>'.$spam_master_alert_level_p_text.'%</b></li>
<li>Protected Against: <b>'.number_format($spam_master_protection_total_number).' threats</b></li>
<li>Spam Learning: <b>'.$spam_master_learning_active_result.'</b></li>
'.$spam_master_block_count_result.'
<li>Spam Firewall: <b>'.$spam_master_firewall_on_result.'</b>
<ul>
<li>reCaptcha Login: <b>'.$spam_master_recaptcha_login_status.'</b></li>
<li>reCaptcha Registration: <b>'.$spam_master_recaptcha_registration_status.'</b></li>
<li>reCaptcha Comment: <b>'.$spam_master_recaptcha_comments_status.'</b></li>
<li>Honeypot Time Trap: <b>'.$spam_master_honeypot_timetrap_status.'</b></li>
<li>Firewall Total Entries: <b>'.$spam_master_total_block_count_text.'</b></li>
<li>Firewall Weekly Entries: <b>'.$spam_master_weekly_block_count_text.'</b></li>
</ul>
</li>
<li>Spam Buffer: <b>Healthy</b>
<ul>
<li>Total Blacklist Size: <b>'.$spam_master_total_buffer_count_text.'</b></li>
<li>Weekly Blacklist Size: <b>'.$spam_master_weekly_buffer_count_text.'</b></li>
<li>Total Whitelist Size: <b>'.$spam_master_total_white_count_text.'</b></li>
<li>Weekly Whitelist Size: <b>'.$spam_master_weekly_white_count_text.'</b></li>
</ul>
</li>'.
$spam_master_registration_status_result.'
<ul>'.
$woocommerce_scan_result.'
<li>Total Users: <b>'.number_format($spam_master_user_registrations).' registrations</b></li>
<li>Registration Total Entries: <b>'.$spam_master_total_users_block_count_text.'</b></li>
<li>Registration Weekly Entries: <b>'.$spam_master_weekly_users_block_count_text.'</b></li>
</ul>
</li>'.
$spam_master_comments_status_result.'
<ul>
<li>Comment Russian Chars: <b>'.$comment_russian_char_result.'</b></li>
<li>Comment Chinese Chars: <b>'.$comment_chinese_char_result.'</b></li>
<li>Comment Asian Chars: <b>'.$comment_asian_char_result.'</b></li>
<li>Comment Arabic Chars: <b>'.$comment_arabic_char_result.'</b></li>
<li>Comment Spam Chars: <b>'.$comment_spam_char_result.'</b></li>
<li>Comment Total Entries: <b>'.$spam_master_total_comment_count_text.'</b></li>
<li>Comment Weekly Entries: <b>'.$spam_master_weekly_comment_count_text.'</b></li>
</ul>
</li>'.
$spam_master_contacts_status_result.'
<ul>
<li>Text Scan Override: <b>'.$contact_text_override_result.'</b></li>
<li>Contact Russian Chars: <b>'.$contact_russian_char_result.'</b></li>
<li>Contact Chinese Chars: <b>'.$contact_chinese_char_result.'</b></li>
<li>Contact Asian Chars: <b>'.$contact_asian_char_result.'</b></li>
<li>Contact Arabic Chars: <b>'.$contact_arabic_char_result.'</b></li>
<li>Contact Spam Chars: <b>'.$contact_spam_char_result.'</b></li>
<li>Contact Total Entries: <b>'.$spam_master_total_contact_count_text.'</b></li>
<li>Contact Weekly Entries: <b>'.$spam_master_weekly_contact_count_text.'</b></li>
</ul>
</li>
<li>Total System Entries: <b>'.$spam_master_total_system_count_text.'</b></li>
<li>Weekly System Entries: <b>'.$spam_master_weekly_system_count_text.'</b></li>
<li>Total Logging Entries: <b>'.$spam_master_total_logging_count_text.'</b></li>
<li>Weekly Logging Entries: <b>'.$spam_master_weekly_logging_count_text.'</b></li>
'.$spam_master_warning_signature.'
<p>The weekly report email can be turned off in Spam Master Protection Tools page, Emails & Reporting section.</p>
<br>
<p>See you next week!</p>
<p>TechGasp Team</p>';
$spam_master_table_content_close = '</div>
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>';
$spam_master_table_footer_start = '<tr>
<td align="center" valign="top">
<table border="0" cellpadding="10" cellspacing="0" width="600" id="template_footer" style="border-top:0; -webkit-border-radius:3px;">
<tr>
<td valign="top">
<table border="0" cellpadding="10" cellspacing="0" width="100%">
<tr>
<td colspan="2" valign="middle" id="credit" style="border:0; color: #000000; font-family: &apos;Helvetica Neue&apos;, Helvetica, Arial, &apos;Lucida Grande&apos;, sans-serif; font-size:14px; line-height:125%; text-align:center;">';
$spam_master_table_footer_content = '<p><a href="https://www.wordpress.org/plugins/spam-master/" target="_blank">Share the love, please rate us on WordPress.org</a></p>';
$spam_master_email_close = '</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>
</table>
</div>
</body>
</html>';
		//send email
		$from = $admin_email;
		$to = $admin_email.$spam_master_more_emails;
		$subject = $spam_master_subject_title;
		$headers = array ('From' => $from, 'To' => $to, 'Subject' => $subject);
		$message = $spam_master_html.
					$spam_master_header.
					$spam_master_body.
					$spam_master_table_header.
					$spam_master_table_body.
					$spam_master_table_content.
					$spam_master_table_content_close.
					$spam_master_table_footer_start.
					$spam_master_table_footer_content.
					$spam_master_email_close;
		wp_mail( $to, $subject, $message, $headers );	
		// Reset content-type to avoid conflicts
		remove_filter( 'wp_mail_content_type', 'spam_master_send_weekly_report_html' );

		//Set date option
		if( is_multisite() ){
			update_blog_option($blog_id, 'spam_master_emails_weekly_email_date', $spam_master_emails_current_email_date);
		}
		else{
			update_option('spam_master_emails_weekly_email_date', $spam_master_emails_current_email_date);
		}
		//Log
		$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Report: Weekly Email successfully sent.' ));
	}
}
?>
