<?php
if(!class_exists('WP_List_Table')){
	require_once( get_home_path() . 'wp-admin/includes/class-wp-list-table.php' );
}
class spam_master_firewall_table_blocked extends WP_List_Table {
	/**
	 * Constructor, we override the parent to pass our own arguments
	 * We usually focus on three parameters: singular and plural labels, as well as whether the class supports AJAX.
	 */
	 function __construct() {
		 parent::__construct( array(
		'singular'=> 'singular_form', //Singular label
		'plural' => 'plural_form', //plural label, also this well be one of the table css class
		'ajax'	=> false //We won't support Ajax for this table
		) );
	 }

	/**
	 * Define the columns that are going to be used in the table
	 * @return array $columns, the array of columns to use with the table
	 */
	function get_columns() {
		$columns = array(
						'col_blocks_time' => __('Date'),
						'col_blocks_type' => __('Type'),
						'col_blocks_details' => __('Details'),
		);
		return $columns;
	}

	public function get_hidden_columns(){
		// Setup Hidden columns and return them
		return array();
	}
	/**
	 * Decide which columns to activate the sorting functionality on
	 * @return array $sortable, the array of columns that can be sorted by the user
	 */
	public function get_sortable_columns(){
		$sortable_columns = array(
								'col_blocks_time'		=>	array('time',false),
								'col_blocks_type'		=>	array('spamkey',false),
								'col_blocks_details'	=>	array('spamvalue',false),
							);
		return $sortable_columns;
	}

	/** * 
	Retrieve records data from the database
	* * @param int $per_page
	* @param int $page_number
	* * @return mixed
	*/
	public static function get_records($per_page, $page_number){
	global $wpdb;

		$table_spam_master_keys = $wpdb->prefix."spam_master_keys";
		$sql = "SELECT * FROM {$table_spam_master_keys}";
		if (isset($_REQUEST['s'])) {
			$search_firewall = esc_sql($_REQUEST['s']);
			$sql.= " WHERE (time LIKE '%".$search_firewall."%' OR spamvalue LIKE '%".$search_firewall."%') AND spamkey = 'Firewall'";
		}
		else{
			$search_firewall = false;
			$sql.= " WHERE spamkey = 'Firewall'";
		}
		if (!empty($_REQUEST['orderby'])) {
			$sql.= ' ORDER BY ' . esc_sql($_REQUEST['orderby']);
			$sql.= !empty($_REQUEST['order']) ? ' ' . esc_sql($_REQUEST['order']) : ' DESC';
		}
		else{
			$sql.= ' ORDER BY id';
			$sql.= !empty($_REQUEST['order']) ? ' ' . esc_sql($_REQUEST['order']) : ' DESC';
		}
		$sql.= " LIMIT $per_page";
		$sql.= ' OFFSET ' . ($page_number - 1) * $per_page;
		$result = $wpdb->get_results($sql, 'ARRAY_A');
		return $result;
	}

	/**
	 * Prepare the table with different parameters, pagination, columns and table elements
	 */
	public function prepare_items(){
		// $this->_column_headers = $this->get_column_info();
		$columns = $this->get_columns();
		$hidden = $this->get_hidden_columns();
		$sortable = $this->get_sortable_columns();
		$this->_column_headers = array(
										$columns,
										$hidden,
										$sortable
										);
		/** Process bulk action */
		$this->process_bulk_action();
		$per_page = $this->get_items_per_page('records_per_page', 25);
		$current_page = $this->get_pagenum();
		$total_items = self::record_count();
		$data = self::get_records($per_page, $current_page);
		$this->set_pagination_args([
									'total_items' => $total_items, //WE have to calculate the total number of items
									'per_page' => $per_page // WE have to determine how many items to show on a page
		]);
		$this->items = $data;
	}

	/**
	 * Display the rows of records in the table
	 * @return string, echo the markup of the rows
	 */
	public function display_rows() {
		global $wpdb;
		//Get the records registered in the prepare_items method
		$records = $this->items;
		//Get the columns registered in the get_columns and get_sortable_columns methods
		list( $columns, $hidden ) = $this->get_column_info();
		//Loop for each record
		if(!empty($records)){
			foreach($records as $key){
				$time = $key['time'];
				$spamkey = $key['spamkey'];
				$spamvalue = $key['spamvalue'];

				//Open the line
				static $row_class = '';
				$row_class = ( $row_class == '' ? ' class="alternate"' : '' );
				echo '<tr '.$row_class.'>';
				foreach ( $columns as $column_name => $column_display_name ) {

					//Style attributes for each col
					$class = 'class="'.$column_name. ' column-'.$column_name.'"';
					$style = '';
					if ( in_array( $column_name, $hidden ) )
					$style = ' style="display:none;"';
					$attributes = $style;
					//Display the cell
					switch ( $column_name ) {
						case 'col_blocks_time':	echo '<td '.$attributes.'>'.stripslashes($time).'</td>';break;
						case 'col_blocks_type':	echo '<td '.$attributes.'>'.stripslashes($spamkey).'</td>';break;
						case 'col_blocks_details':	echo '<td '.$attributes.'>'.stripslashes(wp_strip_all_tags($spamvalue)).'</td>';break;
					}
				}
				echo '</tr>';
			}
		}
	}

	/** 
	* Returns the count of records in the database. 
	* * @return null|string 
	*/
	public static function record_count(){
	global $wpdb;
		$table_spam_master_keys = $wpdb->prefix."spam_master_keys";
		$sql = "SELECT COUNT(*) FROM {$table_spam_master_keys}";
		if (isset($_REQUEST['s'])) {
			$search_firewall = esc_sql($_REQUEST['s']);
			$sql.= " WHERE (time LIKE '%".$search_firewall."%' OR spamvalue LIKE '%".$search_firewall."%') AND spamkey = 'Firewall'";
		}
		else{
			$search_firewall = false;
			$sql.= " WHERE spamkey = 'Firewall'";
		}
		return $wpdb->get_var($sql);
	}

    public function search_box( $text, $input_id ) {
        if ( empty( $_REQUEST['s'] ) && ! $this->has_items() ) {
            return;
        }
 
        $input_id = $input_id . '-search-input';
 
        if ( ! empty( $_REQUEST['orderby'] ) ) {
            echo '<input type="hidden" name="orderby" value="' . esc_attr( $_REQUEST['orderby'] ) . '" />';
        }
        if ( ! empty( $_REQUEST['order'] ) ) {
            echo '<input type="hidden" name="order" value="' . esc_attr( $_REQUEST['order'] ) . '" />';
        }
        if ( ! empty( $_REQUEST['post_mime_type'] ) ) {
            echo '<input type="hidden" name="post_mime_type" value="' . esc_attr( $_REQUEST['post_mime_type'] ) . '" />';
        }
        if ( ! empty( $_REQUEST['detached'] ) ) {
            echo '<input type="hidden" name="detached" value="' . esc_attr( $_REQUEST['detached'] ) . '" />';
        }
        ?>
<p class="search-box">
    <label class="screen-reader-text" for="<?php echo esc_attr( $input_id ); ?>"><?php echo $text; ?>:</label>
    <input type="search" id="<?php echo esc_attr( $input_id ); ?>" name="s" value="<?php _admin_search_query(); ?>" />
        <?php submit_button( $text, '', '', false, array( 'id' => 'search-submit' ) ); ?>
</p>
        <?php
    }

}
