<?php
function menu_anal_single(){
	if ( is_admin() )
		add_submenu_page( 'spam-master', 'Analytics', 'Analytics', 'manage_options', 'spam-master-analytics', 'spam_master_analytics' );
}
///////////////////////
// WORDPRESS ACTIONS //
///////////////////////
if( is_multisite() ) {
	add_action( 'admin_menu', 'menu_anal_single' );
}
else {
	add_action( 'admin_menu', 'menu_anal_single' );
}

function spam_master_analytics(){
global $wpdb, $blog_id;
$plugin_master_name = constant('SPAM_MASTER_NAME');
//get menu page
if(isset($_GET['analytics'])){
	$selected_analytics_menu = $_GET['analytics'];
}
else{
	$selected_analytics_menu = 'empty';
}
//Prepare 31 Days
$spam_master_today = current_time( 'mysql' );
$spam_master_today_minus_15 = date('Y-m-d h:i:s',strtotime($spam_master_today . "-14 days"));
//prepare Table
$table_name = $wpdb->prefix."spam_master_keys";
?>
<div class="wrap">
<h1><?php echo $plugin_master_name; ?> Analytics</h1>

<?php

if(!class_exists('WP_List_Table')){
	require_once( get_home_path() . 'wp-admin/includes/class-wp-list-table.php' );
}

if(!class_exists('spam_master_analytics_menu_table')){
	require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/spam-master-admin-analytics-menu-table.php');
}
//Prepare Table of elements
$wp_list_table = new spam_master_analytics_menu_table();
//Table of elements
$wp_list_table->display();

////////////
/// EMPTY///
////////////
if($selected_analytics_menu == 'empty'){
	if(!class_exists('spam_master_analytics_empty_table')){
		require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/spam-master-admin-analytics-empty-table.php');
	}
	//Prepare Table of elements
	$wp_list_table = new spam_master_analytics_empty_table();
	//Table of elements
	$wp_list_table->display();
}
if($selected_analytics_menu == 'stat'){
	if(!class_exists('spam_master_statistics_table')){
		require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/statistics/spam-master-admin-statistics-table.php');
	}
	?>
	<h1>Statistics</h1>
	<?php
	//Prepare Table of elements
	$wp_list_table = new spam_master_statistics_table();
	//Table of elements
	$wp_list_table->display();
}
if($selected_analytics_menu == 'fire'){
	$total_firewall = $wpdb->get_results(
						$wpdb->prepare(
										"SELECT DAY(time) AS day, MONTH(time) AS month, COUNT(spamkey) AS total FROM $table_name WHERE (time BETWEEN %s AND %s) AND spamkey = 'Firewall' GROUP BY DAY(time) ORDER BY id DESC",
										$spam_master_today_minus_15, $spam_master_today
					));
	if(!empty($total_firewall)){
	?>
<h1>Firewall</h1>
<table class="widefat" cellspacing="0">
	<thead>
		<tr></tr>
	</thead>

	<tfoot>
		<tr></tr>
	</tfoot>

	<tbody>
		<tr>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
      google.charts.load('current', {'packages':['corechart']});
      google.charts.setOnLoadCallback(drawChart);

      function drawChart() {
        var data = google.visualization.arrayToDataTable([
          ['Day', 'Entries'],
			<?php 
			foreach($total_firewall as $spam_firewall){
			$day_firewall = $spam_firewall->day;
			$month_firewall = $spam_firewall->month;
			$value_firewall = $spam_firewall->total;
			?>
			['<?php echo $day_firewall . ' ' . date("M", mktime(0, 0, 0, $month_firewall, 10)); ?>', <?php echo $value_firewall; ?>],
			<?php
			}
			?>
        ]);

        var options = {
          title: '15 Days - Firewall Entries',
          chartArea: {
	        width: "90%",
			},
          curveType: 'function',
          legend: { position: 'bottom' },
          series: {
			0: { color: '#E8052B', pointSize: '10'}
		   },
			logScale:true,
        };

        var chart = new google.visualization.LineChart(document.getElementById('curve_chart'));

        chart.draw(data, options);
      }
</script>
<div id="curve_chart" style="width: 100%; height: 350px"></div>
		</tr>
	</tbody>
</table>
<br>
<?php
	}
	else{
		if(!class_exists('spam_master_analytics_nodata_table')){
			require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/spam-master-admin-analytics-nodata-table.php');
		}
		//Prepare Table of elements
		$wp_list_table = new spam_master_analytics_nodata_table();
		//Table of elements
		$wp_list_table->display();
		?>
		<br>
		<?php
	}

	if(!class_exists('spam_master_firewall_table_blocked')){
		require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/firewall/spam-master-admin-firewall-table-blocked.php');
	}
	//Prepare Table of elements
	$wp_list_table = new spam_master_firewall_table_blocked();
	$wp_list_table->prepare_items();
	?>
	<form method="get">
	<input type="hidden" name="page" value="<?php echo esc_attr($_REQUEST['page']); ?>" />
	<input type="hidden" name="analytics" value="fire" />
	<?php
	$wp_list_table->search_box('search', '-search-input');
	//Table of elements
	$wp_list_table->display();
	?>
	</form>
	<?php

}
if($selected_analytics_menu == 'regi'){
	$total_registration = $wpdb->get_results(
						$wpdb->prepare(
										"SELECT DAY(time) AS day, MONTH(time) AS month, COUNT(spamkey) AS total FROM $table_name WHERE (time BETWEEN %s AND %s) AND (spamkey = 'Registration' OR spamkey = 'Woocommerce') GROUP BY DAY(time) ORDER BY id DESC",
										$spam_master_today_minus_15, $spam_master_today
					));
	if(!empty($total_registration)){
	?>
<h1>Registrations</h1>
<table class="widefat" cellspacing="0">
	<thead>
		<tr></tr>
	</thead>

	<tfoot>
		<tr></tr>
	</tfoot>

	<tbody>
		<tr>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
      google.charts.load('current', {'packages':['corechart']});
      google.charts.setOnLoadCallback(drawChart);

      function drawChart() {
        var data = google.visualization.arrayToDataTable([
          ['Day', 'Entries'],
			<?php 
			foreach($total_registration as $spam_registration){
			$day_registration = $spam_registration->day;
			$month_registration = $spam_registration->month;
			$value_registration = $spam_registration->total;
			?>
			['<?php echo $day_registration . ' ' . date("M", mktime(0, 0, 0, $month_registration, 10)); ?>', <?php echo $value_registration; ?>],
			<?php
			}
			?>
        ]);

        var options = {
          title: '15 Days - Registration Entries',
          chartArea: {
	        width: "90%",
			},
          curveType: 'function',
          legend: { position: 'bottom' },
          series: {
			0: { color: '#E8052B', pointSize: '10'}
		   },
			logScale:true,
        };

        var chart = new google.visualization.LineChart(document.getElementById('curve_chart'));

        chart.draw(data, options);
      }
</script>
<div id="curve_chart" style="width: 100%; height: 350px"></div>
		</tr>
	</tbody>
</table>
<br>
<?php
	}
	else{
		if(!class_exists('spam_master_analytics_nodata_table')){
			require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/spam-master-admin-analytics-nodata-table.php');
		}
		//Prepare Table of elements
		$wp_list_table = new spam_master_analytics_nodata_table();
		//Table of elements
		$wp_list_table->display();
		?>
		<br>
		<?php
	}

	//Prepare Table of elements
	if(!class_exists('spam_master_registrations_table_blocked')){
		require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/registrations/spam-master-admin-registrations-table-blocked.php');
	}
	$wp_list_table = new spam_master_registrations_table_blocked();
	$wp_list_table->prepare_items();
	?>
	<form method="get">
	<input type="hidden" name="page" value="<?php echo esc_attr($_REQUEST['page']); ?>" />
	<input type="hidden" name="analytics" value="regi" />
	<?php
	$wp_list_table->search_box('search', '-search-input');
	//Table of elements
	$wp_list_table->display();
	?>
	</form>
	<?php

}
if($selected_analytics_menu == 'comm'){
	$total_comments = $wpdb->get_results(
						$wpdb->prepare(
										"SELECT DAY(time) AS day, MONTH(time) AS month, COUNT(spamkey) AS total FROM $table_name WHERE (time BETWEEN %s AND %s) AND (spamkey = 'Comment' OR spamkey = 'Contact-Form') GROUP BY DAY(time) ORDER BY id DESC",
										$spam_master_today_minus_15, $spam_master_today
					));
	if(!empty($total_comments)){
?>
<h1>Comments</h1>
<table class="widefat" cellspacing="0">
	<thead>
		<tr></tr>
	</thead>

	<tfoot>
		<tr></tr>
	</tfoot>

	<tbody>
		<tr>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
      google.charts.load('current', {'packages':['corechart']});
      google.charts.setOnLoadCallback(drawChart);

      function drawChart() {
        var data = google.visualization.arrayToDataTable([
          ['Day', 'Entries'],
			<?php 
			foreach($total_comments as $spam_comments){
			$day_comments = $spam_comments->day;
			$month_comments = $spam_comments->month;
			$value_comments = $spam_comments->total;
			?>
			['<?php echo $day_comments . ' ' . date("M", mktime(0, 0, 0, $month_comments, 10)); ?>', <?php echo $value_comments; ?>],
			<?php
			}
			?>
        ]);

        var options = {
          title: '15 Days - Comment Entries',
          chartArea: {
	        width: "90%",
			},
          curveType: 'function',
          legend: { position: 'bottom' },
          series: {
			0: { color: '#E8052B', pointSize: '10'}
		   },
			logScale:true,
        };

        var chart = new google.visualization.LineChart(document.getElementById('curve_chart'));

        chart.draw(data, options);
      }
</script>
<div id="curve_chart" style="width: 100%; height: 350px"></div>
		</tr>
	</tbody>
</table>
<br>
<?php
	}
	else{
		if(!class_exists('spam_master_analytics_nodata_table')){
			require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/spam-master-admin-analytics-nodata-table.php');
		}
		//Prepare Table of elements
		$wp_list_table = new spam_master_analytics_nodata_table();
		//Table of elements
		$wp_list_table->display();
		?>
		<br>
		<?php
	}

	if(!class_exists('spam_master_comments_table_blocked')){
		require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/comments/spam-master-admin-comments-table-blocked.php');
	}
	//Prepare Table of elements
	$wp_list_table = new spam_master_comments_table_blocked();
	$wp_list_table->prepare_items();
	?>
	<form method="get">
	<input type="hidden" name="page" value="<?php echo esc_attr($_REQUEST['page']); ?>" />
	<input type="hidden" name="analytics" value="comm" />
	<?php
	$wp_list_table->search_box('search', '-search-input');
	//Table of elements
	$wp_list_table->display();
	?>
	</form>
	<?php
}
if($selected_analytics_menu == 'syst'){
	$total_system = $wpdb->get_results(
						$wpdb->prepare(
										"SELECT DAY(time) AS day, MONTH(time) AS month, COUNT(spamkey) AS total FROM $table_name WHERE (time BETWEEN %s AND %s) AND spamkey = 'System' GROUP BY DAY(time) ORDER BY id DESC",
										$spam_master_today_minus_15, $spam_master_today
					));
	if(!empty($total_system)){
	?>
<h1>System</h1>
<table class="widefat" cellspacing="0">
	<thead>
		<tr></tr>
	</thead>

	<tfoot>
		<tr></tr>
	</tfoot>

	<tbody>
		<tr>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
      google.charts.load('current', {'packages':['corechart']});
      google.charts.setOnLoadCallback(drawChart);

      function drawChart() {
        var data = google.visualization.arrayToDataTable([
          ['Day', 'Entries'],
			<?php 
			foreach($total_system as $spam_system){
			$day_system = $spam_system->day;
			$month_system = $spam_system->month;
			$value_system = $spam_system->total;
			?>
			['<?php echo $day_system  .' ' . date("M", mktime(0, 0, 0, $month_system, 10)); ?>', <?php echo $value_system; ?>],
			<?php
			}
			?>
        ]);

        var options = {
          title: '15 Days - System Entries',
          chartArea: {
	        width: "90%",
			},
          curveType: 'function',
          legend: { position: 'bottom' },
          series: {
			0: { color: '#E8052B', pointSize: '10'}
		   },
			logScale:true,
        };

        var chart = new google.visualization.LineChart(document.getElementById('curve_chart'));

        chart.draw(data, options);
      }
</script>
<div id="curve_chart" style="width: 100%; height: 350px"></div>
		</tr>
	</tbody>
</table>
<br>
<?php
	}
	else{
		if(!class_exists('spam_master_analytics_nodata_table')){
			require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/spam-master-admin-analytics-nodata-table.php');
		}
		//Prepare Table of elements
		$wp_list_table = new spam_master_analytics_nodata_table();
		//Table of elements
		$wp_list_table->display();
		?>
		<br>
		<?php
	}

	if(!class_exists('spam_master_system_table_blocked')){
		require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/system/spam-master-admin-system-table-blocked.php');
	}
	//Prepare Table of elements
	$wp_list_table = new spam_master_system_table_blocked();
	$wp_list_table->prepare_items();
	?>
	<form method="get">
	<input type="hidden" name="page" value="<?php echo esc_attr($_REQUEST['page']); ?>" />
	<input type="hidden" name="analytics" value="syst" />
	<?php
	$wp_list_table->search_box('search', '-search-input');
	//Table of elements
	$wp_list_table->display();
	?>
	</form>
	<?php

}
if($selected_analytics_menu == 'logs'){
	$total_logs = $wpdb->get_results(
						$wpdb->prepare(
										"SELECT DAY(time) AS day, MONTH(time) AS month, COUNT(spamkey) AS total FROM $table_name WHERE (time BETWEEN %s AND %s) GROUP BY DAY(time) ORDER BY id DESC",
										$spam_master_today_minus_15, $spam_master_today
					));					
	if(!empty($total_logs)){
?>
<h1>Logs</h1>
<table class="widefat" cellspacing="0">
	<thead>
		<tr></tr>
	</thead>

	<tfoot>
		<tr></tr>
	</tfoot>

	<tbody>
		<tr>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
      google.charts.load('current', {'packages':['corechart']});
      google.charts.setOnLoadCallback(drawChart);

      function drawChart() {
        var data = google.visualization.arrayToDataTable([
          ['Day', 'Entries'],
			<?php 
			foreach($total_logs as $spam_logs){
			$day_logs = $spam_logs->day;
			$month_logs = $spam_logs->month;
			$value_logs = $spam_logs->total;
			?>
			['<?php echo $day_logs  .' ' . date("M", mktime(0, 0, 0, $month_logs, 10)); ?>', <?php echo $value_logs; ?>],
			<?php
			}
			?>
        ]);

        var options = {
          title: '15 Days - Logging',
          chartArea: {
	        width: "90%",
			},
          curveType: 'function',
          legend: { position: 'bottom' },
          series: {
			0: { color: '#E8052B', pointSize: '10'}
		   },
			logScale:true,
        };

        var chart = new google.visualization.LineChart(document.getElementById('curve_chart'));

        chart.draw(data, options);
      }
</script>
<div id="curve_chart" style="width: 100%; height: 350px"></div>
		</tr>
	</tbody>
</table>
<br>
<?php
	}
	else{
		if(!class_exists('spam_master_analytics_nodata_table')){
			require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/spam-master-admin-analytics-nodata-table.php');
		}
		//Prepare Table of elements
		$wp_list_table = new spam_master_analytics_nodata_table();
		//Table of elements
		$wp_list_table->display();
		?>
		<br>
		<?php
	}

	if(!class_exists('spam_master_logs_table')){
		require_once( WP_PLUGIN_DIR . '/spam-master/includes/analytics/logs/spam-master-admin-logs-table.php');
	}
	//Prepare Table of elements
	$wp_list_table = new spam_master_logs_table();
	$wp_list_table->prepare_items();
	?>
	<form method="get">
	<input type="hidden" name="page" value="<?php echo esc_attr($_REQUEST['page']); ?>" />
	<input type="hidden" name="analytics" value="logs" />
	<?php
	$wp_list_table->search_box('search', '-search-input');
	//Table of elements
	$wp_list_table->display();
	?>
	</form>
	<?php

}
?>
<br>
<h2>IMPORTANT: Makes no use of Javascript or Ajax to keep your website fast and conflicts free</h2>

<div style="background: url(<?php echo plugins_url('../images/techgasp-hr.png', dirname(__FILE__)); ?>) repeat-x; height: 10px"></div>
<br>
<p>
<a class="button-secondary" href="https://wordpress.techgasp.com" target="_blank" title="Visit Website">More TechGasp Plugins</a>
<a class="button-secondary" href="https://www.techgasp.com/support/" target="_blank" title="TechGasp Support">TechGasp Support</a>
<a class="button-primary" href="https://wordpress.techgasp.com/spam-master/" target="_blank" title="Visit Website"><?php echo $plugin_master_name; ?> Info</a>
<a class="button-primary" href="https://wordpress.techgasp.com/spam-master-documentation/" target="_blank" title="Visit Website"><?php echo $plugin_master_name; ?> Documentation</a>
<a class="button-primary" href="https://wordpress.org/plugins/spam-master/" target="_blank" title="Visit Website">RATE US *****</a>
</p>
</div>
<?php
}
