<?php
if(is_multisite()){
$response_key = get_blog_option($blog_id, 'spam_master_status');
}
else{
$response_key = get_option('spam_master_status');
}
if($response_key == 'VALID' || $response_key == 'MALFUNCTION_1' || $response_key == 'MALFUNCTION_2'){

	add_filter('wpcf7_spam', 'spam_master_contact_form_7');
	function spam_master_contact_form_7($spam){
	global $wpdb, $blog_id;
		//buffer action
		if ( $spam ) {
			return $spam;
		}

		//Remote Ip
		$blog_threat_ip = $_SERVER['REMOTE_ADDR'];

		$blog_threat_type = 'contact-form-7';

		//Prepare Email
		$result_comment_author_email = wp_strip_all_tags($_POST['your-email']);
		if(empty($result_comment_author_email)){
			$result_comment_author_email = 'email-'.date("YmdHis");
		}

		//Add Tables
		$table_threats = $wpdb->prefix."spam_master_threats";
		$table_keys = $wpdb->prefix."spam_master_keys";

		if(is_multisite()){
			$spam_master_alert_level = get_blog_option($blog_id, 'spam_master_alert_level');
			$blog_license_key = get_blog_option($blog_id, 'spam_license_key');
			$contact_text_override = get_blog_option($blog_id, 'contact_text_override');
			$contact_russian_char = get_blog_option($blog_id, 'contact_russian_char');
			$contact_russian_char_set = get_blog_option($blog_id, 'comment_russian_char_set');
			$contact_chinese_char = get_blog_option($blog_id, 'contact_chinese_char');
			$contact_chinese_char_set = get_blog_option($blog_id, 'comment_chinese_char_set');
			$contact_asian_char = get_blog_option($blog_id, 'contact_asian_char');
			$contact_asian_char_set = get_blog_option($blog_id, 'comment_asian_char_set');
			$contact_arabic_char = get_blog_option($blog_id, 'contact_arabic_char');
			$contact_arabic_char_set = get_blog_option($blog_id, 'comment_arabic_char_set');
			$contact_spam_char = get_blog_option($blog_id, 'contact_spam_char');
			$contact_spam_char_set = get_blog_option($blog_id, 'comment_spam_char_set');
		}
		else{
			$spam_master_alert_level = get_option('spam_master_alert_level');
			$blog_license_key = get_option('spam_license_key');
			$contact_text_override = get_option('contact_text_override');
			$contact_russian_char = get_option('contact_russian_char');
			$contact_russian_char_set = get_option('comment_russian_char_set');
			$contact_chinese_char = get_option('contact_chinese_char');
			$contact_chinese_char_set = get_option('comment_chinese_char_set');
			$contact_asian_char = get_option('contact_asian_char');
			$contact_asian_char_set = get_option('comment_asian_char_set');
			$contact_arabic_char = get_option('contact_arabic_char');
			$contact_arabic_char_set = get_option('comment_arabic_char_set');
			$contact_spam_char = get_option('contact_spam_char');
			$contact_spam_char_set = get_option('comment_spam_char_set');
		}

		//Prepare Text
		$result_comment_content_trim = substr($_POST['your-message'],0,360);
		$result_comment_content_clean = wp_strip_all_tags(stripslashes_deep($result_comment_content_trim), true);
		if(empty($result_comment_content_clean)){
			$result_comment_content_clean = 'your-message';
		}
		if($contact_text_override == 'true'){
			$result_comment_content_post = 'text-scan-disabled: '.date("YmdHis");
		}
		else{
			$result_comment_content_post = wp_strip_all_tags(stripslashes_deep($result_comment_content_trim), true);
			if(empty($result_comment_content_post)){
				$result_comment_content_post = 'text-scan-disabled: your-message';
			}
		}

		//First check Alert and Flooding
		if ($spam_master_alert_level == 'ALERT_2' || $spam_master_alert_level == 'ALERT_3'){
			$spam_master_last_contact =  $wpdb->get_var("SELECT time FROM $table_keys WHERE spamkey = 'Contact-Form' ORDER BY time DESC LIMIT 1");
			$flood_date_plus_2 = date('Y-m-d H:i:s', strtotime($spam_master_last_contact . '+ 3 minute'));
			$flood_date = current_time('mysql');
			if($flood_date_plus_2 >= $flood_date){

				$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Contact-Form', 'spamvalue' => 'Alert 2/3 warning, contact form flooding detected from Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email . ', Text: ' . $result_comment_content_clean ));

				return  $result['reason'] = array( 'date_too_late' => wpcf7_get_message( 'date_too_late' ) );
				exit();
			}
		}

		//Log System
		$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Firewall', 'spamvalue' => 'Contact Form 7 Spam Check Triggered. Incoming: '.$blog_threat_ip ));

		///////////////////////////////////
		//lets do a quick character block//
		///////////////////////////////////
		if(empty($contact_text_override) || $contact_text_override == 'false'){
			if ($contact_russian_char == 'true' || $contact_chinese_char == 'true' || $contact_asian_char == 'true' || $contact_arabic_char == 'true' || $contact_spam_char == 'true'){
				//Start Russian
				if ($contact_russian_char == 'true'){
					$blacklist_russian_char_string = $contact_russian_char_set;
					$blacklist_russian_char_array = explode("\n", $blacklist_russian_char_string);
					$blacklist_russian_char_size = sizeof($blacklist_russian_char_array);
					// Analyse List
					for($i = 0; $i < $blacklist_russian_char_size; $i++){
						$blacklist_russian_char_current = trim($blacklist_russian_char_array[$i]);
						//check buffer
						if(stripos($result_comment_content_clean, $blacklist_russian_char_current) !== false){
							//add to buffer	ip and email
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
							//insert transient
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Contact-Form', 'spamvalue' => 'Blocked using Cyrillic Char, ' . $blacklist_russian_char_current . ', Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
							//Report only, create data to be posted
							$blog_web_address = get_site_url();
							$address_unclean = $blog_web_address;
							$address = preg_replace('#^https?://#', '', $address_unclean);
							@$blog_server_ip = $_SERVER['SERVER_ADDR'];
							//if empty ip
							if(empty($blog_server_ip) || $blog_server_ip == '0'){
								@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
							}
							$spam_master_learning_post = array(
																'blog_license_key' => $blog_license_key,
																'blog_threat_ip' => $blog_threat_ip,
																'blog_threat_type' => $blog_threat_type,
																'blog_threat_email' => $result_comment_author_email,
																'blog_threat_content' => 'Cyrillic Char: '. $blacklist_russian_char_current . 'Text: ' .$result_comment_content_clean,
																'blog_web_adress' => $address,
																'blog_server_ip' => $blog_server_ip
														);										
							$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
							$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																										'method' => 'POST',
																										'timeout' => 45,
																										'body' => $spam_master_learning_post
																								));
							if(is_multisite()){
								$blog_prefix = $wpdb->get_blog_prefix($blog_id);
								$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
								exit();
							}
							else{
								$table_prefix = $wpdb->base_prefix;
								$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
								exit();
							}
						//end stripos
						}
					//end for
					}
				//end russian
				}

				//Start Chinese
				if ($contact_chinese_char == 'true'){
					$blacklist_chinese_char_string = $contact_chinese_char_set;
					$blacklist_chinese_char_array = explode("\n", $blacklist_chinese_char_string);
					$blacklist_chinese_char_size = sizeof($blacklist_chinese_char_array);
					// Analyse List
					for($i = 0; $i < $blacklist_chinese_char_size; $i++){
						$blacklist_chinese_char_current = trim($blacklist_chinese_char_array[$i]);
						//check buffer
						if(stripos($result_comment_content_clean, $blacklist_chinese_char_current) !== false){
							//add to buffer	ip and email
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
							//insert transient
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Contact-Form', 'spamvalue' => 'Blocked using Chinese Char, ' . $blacklist_chinese_char_current . ', Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
							//Report only, create data to be posted
							$blog_web_address = get_site_url();
							$address_unclean = $blog_web_address;
							$address = preg_replace('#^https?://#', '', $address_unclean);
							@$blog_server_ip = $_SERVER['SERVER_ADDR'];
							//if empty ip
							if(empty($blog_server_ip) || $blog_server_ip == '0'){
								@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
							}
							$spam_master_learning_post = array(
																'blog_license_key' => $blog_license_key,
																'blog_threat_ip' => $blog_threat_ip,
																'blog_threat_type' => $blog_threat_type,
																'blog_threat_email' => $result_comment_author_email,
																'blog_threat_content' => 'Chinese Char: '. $blacklist_chinese_char_current . 'Text: ' .$result_comment_content_clean,
																'blog_web_adress' => $address,
																'blog_server_ip' => $blog_server_ip
															);										
							$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
							$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																										'method' => 'POST',
																										'timeout' => 45,
																										'body' => $spam_master_learning_post
																								));
							if(is_multisite()){
								$blog_prefix = $wpdb->get_blog_prefix($blog_id);
								$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
								exit();
							}
							else{
								$table_prefix = $wpdb->base_prefix;
								$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
								exit();
							}
						//end stripos
						}
					//end for
					}
				//end chinese
				}

				//Start Asian
				if ($contact_asian_char == 'true'){
					$blacklist_asian_char_string = $contact_asian_char_set;
					$blacklist_asian_char_array = explode("\n", $blacklist_asian_char_string);
					$blacklist_asian_char_size = sizeof($blacklist_asian_char_array);
					// Analyse List
					for($i = 0; $i < $blacklist_asian_char_size; $i++){
						$blacklist_asian_char_current = trim($blacklist_asian_char_array[$i]);
						//check buffer
						if(stripos($result_comment_content_clean, $blacklist_asian_char_current) !== false){
							//add to buffer	ip and email
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
							//insert transient
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Contact-Form', 'spamvalue' => 'Blocked using Asian Char, ' . $blacklist_asian_char_current . ', Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
							//Report only, create data to be posted
							$blog_web_address = get_site_url();
							$address_unclean = $blog_web_address;
							$address = preg_replace('#^https?://#', '', $address_unclean);
							@$blog_server_ip = $_SERVER['SERVER_ADDR'];
							//if empty ip
							if(empty($blog_server_ip) || $blog_server_ip == '0'){
								@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
							}
							$spam_master_learning_post = array(
																'blog_license_key' => $blog_license_key,
																'blog_threat_ip' => $blog_threat_ip,
																'blog_threat_type' => $blog_threat_type,
																'blog_threat_email' => $result_comment_author_email,
																'blog_threat_content' => 'Asian Char: '. $blacklist_asian_char_current . 'Text: ' .$result_comment_content_clean,
																'blog_web_adress' => $address,
																'blog_server_ip' => $blog_server_ip
														);										
							$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
							$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																										'method' => 'POST',
																										'timeout' => 45,
																										'body' => $spam_master_learning_post
																								));
							if(is_multisite()){
								$blog_prefix = $wpdb->get_blog_prefix($blog_id);
								$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
								exit();
							}
							else{
								$table_prefix = $wpdb->base_prefix;
								$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
								exit();
							}
						//end stripos
						}
					//end for
					}
				//end asian
				}

				//Start Arabic
				if ($contact_arabic_char == 'true'){
					$blacklist_arabic_char_string = $contact_arabic_char_set;
					$blacklist_arabic_char_array = explode("\n", $blacklist_arabic_char_string);
					$blacklist_arabic_char_size = sizeof($blacklist_arabic_char_array);
					// Analyse List
					for($i = 0; $i < $blacklist_arabic_char_size; $i++){
						$blacklist_arabic_char_current = trim($blacklist_arabic_char_array[$i]);
						//check buffer
						if(stripos($result_comment_content_clean, $blacklist_arabic_char_current) !== false){
							//add to buffer	ip and email
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
							//insert transient
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Contact-Form', 'spamvalue' => 'Blocked using Arabic Char, ' . $blacklist_arabic_char_current . ', Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
							//Report only, create data to be posted
							$blog_web_address = get_site_url();
							$address_unclean = $blog_web_address;
							$address = preg_replace('#^https?://#', '', $address_unclean);
							@$blog_server_ip = $_SERVER['SERVER_ADDR'];
							//if empty ip
							if(empty($blog_server_ip) || $blog_server_ip == '0'){
								@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
							}
							$spam_master_learning_post = array(
																'blog_license_key' => $blog_license_key,
																'blog_threat_ip' => $blog_threat_ip,
																'blog_threat_type' => $blog_threat_type,
																'blog_threat_email' => $result_comment_author_email,
																'blog_threat_content' => 'Arabic Char: '. $blacklist_arabic_char_current . 'Text: ' .$result_comment_content_clean,
																'blog_web_adress' => $address,
																'blog_server_ip' => $blog_server_ip
														);										
							$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
							$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																										'method' => 'POST',
																										'timeout' => 45,
																										'body' => $spam_master_learning_post
																								));
							if(is_multisite()){
								$blog_prefix = $wpdb->get_blog_prefix($blog_id);
								$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
								exit();
							}
							else{
								$table_prefix = $wpdb->base_prefix;
								$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
								exit();
							}
						//end stripos
						}
					//end for
					}
				//end arabic
				}

				//Start Spam
				if ($contact_spam_char == 'true'){
					$blacklist_spam_char_string = $contact_spam_char_set;
					$blacklist_spam_char_array = explode("\n", $blacklist_spam_char_string);
					$blacklist_spam_char_size = sizeof($blacklist_spam_char_array);
					// Analyse List
					for($i = 0; $i < $blacklist_spam_char_size; $i++){
						$blacklist_spam_char_current = trim($blacklist_spam_char_array[$i]);
						//check buffer
						if(stripos($result_comment_content_clean, $blacklist_spam_char_current) !== false){
							//add to buffer	ip and email
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
							//insert transient
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Contact-Form', 'spamvalue' => 'Blocked using Spam Char, ' . $blacklist_spam_char_current . ', Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
							//Report only, create data to be posted
							$blog_web_address = get_site_url();
							$address_unclean = $blog_web_address;
							$address = preg_replace('#^https?://#', '', $address_unclean);
							@$blog_server_ip = $_SERVER['SERVER_ADDR'];
							//if empty ip
							if(empty($blog_server_ip) || $blog_server_ip == '0'){
								@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
							}
							$spam_master_learning_post = array(
																'blog_license_key' => $blog_license_key,
																'blog_threat_ip' => $blog_threat_ip,
																'blog_threat_type' => $blog_threat_type,
																'blog_threat_email' => $result_comment_author_email,
																'blog_threat_content' => 'Spam Char: '. $blacklist_spam_char_current . 'Text: ' .$result_comment_content_clean,
																'blog_web_adress' => $address,
																'blog_server_ip' => $blog_server_ip
														);										
							$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
							$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																										'method' => 'POST',
																										'timeout' => 45,
																										'body' => $spam_master_learning_post
																								));
							if(is_multisite()){
								$blog_prefix = $wpdb->get_blog_prefix($blog_id);
								$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
								exit();
							}
							else{
								$table_prefix = $wpdb->base_prefix;
								$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
								exit();
							}
						//end stripos
						}
					//end for
					}
				//end spam
				}

			//end chars
			}
		//end contact_text_override
		}

		//prepare threat buffer
		$is_buffer_threat = $wpdb->get_results(
							$wpdb->prepare( 
											"SELECT threat 
											FROM $table_threats
											WHERE threat = %s OR threat = %s", 
											$blog_threat_ip, $result_comment_author_email
							));
		if(!empty($is_buffer_threat)){
			//insert transient
			$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Contact-Form', 'spamvalue' => 'Blocked by spam buffer, Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email . ', Text: ' . $result_comment_content_clean ));
			if(is_multisite()){
				$blog_prefix = $wpdb->get_blog_prefix($blog_id);
				$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
			}
			else{
				$table_prefix = $wpdb->base_prefix;
				$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
			}
			return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
			exit();
		}
		else{
			//create data to be posted
			$blog_web_adress = get_site_url();
			$address_unclean = $blog_web_adress;
			$address = preg_replace('#^https?://#', '', $address_unclean);
			@$blog_server_ip = $_SERVER['SERVER_ADDR'];
			//if empty ip
			if(empty($blog_server_ip) || $blog_server_ip == '0'){
				@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
			}		
			$spam_master_learning_post = array(
											'blog_license_key' => $blog_license_key,
											'blog_threat_ip' => $blog_threat_ip,
											'blog_threat_type' => $blog_threat_type,
											'blog_threat_email' => $result_comment_author_email,
											'blog_threat_content' => $result_comment_content_post,
											'blog_web_adress' => $address,
											'blog_server_ip' => $blog_server_ip
										);										
			$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
			$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																						'method' => 'POST',
																						'timeout' => 45,
																						'body' => $spam_master_learning_post
																				));
			if ( is_wp_error( $response ) ) {
				$error_message = $response->get_error_message();
				//Log
				$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Error: Contact-Form 7 response. '.$error_message ));
				echo "Something went wrong, please get in touch with TechGasp Support: $error_message";
			}
			else{
				$data = json_decode( wp_remote_retrieve_body( $response ), true );
				if(empty($data)){
					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Contact-Form', 'spamvalue' => 'Delivered, Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email . ', Text: ' . $result_comment_content_clean ));
					return false;
				}
				else{
					$spam_threat = $data['threat'];
					//add to buffer	ip and email
					$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
					$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
					//insert transient
					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Contact-Form', 'spamvalue' => 'Blocked by online RBL, Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email . ', Text: ' . $result_comment_content_clean ));
					if(is_multisite()){
						$blog_prefix = $wpdb->get_blog_prefix($blog_id);
						$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
					}
					else{
						$table_prefix = $wpdb->base_prefix;
						$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
					}
				return  $result['reason'] = array( 'spam' => wpcf7_get_message( 'spam' ) );
				exit();
				}
			}
		}
	}
//end valid
}
?>
