function vulnerability_ajax(action_before = true) {
    var target = 'all';
    var wtitan_target = jQuery(".wtitan-tab-table-container#wtitan-vulnerability");
    var loader = jQuery('.wt-scan-icon-loader');
    jQuery.ajax({
        method: 'POST', url: ajaxurl, data: {
            action: 'wtitan_get_vulners',
            target: target,
            _ajax_nonce: wtvulner.nonce
        },
        beforeSend: function () {
            if(action_before) {
                wtitan_progress_status(jQuery('#wt-scan-progress-vulnerability .wt-scan-step-icon'), 'loader');
                wtitan_target.html("");
            }
        },
        success: function (result) {
            console.log('vulnerability - ok');

            var status = loader.attr('data-status');
            if((status === '11') || (action_before && status === '1')) {
                loader.hide();
                jQuery('#wt-checker-check').removeAttr('disabled');
            }
            else loader.attr('data-status', loader.attr('data-status')+'1');

            var noticeId = jQuery.wbcr_factory_clearfy_219.app.showNotice('Vulnerability scan success', 'success');
            setTimeout(function() {
                jQuery.wbcr_factory_clearfy_219.app.hideNotice(noticeId);
            }, 5000);

            if(action_before) {
                wtitan_target.html(result);
                wtitan_progress_status(jQuery('#wt-scan-progress-vulnerability .wt-scan-step-icon'), 'ok');
            }
        },
        complete: function () {
        }
    });
}