<?php
global $wpdb, $blog_id;
if(is_multisite()){
	//Firewall delete expired transients
	$sql_firewall_transients_timeout = "delete from t1, t2
										using {$wpdb->sitemeta} t1
										join {$wpdb->sitemeta} t2 on t2.meta_key = replace(t1.meta_key, '_timeout', '')
										where (t1.meta_key like '\_transient\_timeout\_spam_master_firewall_ip%' or t1.meta_key like '\_site\_transient\_timeout\_spam_master_firewall_ip%');";
	$wpdb->query($sql_firewall_transients_timeout);

	$sql_firewall_transients = "delete from {$wpdb->sitemeta}
								where (
								meta_key like '\_transient\_timeout\_spam_master_firewall_ip%'
								or meta_key like '\_site\_transient\_timeout\_spam_master_firewall_ip%');";
	$wpdb->query($sql_firewall_transients);

	//Invalid delete expired transients
	$sql_invalid_transients_timeout = "delete from t1, t2
										using {$wpdb->sitemeta} t1
										join {$wpdb->sitemeta} t2 on t2.meta_key = replace(t1.meta_key, '_timeout', '')
										where (t1.meta_key like '\_transient\_timeout\_spam_master_invalid_email%' or t1.meta_key like '\_site\_transient\_timeout\_spam_master_invalid_email%');";
	$wpdb->query($sql_invalid_transients_timeout);

	$sql_invalid_transients = "delete from {$wpdb->sitemeta}
								where (
								meta_key like '\_transient\_timeout\_spam_master_invalid_email%'
								or meta_key like '\_site\_transient\_timeout\_spam_master_invalid_email%');";
	$wpdb->query($sql_invalid_transients);

	//R-check tables
	$blogs = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs;" );
	$spam_master_db_version = "1.0";
	$charset_collate = $wpdb->get_charset_collate();
	foreach ( $blogs as $id ) {
		$table_threats = $wpdb->get_blog_prefix($id)."spam_master_threats";
		$table_white = $wpdb->get_blog_prefix($id)."spam_master_white";
		$table_keys = $wpdb->get_blog_prefix($id)."spam_master_keys";
		if($wpdb->get_var("SHOW TABLES LIKE '$table_threats'") != $table_threats) {
			$sql_threats = "CREATE TABLE $table_threats (
						id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
						time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
						threat VARCHAR( 255 ) NOT NULL,
						UNIQUE KEY id (id)
						) $charset_collate; ";
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql_threats);
			update_blog_option($id, 'spam_master_threats_db_version', $spam_master_db_version );
		}
		if($wpdb->get_var("SHOW TABLES LIKE '$table_white'") != $table_white) {
			$sql_white = "CREATE TABLE $table_white (
						id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
						time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
						white VARCHAR( 255 ) NOT NULL,
						UNIQUE KEY id (id)
						) $charset_collate; ";
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql_white);
			update_blog_option($id, 'spam_master_white_db_version', $spam_master_db_version );
		}
		if($wpdb->get_var("SHOW TABLES LIKE '$table_keys'") != $table_keys) {
			$sql_keys = "CREATE TABLE $table_keys (
						id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
						time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
						spamkey VARCHAR( 128 ) NOT NULL,
						spamvalue LONGTEXT NOT NULL,
						UNIQUE KEY id (id)
						) $charset_collate; ";
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql_keys);
			update_blog_option($id, 'spam_master_keys_db_version', $spam_master_db_version );
		}
		//Delete Blacklist
		delete_blog_option($id, 'blacklist_keys');
		delete_blog_option($id, 'blacklist_keys_bk');
		//Replace White List in DB
		$spam_master_whitelist = get_blog_option($id, 'spam_master_whitelist');
		if(!empty($spam_master_array_whitelist)){
			$spam_master_array_whitelist = array_merge(explode(" ", $spam_master_whitelist));
			$table_white_insert = $wpdb->get_blog_prefix($id)."spam_master_white";
			foreach($spam_master_array_whitelist as $threat){
				$wpdb->replace( $table_white_insert, array( 'time' => current_time( 'mysql' ), 'white' => $threat ));
			}
		}
		//Delete White List
		delete_blog_option($id, 'spam_master_whitelist');
		update_blog_option($id, 'spam_master_upgrade_to_6', '1');
	}
}
else{
	//Firewall delete expired transients
	$sql_firewall_transients_timeout = "delete from t1, t2
										using {$wpdb->options} t1
										join {$wpdb->options} t2 on t2.option_name = replace(t1.option_name, '_timeout', '')
										where (t1.option_name like '\_transient\_timeout\_spam_master_firewall_ip%' or t1.option_name like '\_site\_transient\_timeout\_spam_master_firewall_ip%');";
	$wpdb->query($sql_firewall_transients_timeout);

	$sql_firewall_transients = "delete from {$wpdb->options}
								where (
								option_name like '\_transient\_timeout\_spam_master_firewall_ip%'
								or option_name like '\_site\_transient\_timeout\_spam_master_firewall_ip%');";
	$wpdb->query($sql_firewall_transients);

	//Invalid delete expired transients
	$sql_invalid_transients_timeout = "delete from t1, t2
										using {$wpdb->options} t1
										join {$wpdb->options} t2 on t2.option_name = replace(t1.option_name, '_timeout', '')
										where (t1.option_name like '\_transient\_timeout\_spam_master_invalid_email%' or t1.option_name like '\_site\_transient\_timeout\_spam_master_invalid_email%');";
	$wpdb->query($sql_invalid_transients_timeout);

	$sql_invalid_transients = "delete from {$wpdb->options}
								where (
								option_name like '\_transient\_timeout\_spam_master_invalid_email%'
								or option_name like '\_site\_transient\_timeout\_spam_master_invalid_email%');";
	$wpdb->query($sql_invalid_transients);

	//R-check tables
	$spam_master_db_version = "1.0";
	$charset_collate = $wpdb->get_charset_collate();
	$table_threats = $wpdb->prefix."spam_master_threats";
	$table_white = $wpdb->prefix."spam_master_white";
	$table_keys = $wpdb->prefix."spam_master_keys";
	if($wpdb->get_var("SHOW TABLES LIKE '$table_threats'") != $table_threats) {
		$sql_threats = "CREATE TABLE $table_threats (
				id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
				time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
				threat VARCHAR( 255 ) NOT NULL,
				UNIQUE KEY id (id)
				) $charset_collate; ";
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql_threats);
		update_option( 'spam_master_threats_db_version' , $spam_master_db_version );
	}
	if($wpdb->get_var("SHOW TABLES LIKE '$table_white'") != $table_white) {
		$sql_white = "CREATE TABLE $table_white (
				id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
				time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
				white VARCHAR( 255 ) NOT NULL,
				UNIQUE KEY id (id)
				) $charset_collate; ";
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql_white);
		update_option( 'spam_master_white_db_version' , $spam_master_db_version );
	}
	if($wpdb->get_var("SHOW TABLES LIKE '$table_keys'") != $table_keys) {
		$sql_keys = "CREATE TABLE $table_keys (
					id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
					time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
					spamkey VARCHAR( 128 ) NOT NULL,
					spamvalue LONGTEXT NOT NULL,
					UNIQUE KEY id (id)
					) $charset_collate; ";
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql_keys);
		update_option( 'spam_master_keys_db_version' , $spam_master_db_version );
	}

	//Delete Blacklist
	delete_option('blacklist_keys');
	delete_option('blacklist_keys_bk');
	//Replace White List in DB
	$spam_master_whitelist = get_option('spam_master_whitelist');
	if(!empty($spam_master_array_whitelist)){
		$spam_master_array_whitelist = array_merge(explode(" ", $spam_master_whitelist));
		$table_white = $wpdb->prefix."spam_master_white";
		foreach($spam_master_array_whitelist as $threat){
			$wpdb->replace( $table_white, 
									array( 'time' => current_time( 'mysql' ), 'white' => $threat ) 
						);
		}
	}
	//Delete White List
	delete_option('spam_master_whitelist');
	update_option('spam_master_upgrade_to_6', '1');
}
//Log
$table_keys = $wpdb->prefix."spam_master_keys";
$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Plugin Activation successfully run to version 6.x.' ));
?>
