<?php
		/** function/method
		* Usage: hooking (registering) the plugin menu
		* Arg(0): null
		* Return: void
		*/
		function menu_white_single(){
		if ( is_admin() )
		add_submenu_page( 'spam-master', 'Whitelist', 'Whitelist', 'manage_options', 'spam-master-whitelist', 'spam_master_whitelist' );
		}

		///////////////////////
		// WORDPRESS ACTIONS //
		///////////////////////
		if( is_multisite() ) {
		add_action( 'admin_menu', 'menu_white_single' );
		}
		else{
		add_action( 'admin_menu', 'menu_white_single' );
		}

function spam_master_whitelist(){
global $wpdb;

$plugin_master_name = constant('SPAM_MASTER_NAME');

//Load Tables
$table_keys = $wpdb->prefix."spam_master_keys";
$table_spam_master_white = $wpdb->prefix."spam_master_white";
$table_spam_master_threats = $wpdb->prefix."spam_master_threats";

//Log User
$current_user = wp_get_current_user();
$spam_master_username = $current_user->user_login;
if(!empty($spam_master_username)){
	$spam_master_username_display = ' by '.$spam_master_username. '.';
}
else{
	$spam_master_username_display = '.';
}

//Add Whitelist
if(isset($_POST['add_whitelist'])){
	check_admin_referer( 'save-settings_spam_master_add_whitelist' );
	if(isset($_POST['spam_master_add_whitelist'])){
		$add_to_white = sanitize_text_field($_POST['spam_master_add_whitelist']);
		if(empty($add_to_white)){
			$add_to_white = '(add none)';
		}
		//Email Validation
		if ( (!filter_var($add_to_white, FILTER_VALIDATE_EMAIL)) && (!filter_var($add_to_white, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) && (!filter_var($add_to_white, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) ){
			//Log
			$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Whitelist add entry '.$add_to_white.' failed validation,'.$spam_master_username_display ));
?>
<div id="message" class="error">
<p><?php _e('Error! Could not validate your Email, IPV6 or IPV4 for whitelist addition. Please insert a valid Email or Ip.', 'spam_master'); ?></p>
</div>
<?php
		}
		else{
			//First check whitelist to see if exists
			$exists_white = $wpdb->get_var(
							$wpdb->prepare("SELECT white FROM $table_spam_master_white WHERE white = %s",
							$add_to_white
							));
			//Exists error
			if($exists_white){
				//Log
				$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Whitelist add entry '.$add_to_white.' failed because it exists,'.$spam_master_username_display ));
?>
<div id="message" class="error">
<p><?php _e($add_to_white . ' already exists in whitelist.', 'spam_master'); ?></p>
</div>
<?php
				//Exists but lets delete from threats
				$wpdb->delete( $table_spam_master_threats, array( 'threat' => $add_to_white ) );
			}
			else{
				//Log
				$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Whitelist add entry '.$add_to_white.' successful,'.$spam_master_username_display ));
				//Insert to white
				$wpdb->insert( $table_spam_master_white, array( 'time' => current_time( 'mysql' ), 'white' => $add_to_white ));
				//Delete from threats
				$wpdb->delete( $table_spam_master_threats, array( 'threat' => $add_to_white ) );
?>
<div id="message" class="updated">
<p><?php _e($add_to_white . ' Successfully inserted in whitelist and deleted from spam buffer if exists.', 'spam_master'); ?></p>
</div>
<?php
			}
		}	
	}
}

//Delete Whitelist
if(isset($_POST['delete_whitelist'])){
	check_admin_referer( 'save-settings_spam_master_delete_whitelist' );
	if(isset($_POST['spam_master_delete_whitelist'])){
		$delete_to_white = sanitize_text_field($_POST['spam_master_delete_whitelist']);
		if(empty($delete_to_white)){
			$delete_to_white = '(delete none)';
		}
		//Email Validation
		if ( (!filter_var($delete_to_white, FILTER_VALIDATE_EMAIL)) && (!filter_var($delete_to_white, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) && (!filter_var($delete_to_white, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) ){
			//Log
			$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Whitelist delete entry '.$delete_to_white.' failed validation,'.$spam_master_username_display ));
?>
<div id="message" class="error">
<p><?php _e('Error! Could not validate your Email, IPV6 or IPV4 for whitelist deletion. Please insert a valid listed Email or Ip.', 'spam_master'); ?></p>
</div>
<?php
		}
		else{
			//Log
			$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Whitelist delete entry '.$delete_to_white.' successful,'.$spam_master_username_display ));
			//Delete from threats
			$wpdb->delete( $table_spam_master_white, array( 'white' => $delete_to_white ) );
?>
<div id="message" class="updated">
<p><?php _e($delete_to_white . ' Successfully from whitelist.', 'spam_master'); ?></p>
</div>
<?php
		}
	}
}

?>
<div class="wrap">
<h1><?php echo $plugin_master_name; ?> Whitelist</h1>

<table class="widefat" cellspacing="0">
	<thead>
		<tr>
			<th colspan="2">
				<h2><img src="<?php echo plugins_url('../images/techgasp-minilogo-16.png', dirname(__FILE__)); ?>" style="float:left; height:18px; vertical-align:middle;" /><?php _e('&nbsp;Spam Master Whitelist Exclusions', 'spam_master'); ?></h2>
				<p>Spam Buffer Whitelisting excludes spam checks from safe Emails or Ip's, it also removes these safe Emails and Ip's from your local Spam Buffer.</p>
			</th>
		</tr>
		<tr>
			<th colspan="2">
				<p>Whitelisting does not remove Emails or Ip's from <b>Spam Master Online RBL Servers</b>. Make sure you remove them.</p>
				<p><a href="https://spammaster.techgasp.com/remove-threat/" target="_blank"><img src="<?php echo plugins_url('../images/check-fail.png', dirname(__FILE__)); ?>" style="height:24px; vertical-align:middle;" > RBL Removal</a> <a href="https://spammaster.techgasp.com/search-threat/" target="_blank"><a href="https://spammaster.techgasp.com/search-threat/" target="_blank"><img src="<?php echo plugins_url('../images/check-threat.png', dirname(__FILE__)); ?>" style="height:24px; vertical-align:middle;" > RBL Search</a></p>
			</th>
		</tr>
	</thead>

	<tfoot>
		<tr>
			<td colspan="2"></td>
		</tr>
	</tfoot>

	<tbody>
		<tr>
			<td class="alternate">
				<form method="post" width='1'>
					<fieldset class="options">
						<?php $sec_nonce = wp_nonce_field( 'save-settings_spam_master_add_whitelist' ); ?>
						<label for="spam_master_add_whitelist"><b><?php _e('Add Email or Ip\'s to Whitelist:', 'spam_master'); ?></b></label>
						<input id="spam_master_add_whitelist" name="spam_master_add_whitelist" type="text" value="">&nbsp;&nbsp;<input class='button-primary' type='submit' name='add_whitelist' value='<?php _e("Add Whitelist", 'spam_master'); ?>' id='submitbutton' />
					</fieldset>
				</form>
			</td>
			<td class="alternate">
				<form method="post" width='1'>
					<fieldset class="options">
						<?php $sec_nonce = wp_nonce_field( 'save-settings_spam_master_delete_whitelist' ); ?>
						<label for="spam_master_delete_whitelist"><b><?php _e('Delete Email or Ip\'s from Whitelist:', 'spam_master'); ?></b></label>
						<input id="spam_master_delete_whitelist" name="spam_master_delete_whitelist" type="text" value="">&nbsp;&nbsp;<input class='button-primary' type='submit' name='delete_whitelist' value='<?php _e("Delete Whitelist", 'spam_master'); ?>' id='submitbutton' />
					</fieldset>
				</form>
			</td>
		</tr>
	</tbody>
</table>

<br>

<?php
if(!class_exists('spam_master_whitelist_table')){
	require_once( WP_PLUGIN_DIR . '/spam-master/includes/whitelist/spam-master-admin-whitelist-table.php');
}
//Prepare Table of elements
$wp_list_table = new spam_master_whitelist_table();
$wp_list_table->prepare_items();
?>
<form method="get">
<input type="hidden" name="page" value="<?php echo esc_attr($_REQUEST['page']); ?>" />
<?php
$wp_list_table->search_box('search', '-search-input');
//Table of elements
$wp_list_table->display();
?>
</form>

<br>

<h2>IMPORTANT: Makes no use of Javascript or Ajax to keep your website fast and conflicts free</h2>

<div style="background: url(<?php echo plugins_url('../images/techgasp-hr.png', dirname(__FILE__)); ?>) repeat-x; height: 10px"></div>
<br>
<p>
<a class="button-secondary" href="https://wordpress.techgasp.com" target="_blank" title="Visit Website">More TechGasp Plugins</a>
<a class="button-secondary" href="https://www.techgasp.com/support/" target="_blank" title="TechGasp Support">TechGasp Support</a>
<a class="button-primary" href="https://wordpress.techgasp.com/spam-master/" target="_blank" title="Visit Website"><?php echo $plugin_master_name; ?> Info</a>
<a class="button-primary" href="https://wordpress.techgasp.com/spam-master-documentation/" target="_blank" title="Visit Website"><?php echo $plugin_master_name; ?> Documentation</a>
<a class="button-primary" href="https://wordpress.org/plugins/spam-master/" target="_blank" title="Visit Website">RATE US *****</a>
</p>
</div>
<?php
}
