<?php
/**
 * The Template for displaying all single posts.
 *
 * @package Catch Themes
 * @subpackage Adventurous
 * @since Adventurous 1.0
 */

get_header(); ?>

		<div id="primary" class="content-area">
			<div id="content" class="site-content" role="main">

			<?php while ( have_posts() ) : the_post(); ?>

				<?php adventurous_content_nav( 'nav-above' ); ?>

				<?php
                    /* Include the Post-Format-specific template for the content.
                     * If you want to overload this in a child theme then include a file
                     * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                     */
                    //get_template_part( 'content', get_post_format() );
					$postformat = ( get_post_format() ? get_post_format() : 'single' );
					get_template_part( 'content', $postformat );
                ?>

				<?php adventurous_content_nav( 'nav-below' ); ?>

				<?php
					//Getting data from Theme Options Panel
					global $adventurous_options_settings;
					$options = $adventurous_options_settings;
					// If comments are open or we have at least one comment, load up the comment template
					if ( comments_open() || '0' != get_comments_number() ) {
						comments_template( '', true );
					}
				?>

			<?php endwhile; // end of the loop. ?>

			</div><!-- #content .site-content -->
		</div><!-- #primary .content-area -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>