<?php

/**
 * Title: Feedback
*
* Description: Displays list of all CyberChimps theme linking to it's pro and free versions.
*
* Please do not edit this file. This file is part of the CyberChimps Framework and all modifications
* should be made in a child theme.
*
* @category CyberChimps Framework
* @package  Framework
* @since    1.0
* @author   CyberChimps
* @license  http://www.opensource.org/licenses/gpl-license.php GPL v3.0 (or later)
* @link     http://www.cyberchimps.com/
*/

function cyberchimps_feedback_style() {
	
	// Set template directory uri
	$directory_uri = get_template_directory_uri();
	
	wp_enqueue_style( 'about_style', get_template_directory_uri() . '/core/includes/css/options.css' );
	
	wp_enqueue_script( 'responsive_jquery_validation', get_stylesheet_directory_uri() . '/core/includes/js/jquery.validate.min.js', array(), true );
	wp_enqueue_script( 'responsive_jquery_validationform', get_stylesheet_directory_uri() . '/core/includes/js/validation.js', array(), true );
}

function cyberchimps_add_feedback() {
	$page = add_theme_page(
			'Request a Feature',
			'Request a Feature',
			'administrator',
			'responsive-feedback',
			'cyberchimps_display_feedback'
	);

	add_action( 'admin_print_styles-' . $page, 'cyberchimps_feedback_style' );
}

add_action( 'admin_menu', 'cyberchimps_add_feedback' );

function responsive_sender_email($sent_from)
{
	return $_POST['ccemail'];
}
function responsive_mail_name ($sent_from)
{
	return $_POST['ccemail']; 
}
function cyberchimps_display_feedback() {
	$strResponseMessage ='';
	$to = 'hello@cyberchimps.com';
	if (isset($_POST['ccSubmitBtn']))
	{
		//Send mail
		if(!empty($_POST['ccfeature']) && !empty($_POST['ccemail']))
		{
			$subject = "Feature Request for Responsive Free Theme";
			$headers = 'From: '.'<'.$_POST['ccemail'].'>'. "\r\n";			
			$feature = wp_kses_stripslashes ($_POST['ccfeature']);
			
			add_filter( 'wp_mail_from', 'responsive_sender_email' );
			add_filter( 'wp_mail_from_name', 'responsive_mail_name' );
			
			if(wp_mail($to, $subject, $feature, $headers)) {
				$strResponseMessage = "Thanks, your note is on its way to us now. Be sure to whitelist our mail id hello@cyberchimps.com so that our reply doesn't end up in your spam folder. Have a lovely day ahead !";
			} else {
				$strResponseMessage = "There was some issue sending mail. Please try again";
			}
		}
	}
	
		
		?>					
				<div class="panel-heading"><h3 class="panel-title" style="line-height: 20px;"><?php echo "Feature Request";?></h3></div>				
				<div class="panel panel-primary">
				<?php if ($strResponseMessage != '' ) { ?> 
					<span class="updateres"> <?php echo $strResponseMessage; ?></span>
				<?php } else { ?>	
				
<span class="ccinfo"><?php _e("We believe you , yes you, are our best critic. Without you, we wouldn't exist ! Its our job to make you happy.
So, don't be shy, tell us what feature you would like us to add to this theme and we'll try our very best to do that. All mails are replied to within 24 hours - so you are guaranteed an answer, even if we can't implement what you request.",'responsive') ?></span>
		
					
				      <div class="panel-body">
						<form action="" id="formfeedback" method="post">
							 <div class="form-group">
								<label for="ccfeature">Feature Request</label>
							    <textarea id="ccfeature" class="form-control" name="ccfeature" placeholder="Enter Feature Request" data-placement="right" title="Please Enter Feature Request" value="<?php ?>"></textarea>
								<label for="ccemail">Email Id</label>
							    <input type="text" id="ccemail" class="form-control" name="ccemail" placeholder="Enter Email Id" data-placement="right" title="Please Enter Email Id" value="<?php ?>"/>
						   </div>
						   <input type="submit" id="ccSubmitBtn" name="ccSubmitBtn" class="button button-primary" value="Send">						   
					   </form>
					</div>
				</div>	
			<?php }?>				 	   
		<?php 	 			
}