<?php
/**
 * Theme specific helper functions
 *
 * @package Aamla
 * @since 1.0.0
 */

/**
 * Return all available Google Sans Serif Fonts.
 *
 * @return array All Google Fonts.
 */
function aamla_google_sans_fonts() {
	return [
		'roboto'                     => [
			'family'   => 'Roboto',
			'variants' => [
				'100',
				'100italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'700',
				'700italic',
				'900',
				'900italic',
			],
		],
		'open-sans'                  => [
			'family'   => 'Open Sans',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
			],
		],
		'lato'                       => [
			'family'   => 'Lato',
			'variants' => [
				'100',
				'100italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'700',
				'700italic',
				'900',
				'900italic',
			],
		],
		'montserrat'                 => [
			'family'   => 'Montserrat',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'roboto-condensed'           => [
			'family'   => 'Roboto Condensed',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'oswald'                     => [
			'family'   => 'Oswald',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'source-sans-pro'            => [
			'family'   => 'Source Sans Pro',
			'variants' => [
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'900',
				'900italic',
			],
		],
		'raleway'                    => [
			'family'   => 'Raleway',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'pt-sans'                    => [
			'family'   => 'PT Sans',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'ubuntu'                     => [
			'family'   => 'Ubuntu',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'700',
				'700italic',
			],
		],
		'francois-one'               => [
			'family'   => 'Francois One',
			'variants' => [
				'400',
			],
		],
		'noto-sans'                  => [
			'family'   => 'Noto Sans',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'poppins'                    => [
			'family'   => 'Poppins',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'titillium-web'              => [
			'family'   => 'Titillium Web',
			'variants' => [
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'900',
			],
		],
		'muli'                       => [
			'family'   => 'Muli',
			'variants' => [
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'arimo'                      => [
			'family'   => 'Arimo',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'pt-sans-narrow'             => [
			'family'   => 'PT Sans Narrow',
			'variants' => [
				'400',
				'700',
			],
		],
		'fira-sans'                  => [
			'family'   => 'Fira Sans',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'nunito'                     => [
			'family'   => 'Nunito',
			'variants' => [
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'work-sans'                  => [
			'family'   => 'Work Sans',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'dosis'                      => [
			'family'   => 'Dosis',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
			],
		],
		'nanum-gothic'               => [
			'family'   => 'Nanum Gothic',
			'variants' => [
				'400',
				'700',
				'800',
			],
		],
		'oxygen'                     => [
			'family'   => 'Oxygen',
			'variants' => [
				'300',
				'400',
				'700',
			],
		],
		'quicksand'                  => [
			'family'   => 'Quicksand',
			'variants' => [
				'300',
				'400',
				'500',
				'700',
			],
		],
		'cabin'                      => [
			'family'   => 'Cabin',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'hind'                       => [
			'family'   => 'Hind',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'josefin-sans'               => [
			'family'   => 'Josefin Sans',
			'variants' => [
				'100',
				'100italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'rubik'                      => [
			'family'   => 'Rubik',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'700',
				'700italic',
				'900',
				'900italic',
			],
		],
		'exo-2'                      => [
			'family'   => 'Exo 2',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'yanone-kaffeesatz'          => [
			'family'   => 'Yanone Kaffeesatz',
			'variants' => [
				'200',
				'300',
				'400',
				'700',
			],
		],
		'libre-franklin'             => [
			'family'   => 'Libre Franklin',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'merriweather-sans'          => [
			'family'   => 'Merriweather Sans',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'700',
				'700italic',
				'800',
				'800italic',
			],
		],
		'karla'                      => [
			'family'   => 'Karla',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'nunito-sans'                => [
			'family'   => 'Nunito Sans',
			'variants' => [
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'asap'                       => [
			'family'   => 'Asap',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'archivo-narrow'             => [
			'family'   => 'Archivo Narrow',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'exo'                        => [
			'family'   => 'Exo',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'signika'                    => [
			'family'   => 'Signika',
			'variants' => [
				'300',
				'400',
				'600',
				'700',
			],
		],
		'hind-siliguri'              => [
			'family'   => 'Hind Siliguri',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'kanit'                      => [
			'family'   => 'Kanit',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'play'                       => [
			'family'   => 'Play',
			'variants' => [
				'400',
				'700',
			],
		],
		'teko'                       => [
			'family'   => 'Teko',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'cairo'                      => [
			'family'   => 'Cairo',
			'variants' => [
				'200',
				'300',
				'400',
				'600',
				'700',
				'900',
			],
		],
		'maven-pro'                  => [
			'family'   => 'Maven Pro',
			'variants' => [
				'400',
				'500',
				'700',
				'900',
			],
		],
		'catamaran'                  => [
			'family'   => 'Catamaran',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'pt-sans-caption'            => [
			'family'   => 'PT Sans Caption',
			'variants' => [
				'400',
				'700',
			],
		],
		'rajdhani'                   => [
			'family'   => 'Rajdhani',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'cuprum'                     => [
			'family'   => 'Cuprum',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'heebo'                      => [
			'family'   => 'Heebo',
			'variants' => [
				'100',
				'300',
				'400',
				'500',
				'700',
				'800',
				'900',
			],
		],
		'orbitron'                   => [
			'family'   => 'Orbitron',
			'variants' => [
				'400',
				'500',
				'700',
				'900',
			],
		],
		'yantramanav'                => [
			'family'   => 'Yantramanav',
			'variants' => [
				'100',
				'300',
				'400',
				'500',
				'700',
				'900',
			],
		],
		'alegreya-sans'              => [
			'family'   => 'Alegreya Sans',
			'variants' => [
				'100',
				'100italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'monda'                      => [
			'family'   => 'Monda',
			'variants' => [
				'400',
				'700',
			],
		],
		'philosopher'                => [
			'family'   => 'Philosopher',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'quattrocento-sans'          => [
			'family'   => 'Quattrocento Sans',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'istok-web'                  => [
			'family'   => 'Istok Web',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'fira-sans-condensed'        => [
			'family'   => 'Fira Sans Condensed',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'news-cycle'                 => [
			'family'   => 'News Cycle',
			'variants' => [
				'400',
				'700',
			],
		],
		'prompt'                     => [
			'family'   => 'Prompt',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'cabin-condensed'            => [
			'family'   => 'Cabin Condensed',
			'variants' => [
				'400',
				'500',
				'600',
				'700',
			],
		],
		'assistant'                  => [
			'family'   => 'Assistant',
			'variants' => [
				'200',
				'300',
				'400',
				'600',
				'700',
				'800',
			],
		],
		'gudea'                      => [
			'family'   => 'Gudea',
			'variants' => [
				'400',
				'400italic',
				'700',
			],
		],
		'benchnine'                  => [
			'family'   => 'BenchNine',
			'variants' => [
				'300',
				'400',
				'700',
			],
		],
		'hind-madurai'               => [
			'family'   => 'Hind Madurai',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'economica'                  => [
			'family'   => 'Economica',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'barlow-condensed'           => [
			'family'   => 'Barlow Condensed',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'cantarell'                  => [
			'family'   => 'Cantarell',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'khand'                      => [
			'family'   => 'Khand',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'fira-sans-extra-condensed'  => [
			'family'   => 'Fira Sans Extra Condensed',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'khula'                      => [
			'family'   => 'Khula',
			'variants' => [
				'300',
				'400',
				'600',
				'700',
				'800',
			],
		],
		'barlow'                     => [
			'family'   => 'Barlow',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'pragati-narrow'             => [
			'family'   => 'Pragati Narrow',
			'variants' => [
				'400',
				'700',
			],
		],
		'ruda'                       => [
			'family'   => 'Ruda',
			'variants' => [
				'400',
				'700',
				'900',
			],
		],
		'jura'                       => [
			'family'   => 'Jura',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'hind-vadodara'              => [
			'family'   => 'Hind Vadodara',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'signika-negative'           => [
			'family'   => 'Signika Negative',
			'variants' => [
				'300',
				'400',
				'600',
				'700',
			],
		],
		'chivo'                      => [
			'family'   => 'Chivo',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'700',
				'700italic',
				'900',
				'900italic',
			],
		],
		'amaranth'                   => [
			'family'   => 'Amaranth',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'barlow-semi-condensed'      => [
			'family'   => 'Barlow Semi Condensed',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'magra'                      => [
			'family'   => 'Magra',
			'variants' => [
				'400',
				'700',
			],
		],
		'changa'                     => [
			'family'   => 'Changa',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
			],
		],
		'sintony'                    => [
			'family'   => 'Sintony',
			'variants' => [
				'400',
				'700',
			],
		],
		'advent-pro'                 => [
			'family'   => 'Advent Pro',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'montserrat-alternates'      => [
			'family'   => 'Montserrat Alternates',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'arsenal'                    => [
			'family'   => 'Arsenal',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'sarala'                     => [
			'family'   => 'Sarala',
			'variants' => [
				'400',
				'700',
			],
		],
		'hind-guntur'                => [
			'family'   => 'Hind Guntur',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'overpass'                   => [
			'family'   => 'Overpass',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'alegreya-sans-sc'           => [
			'family'   => 'Alegreya Sans SC',
			'variants' => [
				'100',
				'100italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'scada'                      => [
			'family'   => 'Scada',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'saira-condensed'            => [
			'family'   => 'Saira Condensed',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'rambla'                     => [
			'family'   => 'Rambla',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'syncopate'                  => [
			'family'   => 'Syncopate',
			'variants' => [
				'400',
				'700',
			],
		],
		'marvel'                     => [
			'family'   => 'Marvel',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'nobile'                     => [
			'family'   => 'Nobile',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'700',
				'700italic',
			],
		],
		'el-messiri'                 => [
			'family'   => 'El Messiri',
			'variants' => [
				'400',
				'500',
				'600',
				'700',
			],
		],
		'saira'                      => [
			'family'   => 'Saira',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'jaldi'                      => [
			'family'   => 'Jaldi',
			'variants' => [
				'400',
				'700',
			],
		],
		'alef'                       => [
			'family'   => 'Alef',
			'variants' => [
				'400',
				'700',
			],
		],
		'archivo'                    => [
			'family'   => 'Archivo',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'palanquin'                  => [
			'family'   => 'Palanquin',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'quantico'                   => [
			'family'   => 'Quantico',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'saira-semi-condensed'       => [
			'family'   => 'Saira Semi Condensed',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'mitr'                       => [
			'family'   => 'Mitr',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'martel-sans'                => [
			'family'   => 'Martel Sans',
			'variants' => [
				'200',
				'300',
				'400',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'biryani'                    => [
			'family'   => 'Biryani',
			'variants' => [
				'200',
				'300',
				'400',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'puritan'                    => [
			'family'   => 'Puritan',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'mada'                       => [
			'family'   => 'Mada',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'900',
			],
		],
		'rosario'                    => [
			'family'   => 'Rosario',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'ibm-plex-sans'              => [
			'family'   => 'IBM Plex Sans',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'mukta'                      => [
			'family'   => 'Mukta',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
			],
		],
		'encode-sans-condensed'      => [
			'family'   => 'Encode Sans Condensed',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'miriam-libre'               => [
			'family'   => 'Miriam Libre',
			'variants' => [
				'400',
				'700',
			],
		],
		'mukta-vaani'                => [
			'family'   => 'Mukta Vaani',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
			],
		],
		'saira-extra-condensed'      => [
			'family'   => 'Saira Extra Condensed',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'tajawal'                    => [
			'family'   => 'Tajawal',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'700',
				'800',
				'900',
			],
		],
		'lekton'                     => [
			'family'   => 'Lekton',
			'variants' => [
				'400',
				'400italic',
				'700',
			],
		],
		'asap-condensed'             => [
			'family'   => 'Asap Condensed',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'proza-libre'                => [
			'family'   => 'Proza Libre',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
			],
		],
		'cambay'                     => [
			'family'   => 'Cambay',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'mukta-malar'                => [
			'family'   => 'Mukta Malar',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
			],
		],
		'palanquin-dark'             => [
			'family'   => 'Palanquin Dark',
			'variants' => [
				'400',
				'500',
				'600',
				'700',
			],
		],
		'amiko'                      => [
			'family'   => 'Amiko',
			'variants' => [
				'400',
				'600',
				'700',
			],
		],
		'encode-sans'                => [
			'family'   => 'Encode Sans',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'mukta-mahee'                => [
			'family'   => 'Mukta Mahee',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
			],
		],
		'sarpanch'                   => [
			'family'   => 'Sarpanch',
			'variants' => [
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'athiti'                     => [
			'family'   => 'Athiti',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'montserrat-subrayada'       => [
			'family'   => 'Montserrat Subrayada',
			'variants' => [
				'400',
				'700',
			],
		],
		'sansita'                    => [
			'family'   => 'Sansita',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'padauk'                     => [
			'family'   => 'Padauk',
			'variants' => [
				'400',
				'700',
			],
		],
		'arya'                       => [
			'family'   => 'Arya',
			'variants' => [
				'400',
				'700',
			],
		],
		'ibm-plex-sans-condensed'    => [
			'family'   => 'IBM Plex Sans Condensed',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'asul'                       => [
			'family'   => 'Asul',
			'variants' => [
				'400',
				'700',
			],
		],
		'encode-sans-semi-condensed' => [
			'family'   => 'Encode Sans Semi Condensed',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'mina'                       => [
			'family'   => 'Mina',
			'variants' => [
				'400',
				'700',
			],
		],
		'encode-sans-expanded'       => [
			'family'   => 'Encode Sans Expanded',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'gothic-a1'                  => [
			'family'   => 'Gothic A1',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'kantumruy'                  => [
			'family'   => 'Kantumruy',
			'variants' => [
				'300',
				'400',
				'700',
			],
		],
		'gfs-neohellenic'            => [
			'family'   => 'GFS Neohellenic',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'encode-sans-semi-expanded'  => [
			'family'   => 'Encode Sans Semi Expanded',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'chathura'                   => [
			'family'   => 'Chathura',
			'variants' => [
				'100',
				'300',
				'400',
				'700',
				'800',
			],
		],
	];
}

/**
 * Return all available Google Serif Fonts.
 *
 * @return array All Google Fonts.
 */
function aamla_google_serif_fonts() {
	// Serif google font.
	return [
		'roboto-slab'         => [
			'family'   => 'Roboto Slab',
			'variants' => [
				'100',
				'300',
				'400',
				'700',
			],
		],
		'merriweather'        => [
			'family'   => 'Merriweather',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'700',
				'700italic',
				'900',
				'900italic',
			],
		],
		'playfair-display'    => [
			'family'   => 'Playfair Display',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
				'900',
				'900italic',
			],
		],
		'lora'                => [
			'family'   => 'Lora',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'pt-serif'            => [
			'family'   => 'PT Serif',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'noto-serif'          => [
			'family'   => 'Noto Serif',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'crimson-text'        => [
			'family'   => 'Crimson Text',
			'variants' => [
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'bitter'              => [
			'family'   => 'Bitter',
			'variants' => [
				'400',
				'400italic',
				'700',
			],
		],
		'libre-baskerville'   => [
			'family'   => 'Libre Baskerville',
			'variants' => [
				'400',
				'400italic',
				'700',
			],
		],
		'arvo'                => [
			'family'   => 'Arvo',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'source-serif-pro'    => [
			'family'   => 'Source Serif Pro',
			'variants' => [
				'400',
				'600',
				'700',
			],
		],
		'eb-garamond'         => [
			'family'   => 'EB Garamond',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
			],
		],
		'rokkitt'             => [
			'family'   => 'Rokkitt',
			'variants' => [
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'vollkorn'            => [
			'family'   => 'Vollkorn',
			'variants' => [
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'900',
				'900italic',
			],
		],
		'cinzel'              => [
			'family'   => 'Cinzel',
			'variants' => [
				'400',
				'700',
				'900',
			],
		],
		'alegreya'            => [
			'family'   => 'Alegreya',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'noticia-text'        => [
			'family'   => 'Noticia Text',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'old-standard-tt'     => [
			'family'   => 'Old Standard TT',
			'variants' => [
				'400',
				'400italic',
				'700',
			],
		],
		'domine'              => [
			'family'   => 'Domine',
			'variants' => [
				'400',
				'700',
			],
		],
		'tinos'               => [
			'family'   => 'Tinos',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'josefin-slab'        => [
			'family'   => 'Josefin Slab',
			'variants' => [
				'100',
				'100italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'amiri'               => [
			'family'   => 'Amiri',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'nanum-myeongjo'      => [
			'family'   => 'Nanum Myeongjo',
			'variants' => [
				'400',
				'700',
				'800',
			],
		],
		'playfair-display-sc' => [
			'family'   => 'Playfair Display SC',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
				'900',
				'900italic',
			],
		],
		'cormorant-garamond'  => [
			'family'   => 'Cormorant Garamond',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'cardo'               => [
			'family'   => 'Cardo',
			'variants' => [
				'400',
				'400italic',
				'700',
			],
		],
		'frank-ruhl-libre'    => [
			'family'   => 'Frank Ruhl Libre',
			'variants' => [
				'300',
				'400',
				'500',
				'700',
				'900',
			],
		],
		'quattrocento'        => [
			'family'   => 'Quattrocento',
			'variants' => [
				'400',
				'700',
			],
		],
		'volkhov'             => [
			'family'   => 'Volkhov',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'neuton'              => [
			'family'   => 'Neuton',
			'variants' => [
				'200',
				'300',
				'400',
				'400italic',
				'700',
				'800',
			],
		],
		'glegoo'              => [
			'family'   => 'Glegoo',
			'variants' => [
				'400',
				'700',
			],
		],
		'kreon'               => [
			'family'   => 'Kreon',
			'variants' => [
				'300',
				'400',
				'700',
			],
		],
		'enriqueta'           => [
			'family'   => 'Enriqueta',
			'variants' => [
				'400',
				'700',
			],
		],
		'gentium-basic'       => [
			'family'   => 'Gentium Basic',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'yrsa'                => [
			'family'   => 'Yrsa',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'gentium-book-basic'  => [
			'family'   => 'Gentium Book Basic',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'martel'              => [
			'family'   => 'Martel',
			'variants' => [
				'200',
				'300',
				'400',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'rufina'              => [
			'family'   => 'Rufina',
			'variants' => [
				'400',
				'700',
			],
		],
		'lusitana'            => [
			'family'   => 'Lusitana',
			'variants' => [
				'400',
				'700',
			],
		],
		'zilla-slab'          => [
			'family'   => 'Zilla Slab',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'cormorant'           => [
			'family'   => 'Cormorant',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'pridi'               => [
			'family'   => 'Pridi',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'karma'               => [
			'family'   => 'Karma',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'kameron'             => [
			'family'   => 'Kameron',
			'variants' => [
				'400',
				'700',
			],
		],
		'taviraj'             => [
			'family'   => 'Taviraj',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'halant'              => [
			'family'   => 'Halant',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'unna'                => [
			'family'   => 'Unna',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'eczar'               => [
			'family'   => 'Eczar',
			'variants' => [
				'400',
				'500',
				'600',
				'700',
				'800',
			],
		],
		'caudex'              => [
			'family'   => 'Caudex',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'scheherazade'        => [
			'family'   => 'Scheherazade',
			'variants' => [
				'400',
				'700',
			],
		],
		'alegreya-sc'         => [
			'family'   => 'Alegreya SC',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'abhaya-libre'        => [
			'family'   => 'Abhaya Libre',
			'variants' => [
				'400',
				'500',
				'600',
				'700',
				'800',
			],
		],
		'judson'              => [
			'family'   => 'Judson',
			'variants' => [
				'400',
				'400italic',
				'700',
			],
		],
		'spectral'            => [
			'family'   => 'Spectral',
			'variants' => [
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
			],
		],
		'sumana'              => [
			'family'   => 'Sumana',
			'variants' => [
				'400',
				'700',
			],
		],
		'trirong'             => [
			'family'   => 'Trirong',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic',
			],
		],
		'buenard'             => [
			'family'   => 'Buenard',
			'variants' => [
				'400',
				'700',
			],
		],
		'hanuman'             => [
			'family'   => 'Hanuman',
			'variants' => [
				'400',
				'700',
			],
		],
		'rasa'                => [
			'family'   => 'Rasa',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'laila'               => [
			'family'   => 'Laila',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'maitree'             => [
			'family'   => 'Maitree',
			'variants' => [
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'vesper-libre'        => [
			'family'   => 'Vesper Libre',
			'variants' => [
				'400',
				'500',
				'700',
				'900',
			],
		],
		'podkova'             => [
			'family'   => 'Podkova',
			'variants' => [
				'400',
				'500',
				'600',
				'700',
				'800',
			],
		],
		'tienne'              => [
			'family'   => 'Tienne',
			'variants' => [
				'400',
				'700',
				'900',
			],
		],
		'sura'                => [
			'family'   => 'Sura',
			'variants' => [
				'400',
				'700',
			],
		],
		'cormorant-sc'        => [
			'family'   => 'Cormorant SC',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'cormorant-infant'    => [
			'family'   => 'Cormorant Infant',
			'variants' => [
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'david-libre'         => [
			'family'   => 'David Libre',
			'variants' => [
				'400',
				'500',
				'700',
			],
		],
		'aref-ruqaa'          => [
			'family'   => 'Aref Ruqaa',
			'variants' => [
				'400',
				'700',
			],
		],
		'inika'               => [
			'family'   => 'Inika',
			'variants' => [
				'400',
				'700',
			],
		],
		'manuale'             => [
			'family'   => 'Manuale',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'spectral-sc'         => [
			'family'   => 'Spectral SC',
			'variants' => [
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
			],
		],
		'cormorant-upright'   => [
			'family'   => 'Cormorant Upright',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'almendra'            => [
			'family'   => 'Almendra',
			'variants' => [
				'400',
				'400italic',
				'700',
				'700italic',
			],
		],
		'ibm-plex-serif'      => [
			'family'   => 'IBM Plex Serif',
			'variants' => [
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'kadwa'               => [
			'family'   => 'Kadwa',
			'variants' => [
				'400',
				'700',
			],
		],
		'biorhyme'            => [
			'family'   => 'BioRhyme',
			'variants' => [
				'200',
				'300',
				'400',
				'700',
				'800',
			],
		],
		'inknut-antiqua'      => [
			'family'   => 'Inknut Antiqua',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			],
		],
		'sahitya'             => [
			'family'   => 'Sahitya',
			'variants' => [
				'400',
				'700',
			],
		],
		'faustina'            => [
			'family'   => 'Faustina',
			'variants' => [
				'400',
				'400italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
			],
		],
		'nokora'              => [
			'family'   => 'Nokora',
			'variants' => [
				'400',
				'700',
			],
		],
		'vollkorn-sc'         => [
			'family'   => 'Vollkorn SC',
			'variants' => [
				'400',
				'600',
				'700',
				'900',
			],
		],
		'cormorant-unicase'   => [
			'family'   => 'Cormorant Unicase',
			'variants' => [
				'300',
				'400',
				'500',
				'600',
				'700',
			],
		],
		'biorhyme-expanded'   => [
			'family'   => 'BioRhyme Expanded',
			'variants' => [
				'200',
				'300',
				'400',
				'700',
				'800',
			],
		],
	];
}
