<?php
/**
 *
 * WARNING: Please do not edit this file.
 * @see http://codex.wordpress.org/Child_Themes
 *
 * Load the theme function files (options panel, theme functions, widgets, etc...).
 */

include_once get_template_directory() . '/theme/class-capture.php'; // Capture Class (main functionality, actions/filters)

include_once get_template_directory() . '/includes/class-tgm-plugin-activation.php'; // TGM Activation

include_once get_template_directory() . '/includes/theme-options.php'; // SDS Theme Options
include_once get_template_directory() . '/includes/theme-functions.php'; // SDS Theme Options Functions
include_once get_template_directory() . '/includes/class-customize-us-control.php'; // Customize Controller
include_once get_template_directory() . '/includes/widget-social-media.php'; // SDS Social Media Widget


/**
 * ---------------
 * Theme Specifics
 * ---------------
 */

/**
 * This function registers all color schemes available in this theme.
 */
if ( ! function_exists( 'sds_color_schemes' ) ) {
	function sds_color_schemes() {
		$color_schemes = array(
			'default' => array( // Name used in saved option
				'label' => __( 'Default', 'capture' ), // Label on options panel (required)
				'stylesheet' => false, // Stylesheet URL, relative to theme directory (required)
				'preview' => '#222222', // Preview color on options panel (required)
				'content_color' => '#333333', // Default content color (required)
				'default' => true
			),
			'slocum-blue' => array(
				'label' => __( 'Slocum Blue', 'capture' ),
				'stylesheet' => '/css/slocum-blue.css',
				'preview' => '#3c639a',
				'content_color' => '#333333',
				'deps' => 'capture'
			)
		);

		return apply_filters( 'sds_theme_options_color_schemes', $color_schemes );
	}
}

/**
 * This function registers all web fonts available in this theme.
 *
 * Note: Capture requires both Damion and Oswald webfonts for post titles and site title. We're
 * including those fonts as well below.
 */
if ( ! function_exists( 'sds_web_fonts' ) ) {
	function sds_web_fonts() {
		$web_fonts = array(
			// Lato
			'Damion|Oswald|Lato:400' => array(
				'label' => 'Lato',
				'css' => 'font-family: \'Lato\', sans-serif;'
			)
		);

		return apply_filters( 'sds_theme_options_web_fonts', $web_fonts );
	}
}

/**
 * This function sets the default image dimensions string on the options panel.
 */
if ( ! function_exists( 'sds_theme_options_logo_dimensions' ) ) {
	add_filter( 'sds_theme_options_logo_dimensions', 'sds_theme_options_logo_dimensions' );

	function sds_theme_options_logo_dimensions( $default ) {
		return '600x180';
	}
}

/**
 * This function sets a default featured image size for use in this theme.
 */
if ( ! function_exists( 'sds_theme_options_default_featured_image_size' ) ) {
	add_filter( 'sds_theme_options_default_featured_image_size', 'sds_theme_options_default_featured_image_size' );

	function sds_theme_options_default_featured_image_size( $default ) {
		return 'capture-1200x500';
	}
}

/**
 * This function adds the custom Theme Customizer styles to the <head> tag.
 */
if ( ! function_exists( 'capture_wp_head' ) ) {
	add_action( 'wp_head', 'capture_wp_head', 20 );

	function capture_wp_head() {
		$sds_theme_options_instance = SDS_Theme_Options_Instance();
	?>
		<style type="text/css" id="<?php echo $sds_theme_options_instance->get_parent_theme()->get_template(); ?>-theme-customizer">
			<?php if( $background_color = get_background_color() ) : ?>
				/* Background Color */
				.post:after, .post:before, .post-container:after, .post-container:before,
				.primary-sidebar-widget:before, .primary-sidebar-widget:after,
				.widget-container:before, .widget-container:after {
					background-color: #<?php echo $background_color; ?>;
				}
			<?php endif; ?>

			<?php if( $background = set_url_scheme( get_background_image() ) ) : ?>
				/* Background Image */
				.post:after, .post:before, .post-container:after, .post-container:before {
					background-color: transparent;
				}
			<?php endif; ?>

			/* Content Color */
			article.content, .post-date, .post-footer .post-meta p, #post-author {
				color: <?php echo get_theme_mod( 'content_color' ); ?>;
			}
		</style>
	<?php
	}
}

if ( ! function_exists( 'sds_theme_options_ads' ) ) {
	add_action( 'sds_theme_options_ads', 'sds_theme_options_ads' );

	function sds_theme_options_ads() {
	?>
		<div class="sds-theme-options-ad">
			<a href="<?php echo esc_url( sds_get_pro_link( 'theme-options-ad' ) ); ?>" target="_blank" class="sds-theme-options-upgrade-ad">
				<h3><?php _e( 'Upgrade to Capture Pro!', 'capture' ); ?></h3>
				<ul>
					<li><?php _e( 'Priority Ticketing Support', 'capture' ); ?></li>
					<li><?php _e( 'Fullscreen WordPress Gallery Slideshows', 'capture' ); ?></li>
					<li><?php _e( 'Featured Videos', 'capture' ); ?></li>
					<li><?php _e( 'More Color Schemes', 'capture' ); ?></li>
					<li><?php _e( 'Web Fonts', 'capture' ); ?></li>
					<li><?php _e( 'Adjust Featured Image Sizes', 'capture' ); ?></li>
					<li><?php _e( 'Easily Add Custom Scripts/Styles', 'capture' ); ?></li>
					<li><?php _e( 'and More!', 'capture' ); ?></li>
				</ul>

				<span class="sds-theme-options-btn-green"><?php _e( 'Upgrade Now!', 'capture' ); ?></span>
			</a>
		</div>

		<div class="sds-theme-options-ad">
			<a href="<?php echo esc_url( 'http://conductorplugin.com/slocum-themes/' ); ?>" target="_blank" class="sds-theme-options-upgrade-ad sds-theme-options-upgrade-ad-dark-gray">
				<h3><?php _e( 'Introducing Conductor Plugin', 'capture' ); ?></h3>
				<ul>
					<li><?php _e( 'Custom Layouts', 'capture' ); ?></li>
					<li><?php _e( 'Custom Content Displays', 'capture' ); ?></li>
					<li><?php _e( 'No Code Required!', 'capture' ); ?></li>
				</ul>

				<span class="sds-theme-options-btn-yellow"><?php _e( 'Get Conductor!', 'capture' ); ?></span>
			</a>
		</div>
	<?php
	}
}

if ( ! function_exists( 'sds_theme_options_upgrade_cta' ) ) {
	add_action( 'sds_theme_options_upgrade_cta', 'sds_theme_options_upgrade_cta' );

	function sds_theme_options_upgrade_cta( $type ) {
		switch( $type ) :
			case 'color-schemes':
		?>
				<p>
					<?php
						printf( '<a href="%1$s" target="_blank">%2$s</a> %3$s',
							esc_url( sds_get_pro_link( 'theme-options-colors' ) ),
							__( 'Upgrade to Capture Pro', 'capture' ),
							__( 'and receive more color schemes!', 'capture' )
						);
					?>
				</p>
		<?php
			break;
			case 'web-fonts':
		?>
				<p>
					<?php
						printf( '<a href="%1$s" target="_blank">%2$s</a> %3$s',
							esc_url( sds_get_pro_link( 'theme-options-fonts' ) ),
							__( 'Upgrade to Capture Pro', 'capture' ),
							__( 'to use more web fonts!', 'capture' )
						);
					?>
				</p>
		<?php
			break;
			case 'help-support':
		?>
				<p>
					<?php
						printf( '<a href="%1$s" target="_blank">%2$s</a> %3$s',
							esc_url( sds_get_pro_link( 'theme-options-help' ) ),
							__( 'Upgrade to Capture Pro', 'capture' ),
							__( 'to receive priority ticketing support!', 'capture' )
						);
					?>
				</p>
		<?php
			break;
		endswitch;
	}
}

function sds_get_pro_link( $content ) {
	return esc_url( 'https://slocumthemes.com/wordpress-themes/capture/?utm_source=capture&utm_medium=link&utm_content=' . urlencode( sanitize_title_with_dashes( $content ) ) . '&utm_campaign=pro#purchase-theme' );
}

if ( ! function_exists( 'sds_theme_options_help_support_tab_content' ) ) {
	add_action( 'sds_theme_options_help_support_tab_content', 'sds_theme_options_help_support_tab_content' );

	function sds_theme_options_help_support_tab_content( ) {
	?>
		<p><?php printf( __( 'If you\'d like to create a support request, please visit the %1$s.', 'capture' ), '<a href="http://wordpress.org/themes/capture/" target="_blank">Capture Forums on WordPress.org</a>' ); ?></p>
	<?php
	}
}

if ( ! function_exists( 'sds_copyright_branding' ) ) {
	add_filter( 'sds_copyright_branding', 'sds_copyright_branding', 10, 2 );

	function sds_copyright_branding( $text, $theme_name ) {
		return '<a href="https://slocumthemes.com/wordpress-themes/capture-free/" target="_blank">' . sprintf( __( '%1$s by Slocum Studio', 'capture' ), $theme_name ) . '</a>';
	}
}


/**
 * This function outputs mobile a navigation HTML structure combining both the top and primary menu items.
 *
 * It will only output the primary menu items from each menu and those items will contain information such as current menu item.
 */
function capture_mobile_menu() {
	global $post;

	// Make sure we have nav menus and they aren't empty
	$nav_menu_locations = get_nav_menu_locations();
	if ( $nav_menu_locations = array_filter( $nav_menu_locations ) ) :
		// Make sure the top menu is always above the primary menu
		array_multisort( $nav_menu_locations, SORT_DESC );
	?>
		<ul id="mobile-menu" class="menu mobile-menu mobile-nav">
			<li class="menu-item close-item close">
				<button class="mobile-nav-close-button">
					<!--[if gt IE 8]><!-->
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" width="100px" height="100px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve"><path fill="#FFFFFF" d="M63.973 49.999l34.76-34.762c1.335-1.333 1.335-3.494 0-4.826l-9.144-9.146 c-1.333-1.332-3.493-1.332-4.827 0L50 36.028L15.237 1.265c-1.332-1.332-3.493-1.332-4.826 0l-9.146 9.146 c-1.333 1.332-1.333 3.493 0 4.826l34.763 34.762L1.267 84.762c-1.334 1.334-1.334 3.493 0 4.826l9.145 9.146 c1.333 1.334 3.495 1.334 4.826 0L50 63.973l34.761 34.761c1.334 1.334 3.493 1.334 4.826 0l9.146-9.146 c1.333-1.333 1.333-3.492 0-4.826L63.973 49.999z"/></svg>
					<!--<![endif]-->
					<span class="mobile-nav-close-button-label"><?php _e( 'Close', 'capture' ); ?></span>
				</button>
			</li>
		<?php
			foreach( $nav_menu_locations as $menu_location_key => $menu_location ) :
				$nav_menu_object = wp_get_nav_menu_object( $menu_location ); // Get current nav menu object
		?>
				<li class="menu-item menu-label <?php echo $menu_location_key . '_label'; ?>"><?php echo $nav_menu_object->name; ?></li>
		<?php
				$nav_menu_items = wp_get_nav_menu_items( $menu_location );

				// Loop through nav items
				if ( ! empty( $nav_menu_items ) ) :
					foreach( $nav_menu_items as $menu_item ) :
						// Only parent elements
						if ( ! $menu_item->menu_item_parent ) :
						?>
							<li class="menu-item <?php echo ( $menu_item->object_id == $post->ID ) ? 'current-menu-item current-nav-item current_page_item' : false; ?>"><a href="<?php echo $menu_item->url; ?>"><?php echo $menu_item->title; ?></a></li>
						<?php
						endif;
					endforeach;
				endif;
			endforeach;
		?>
			<li class="social-media"><?php sds_social_media(); ?></li>
		</ul>
	<?php
	else : // No nav menus set
	?>
		<ul id="mobile-menu" class="menu mobile-menu mobile-nav">
			<li class="menu-item close-item close">
				<button class="mobile-nav-close-button">
					<!--[if gt IE 8]><!-->
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" width="100px" height="100px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve"><path fill="#FFFFFF" d="M63.973 49.999l34.76-34.762c1.335-1.333 1.335-3.494 0-4.826l-9.144-9.146 c-1.333-1.332-3.493-1.332-4.827 0L50 36.028L15.237 1.265c-1.332-1.332-3.493-1.332-4.826 0l-9.146 9.146 c-1.333 1.332-1.333 3.493 0 4.826l34.763 34.762L1.267 84.762c-1.334 1.334-1.334 3.493 0 4.826l9.145 9.146 c1.333 1.334 3.495 1.334 4.826 0L50 63.973l34.761 34.761c1.334 1.334 3.493 1.334 4.826 0l9.146-9.146 c1.333-1.333 1.333-3.492 0-4.826L63.973 49.999z"/></svg>
					<!--<![endif]-->
					<span class="mobile-nav-close-button-label"><?php _e( 'Close', 'capture' ); ?></span>
				</button>
			</li>
			<li class="menu-item menu-label primary_nav_label"><?php printf( __( '%1$s', 'capture' ), apply_filters( 'capture_primary_nav_fallback_label', 'Primary Menu:' ) ); ?></li>
	<?php
			wp_list_pages( array(
				'depth' => 1,
				'title_li' => false
			) );
	?>
			<li class="social-media"><?php sds_social_media(); ?></li>
		</ul>
	<?php
	endif;
}