<?php
/**
** activation theme
**/
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
 wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );

}


//-----------------------------------------------------------------------------------------------------------------------------
// Traduction de chaines de caracteres

function wpm_traduction($texte) { 
	$texte = str_ireplace('Address changed successfully', 'Your address has been changed', $texte); 
	return $texte; 
} 

add_filter('gettext', 'wpm_traduction'); 
add_filter('ngettext', 'wpm_traduction');
/* Ajouter un bouton "Continuer le shopping" sur la page panier */

add_action( 'woocommerce_after_cart_totals', 'wpm_continue_shopping_button' );

function wpm_continue_shopping_button() {

	 // On récupère le lien de votre page boutique   
	 $shop_page_url = get_permalink( woocommerce_get_page_id( 'shop' ) );
 
	 // On ajoute notre bouton 
	echo '<div class="wpm-continue-shopping">';
	echo ' <a href="'.$shop_page_url.'" class="button wpm-shopping-button">continue shopping</a>';
	echo '</div>';
}


//-----------------------------------------------------------------------------------------------------------------------------
// hide coupon field on the checkout page
function disable_coupon_field_on_checkout( $enabled ) {
	if ( is_checkout() ) {
		$enabled = false;
	}
	return $enabled;
}
add_filter( 'woocommerce_coupons_enabled', 'disable_coupon_field_on_checkout' );

function woo_custom_cart_button_text() {
 
  global $woocommerce;
  
  foreach($woocommerce->cart->get_cart() as $cart_item_key => $values ) {
    $_product = $values['data'];
  
    if( get_the_ID() == $_product->id ) {
      return __('Déjà dans le panier - Ajouter à nouveau ?', 'woocommerce');
    }
  }
  
  return __('Add to cart', 'woocommerce');
}


//-----------------------------------------------------------------------------------------------------------------------------
 /**
 * Mon compte custom menu items.
 *
 * @since 2.6.0
 * @return array
 */
function wpb_woo_mon_compte_order() {
 $myorder = array(
 'dashboard' => __( '', 'woocommerce' ),
 'orders' => __( '', 'woocommerce' ),
 'downloads' => __( '', 'woocommerce' ),
 'edit-address' => __( '', 'woocommerce' ),
 'payment-methods' => __( '', 'woocommerce' ),
 'edit-account' => __( '', 'woocommerce' ),
 'customer-logout' => __( '', 'woocommerce' ),
 );
 return $myorder;
}
add_filter ( 'woocommerce_account_menu_items', 'wpb_woo_mon_compte_order' );

//-----------------------------------------------------------------------------------------------------------------------------
add_filter( 'woocommerce_dropdown_variation_attribute_options_args', 'cinchws_filter_dropdown_args', 10 );

function cinchws_filter_dropdown_args( $args ) {
    $args['show_option_none'] = 'Choose it';
    return $args;
}

//-----------------------------------------------------------------------------------------------------------------------------
?>
