<?php
/*
Plugin Name: Footer Content Setup
Description: CDL Footer Customizer
Version: 1.0
Author: Inside Da Web
Author URI: http://www.insidedaweb.com/
*/


add_action( 'admin_menu', 'cdl_fcs_create_menu' );

add_action(  'admin_init', 'cdl_fcs_register_settings' );


/*
* Create submenu for settings page
*/
function cdl_fcs_create_menu(){
	add_submenu_page( 'options-general.php', 'CDL Footer Settings', 'CDL Footer Settings', 'administrator', __FILE__, 'cdl_fcs_settings_page' );
}

/*
* Register plugin settings
*/
function cdl_fcs_register_settings(){
	register_setting( 'cdl_fcs_settings', 'cdl_fcs_facebook' );
	register_setting( 'cdl_fcs_settings', 'cdl_fcs_google_plus' );
	register_setting( 'cdl_fcs_settings', 'cdl_fcs_social_p' );
	register_setting( 'cdl_fcs_settings', 'cdl_fcs_contact_title' );
	register_setting( 'cdl_fcs_settings', 'cdl_fcs_contact_phone' );
	register_setting( 'cdl_fcs_settings', 'cdl_fcs_contact_mail' );
	register_setting( 'cdl_fcs_settings', 'cdl_fcs_newsletter_text' );
}


/*
* Customize settings page
*/
function cdl_fcs_settings_page(){

	?>

	<div class="wrap">
		
		<?php screen_icon('plugins'); ?><h2>CDL Footer Content Setup</h2>

		<div id="message" class="updated" style="display: none;">Setting saved successfully</div>
		<div id="message" class="error" style="display: none;">Error saving settings</div>

		<form action="options.php" method="post">
			<?php
			settings_fields( 'cdl_fcs_settings' );
			?>
			<table class="form-table">


				<tr valign="top">
					<th scope="row"><label>Facebook link:</label></th>
					<td><input type="text" name="cdl_fcs_facebook" size="60" value="<?php print get_option( 'cdl_fcs_facebook' ) ; ?>"/></td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Google+ link:</label></th>
					<td><input type="text" name="cdl_fcs_google_plus" size="60" value="<?php print get_option( 'cdl_fcs_google_plus' ) ; ?>"/></td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>P link:</label></th>
					<td><input type="text" name="cdl_fcs_social_p" size="60" value="<?php print get_option( 'cdl_fcs_social_p' ) ; ?>"/></td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Contact title:</label></th>
					<td><input type="text" name="cdl_fcs_contact_title" size="60" value="<?php print get_option( 'cdl_fcs_contact_title' ) ; ?>"/></td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Contact phone:</label></th>
					<td><input type="text" name="cdl_fcs_contact_phone" size="60" value="<?php print get_option( 'cdl_fcs_contact_phone' ) ; ?>"/></td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Contact mail:</label></th>
					<td><input type="text" name="cdl_fcs_contact_mail" size="60" value="<?php print get_option( 'cdl_fcs_contact_mail' ) ; ?>"/></td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Newsletter form text:</label></th>
					<td><input type="text" name="cdl_fcs_newsletter_text" size="60" value="<?php print get_option( 'cdl_fcs_newsletter_text' ) ; ?>"/></td>
				</tr>


				<tr valign="top">
					<td><input type="submit" name="Save" value="<?php _e('Save Changes') ?>" class="button-primary" /></td>
				</tr>

			</table>
		</form>

	</div>

	<?php
}


?>