<?php
/**
 * Font Awesome
 *
 * @package Menu_Icons
 * @author Dzikri Aziz <kvcrvt@gmail.com>
 */


require_once dirname( __FILE__ ) . '/type-fonts.php';

/**
 * Icon type: Font Awesome
 *
 */
class Menu_Icons_Type_Fontawesome extends Menu_Icons_Type_Fonts {

	/**
	 * Holds icon type
	 *
	 * @since  0.1.0
	 * @access protected
	 * @var    string
	 */
	protected $type = 'fa';

	/**
	 * Custom stylesheet ID
	 *
	 * @since  0.8.0
	 * @access protected
	 * @var    string
	 */
	protected $stylesheet_id = 'font-awesome';

	/**
	 * Holds icon label
	 *
	 * @since  0.1.0
	 * @access protected
	 * @var    string
	 */
	protected $label = 'Font Awesome';

	/**
	 * Holds icon version
	 *
	 * @since  0.1.0
	 * @access protected
	 * @var    string
	 */
	protected $version = '4.4.0';


	/**
	 * Class constructor
	 *
	 * We need to override the parent's to set our stylesheet URL
	 *
	 * @since 0.1.0
	 * @param array $types Icon Types
	 * @return array
	 */
	public function __construct() {
		$this->stylesheet = sprintf(
			'%scss/font-awesome%s.css',
			Menu_Icons::get( 'url' ),
			Menu_Icons::get_script_suffix()
		);

		parent::__construct();
	}


	/**
	 * Genericons's icons names
	 *
	 * @since 0.1.0
	 * @return array
	 */
	public function get_names() {
		return array(
			array(
				'key'   => __( 'brand', 'menu-icons' ),
				'label' => __( 'Brand', 'menu-icons' ),
				'items' => array(
					'fa-500px'                => '500px',
					'fa-adn'                  => 'ADN',
					'fa-amazon'               => 'Amazon',
					'fa-android'              => 'Android',
					'fa-angellist'            => 'AngelList',
					'fa-apple'                => 'Apple',
					'fa-black-tie'            => 'BlackTie',
					'fa-behance'              => 'Behance',
					'fa-behance-square'       => 'Behance',
					'fa-bitbucket'            => 'Bitbucket',
					'fa-bitbucket-square'     => 'Bitbucket',
					'fa-buysellads'           => 'BuySellAds',
					'fa-chrome'               => 'Chrome',
					'fa-codepen'              => 'CodePen',
					'fa-connectdevelop'       => 'Connect + Develop',
					'fa-contao'               => 'Contao',
					'fa-creative-commons'     => 'Creative Commons',
					'fa-css3'                 => 'CSS3',
					'fa-dashcube'             => 'Dashcube',
					'fa-delicious'            => 'Delicious',
					'fa-deviantart'           => 'deviantART',
					'fa-digg'                 => 'Digg',
					'fa-dribbble'             => 'Dribbble',
					'fa-dropbox'              => 'DropBox',
					'fa-drupal'               => 'Drupal',
					'fa-empire'               => 'Empire',
					'fa-expeditedssl'         => 'ExpeditedSSL',
					'fa-facebook-official'    => 'Facebook',
					'fa-facebook-square'      => 'Facebook',
					'fa-facebook'             => 'Facebook',
					'fa-firefox'              => 'Firefox',
					'fa-flickr'               => 'Flickr',
					'fa-fonticons'            => 'FontIcons',
					'fa-forumbee'             => 'Forumbee',
					'fa-foursquare'           => 'Foursquare',
					'fa-get-pocket'           => 'Pocket',
					'fa-git'                  => 'Git',
					'fa-git-square'           => 'Git',
					'fa-github'               => 'GitHub',
					'fa-github-alt'           => 'GitHub',
					'fa-github-square'        => 'GitHub',
					'fa-gittip'               => 'GitTip',
					'fa-google'               => 'Google',
					'fa-google-plus'          => 'Google+',
					'fa-google-plus-square'   => 'Google+',
					'fa-hacker-news'          => 'Hacker News',
					'fa-houzz'                => 'Houzz',
					'fa-html5'                => 'HTML5',
					'fa-instagram'            => 'Instagram',
					'fa-internet-explorer'    => 'Internet Explorer',
					'fa-ioxhost'              => 'IoxHost',
					'fa-joomla'               => 'Joomla',
					'fa-jsfiddle'             => 'JSFiddle',
					'fa-lastfm'               => 'Last.fm',
					'fa-lastfm-square'        => 'Last.fm',
					'fa-leanpub'              => 'Leanpub',
					'fa-linkedin'             => 'LinkedIn',
					'fa-linkedin-square'      => 'LinkedIn',
					'fa-linux'                => 'Linux',
					'fa-maxcdn'               => 'MaxCDN',
					'fa-meanpath'             => 'meanpath',
					'fa-medium'               => 'Medium',
					'fa-odnoklassniki'        => 'Odnoklassniki',
					'fa-odnoklassniki-square' => 'Odnoklassniki',
					'fa-opencart'             => 'OpenCart',
					'fa-openid'               => 'OpenID',
					'fa-opera'                => 'Opera',
					'fa-optin-monster'        => 'OptinMonster',
					'fa-pagelines'            => 'Pagelines',
					'fa-pied-piper'           => 'Pied Piper',
					'fa-pied-piper-alt'       => 'Pied Piper',
					'fa-pinterest'            => 'Pinterest',
					'fa-pinterest-p'          => 'Pinterest',
					'fa-pinterest-square'     => 'Pinterest',
					'fa-qq'                   => 'QQ',
					'fa-reddit'               => 'reddit',
					'fa-reddit-square'        => 'reddit',
					'fa-renren'               => 'Renren',
					'fa-safari'               => 'Safari',
					'fa-sellsy'               => 'SELLSY',
					'fa-shirtsinbulk'         => 'Shirts In Bulk',
					'fa-simplybuilt'          => 'SimplyBuilt',
					'fa-skyatlas'             => 'Skyatlas',
					'fa-skype'                => 'Skype',
					'fa-slack'                => 'Slack',
					'fa-slideshare'           => 'SlideShare',
					'fa-soundcloud'           => 'SoundCloud',
					'fa-spotify'              => 'Spotify',
					'fa-stack-exchange'       => 'Stack Exchange',
					'fa-stack-overflow'       => 'Stack Overflow',
					'fa-steam'                => 'Steam',
					'fa-steam-square'         => 'Steam',
					'fa-stumbleupon'          => 'StumbleUpon',
					'fa-stumbleupon-circle'   => 'StumbleUpon',
					'fa-tencent-weibo'        => 'Tencent Weibo',
					'fa-trello'               => 'Trello',
					'fa-tripadvisor'          => 'TripAdvisor',
					'fa-tumblr'               => 'Tumblr',
					'fa-tumblr-square'        => 'Tumblr',
					'fa-twitch'               => 'Twitch',
					'fa-twitter'              => 'Twitter',
					'fa-twitter-square'       => 'Twitter',
					'fa-vimeo'                => 'Vimeo',
					'fa-vimeo-square'         => 'Vimeo',
					'fa-viacoin'              => 'Viacoin',
					'fa-vine'                 => 'Vine',
					'fa-vk'                   => 'VK',
					'fa-weixin'               => 'Weixin',
					'fa-weibo'                => 'Wibo',
					'fa-whatsapp'             => 'WhatsApp',
					'fa-wikipedia-w'          => 'Wikipedia',
					'fa-windows'              => 'Windows',
					'fa-wordpress'            => 'WordPress',
					'fa-xing'                 => 'Xing',
					'fa-xing-square'          => 'Xing',
					'fa-y-combinator'         => 'Y Combinator',
					'fa-yahoo'                => 'Yahoo!',
					'fa-yelp'                 => 'Yelp',
					'fa-youtube'              => 'YouTube',
					'fa-youtube-square'       => 'YouTube',
				),
			),
			array(
				'key'   => 'chart',
				'label' => __( 'Charts', 'menu-icons' ),
				'items' => array(
					'fa-area-chart'  => __( 'Area Chart', 'menu-icons' ),
					'fa-bar-chart-o' => __( 'Bar Chart', 'menu-icons' ),
					'fa-line-chart'  => __( 'Line Chart', 'menu-icons' ),
					'fa-pie-chart'   => __( 'Pie Chart', 'menu-icons' ),
				),
			),
			array(
				'key'   => 'currency',
				'label' => __( 'Currency', 'menu-icons' ),
				'items' => array(
					'fa-bitcoin'      => __( 'Bitcoin', 'menu-icons' ),
					'fa-dollar'       => __( 'Dollar', 'menu-icons' ),
					'fa-euro'         => __( 'Euro', 'menu-icons' ),
					'fa-gbp'          => __( 'GBP', 'menu-icons' ),
					'fa-gg'           => __( 'GBP', 'menu-icons' ),
					'fa-gg-circle'    => __( 'GG', 'menu-icons' ),
					'fa-ils'          => __( 'Israeli Sheqel', 'menu-icons' ),
					'fa-money'        => __( 'Money', 'menu-icons' ),
					'fa-rouble'       => __( 'Rouble', 'menu-icons' ),
					'fa-inr'          => __( 'Rupee', 'menu-icons' ),
					'fa-try'          => __( 'Turkish Lira', 'menu-icons' ),
					'fa-krw'          => __( 'Won', 'menu-icons' ),
					'fa-jpy'          => __( 'Yen', 'menu-icons' ),
				),
			),
			array(
				'key'   => 'directional',
				'label' => __( 'Directional', 'menu-icons' ),
				'items' => array(
					'fa-angle-down'           => __( 'Angle Down', 'menu-icons' ),
					'fa-angle-left'           => __( 'Angle Left', 'menu-icons' ),
					'fa-angle-right'          => __( 'Angle Right', 'menu-icons' ),
					'fa-angle-up'             => __( 'Angle Up', 'menu-icons' ),
					'fa-angle-double-down'    => __( 'Angle Double Down', 'menu-icons' ),
					'fa-angle-double-left'    => __( 'Angle Double Left', 'menu-icons' ),
					'fa-angle-double-right'   => __( 'Angle Double Right', 'menu-icons' ),
					'fa-angle-double-up'      => __( 'Angle Double Up', 'menu-icons' ),
					'fa-arrow-circle-o-down'  => __( 'Arrow Circle Down', 'menu-icons' ),
					'fa-arrow-circle-o-left'  => __( 'Arrow Circle Left', 'menu-icons' ),
					'fa-arrow-circle-o-right' => __( 'Arrow Circle Right', 'menu-icons' ),
					'fa-arrow-circle-o-up'    => __( 'Arrow Circle Up', 'menu-icons' ),
					'fa-arrow-circle-down'    => __( 'Arrow Circle Down', 'menu-icons' ),
					'fa-arrow-circle-left'    => __( 'Arrow Circle Left', 'menu-icons' ),
					'fa-arrow-circle-right'   => __( 'Arrow Circle Right', 'menu-icons' ),
					'fa-arrow-circle-up'      => __( 'Arrow Circle Up', 'menu-icons' ),
					'fa-arrow-down'           => __( 'Arrow Down', 'menu-icons' ),
					'fa-arrow-left'           => __( 'Arrow Left', 'menu-icons' ),
					'fa-arrow-right'          => __( 'Arrow Right', 'menu-icons' ),
					'fa-arrow-up'             => __( 'Arrow Up', 'menu-icons' ),
					'fa-arrows'               => __( 'Arrows', 'menu-icons' ),
					'fa-arrows-alt'           => __( 'Arrows', 'menu-icons' ),
					'fa-arrows-h'             => __( 'Arrows', 'menu-icons' ),
					'fa-arrows-v'             => __( 'Arrows', 'menu-icons' ),
					'fa-caret-down'           => __( 'Caret Down', 'menu-icons' ),
					'fa-caret-left'           => __( 'Caret Left', 'menu-icons' ),
					'fa-caret-right'          => __( 'Caret Right', 'menu-icons' ),
					'fa-caret-up'             => __( 'Caret Up', 'menu-icons' ),
					'fa-caret-square-o-down'  => __( 'Caret Down', 'menu-icons' ),
					'fa-caret-square-o-left'  => __( 'Caret Left', 'menu-icons' ),
					'fa-caret-square-o-right' => __( 'Caret Right', 'menu-icons' ),
					'fa-caret-square-o-up'    => __( 'Caret Up', 'menu-icons' ),
					'fa-chevron-circle-down'  => __( 'Chevron Circle Down', 'menu-icons' ),
					'fa-chevron-circle-left'  => __( 'Chevron Circle Left', 'menu-icons' ),
					'fa-chevron-circle-right' => __( 'Chevron Circle Right', 'menu-icons' ),
					'fa-chevron-circle-up'    => __( 'Chevron Circle Up', 'menu-icons' ),
					'fa-chevron-down'         => __( 'Chevron Down', 'menu-icons' ),
					'fa-chevron-left'         => __( 'Chevron Left', 'menu-icons' ),
					'fa-chevron-right'        => __( 'Chevron Right', 'menu-icons' ),
					'fa-chevron-up'           => __( 'Chevron Up', 'menu-icons' ),
					'fa-hand-o-down'          => __( 'Hand Down', 'menu-icons' ),
					'fa-hand-o-left'          => __( 'Hand Left', 'menu-icons' ),
					'fa-hand-o-right'         => __( 'Hand Right', 'menu-icons' ),
					'fa-hand-o-up'            => __( 'Hand Up', 'menu-icons' ),
					'fa-long-arrow-down'      => __( 'Long Arrow Down', 'menu-icons' ),
					'fa-long-arrow-left'      => __( 'Long Arrow Left', 'menu-icons' ),
					'fa-long-arrow-right'     => __( 'Long Arrow Right', 'menu-icons' ),
					'fa-long-arrow-up'        => __( 'Long Arrow Up', 'menu-icons' ),
				),
			),
			array(
				'key'   => 'file-types',
				'label' => __( 'File Types', 'menu-icons' ),
				'items' => array(
					'fa-file'              => __( 'File', 'menu-icons' ),
					'fa-file-o'            => __( 'File', 'menu-icons' ),
					'fa-file-text'         => __( 'File: Text', 'menu-icons' ),
					'fa-file-text-o'       => __( 'File: Text', 'menu-icons' ),
					'fa-file-archive-o'    => __( 'File: Archive', 'menu-icons' ),
					'fa-file-audio-o'      => __( 'File: Audio', 'menu-icons' ),
					'fa-file-code-o'       => __( 'File: Code', 'menu-icons' ),
					'fa-file-excel-o'      => __( 'File: Excel', 'menu-icons' ),
					'fa-file-image-o'      => __( 'File: Image', 'menu-icons' ),
					'fa-file-pdf-o'        => __( 'File: PDF', 'menu-icons' ),
					'fa-file-powerpoint-o' => __( 'File: Powerpoint', 'menu-icons' ),
					'fa-file-video-o'      => __( 'File: Video', 'menu-icons' ),
					'fa-file-word-o'       => __( 'File: Word', 'menu-icons' ),
				),
			),
			array(
				'key'   => 'form-control',
				'label' => __( 'Form Controls', 'menu-icons' ),
				'items' => array(
					'fa-check-square'   => __( 'Check', 'menu-icons' ),
					'fa-check-square-o' => __( 'Check', 'menu-icons' ),
					'fa-circle'         => __( 'Circle', 'menu-icons' ),
					'fa-circle-o'       => __( 'Circle', 'menu-icons' ),
					'fa-dot-circle-o'   => __( 'Dot', 'menu-icons' ),
					'fa-minus-square'   => __( 'Minus', 'menu-icons' ),
					'fa-minus-square-o' => __( 'Minus', 'menu-icons' ),
					'fa-plus-square'    => __( 'Plus', 'menu-icons' ),
					'fa-plus-square-o'  => __( 'Plus', 'menu-icons' ),
					'fa-square'         => __( 'Square', 'menu-icons' ),
					'fa-square-o'       => __( 'Square', 'menu-icons' ),
				),
			),
			array(
				'key'   => 'gender',
				'label' => __( 'Genders', 'menu-icons' ),
				'items' => array(
					'fa-genderless'      => __( 'Genderless', 'menu-icons' ),
					'fa-mars'            => __( 'Mars', 'menu-icons' ),
					'fa-mars-double'     => __( 'Mars', 'menu-icons' ),
					'fa-mars-stroke'     => __( 'Mars', 'menu-icons' ),
					'fa-mars-stroke-h'   => __( 'Mars', 'menu-icons' ),
					'fa-mars-stroke-v'   => __( 'Mars', 'menu-icons' ),
					'fa-mercury'         => __( 'Mercury', 'menu-icons' ),
					'fa-neuter'          => __( 'Neuter', 'menu-icons' ),
					'fa-transgender'     => __( 'Transgender', 'menu-icons' ),
					'fa-transgender-alt' => __( 'Transgender', 'menu-icons' ),
					'fa-venus'           => __( 'Venus', 'menu-icons' ),
					'fa-venus-double'    => __( 'Venus', 'menu-icons' ),
					'fa-venus-mars'      => __( 'Venus + Mars', 'menu-icons' ),
				),
			),
			array(
				'key'   => 'medical',
				'label' => __( 'Medical', 'menu-icons' ),
				'items' => array(
					'fa-heart'       => __( 'Heart', 'menu-icons' ),
					'fa-heart-o'     => __( 'Heart', 'menu-icons' ),
					'fa-heartbeat'   => __( 'Heartbeat', 'menu-icons' ),
					'fa-h-square'    => __( 'Hospital', 'menu-icons' ),
					'fa-hospital-o'  => __( 'Hospital', 'menu-icons' ),
					'fa-medkit'      => __( 'Medkit', 'menu-icons' ),
					'fa-stethoscope' => __( 'Stethoscope', 'menu-icons' ),
					'fa-user-md'     => __( 'User MD', 'menu-icons' ),
				),
			),
			array(
				'key'   => 'payment',
				'label' => __( 'Payment', 'menu-icons' ),
				'items' => array(
					'fa-cc-amex'         => 'American Express',
					'fa-credit-card'     => __( 'Credit Card', 'menu-icons' ),
					'fa-cc-diners-club'  => 'Diners Club',
					'fa-cc-discover'     => 'Discover',
					'fa-google-wallet'   => 'Google Wallet',
					'fa-cc-jcb'          => 'JCB',
					'fa-cc-mastercard'   => 'MasterCard',
					'fa-cc-paypal'       => 'PayPal',
					'fa-paypal'          => 'PayPal',
					'fa-cc-stripe'       => 'Stripe',
					'fa-cc-visa'         => 'Visa',
				),
			),
			array(
				'key'   => 'spinner',
				'label' => __( 'Spinners', 'menu-icons' ),
				'items' => array(
					'fa-circle-o-notch' => __( 'Circle', 'menu-icons' ),
					'fa-cog'            => __( 'Cog', 'menu-icons' ),
					'fa-refresh'        => __( 'Refresh', 'menu-icons' ),
					'fa-spinner'        => __( 'Spinner', 'menu-icons' ),
				),
			),
			array(
				'key'   => 'transportation',
				'label' => __( 'Transportation', 'menu-icons' ),
				'items' => array(
					'fa-ambulance'     => __( 'Ambulance', 'menu-icons' ),
					'fa-bicycle'       => __( 'Bicycle', 'menu-icons' ),
					'fa-bus'           => __( 'Bus', 'menu-icons' ),
					'fa-car'           => __( 'Car', 'menu-icons' ),
					'fa-fighter-jet'   => __( 'Fighter Jet', 'menu-icons' ),
					'fa-motorcycle'    => __( 'Motorcycle', 'menu-icons' ),
					'fa-plane'         => __( 'Plane', 'menu-icons' ),
					'fa-rocket'        => __( 'Rocket', 'menu-icons' ),
					'fa-ship'          => __( 'Ship', 'menu-icons' ),
					'fa-space-shuttle' => __( 'Space Shuttle', 'menu-icons' ),
					'fa-subway'        => __( 'Subway', 'menu-icons' ),
					'fa-taxi'          => __( 'Taxi', 'menu-icons' ),
					'fa-train'         => __( 'Train', 'menu-icons' ),
					'fa-truck'         => __( 'Truck', 'menu-icons' ),
					'fa-wheelchair'    => __( 'Wheelchair', 'menu-icons' ),
				),
			),
			array(
				'key'   => 'text-editor',
				'label' => __( 'Text Editor', 'menu-icons' ),
				'items' => array(
					'fa-align-left'    => __( 'Align Left', 'menu-icons' ),
					'fa-align-center'  => __( 'Align Center', 'menu-icons' ),
					'fa-align-justify' => __( 'Justify', 'menu-icons' ),
					'fa-align-right'   => __( 'Align Right', 'menu-icons' ),
					'fa-bold'          => __( 'Bold', 'menu-icons' ),
					'fa-clipboard'     => __( 'Clipboard', 'menu-icons' ),
					'fa-columns'       => __( 'Columns', 'menu-icons' ),
					'fa-copy'          => __( 'Copy', 'menu-icons' ),
					'fa-cut'           => __( 'Cut', 'menu-icons' ),
					'fa-paste'         => __( 'Paste', 'menu-icons' ),
					'fa-eraser'        => __( 'Eraser', 'menu-icons' ),
					'fa-files-o'       => __( 'Files', 'menu-icons' ),
					'fa-font'          => __( 'Font', 'menu-icons' ),
					'fa-header'        => __( 'Header', 'menu-icons' ),
					'fa-indent'        => __( 'Indent', 'menu-icons' ),
					'fa-outdent'       => __( 'Outdent', 'menu-icons' ),
					'fa-italic'        => __( 'Italic', 'menu-icons' ),
					'fa-link'          => __( 'Link', 'menu-icons' ),
					'fa-unlink'        => __( 'Unlink', 'menu-icons' ),
					'fa-list'          => __( 'List', 'menu-icons' ),
					'fa-list-alt'      => __( 'List', 'menu-icons' ),
					'fa-list-ol'       => __( 'Ordered List', 'menu-icons' ),
					'fa-list-ul'       => __( 'Unordered List', 'menu-icons' ),
					'fa-paperclip'     => __( 'Paperclip', 'menu-icons' ),
					'fa-paragraph'     => __( 'Paragraph', 'menu-icons' ),
					'fa-repeat'        => __( 'Repeat', 'menu-icons' ),
					'fa-undo'          => __( 'Undo', 'menu-icons' ),
					'fa-save'          => __( 'Save', 'menu-icons' ),
					'fa-strikethrough' => __( 'Strikethrough', 'menu-icons' ),
					'fa-subscript'     => __( 'Subscript', 'menu-icons' ),
					'fa-superscript'   => __( 'Superscript', 'menu-icons' ),
					'fa-table'         => __( 'Table', 'menu-icons' ),
					'fa-text-height'   => __( 'Text Height', 'menu-icons' ),
					'fa-text-width'    => __( 'Text Width', 'menu-icons' ),
					'fa-th'            => __( 'Table Header', 'menu-icons' ),
					'fa-th-large'      => __( 'TH Large', 'menu-icons' ),
					'fa-th-list'       => __( 'TH List', 'menu-icons' ),
					'fa-underline'     => __( 'Underline', 'menu-icons' ),
				),
			),
			array(
				'key'   => 'video-player',
				'label' => __( 'Video Player', 'menu-icons' ),
				'items' => array(
					'fa-arrows-alt'    => __( 'Arrows', 'menu-icons' ),
					'fa-backward'      => __( 'Backward', 'menu-icons' ),
					'fa-compress'      => __( 'Compress', 'menu-icons' ),
					'fa-eject'         => __( 'Eject', 'menu-icons' ),
					'fa-expand'        => __( 'Expand', 'menu-icons' ),
					'fa-fast-backward' => __( 'Fast Backward', 'menu-icons' ),
					'fa-fast-forward'  => __( 'Fast Forward', 'menu-icons' ),
					'fa-forward'       => __( 'Forward', 'menu-icons' ),
					'fa-pause'         => __( 'Pause', 'menu-icons' ),
					'fa-play'          => __( 'Play', 'menu-icons' ),
					'fa-play-circle'   => __( 'Play', 'menu-icons' ),
					'fa-play-circle-o' => __( 'Play', 'menu-icons' ),
					'fa-step-backward' => __( 'Step Backward', 'menu-icons' ),
					'fa-step-forward'  => __( 'Step Forward', 'menu-icons' ),
					'fa-stop'          => __( 'Stop', 'menu-icons' ),
					'fa-youtube-play'  => sprintf( __( '%s Play', 'menu-icons' ), 'YouTube' ),
				),
			),
			array(
				'key'   => 'web-application',
				'label' => __( 'Web Application', 'menu-icons' ),
				'items' => array(
					'fa-adjust'               => __( 'Adjust', 'menu-icons' ),
					'fa-anchor'               => __( 'Anchor', 'menu-icons' ),
					'fa-archive'              => __( 'Archive', 'menu-icons' ),
					'fa-arrows'               => __( 'Arrows', 'menu-icons' ),
					'fa-arrows-h'             => __( 'Arrows', 'menu-icons' ),
					'fa-arrows-v'             => __( 'Arrows', 'menu-icons' ),
					'fa-asterisk'             => __( 'Asterisk', 'menu-icons' ),
					'fa-at'                   => __( 'At', 'menu-icons' ),
					'fa-balance-scale'        => __( 'Balance', 'menu-icons' ),
					'fa-ban'                  => __( 'Ban', 'menu-icons' ),
					'fa-barcode'              => __( 'Barcode', 'menu-icons' ),
					'fa-bars'                 => __( 'Bars', 'menu-icons' ),
					'fa-battery-empty'        => __( 'Battery', 'menu-icons' ),
					'fa-battery-quarter'      => __( 'Battery', 'menu-icons' ),
					'fa-battery-half'         => __( 'Battery', 'menu-icons' ),
					'fa-battery-full'         => __( 'Battery', 'menu-icons' ),
					'fa-bed'                  => __( 'Bed', 'menu-icons' ),
					'fa-beer'                 => __( 'Beer', 'menu-icons' ),
					'fa-bell'                 => __( 'Bell', 'menu-icons' ),
					'fa-bell-o'               => __( 'Bell', 'menu-icons' ),
					'fa-bell-slash'           => __( 'Bell', 'menu-icons' ),
					'fa-bell-slash-o'         => __( 'Bell', 'menu-icons' ),
					'fa-binoculars'           => __( 'Binoculars', 'menu-icons' ),
					'fa-birthday-cake'        => __( 'Birthday Cake', 'menu-icons' ),
					'fa-bolt'                 => __( 'Bolt', 'menu-icons' ),
					'fa-book'                 => __( 'Book', 'menu-icons' ),
					'fa-bookmark'             => __( 'Bookmark', 'menu-icons' ),
					'fa-bookmark-o'           => __( 'Bookmark', 'menu-icons' ),
					'fa-bomb'                 => __( 'Bomb', 'menu-icons' ),
					'fa-briefcase'            => __( 'Briefcase', 'menu-icons' ),
					'fa-bug'                  => __( 'Bug', 'menu-icons' ),
					'fa-building'             => __( 'Building', 'menu-icons' ),
					'fa-building-o'           => __( 'Building', 'menu-icons' ),
					'fa-bullhorn'             => __( 'Bullhorn', 'menu-icons' ),
					'fa-bullseye'             => __( 'Bullseye', 'menu-icons' ),
					'fa-calculator'           => __( 'Calculator', 'menu-icons' ),
					'fa-calendar'             => __( 'Calendar', 'menu-icons' ),
					'fa-calendar-o'           => __( 'Calendar', 'menu-icons' ),
					'fa-calendar-check-o'     => __( 'Calendar', 'menu-icons' ),
					'fa-calendar-minus-o'     => __( 'Calendar', 'menu-icons' ),
					'fa-calendar-times-o'     => __( 'Calendar', 'menu-icons' ),
					'fa-camera'               => __( 'Camera', 'menu-icons' ),
					'fa-camera-retro'         => __( 'Camera Retro', 'menu-icons' ),
					'fa-caret-square-o-down'  => __( 'Caret Down', 'menu-icons' ),
					'fa-caret-square-o-left'  => __( 'Caret Left', 'menu-icons' ),
					'fa-caret-square-o-right' => __( 'Caret Right', 'menu-icons' ),
					'fa-caret-square-o-up'    => __( 'Caret Up', 'menu-icons' ),
					'fa-cart-arrow-down'      => __( 'Cart Arrow Down', 'menu-icons' ),
					'fa-cart-plus'            => __( 'Cart Plus', 'menu-icons' ),
					'fa-certificate'          => __( 'Certificate', 'menu-icons' ),
					'fa-check'                => __( 'Check', 'menu-icons' ),
					'fa-check-circle'         => __( 'Check', 'menu-icons' ),
					'fa-check-circle-o'       => __( 'Check', 'menu-icons' ),
					'fa-child'                => __( 'Child', 'menu-icons' ),
					'fa-circle-thin'          => __( 'Circle', 'menu-icons' ),
					'fa-clock-o'              => __( 'Clock', 'menu-icons' ),
					'fa-clone'                => __( 'Clone', 'menu-icons' ),
					'fa-cloud'                => __( 'Cloud', 'menu-icons' ),
					'fa-cloud-download'       => __( 'Cloud Download', 'menu-icons' ),
					'fa-cloud-upload'         => __( 'Cloud Upload', 'menu-icons' ),
					'fa-code'                 => __( 'Code', 'menu-icons' ),
					'fa-code-fork'            => __( 'Code Fork', 'menu-icons' ),
					'fa-coffee'               => __( 'Coffee', 'menu-icons' ),
					'fa-cogs'                 => __( 'Cogs', 'menu-icons' ),
					'fa-comment'              => __( 'Comment', 'menu-icons' ),
					'fa-comment-o'            => __( 'Comment', 'menu-icons' ),
					'fa-comments'             => __( 'Comments', 'menu-icons' ),
					'fa-comments-o'           => __( 'Comments', 'menu-icons' ),
					'fa-commenting'           => __( 'Commenting', 'menu-icons' ),
					'fa-commenting-o'         => __( 'Commenting', 'menu-icons' ),
					'fa-compass'              => __( 'Compass', 'menu-icons' ),
					'fa-copyright'            => __( 'Copyright', 'menu-icons' ),
					'fa-credit-card'          => __( 'Credit Card', 'menu-icons' ),
					'fa-crop'                 => __( 'Crop', 'menu-icons' ),
					'fa-crosshairs'           => __( 'Crosshairs', 'menu-icons' ),
					'fa-cube'                 => __( 'Cube', 'menu-icons' ),
					'fa-cubes'                => __( 'Cubes', 'menu-icons' ),
					'fa-i-cursor'             => __( 'Cursor', 'menu-icons' ),
					'fa-cutlery'              => __( 'Cutlery', 'menu-icons' ),
					'fa-dashboard'            => __( 'Dashboard', 'menu-icons' ),
					'fa-database'             => __( 'Database', 'menu-icons' ),
					'fa-desktop'              => __( 'Desktop', 'menu-icons' ),
					'fa-diamond'              => __( 'Diamond', 'menu-icons' ),
					'fa-download'             => __( 'Download', 'menu-icons' ),
					'fa-edit'                 => __( 'Edit', 'menu-icons' ),
					'fa-ellipsis-h'           => __( 'Ellipsis', 'menu-icons' ),
					'fa-ellipsis-v'           => __( 'Ellipsis', 'menu-icons' ),
					'fa-envelope'             => __( 'Envelope', 'menu-icons' ),
					'fa-envelope-o'           => __( 'Envelope', 'menu-icons' ),
					'fa-envelope-square'      => __( 'Envelope', 'menu-icons' ),
					'fa-eraser'               => __( 'Eraser', 'menu-icons' ),
					'fa-exchange'             => __( 'Exchange', 'menu-icons' ),
					'fa-exclamation'          => __( 'Exclamation', 'menu-icons' ),
					'fa-exclamation-circle'   => __( 'Exclamation', 'menu-icons' ),
					'fa-exclamation-triangle' => __( 'Exclamation', 'menu-icons' ),
					'fa-external-link'        => __( 'External Link', 'menu-icons' ),
					'fa-external-link-square' => __( 'External Link', 'menu-icons' ),
					'fa-eye'                  => __( 'Eye', 'menu-icons' ),
					'fa-eye-slash'            => __( 'Eye', 'menu-icons' ),
					'fa-eyedropper'           => __( 'Eye Dropper', 'menu-icons' ),
					'fa-fax'                  => __( 'Fax', 'menu-icons' ),
					'fa-female'               => __( 'Female', 'menu-icons' ),
					'fa-film'                 => __( 'Film', 'menu-icons' ),
					'fa-filter'               => __( 'Filter', 'menu-icons' ),
					'fa-fire'                 => __( 'Fire', 'menu-icons' ),
					'fa-fire-extinguisher'    => __( 'Fire Extinguisher', 'menu-icons' ),
					'fa-flag'                 => __( 'Flag', 'menu-icons' ),
					'fa-flag-checkered'       => __( 'Flag', 'menu-icons' ),
					'fa-flag-o'               => __( 'Flag', 'menu-icons' ),
					'fa-flash'                => __( 'Flash', 'menu-icons' ),
					'fa-flask'                => __( 'Flask', 'menu-icons' ),
					'fa-folder'               => __( 'Folder', 'menu-icons' ),
					'fa-folder-open'          => __( 'Folder Open', 'menu-icons' ),
					'fa-folder-o'             => __( 'Folder', 'menu-icons' ),
					'fa-folder-open-o'        => __( 'Folder Open', 'menu-icons' ),
					'fa-futbol-o'             => __( 'Foot Ball', 'menu-icons' ),
					'fa-frown-o'              => __( 'Frown', 'menu-icons' ),
					'fa-gamepad'              => __( 'Gamepad', 'menu-icons' ),
					'fa-gavel'                => __( 'Gavel', 'menu-icons' ),
					'fa-gear'                 => __( 'Gear', 'menu-icons' ),
					'fa-gears'                => __( 'Gears', 'menu-icons' ),
					'fa-gift'                 => __( 'Gift', 'menu-icons' ),
					'fa-glass'                => __( 'Glass', 'menu-icons' ),
					'fa-globe'                => __( 'Globe', 'menu-icons' ),
					'fa-graduation-cap'       => __( 'Graduation Cap', 'menu-icons' ),
					'fa-group'                => __( 'Group', 'menu-icons' ),
					'fa-hand-lizard-o'        => __( 'Hand', 'menu-icons' ),
					'fa-hand-paper-o'         => __( 'Hand', 'menu-icons' ),
					'fa-hand-peace-o'         => __( 'Hand', 'menu-icons' ),
					'fa-hand-pointer-o'       => __( 'Hand', 'menu-icons' ),
					'fa-hand-rock-o'          => __( 'Hand', 'menu-icons' ),
					'fa-hand-scissors-o'      => __( 'Hand', 'menu-icons' ),
					'fa-hand-spock-o'         => __( 'Hand', 'menu-icons' ),
					'fa-hdd-o'                => __( 'HDD', 'menu-icons' ),
					'fa-headphones'           => __( 'Headphones', 'menu-icons' ),
					'fa-home'                 => __( 'Home', 'menu-icons' ),
					'fa-hourglass-o'          => __( 'Hourglass', 'menu-icons' ),
					'fa-hourglass-start'      => __( 'Hourglass', 'menu-icons' ),
					'fa-hourglass-half'       => __( 'Hourglass', 'menu-icons' ),
					'fa-hourglass-end'        => __( 'Hourglass', 'menu-icons' ),
					'fa-hourglass'            => __( 'Hourglass', 'menu-icons' ),
					'fa-history'              => __( 'History', 'menu-icons' ),
					'fa-inbox'                => __( 'Inbox', 'menu-icons' ),
					'fa-industry'             => __( 'Industry', 'menu-icons' ),
					'fa-info'                 => __( 'Info', 'menu-icons' ),
					'fa-info-circle'          => __( 'Info', 'menu-icons' ),
					'fa-key'                  => __( 'Key', 'menu-icons' ),
					'fa-keyboard-o'           => __( 'Keyboard', 'menu-icons' ),
					'fa-language'             => __( 'Language', 'menu-icons' ),
					'fa-laptop'               => __( 'Laptop', 'menu-icons' ),
					'fa-leaf'                 => __( 'Leaf', 'menu-icons' ),
					'fa-legal'                => __( 'Legal', 'menu-icons' ),
					'fa-lemon-o'              => __( 'Lemon', 'menu-icons' ),
					'fa-level-down'           => __( 'Level Down', 'menu-icons' ),
					'fa-level-up'             => __( 'Level Up', 'menu-icons' ),
					'fa-life-ring'            => __( 'Life Buoy', 'menu-icons' ),
					'fa-lightbulb-o'          => __( 'Lightbulb', 'menu-icons' ),
					'fa-location-arrow'       => __( 'Location Arrow', 'menu-icons' ),
					'fa-lock'                 => __( 'Lock', 'menu-icons' ),
					'fa-magic'                => __( 'Magic', 'menu-icons' ),
					'fa-magnet'               => __( 'Magnet', 'menu-icons' ),
					'fa-mail-forward'         => __( 'Mail Forward', 'menu-icons' ),
					'fa-mail-reply'           => __( 'Mail Reply', 'menu-icons' ),
					'fa-mail-reply-all'       => __( 'Mail Reply All', 'menu-icons' ),
					'fa-male'                 => __( 'Male', 'menu-icons' ),
					'fa-map'                  => __( 'Map', 'menu-icons' ),
					'fa-map-o'                => __( 'Map', 'menu-icons' ),
					'fa-map-marker'           => __( 'Map Marker', 'menu-icons' ),
					'fa-map-pin'              => __( 'Map Pin', 'menu-icons' ),
					'fa-map-signs'            => __( 'Map Signs', 'menu-icons' ),
					'fa-meh-o'                => __( 'Meh', 'menu-icons' ),
					'fa-microphone'           => __( 'Microphone', 'menu-icons' ),
					'fa-microphone-slash'     => __( 'Microphone', 'menu-icons' ),
					'fa-minus'                => __( 'Minus', 'menu-icons' ),
					'fa-minus-circle'         => __( 'Minus', 'menu-icons' ),
					'fa-mobile'               => __( 'Mobile', 'menu-icons' ),
					'fa-mobile-phone'         => __( 'Mobile Phone', 'menu-icons' ),
					'fa-moon-o'               => __( 'Moon', 'menu-icons' ),
					'fa-mouse-pointer'        => __( 'Mouse Pointer', 'menu-icons' ),
					'fa-music'                => __( 'Music', 'menu-icons' ),
					'fa-newspaper-o'          => __( 'Newspaper', 'menu-icons' ),
					'fa-object-group'         => __( 'Object Group', 'menu-icons' ),
					'fa-object-ungroup'       => __( 'Object Ungroup', 'menu-icons' ),
					'fa-paint-brush'          => __( 'Paint Brush', 'menu-icons' ),
					'fa-paper-plane'          => __( 'Paper Plane', 'menu-icons' ),
					'fa-paper-plane-o'        => __( 'Paper Plane', 'menu-icons' ),
					'fa-paw'                  => __( 'Paw', 'menu-icons' ),
					'fa-pencil'               => __( 'Pencil', 'menu-icons' ),
					'fa-pencil-square'        => __( 'Pencil', 'menu-icons' ),
					'fa-pencil-square-o'      => __( 'Pencil', 'menu-icons' ),
					'fa-phone'                => __( 'Phone', 'menu-icons' ),
					'fa-phone-square'         => __( 'Phone', 'menu-icons' ),
					'fa-picture-o'            => __( 'Picture', 'menu-icons' ),
					'fa-plug'                 => __( 'Plug', 'menu-icons' ),
					'fa-plus'                 => __( 'Plus', 'menu-icons' ),
					'fa-plus-circle'          => __( 'Plus', 'menu-icons' ),
					'fa-power-off'            => __( 'Power Off', 'menu-icons' ),
					'fa-print'                => __( 'Print', 'menu-icons' ),
					'fa-puzzle-piece'         => __( 'Puzzle Piece', 'menu-icons' ),
					'fa-qrcode'               => __( 'QR Code', 'menu-icons' ),
					'fa-question'             => __( 'Question', 'menu-icons' ),
					'fa-question-circle'      => __( 'Question', 'menu-icons' ),
					'fa-quote-left'           => __( 'Quote Left', 'menu-icons' ),
					'fa-quote-right'          => __( 'Quote Right', 'menu-icons' ),
					'fa-random'               => __( 'Random', 'menu-icons' ),
					'fa-rebel'                => __( 'Rebel', 'menu-icons' ),
					'fa-recycle'              => __( 'Recycle', 'menu-icons' ),
					'fa-registered'           => __( 'Registered', 'menu-icons' ),
					'fa-reply'                => __( 'Reply', 'menu-icons' ),
					'fa-reply-all'            => __( 'Reply All', 'menu-icons' ),
					'fa-retweet'              => __( 'Retweet', 'menu-icons' ),
					'fa-road'                 => __( 'Road', 'menu-icons' ),
					'fa-rss'                  => __( 'RSS', 'menu-icons' ),
					'fa-rss-square'           => __( 'RSS Square', 'menu-icons' ),
					'fa-search'               => __( 'Search', 'menu-icons' ),
					'fa-search-minus'         => __( 'Search Minus', 'menu-icons' ),
					'fa-search-plus'          => __( 'Search Plus', 'menu-icons' ),
					'fa-server'               => __( 'Server', 'menu-icons' ),
					'fa-share'                => __( 'Share', 'menu-icons' ),
					'fa-share-alt'            => __( 'Share', 'menu-icons' ),
					'fa-share-alt-square'     => __( 'Share', 'menu-icons' ),
					'fa-share-square'         => __( 'Share', 'menu-icons' ),
					'fa-share-square-o'       => __( 'Share', 'menu-icons' ),
					'fa-shield'               => __( 'Shield', 'menu-icons' ),
					'fa-shopping-cart'        => __( 'Shopping Cart', 'menu-icons' ),
					'fa-sign-in'              => __( 'Sign In', 'menu-icons' ),
					'fa-sign-out'             => __( 'Sign Out', 'menu-icons' ),
					'fa-signal'               => __( 'Signal', 'menu-icons' ),
					'fa-sitemap'              => __( 'Sitemap', 'menu-icons' ),
					'fa-sliders'              => __( 'Sliders', 'menu-icons' ),
					'fa-smile-o'              => __( 'Smile', 'menu-icons' ),
					'fa-sort'                 => __( 'Sort', 'menu-icons' ),
					'fa-sort-asc'             => __( 'Sort ASC', 'menu-icons' ),
					'fa-sort-desc'            => __( 'Sort DESC', 'menu-icons' ),
					'fa-sort-down'            => __( 'Sort Down', 'menu-icons' ),
					'fa-sort-up'              => __( 'Sort Up', 'menu-icons' ),
					'fa-sort-alpha-asc'       => __( 'Sort Alpha ASC', 'menu-icons' ),
					'fa-sort-alpha-desc'      => __( 'Sort Alpha DESC', 'menu-icons' ),
					'fa-sort-amount-asc'      => __( 'Sort Amount ASC', 'menu-icons' ),
					'fa-sort-amount-desc'     => __( 'Sort Amount DESC', 'menu-icons' ),
					'fa-sort-numeric-asc'     => __( 'Sort Numeric ASC', 'menu-icons' ),
					'fa-sort-numeric-desc'    => __( 'Sort Numeric DESC', 'menu-icons' ),
					'fa-spoon'                => __( 'Spoon', 'menu-icons' ),
					'fa-star'                 => __( 'Star', 'menu-icons' ),
					'fa-star-half'            => __( 'Star Half', 'menu-icons' ),
					'fa-star-half-o'          => __( 'Star Half', 'menu-icons' ),
					'fa-star-half-empty'      => __( 'Star Half Empty', 'menu-icons' ),
					'fa-star-half-full'       => __( 'Star Half Full', 'menu-icons' ),
					'fa-star-o'               => __( 'Star', 'menu-icons' ),
					'fa-sticky-note'          => __( 'Sticky Note', 'menu-icons' ),
					'fa-sticky-note-o'        => __( 'Sticky Note', 'menu-icons' ),
					'fa-street-view'          => __( 'Street View', 'menu-icons' ),
					'fa-suitcase'             => __( 'Suitcase', 'menu-icons' ),
					'fa-sun-o'                => __( 'Sun', 'menu-icons' ),
					'fa-tablet'               => __( 'Tablet', 'menu-icons' ),
					'fa-tachometer'           => __( 'Tachometer', 'menu-icons' ),
					'fa-tag'                  => __( 'Tag', 'menu-icons' ),
					'fa-tags'                 => __( 'Tags', 'menu-icons' ),
					'fa-tasks'                => __( 'Tasks', 'menu-icons' ),
					'fa-television'           => __( 'Television', 'menu-icons' ),
					'fa-terminal'             => __( 'Terminal', 'menu-icons' ),
					'fa-thumb-tack'           => __( 'Thumb Tack', 'menu-icons' ),
					'fa-thumbs-down'          => __( 'Thumbs Down', 'menu-icons' ),
					'fa-thumbs-up'            => __( 'Thumbs Up', 'menu-icons' ),
					'fa-thumbs-o-down'        => __( 'Thumbs Down', 'menu-icons' ),
					'fa-thumbs-o-up'          => __( 'Thumbs Up', 'menu-icons' ),
					'fa-ticket'               => __( 'Ticket', 'menu-icons' ),
					'fa-times'                => __( 'Times', 'menu-icons' ),
					'fa-times-circle'         => __( 'Times', 'menu-icons' ),
					'fa-times-circle-o'       => __( 'Times', 'menu-icons' ),
					'fa-tint'                 => __( 'Tint', 'menu-icons' ),
					'fa-toggle-down'          => __( 'Toggle Down', 'menu-icons' ),
					'fa-toggle-left'          => __( 'Toggle Left', 'menu-icons' ),
					'fa-toggle-right'         => __( 'Toggle Right', 'menu-icons' ),
					'fa-toggle-up'            => __( 'Toggle Up', 'menu-icons' ),
					'fa-toggle-off'           => __( 'Toggle Off', 'menu-icons' ),
					'fa-toggle-on'            => __( 'Toggle On', 'menu-icons' ),
					'fa-trademark'            => __( 'Trademark', 'menu-icons' ),
					'fa-trash'                => __( 'Trash', 'menu-icons' ),
					'fa-trash-o'              => __( 'Trash', 'menu-icons' ),
					'fa-tree'                 => __( 'Tree', 'menu-icons' ),
					'fa-trophy'               => __( 'Trophy', 'menu-icons' ),
					'fa-tty'                  => __( 'TTY', 'menu-icons' ),
					'fa-umbrella'             => __( 'Umbrella', 'menu-icons' ),
					'fa-university'           => __( 'University', 'menu-icons' ),
					'fa-unlock'               => __( 'Unlock', 'menu-icons' ),
					'fa-unlock-alt'           => __( 'Unlock', 'menu-icons' ),
					'fa-unsorted'             => __( 'Unsorted', 'menu-icons' ),
					'fa-upload'               => __( 'Upload', 'menu-icons' ),
					'fa-user'                 => __( 'User', 'menu-icons' ),
					'fa-users'                => __( 'Users', 'menu-icons' ),
					'fa-user-plus'            => __( 'User: Add', 'menu-icons' ),
					'fa-user-times'           => __( 'User: Remove', 'menu-icons' ),
					'fa-user-secret'          => __( 'User: Password', 'menu-icons' ),
					'fa-video-camera'         => __( 'Video Camera', 'menu-icons' ),
					'fa-volume-down'          => __( 'Volume Down', 'menu-icons' ),
					'fa-volume-off'           => __( 'Volume Of', 'menu-icons' ),
					'fa-volume-up'            => __( 'Volume Up', 'menu-icons' ),
					'fa-warning'              => __( 'Warning', 'menu-icons' ),
					'fa-wifi'                 => __( 'WiFi', 'menu-icons' ),
					'fa-wrench'               => __( 'Wrench', 'menu-icons' ),
				),
			),
		);
	}
}
