<?php
/*
Plugin Name: Team CPT
Description: adds team managing functions
*/
add_action( 'init', 'team_manager_register' );

function team_manager_register(){
  $args = array(
    'label' => __( 'Équipe' ),
    'singular_label' => __( 'Équipe' ),
    'public' => true,
    'show_ui' => true,
    'capability_type' => 'post',
    'hierarchical' => true,
    'has_archive' => true,
    'supports' => array( 'title', 'editor', 'thumbnail' ),
    'rewrite' => array('slug' => 'team', 'with_front' => false),
  );
  
  register_post_type( 'team', $args );
  register_taxonomy( "team-type", array( "team" ), array("hierarchical" => true, "label" => "Team Types", "singular_label" => "Team Type", "rewrite" => true, "slug" => 'team-type') );
}

add_action( 'admin_init', 'team_manager_add_meta' );

function team_manager_add_meta(){
  add_meta_box( 'team-meta-box', 'Function in team', 'team_manager_meta_options', 'team', 'normal', 'high' );
}

function team_manager_meta_options(){
  global $post;
  
  if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return $post_id;
  
  $custom = get_post_custom( $post->ID );
  $function = $custom['function'][0];
  
  ?>
  <div class="team_manager_extras">
  
    <div><label style="width: 120px; margin-right: 10px;">Function:</label><input type="text" name="function" value="<?php echo $function; ?>" style="width: 300px;"></div>
  
  </div>
  
  <?php
}

add_action( 'save_post', 'team_manager_save_extras' );

function team_manager_save_extras(){
  global $post;
  
  if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
    return $post_id;
  }else{
    update_post_meta( $post->ID, 'function', $_POST['function'] );
  }
}

?>