<?php
	// Make theme available for translation
	// Translations can be filed in the /languages/ directory
	load_theme_textdomain( 'hbd-theme', TEMPLATEPATH . '/languages' );

	function cdl_scripts(){
	
	wp_register_script( 'jquery_cookie', get_stylesheet_directory_uri() . '/js/jquery.cookie.js' );
	wp_enqueue_script('jquery_cookie');
	
	wp_register_script( 'scancube', get_stylesheet_directory_uri() . '/js/scancuber.js' );
	wp_enqueue_script('scancube');
	
	wp_enqueue_style( 'scancube_st', 'http://cdn.scancube.com/v14/scancube-jzspin1.4.css' );	
}

add_action('wp_enqueue_scripts', 'cdl_scripts');

	add_theme_support( 'menus' );
	add_theme_support('post-formats', array( 'aside'));

//add_action('wp_head', 'show_template');
//function show_template() {
//	global $template;
//	print_r($template);
//}

	$locale = get_locale();
	$locale_file = TEMPLATEPATH . "/languages/$locale.php";
	if ( is_readable($locale_file) )
	    require_once($locale_file);

	// Get the page number
	function get_page_number() {
	    if ( get_query_var('paged') ) {
	        print ' | ' . __( 'Page ' , 'hbd-theme') . get_query_var('paged');
	    }
	} // end get_page_number

	// Custom callback to list comments in the hbd-theme style
	function custom_comments($comment, $args, $depth) {
	  $GLOBALS['comment'] = $comment;
	    $GLOBALS['comment_depth'] = $depth;
	  ?>
	    <li id="comment-<?php comment_ID() ?>" <?php comment_class() ?>>
	        <div class="comment-author vcard"><?php commenter_link() ?></div>
	        <div class="comment-meta"><?php printf(__('Posted %1$s at %2$s <span class="meta-sep">|</span> <a href="%3$s" title="Permalink to this comment">Permalink</a>', 'hbd-theme'),
	                    get_comment_date(),
	                    get_comment_time(),
	                    '#comment-' . get_comment_ID() );
	                    edit_comment_link(__('Edit', 'hbd-theme'), ' <span class="meta-sep">|</span> <span class="edit-link">', '</span>'); ?></div>
	  <?php if ($comment->comment_approved == '0') _e("\t\t\t\t\t<span class='unapproved'>Your comment is awaiting moderation.</span>\n", 'hbd-theme') ?>
	          <div class="comment-content">
	            <?php comment_text() ?>
	        </div>
	        <?php // echo the comment reply link
	            if($args['type'] == 'all' || get_comment_type() == 'comment') :
	                comment_reply_link(array_merge($args, array(
	                    'reply_text' => __('Reply','hbd-theme'),
	                    'login_text' => __('Log in to reply.','hbd-theme'),
	                    'depth' => $depth,
	                    'before' => '<div class="comment-reply-link">',
	                    'after' => '</div>'
	                )));
	            endif;
	        ?>
	<?php } // end custom_comments
	
	// Custom callback to list pings
	function custom_pings($comment, $args, $depth) {
	       $GLOBALS['comment'] = $comment;
	        ?>
	            <li id="comment-<?php comment_ID() ?>" <?php comment_class() ?>>
	                <div class="comment-author"><?php printf(__('By %1$s on %2$s at %3$s', 'hbd-theme'),
	                        get_comment_author_link(),
	                        get_comment_date(),
	                        get_comment_time() );
	                        edit_comment_link(__('Edit', 'hbd-theme'), ' <span class="meta-sep">|</span> <span class="edit-link">', '</span>'); ?></div>
	    <?php if ($comment->comment_approved == '0') _e('\t\t\t\t\t<span class="unapproved">Your trackback is awaiting moderation.</span>\n', 'hbd-theme') ?>
	            <div class="comment-content">
	                <?php comment_text() ?>
	            </div>
	<?php } // end custom_pings
	
	// Produces an avatar image with the hCard-compliant photo class
	function commenter_link() {
	    $commenter = get_comment_author_link();
	    if ( ereg( '<a[^>]* class=[^>]+>', $commenter ) ) {
	        $commenter = ereg_replace( '(<a[^>]* class=[\'"]?)', '\\1url ' , $commenter );
	    } else {
	        $commenter = ereg_replace( '(<a )/', '\\1class="url "' , $commenter );
	    }
	    $avatar_email = get_comment_author_email();
	    $avatar = str_replace( "class='avatar", "class='photo avatar", get_avatar( $avatar_email, 80 ) );
	    echo $avatar . ' <span class="fn n">' . $commenter . '</span>';
	} // end commenter_link
	
	// For category lists on category archives: Returns other categories except the current one (redundant)
	function cats_meow($glue) {
	    $current_cat = single_cat_title( '', false );
	    $separator = "\n";
	    $cats = explode( $separator, get_the_category_list($separator) );
	    foreach ( $cats as $i => $str ) {
	        if ( strstr( $str, ">$current_cat<" ) ) {
	            unset($cats[$i]);
	            break;
	        }
	    }
	    if ( empty($cats) )
	        return false;

	    return trim(join( $glue, $cats ));
	} // end cats_meow
	
	// For tag lists on tag archives: Returns other tags except the current one (redundant)
	function tag_ur_it($glue) {
	    $current_tag = single_tag_title( '', '',  false );
	    $separator = "\n";
	    $tags = explode( $separator, get_the_tag_list( "", "$separator", "" ) );
	    foreach ( $tags as $i => $str ) {
	        if ( strstr( $str, ">$current_tag<" ) ) {
	            unset($tags[$i]);
	            break;
	        }
	    }
	    if ( empty($tags) )
	        return false;

	    return trim(join( $glue, $tags ));
	} // end tag_ur_it
	
	// Register widgetized areas
	function theme_widgets_init() {
	    // Area 1
	    register_sidebar( array (
	    'name' => 'Primary Widget Area',
	    'id' => 'primary_widget_area',
	    'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
	    'after_widget' => "</li>",
	    'before_title' => '<h3 class="widget-title">',
	    'after_title' => '</h3>',
	  ) );

	    // Area 2
	    register_sidebar( array (
	    'name' => 'Secondary Widget Area',
	    'id' => 'secondary_widget_area',
	    'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
	    'after_widget' => "</li>",
	    'before_title' => '<h3 class="widget-title">',
	    'after_title' => '</h3>',
	  ) );
	} // end theme_widgets_init

	add_action( 'init', 'theme_widgets_init' );
	
	$preset_widgets = array (
	    'primary_widget_area'  => array( 'search', 'pages', 'categories', 'archives' ),
	    'secondary_widget_area'  => array( 'links', 'meta' )
	);
	if ( isset( $_GET['activated'] ) ) {
	    update_option( 'sidebars_widgets', $preset_widgets );
	}
	// update_option( 'sidebars_widgets', NULL );
	
	// Check for static widgets in widget-ready areas
	function is_sidebar_active( $index ){
	  global $wp_registered_sidebars;

	  $widgetcolums = wp_get_sidebars_widgets();

	  if ($widgetcolums[$index]) return true;

	    return false;
	} // end is_sidebar_active
	
	// custom add menus
	add_action( 'init', 'register_my_menus' );

	function register_my_menus() 
	{
		register_nav_menus(
			array(
			'menu-1' => __( 'Header Menu' ),
			'menu-2' => __( 'Footer Menu' ),
			'menu-3' => __( 'Home Page Menu' )
			)
		);
	}
	
	// Remove Scripts
	function childtheme_deregister_scripts() {
	wp_deregister_script( 'infieldlabel' );
	}
	add_action( 'wp_print_scripts', 'childtheme_deregister_scripts', 100 );
	
	


function redirect_user_on_role()
{
	//retrieve current user info 
	global $current_user;
     	get_currentuserinfo();
 	//If login user role is Subscriber
     	if ($current_user->user_level == 0)
     	{
        	wp_redirect( home_url() ); exit;
     	}
}
add_action('admin_init','redirect_user_on_role');

add_theme_support( 'post-thumbnails' );

add_image_size( 'reguliere-thumb', 170, 170, false );
add_image_size( 'ephemere-thumb', 255, 255, false );
add_image_size( 'for-zoom-thumb', 700, 700, false );

// Include featured article function
require_once( "iwb-theme-fixes.php" );

function is_post_type($type){
    global $wp_query;
    if($type == get_post_type($wp_query->post->ID)) return true;
    return false;
}





add_action( 'admin_init', 'scancube_add_meta' );

function scancube_add_meta(){
    add_meta_box( 'scancube-meta-box', 'Scancube image nom', 'scancube_meta_options', 'wpsc-product', 'normal', 'high' );
}

function scancube_meta_options(){
    global $post;

    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return $post_id;

    $custom = get_post_custom( $post->ID );
    $scancube_nom = $custom['scancube_nom'][0];
    $scancube_nom2 = $custom['scancube_nom2'][0];

    ?>
    <div class="scancube_extras">

        <div>
            <label style="width: 120px; margin-right: 10px;">Nom low definition:</label><input type="text" name="scancube_nom" value="<?php echo $scancube_nom; ?>" style="width: 300px;">
            <label style="width: 120px; margin-right: 10px;">Nom high definition:</label><input type="text" name="scancube_nom2" value="<?php echo $scancube_nom2; ?>" style="width: 300px;">
        </div>

    </div>

    <?php
}

add_action( 'save_post', 'scancube_save_extras' );

function scancube_save_extras(){
    global $post;

    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
        return $post_id;
    }else{
        update_post_meta( $post->ID, 'scancube_nom', $_POST['scancube_nom'] );
        update_post_meta( $post->ID, 'scancube_nom2', $_POST['scancube_nom2'] );
    }
}

?>
