<?php
/*
Plugin Name: IWB-Models
Description: Adds model managing options for your products;
*/
add_action( 'init', 'iwb_model_manager_register' );

function iwb_model_manager_register(){
	$args = array(
		'label' => __( 'Models' ),
		'singular_label' => __( 'Model' ),
		'public' => true,
		'show_ui' => true,
		'capability_type' => 'post',
		'hierarchical' => true,
		'has_archive' => true,
		'supports' => array( 'title', 'thumbnail' ),
		'rewrite' => array('slug' => 'iwb-model', 'with_front' => false),
	);
	
	register_post_type( 'iwb-model', $args );

}

// Moving Featured image box 
add_action('do_meta_boxes', 'iwb_customposttype_image_box_3');

function iwb_customposttype_image_box_3() {

	remove_meta_box( 'postimagediv', 'iwb-model', 'side' );

	add_meta_box('postimagediv', __('Model image'), 'post_thumbnail_meta_box', 'iwb-model', 'normal', 'high');

}

// End of moving featured image box

add_action( 'admin_init', 'iwb_model_manager_add_meta' );

function iwb_model_manager_add_meta(){
	add_meta_box( 'model-meta-box', 'Model', 'iwb_model_manager_meta_options', 'wpsc-product', 'normal', 'high' );  
}

function iwb_model_manager_meta_options(){

	// select box 
	
	echo '<style>
	
	.model-select-meta-box{
			position: relative;
			background: #fff;
			width: 222px;
	}
	
	.model-select-meta-box:hover .model-select-meta-box ul{
			display: block;
	}
	
	.model-select-caption{
			display: block;
			width: 220px;
			height: 25px;
			text-align: center;
			background: #fefefe;
			color: #333;
			line-height: 25px;
			border: 1px solid #ccc;
			text-decoration: none;
	}
	
	.model-select-meta-box ul{
			display: none;
			position: absolute;
			top: 25px;
			left: 0;
			width: 220px;
			margin: 0;
			padding: 0;
			background: #fff;
			border: 1px solid #ccc; 
			z-index: 99;  
	}
	
	#model-select-ul-inner{
			padding: 5px;
	}
	#model-select-ul-inner li.selected{
		border: 1px solid #ccc;
	}
	
	.model-select-meta-box ul li{
			display: block;  
	}
	
	.model-select-meta-box ul li:hover a,
	.model-select-meta-box ul li:hover a.selected{
			border: 1px solid #ccc;
	}
	
	.model-select-meta-box ul li a{
			display: table;
			width: 100%;
			overflow: hidden;
			text-align: center;
			border: 1px solid #fff;
	}
	.model-select-meta-box ul li a span{
			display: table-cell;
			width: 50%;
			vertical-align: middle;
			text-align: center;
			color: #555;
			text-decoration: none;
	}
	
	</style>';

	global $post;
	
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return $post_id;
	
	$iwb_custom_model = get_post_custom( $post->ID );
	$iwb_product_model = $iwb_custom_model['iwb_product_model'][0];

	$iwb_model_loop_args = array(
	'post_type' => 'iwb-model',
	'posts_per_page' => '-1',
	);

	// Save original loop for later
  	$original_post = $post;
	
	$iwb_model_loop = get_posts( $iwb_model_loop_args );
	
	echo '<div class="model_manager_extras">';
	
	echo '<div class="model-select-meta-box">';
	
	echo '<a href="#" class="model-select-caption">Select model</a>';
	
	echo '<ul id="model-select-ul" style="display: none;">';
	echo '<div id="model-select-ul-inner" >';

	$iwb_prod_modle_title = 'none';

	if ( true ) :
	
		foreach( $iwb_model_loop as $post ) : setup_postdata($post);
		
			echo '<li '. (( $post->ID == $iwb_product_model ) ? 'class= "selected"' : '').'><a href="#" ' . ( ( $post->ID == $iwb_product_model ) ? 'class= "selected"' : '' ) . ' val="';
			echo $post->ID;
			echo '" title="';
			echo $post->post_title;
			echo '"><span style="text-align: center;">';
			echo get_the_post_thumbnail($post->ID, 'standard', array(
									'title' => trim( strip_tags( $post->post_title ) ),
								)); 
			echo '</span><span style="text-align: center;">'. ( trim( strip_tags( $post->post_title ) ) ) .'</span></a></li>';

			if( $post->ID == $iwb_product_model ) { $iwb_prod_modle_title = get_the_title(); }
			
		endforeach;

	else:

    echo 'Aucune modèl disponible';

  	endif;

	// Reset loop now back to original post
  	$post = $original_post;
  	wp_reset_postdata();
	
	echo "<div style='clear: both; height: 0; content: " . '"."' . "; visibility: hidden; display: block;'></div>";
	
	echo '<input type="hidden" name="iwb_product_model" value="' . $iwb_product_model . '">';
	
	echo '</div>';
		
	echo '</ul>';
	
	echo '</div>';

	?>
	<script type="text/javascript">

	var $j = jQuery.noConflict();

	$j(function(){
			$j(".model-select-meta-box").click(function(event){
				event.preventDefault();
				$j("#model-select-ul").toggle('medium');
			});

			$j(".model-select-meta-box ul a").click(function(){
				var val = $j(this).attr('val');
				var name = $j(this).attr('title');
				$j(this).parent().parent().find("input[type='hidden']").attr('value',val);
				$j("#model-select-selected").html(name);
				//fix for e-commerce plugin
				$j( ".product_custom_meta input[value='iwb_product_model']" ).parent().find("textarea").val( val );
			});

			$j("#model-select-ul-inner li").click(function(){
				$j(this).siblings().removeClass("selected");
				$j(this).addClass("selected");
			});

	});

	</script>


	<?php

	// end select box 

	echo '<br>';

	echo 'Sélectionné: ';

	echo ' <span id="model-select-selected">' . $iwb_prod_modle_title.'</span>';
	
	echo '</div>';
	
	
}

add_action( 'save_post', 'iwb_model_manager_save_extras' );

function iwb_model_manager_save_extras(){
	global $post;
	
	if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
		return $post_id;
	}else{

			update_post_meta( $post->ID, 'iwb_product_model', $_POST['iwb_product_model'] );
	
	}
}


?>
