<?php
/*
Plugin Name: IWB-Sizes
Description: Adds size managing options for your products;
*/
add_action( 'init', 'iwb_size_manager_register' );

function iwb_size_manager_register(){
	$args = array(
		'label' => __( 'Sizes' ),
		'singular_label' => __( 'Size' ),
		'public' => true,
		'show_ui' => true,
		'capability_type' => 'post',
		'hierarchical' => true,
		'has_archive' => true,
		'supports' => array( 'title', 'thumbnail' ),
		'rewrite' => array('slug' => 'iwb-size', 'with_front' => false),
	);
	
	register_post_type( 'iwb-size', $args );

}

// Moving Featured image box 
add_action('do_meta_boxes', 'iwb_customposttype_image_box_2');

function iwb_customposttype_image_box_2() {

	remove_meta_box( 'postimagediv', 'iwb-size', 'side' );

	add_meta_box('postimagediv', __('Size image'), 'post_thumbnail_meta_box', 'iwb-size', 'normal', 'high');

}

// End of moving featured image box

add_action( 'admin_init', 'iwb_size_manager_add_meta' );

function iwb_size_manager_add_meta(){
	add_meta_box( 'size-meta-box', 'Size', 'iwb_size_manager_meta_options', 'wpsc-product', 'normal', 'high' );  
}

function iwb_size_manager_meta_options(){

	// select box 
	
	echo '<style>
	
	.size-select-meta-box{
			position: relative;
			background: #fff;
			width: 222px;
	}
	
	.size-select-meta-box:hover .size-select-meta-box ul{
			display: block;
	}
	
	.size-select-caption{
			display: block;
			width: 220px;
			height: 25px;
			text-align: center;
			background: #fefefe;
			color: #333;
			line-height: 25px;
			border: 1px solid #ccc;
			text-decoration: none;
	}
	
	.size-select-meta-box ul{
			display: none;
			position: absolute;
			top: 25px;
			left: 0;
			width: 220px;
			margin: 0;
			padding: 0;
			background: #fff;
			border: 1px solid #ccc; 
			z-index: 99;  
	}
	
	#size-select-ul-inner{
			padding: 5px;
	}
	
	.size-select-meta-box ul li{
			display: block;  
	}
	
	.size-select-meta-box ul li:hover a,
	.size-select-meta-box ul li:hover a.selected{
			border: 1px solid #ccc;
	}
	
	.size-select-meta-box ul li a{
			display: block;
			margin: 2px;
			overflow: hidden;
			text-align: center;
			border: 1px solid #fff;
	}
	
	</style>';

	global $post;
	
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return $post_id;
	
	$iwb_custom_size = get_post_custom( $post->ID );
	$iwb_product_size = $iwb_custom_size['iwb_product_size'][0];

	$iwb_loop_args = array(
	'post_type' => 'iwb-size',
	);

	// Save original loop for later
  $original_post = $post;
	
	$iwb_size_loop = get_posts( $iwb_loop_args );
	
	echo '<div class="size_manager_extras">';
	
	echo '<div class="size-select-meta-box">';
	
	echo '<a href="#" class="size-select-caption">Select size</a>';
	
	echo '<ul id="size-select-ul" style="display: none;">';
	echo '<div id="size-select-ul-inner" >';

	$iwb_prod_size_title = 'none';

	if ( true ) :
	
		foreach( $iwb_size_loop as $post ) : setup_postdata($post);
		
			echo '<li ><a href="#" ' . ( ( $post->ID == $iwb_product_size ) ? 'class= "selected"' : '' ) . ' val="';
			echo $post->ID;
			echo '" title="';
			echo $post->post_title;
			echo '">';
			echo get_the_post_thumbnail($post->ID, 'standard', array(
									'title' => trim(strip_tags( $post->post_title )),
								)); 
			echo '</a></li>';

			if( $post->ID == $iwb_product_size ) { $iwb_prod_size_title = get_the_title(); }
			
		endforeach;

	else:

    echo 'No sizes are inserted yet.';

  endif;

	// Reset loop now back to original post
  $post = $original_post;
  wp_reset_postdata();
	
	echo "<div style='clear: both; height: 0; content: " . '"."' . "; visibility: hidden; display: block;'></div>";
	
	echo '<input type="hidden" name="iwb_product_size" value="' . $iwb_product_size . '">';
	
	echo '</div>';
		
	echo '</ul>';
	
	echo '</div>';

	?>
	<script type="text/javascript">

	var $j = jQuery.noConflict();

	$j(function(){
			$j(".size-select-meta-box").click(function(event){
				event.preventDefault();
				$j("#size-select-ul").toggle('medium');
			});

			$j(".size-select-meta-box ul a").click(function(){
				var val = $j(this).attr('val');
				var name = $j(this).attr('title');
				$j(this).parent().parent().find("input[type='hidden']").attr('value',val);
				$j("#size-select-selected").html(name);
				//fix for e-commerce plugin
				$j( ".product_custom_meta input[value='iwb_product_size']" ).parent().find("textarea").val( val );
			});

	});

	</script>


	<?php

	// end select box 

	echo '<br>';

	echo 'selected: ';

	echo ' <span id="size-select-selected">' . $iwb_prod_size_title.'</span>';
	
	echo '</div>';
	
	
}

add_action( 'save_post', 'iwb_size_manager_save_extras' );

function iwb_size_manager_save_extras(){
	global $post;
	
	if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
		return $post_id;
	}else{
		update_post_meta( $post->ID, 'iwb_product_size', $_POST['iwb_product_size'] );
	}
}


?>