<?php
 namespace MailPoetVendor\Doctrine\DBAL\Platforms; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint; use MailPoetVendor\Doctrine\DBAL\Schema\Identifier; use MailPoetVendor\Doctrine\DBAL\Schema\Index; use MailPoetVendor\Doctrine\DBAL\Schema\Table; use MailPoetVendor\Doctrine\DBAL\Schema\TableDiff; use MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel; use MailPoetVendor\Doctrine\DBAL\Types\BlobType; use MailPoetVendor\Doctrine\DBAL\Types\TextType; use InvalidArgumentException; use function array_diff_key; use function array_merge; use function array_unique; use function array_values; use function count; use function func_get_args; use function implode; use function in_array; use function is_numeric; use function is_string; use function sprintf; use function str_replace; use function strtoupper; use function trim; class MySqlPlatform extends \MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform { public const LENGTH_LIMIT_TINYTEXT = 255; public const LENGTH_LIMIT_TEXT = 65535; public const LENGTH_LIMIT_MEDIUMTEXT = 16777215; public const LENGTH_LIMIT_TINYBLOB = 255; public const LENGTH_LIMIT_BLOB = 65535; public const LENGTH_LIMIT_MEDIUMBLOB = 16777215; protected function doModifyLimitQuery($query, $limit, $offset) { if ($limit !== null) { $query .= ' LIMIT ' . $limit; if ($offset > 0) { $query .= ' OFFSET ' . $offset; } } elseif ($offset > 0) { $query .= ' LIMIT 18446744073709551615 OFFSET ' . $offset; } return $query; } public function getIdentifierQuoteCharacter() { return '`'; } public function getRegexpExpression() { return 'RLIKE'; } public function getGuidExpression() { return 'UUID()'; } public function getLocateExpression($str, $substr, $startPos = \false) { if ($startPos === \false) { return 'LOCATE(' . $substr . ', ' . $str . ')'; } return 'LOCATE(' . $substr . ', ' . $str . ', ' . $startPos . ')'; } public function getConcatExpression() { return \sprintf('CONCAT(%s)', \implode(', ', \func_get_args())); } protected function getDateArithmeticIntervalExpression($date, $operator, $interval, $unit) { $function = $operator === '+' ? 'DATE_ADD' : 'DATE_SUB'; return $function . '(' . $date . ', INTERVAL ' . $interval . ' ' . $unit . ')'; } public function getDateDiffExpression($date1, $date2) { return 'DATEDIFF(' . $date1 . ', ' . $date2 . ')'; } public function getListDatabasesSQL() { return 'SHOW DATABASES'; } public function getListTableConstraintsSQL($table) { return 'SHOW INDEX FROM ' . $table; } public function getListTableIndexesSQL($table, $currentDatabase = null) { if ($currentDatabase) { $currentDatabase = $this->quoteStringLiteral($currentDatabase); $table = $this->quoteStringLiteral($table); return 'SELECT TABLE_NAME AS `Table`, NON_UNIQUE AS Non_Unique, INDEX_NAME AS Key_name, ' . 'SEQ_IN_INDEX AS Seq_in_index, COLUMN_NAME AS Column_Name, COLLATION AS Collation, ' . 'CARDINALITY AS Cardinality, SUB_PART AS Sub_Part, PACKED AS Packed, ' . 'NULLABLE AS `Null`, INDEX_TYPE AS Index_Type, COMMENT AS Comment ' . 'FROM information_schema.STATISTICS WHERE TABLE_NAME = ' . $table . ' AND TABLE_SCHEMA = ' . $currentDatabase . ' ORDER BY SEQ_IN_INDEX ASC'; } return 'SHOW INDEX FROM ' . $table; } public function getListViewsSQL($database) { $database = $this->quoteStringLiteral($database); return 'SELECT * FROM information_schema.VIEWS WHERE TABLE_SCHEMA = ' . $database; } public function getListTableForeignKeysSQL($table, $database = null) { $table = $this->quoteStringLiteral($table); if ($database !== null) { $database = $this->quoteStringLiteral($database); } $sql = 'SELECT DISTINCT k.`CONSTRAINT_NAME`, k.`COLUMN_NAME`, k.`REFERENCED_TABLE_NAME`, ' . 'k.`REFERENCED_COLUMN_NAME` /*!50116 , c.update_rule, c.delete_rule */ ' . 'FROM information_schema.key_column_usage k /*!50116 ' . 'INNER JOIN information_schema.referential_constraints c ON ' . '  c.constraint_name = k.constraint_name AND ' . '  c.table_name = ' . $table . ' */ WHERE k.table_name = ' . $table; $databaseNameSql = $database ?? 'DATABASE()'; $sql .= ' AND k.table_schema = ' . $databaseNameSql . ' /*!50116 AND c.constraint_schema = ' . $databaseNameSql . ' */'; $sql .= ' AND k.`REFERENCED_COLUMN_NAME` is not NULL'; return $sql; } public function getCreateViewSQL($name, $sql) { return 'CREATE VIEW ' . $name . ' AS ' . $sql; } public function getDropViewSQL($name) { return 'DROP VIEW ' . $name; } protected function getVarcharTypeDeclarationSQLSnippet($length, $fixed) { return $fixed ? $length ? 'CHAR(' . $length . ')' : 'CHAR(255)' : ($length ? 'VARCHAR(' . $length . ')' : 'VARCHAR(255)'); } protected function getBinaryTypeDeclarationSQLSnippet($length, $fixed) { return $fixed ? 'BINARY(' . ($length ?: 255) . ')' : 'VARBINARY(' . ($length ?: 255) . ')'; } public function getClobTypeDeclarationSQL(array $field) { if (!empty($field['length']) && \is_numeric($field['length'])) { $length = $field['length']; if ($length <= static::LENGTH_LIMIT_TINYTEXT) { return 'TINYTEXT'; } if ($length <= static::LENGTH_LIMIT_TEXT) { return 'TEXT'; } if ($length <= static::LENGTH_LIMIT_MEDIUMTEXT) { return 'MEDIUMTEXT'; } } return 'LONGTEXT'; } public function getDateTimeTypeDeclarationSQL(array $fieldDeclaration) { if (isset($fieldDeclaration['version']) && $fieldDeclaration['version'] === \true) { return 'TIMESTAMP'; } return 'DATETIME'; } public function getDateTypeDeclarationSQL(array $fieldDeclaration) { return 'DATE'; } public function getTimeTypeDeclarationSQL(array $fieldDeclaration) { return 'TIME'; } public function getBooleanTypeDeclarationSQL(array $field) { return 'TINYINT(1)'; } public function getCollationFieldDeclaration($collation) { return $this->getColumnCollationDeclarationSQL($collation); } public function prefersIdentityColumns() { return \true; } public function supportsIdentityColumns() { return \true; } public function supportsInlineColumnComments() { return \true; } public function supportsColumnCollation() { return \true; } public function getListTablesSQL() { return "SHOW FULL TABLES WHERE Table_type = 'BASE TABLE'"; } public function getListTableColumnsSQL($table, $database = null) { $table = $this->quoteStringLiteral($table); if ($database) { $database = $this->quoteStringLiteral($database); } else { $database = 'DATABASE()'; } return 'SELECT COLUMN_NAME AS Field, COLUMN_TYPE AS Type, IS_NULLABLE AS `Null`, ' . 'COLUMN_KEY AS `Key`, COLUMN_DEFAULT AS `Default`, EXTRA AS Extra, COLUMN_COMMENT AS Comment, ' . 'CHARACTER_SET_NAME AS CharacterSet, COLLATION_NAME AS Collation ' . 'FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ' . $database . ' AND TABLE_NAME = ' . $table . ' ORDER BY ORDINAL_POSITION ASC'; } public function getListTableMetadataSQL(string $table, ?string $database = null) : string { return \sprintf(<<<'SQL'
SELECT ENGINE, AUTO_INCREMENT, TABLE_COLLATION, TABLE_COMMENT, CREATE_OPTIONS
FROM information_schema.TABLES
WHERE TABLE_TYPE = 'BASE TABLE' AND TABLE_SCHEMA = %s AND TABLE_NAME = %s
SQL
, $database ? $this->quoteStringLiteral($database) : 'DATABASE()', $this->quoteStringLiteral($table)); } public function getCreateDatabaseSQL($name) { return 'CREATE DATABASE ' . $name; } public function getDropDatabaseSQL($name) { return 'DROP DATABASE ' . $name; } protected function _getCreateTableSQL($tableName, array $columns, array $options = []) { $queryFields = $this->getColumnDeclarationListSQL($columns); if (isset($options['uniqueConstraints']) && !empty($options['uniqueConstraints'])) { foreach ($options['uniqueConstraints'] as $index => $definition) { $queryFields .= ', ' . $this->getUniqueConstraintDeclarationSQL($index, $definition); } } if (isset($options['indexes']) && !empty($options['indexes'])) { foreach ($options['indexes'] as $index => $definition) { $queryFields .= ', ' . $this->getIndexDeclarationSQL($index, $definition); } } if (isset($options['primary']) && !empty($options['primary'])) { $keyColumns = \array_unique(\array_values($options['primary'])); $queryFields .= ', PRIMARY KEY(' . \implode(', ', $keyColumns) . ')'; } $query = 'CREATE '; if (!empty($options['temporary'])) { $query .= 'TEMPORARY '; } $query .= 'TABLE ' . $tableName . ' (' . $queryFields . ') '; $query .= $this->buildTableOptions($options); $query .= $this->buildPartitionOptions($options); $sql = [$query]; $engine = 'INNODB'; if (isset($options['engine'])) { $engine = \strtoupper(\trim($options['engine'])); } if (isset($options['foreignKeys']) && $engine === 'INNODB') { foreach ((array) $options['foreignKeys'] as $definition) { $sql[] = $this->getCreateForeignKeySQL($definition, $tableName); } } return $sql; } public function getDefaultValueDeclarationSQL($field) { if ($field['type'] instanceof \MailPoetVendor\Doctrine\DBAL\Types\TextType || $field['type'] instanceof \MailPoetVendor\Doctrine\DBAL\Types\BlobType) { $field['default'] = null; } return parent::getDefaultValueDeclarationSQL($field); } private function buildTableOptions(array $options) { if (isset($options['table_options'])) { return $options['table_options']; } $tableOptions = []; if (!isset($options['charset'])) { $options['charset'] = 'utf8'; } $tableOptions[] = \sprintf('DEFAULT CHARACTER SET %s', $options['charset']); if (!isset($options['collate'])) { $options['collate'] = $options['charset'] . '_unicode_ci'; } $tableOptions[] = \sprintf('COLLATE %s', $options['collate']); if (!isset($options['engine'])) { $options['engine'] = 'InnoDB'; } $tableOptions[] = \sprintf('ENGINE = %s', $options['engine']); if (isset($options['auto_increment'])) { $tableOptions[] = \sprintf('AUTO_INCREMENT = %s', $options['auto_increment']); } if (isset($options['comment'])) { $comment = \trim($options['comment'], " '"); $tableOptions[] = \sprintf('COMMENT = %s ', $this->quoteStringLiteral($comment)); } if (isset($options['row_format'])) { $tableOptions[] = \sprintf('ROW_FORMAT = %s', $options['row_format']); } return \implode(' ', $tableOptions); } private function buildPartitionOptions(array $options) { return isset($options['partition_options']) ? ' ' . $options['partition_options'] : ''; } public function getAlterTableSQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $columnSql = []; $queryParts = []; if ($diff->newName !== \false) { $queryParts[] = 'RENAME TO ' . $diff->getNewName()->getQuotedName($this); } foreach ($diff->addedColumns as $column) { if ($this->onSchemaAlterTableAddColumn($column, $diff, $columnSql)) { continue; } $columnArray = $column->toArray(); $columnArray['comment'] = $this->getColumnComment($column); $queryParts[] = 'ADD ' . $this->getColumnDeclarationSQL($column->getQuotedName($this), $columnArray); } foreach ($diff->removedColumns as $column) { if ($this->onSchemaAlterTableRemoveColumn($column, $diff, $columnSql)) { continue; } $queryParts[] = 'DROP ' . $column->getQuotedName($this); } foreach ($diff->changedColumns as $columnDiff) { if ($this->onSchemaAlterTableChangeColumn($columnDiff, $diff, $columnSql)) { continue; } $column = $columnDiff->column; $columnArray = $column->toArray(); if ($columnDiff->hasChanged('default') && \count($columnDiff->changedProperties) === 1 && ($columnArray['type'] instanceof \MailPoetVendor\Doctrine\DBAL\Types\TextType || $columnArray['type'] instanceof \MailPoetVendor\Doctrine\DBAL\Types\BlobType)) { continue; } $columnArray['comment'] = $this->getColumnComment($column); $queryParts[] = 'CHANGE ' . $columnDiff->getOldColumnName()->getQuotedName($this) . ' ' . $this->getColumnDeclarationSQL($column->getQuotedName($this), $columnArray); } foreach ($diff->renamedColumns as $oldColumnName => $column) { if ($this->onSchemaAlterTableRenameColumn($oldColumnName, $column, $diff, $columnSql)) { continue; } $oldColumnName = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($oldColumnName); $columnArray = $column->toArray(); $columnArray['comment'] = $this->getColumnComment($column); $queryParts[] = 'CHANGE ' . $oldColumnName->getQuotedName($this) . ' ' . $this->getColumnDeclarationSQL($column->getQuotedName($this), $columnArray); } if (isset($diff->addedIndexes['primary'])) { $keyColumns = \array_unique(\array_values($diff->addedIndexes['primary']->getColumns())); $queryParts[] = 'ADD PRIMARY KEY (' . \implode(', ', $keyColumns) . ')'; unset($diff->addedIndexes['primary']); } $sql = []; $tableSql = []; if (!$this->onSchemaAlterTable($diff, $tableSql)) { if (\count($queryParts) > 0) { $sql[] = 'ALTER TABLE ' . $diff->getName($this)->getQuotedName($this) . ' ' . \implode(', ', $queryParts); } $sql = \array_merge($this->getPreAlterTableIndexForeignKeySQL($diff), $sql, $this->getPostAlterTableIndexForeignKeySQL($diff)); } return \array_merge($sql, $tableSql, $columnSql); } protected function getPreAlterTableIndexForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $sql = []; $table = $diff->getName($this)->getQuotedName($this); foreach ($diff->changedIndexes as $changedIndex) { $sql = \array_merge($sql, $this->getPreAlterTableAlterPrimaryKeySQL($diff, $changedIndex)); } foreach ($diff->removedIndexes as $remKey => $remIndex) { $sql = \array_merge($sql, $this->getPreAlterTableAlterPrimaryKeySQL($diff, $remIndex)); foreach ($diff->addedIndexes as $addKey => $addIndex) { if ($remIndex->getColumns() === $addIndex->getColumns()) { $indexClause = 'INDEX ' . $addIndex->getName(); if ($addIndex->isPrimary()) { $indexClause = 'PRIMARY KEY'; } elseif ($addIndex->isUnique()) { $indexClause = 'UNIQUE INDEX ' . $addIndex->getName(); } $query = 'ALTER TABLE ' . $table . ' DROP INDEX ' . $remIndex->getName() . ', '; $query .= 'ADD ' . $indexClause; $query .= ' (' . $this->getIndexFieldDeclarationListSQL($addIndex) . ')'; $sql[] = $query; unset($diff->removedIndexes[$remKey], $diff->addedIndexes[$addKey]); break; } } } $engine = 'INNODB'; if ($diff->fromTable instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table && $diff->fromTable->hasOption('engine')) { $engine = \strtoupper(\trim($diff->fromTable->getOption('engine'))); } if ($engine !== 'INNODB') { $diff->addedForeignKeys = []; $diff->changedForeignKeys = []; $diff->removedForeignKeys = []; } $sql = \array_merge($sql, $this->getPreAlterTableAlterIndexForeignKeySQL($diff), parent::getPreAlterTableIndexForeignKeySQL($diff), $this->getPreAlterTableRenameIndexForeignKeySQL($diff)); return $sql; } private function getPreAlterTableAlterPrimaryKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff, \MailPoetVendor\Doctrine\DBAL\Schema\Index $index) { $sql = []; if (!$index->isPrimary() || !$diff->fromTable instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { return $sql; } $tableName = $diff->getName($this)->getQuotedName($this); foreach ($index->getColumns() as $columnName) { if (!$diff->fromTable->hasColumn($columnName)) { continue; } $column = $diff->fromTable->getColumn($columnName); if ($column->getAutoincrement() !== \true) { continue; } $column->setAutoincrement(\false); $sql[] = 'ALTER TABLE ' . $tableName . ' MODIFY ' . $this->getColumnDeclarationSQL($column->getQuotedName($this), $column->toArray()); $column->setAutoincrement(\true); } return $sql; } private function getPreAlterTableAlterIndexForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $sql = []; $table = $diff->getName($this)->getQuotedName($this); foreach ($diff->changedIndexes as $changedIndex) { if (!$changedIndex->isPrimary() || !$diff->fromTable instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { continue; } foreach ($diff->fromTable->getPrimaryKeyColumns() as $columnName) { $column = $diff->fromTable->getColumn($columnName); if (!$column->getAutoincrement() || \in_array($columnName, $changedIndex->getColumns())) { continue; } $column->setAutoincrement(\false); $sql[] = 'ALTER TABLE ' . $table . ' MODIFY ' . $this->getColumnDeclarationSQL($column->getQuotedName($this), $column->toArray()); $column->setAutoincrement(\true); } } return $sql; } protected function getPreAlterTableRenameIndexForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $sql = []; $tableName = $diff->getName($this)->getQuotedName($this); foreach ($this->getRemainingForeignKeyConstraintsRequiringRenamedIndexes($diff) as $foreignKey) { if (\in_array($foreignKey, $diff->changedForeignKeys, \true)) { continue; } $sql[] = $this->getDropForeignKeySQL($foreignKey, $tableName); } return $sql; } private function getRemainingForeignKeyConstraintsRequiringRenamedIndexes(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { if (empty($diff->renamedIndexes) || !$diff->fromTable instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { return []; } $foreignKeys = []; $remainingForeignKeys = \array_diff_key($diff->fromTable->getForeignKeys(), $diff->removedForeignKeys); foreach ($remainingForeignKeys as $foreignKey) { foreach ($diff->renamedIndexes as $index) { if ($foreignKey->intersectsIndexColumns($index)) { $foreignKeys[] = $foreignKey; break; } } } return $foreignKeys; } protected function getPostAlterTableIndexForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { return \array_merge(parent::getPostAlterTableIndexForeignKeySQL($diff), $this->getPostAlterTableRenameIndexForeignKeySQL($diff)); } protected function getPostAlterTableRenameIndexForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $sql = []; $tableName = $diff->newName !== \false ? $diff->getNewName()->getQuotedName($this) : $diff->getName($this)->getQuotedName($this); foreach ($this->getRemainingForeignKeyConstraintsRequiringRenamedIndexes($diff) as $foreignKey) { if (\in_array($foreignKey, $diff->changedForeignKeys, \true)) { continue; } $sql[] = $this->getCreateForeignKeySQL($foreignKey, $tableName); } return $sql; } protected function getCreateIndexSQLFlags(\MailPoetVendor\Doctrine\DBAL\Schema\Index $index) { $type = ''; if ($index->isUnique()) { $type .= 'UNIQUE '; } elseif ($index->hasFlag('fulltext')) { $type .= 'FULLTEXT '; } elseif ($index->hasFlag('spatial')) { $type .= 'SPATIAL '; } return $type; } public function getIntegerTypeDeclarationSQL(array $field) { return 'INT' . $this->_getCommonIntegerTypeDeclarationSQL($field); } public function getBigIntTypeDeclarationSQL(array $field) { return 'BIGINT' . $this->_getCommonIntegerTypeDeclarationSQL($field); } public function getSmallIntTypeDeclarationSQL(array $field) { return 'SMALLINT' . $this->_getCommonIntegerTypeDeclarationSQL($field); } public function getFloatDeclarationSQL(array $field) { return 'DOUBLE PRECISION' . $this->getUnsignedDeclaration($field); } public function getDecimalTypeDeclarationSQL(array $columnDef) { return parent::getDecimalTypeDeclarationSQL($columnDef) . $this->getUnsignedDeclaration($columnDef); } private function getUnsignedDeclaration(array $columnDef) { return !empty($columnDef['unsigned']) ? ' UNSIGNED' : ''; } protected function _getCommonIntegerTypeDeclarationSQL(array $columnDef) { $autoinc = ''; if (!empty($columnDef['autoincrement'])) { $autoinc = ' AUTO_INCREMENT'; } return $this->getUnsignedDeclaration($columnDef) . $autoinc; } public function getAdvancedForeignKeyOptionsSQL(\MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint $foreignKey) { $query = ''; if ($foreignKey->hasOption('match')) { $query .= ' MATCH ' . $foreignKey->getOption('match'); } $query .= parent::getAdvancedForeignKeyOptionsSQL($foreignKey); return $query; } public function getDropIndexSQL($index, $table = null) { if ($index instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Index) { $indexName = $index->getQuotedName($this); } elseif (\is_string($index)) { $indexName = $index; } else { throw new \InvalidArgumentException('MysqlPlatform::getDropIndexSQL() expects $index parameter to be string or \\Doctrine\\DBAL\\Schema\\Index.'); } if ($table instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { $table = $table->getQuotedName($this); } elseif (!\is_string($table)) { throw new \InvalidArgumentException('MysqlPlatform::getDropIndexSQL() expects $table parameter to be string or \\Doctrine\\DBAL\\Schema\\Table.'); } if ($index instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Index && $index->isPrimary()) { return $this->getDropPrimaryKeySQL($table); } return 'DROP INDEX ' . $indexName . ' ON ' . $table; } protected function getDropPrimaryKeySQL($table) { return 'ALTER TABLE ' . $table . ' DROP PRIMARY KEY'; } public function getSetTransactionIsolationSQL($level) { return 'SET SESSION TRANSACTION ISOLATION LEVEL ' . $this->_getTransactionIsolationLevelSQL($level); } public function getName() { return 'mysql'; } public function getReadLockSQL() { return 'LOCK IN SHARE MODE'; } protected function initializeDoctrineTypeMappings() { $this->doctrineTypeMapping = ['tinyint' => 'boolean', 'smallint' => 'smallint', 'mediumint' => 'integer', 'int' => 'integer', 'integer' => 'integer', 'bigint' => 'bigint', 'tinytext' => 'text', 'mediumtext' => 'text', 'longtext' => 'text', 'text' => 'text', 'varchar' => 'string', 'string' => 'string', 'char' => 'string', 'date' => 'date', 'datetime' => 'datetime', 'timestamp' => 'datetime', 'time' => 'time', 'float' => 'float', 'double' => 'float', 'real' => 'float', 'decimal' => 'decimal', 'numeric' => 'decimal', 'year' => 'date', 'longblob' => 'blob', 'blob' => 'blob', 'mediumblob' => 'blob', 'tinyblob' => 'blob', 'binary' => 'binary', 'varbinary' => 'binary', 'set' => 'simple_array']; } public function getVarcharMaxLength() { return 65535; } public function getBinaryMaxLength() { return 65535; } protected function getReservedKeywordsClass() { return \MailPoetVendor\Doctrine\DBAL\Platforms\Keywords\MySQLKeywords::class; } public function getDropTemporaryTableSQL($table) { if ($table instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { $table = $table->getQuotedName($this); } elseif (!\is_string($table)) { throw new \InvalidArgumentException('getDropTemporaryTableSQL() expects $table parameter to be string or \\Doctrine\\DBAL\\Schema\\Table.'); } return 'DROP TEMPORARY TABLE ' . $table; } public function getBlobTypeDeclarationSQL(array $field) { if (!empty($field['length']) && \is_numeric($field['length'])) { $length = $field['length']; if ($length <= static::LENGTH_LIMIT_TINYBLOB) { return 'TINYBLOB'; } if ($length <= static::LENGTH_LIMIT_BLOB) { return 'BLOB'; } if ($length <= static::LENGTH_LIMIT_MEDIUMBLOB) { return 'MEDIUMBLOB'; } } return 'LONGBLOB'; } public function quoteStringLiteral($str) { $str = \str_replace('\\', '\\\\', $str); return parent::quoteStringLiteral($str); } public function getDefaultTransactionIsolationLevel() { return \MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel::REPEATABLE_READ; } public function supportsColumnLengthIndexes() : bool { return \true; } } 