<?php
 namespace MailPoetVendor\Doctrine\ORM\Cache; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\Common\Cache\Cache as CacheAdapter; use MailPoetVendor\Doctrine\Common\Cache\CacheProvider; use MailPoetVendor\Doctrine\Common\Cache\MultiGetCache; use MailPoetVendor\Doctrine\ORM\Cache; use MailPoetVendor\Doctrine\ORM\Cache\Persister\Collection\NonStrictReadWriteCachedCollectionPersister; use MailPoetVendor\Doctrine\ORM\Cache\Persister\Collection\ReadOnlyCachedCollectionPersister; use MailPoetVendor\Doctrine\ORM\Cache\Persister\Collection\ReadWriteCachedCollectionPersister; use MailPoetVendor\Doctrine\ORM\Cache\Persister\Entity\NonStrictReadWriteCachedEntityPersister; use MailPoetVendor\Doctrine\ORM\Cache\Persister\Entity\ReadOnlyCachedEntityPersister; use MailPoetVendor\Doctrine\ORM\Cache\Persister\Entity\ReadWriteCachedEntityPersister; use MailPoetVendor\Doctrine\ORM\Cache\Region\DefaultMultiGetRegion; use MailPoetVendor\Doctrine\ORM\Cache\Region\DefaultRegion; use MailPoetVendor\Doctrine\ORM\Cache\Region\FileLockRegion; use MailPoetVendor\Doctrine\ORM\Cache\Region\UpdateTimestampCache; use MailPoetVendor\Doctrine\ORM\EntityManagerInterface; use MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata; use MailPoetVendor\Doctrine\ORM\Persisters\Collection\CollectionPersister; use MailPoetVendor\Doctrine\ORM\Persisters\Entity\EntityPersister; class DefaultCacheFactory implements \MailPoetVendor\Doctrine\ORM\Cache\CacheFactory { private $cache; private $regionsConfig; private $timestampRegion; private $regions = []; private $fileLockRegionDirectory; public function __construct(\MailPoetVendor\Doctrine\ORM\Cache\RegionsConfiguration $cacheConfig, \MailPoetVendor\Doctrine\Common\Cache\Cache $cache) { $this->cache = $cache; $this->regionsConfig = $cacheConfig; } public function setFileLockRegionDirectory($fileLockRegionDirectory) { $this->fileLockRegionDirectory = (string) $fileLockRegionDirectory; } public function getFileLockRegionDirectory() { return $this->fileLockRegionDirectory; } public function setRegion(\MailPoetVendor\Doctrine\ORM\Cache\Region $region) { $this->regions[$region->getName()] = $region; } public function setTimestampRegion(\MailPoetVendor\Doctrine\ORM\Cache\TimestampRegion $region) { $this->timestampRegion = $region; } public function buildCachedEntityPersister(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em, \MailPoetVendor\Doctrine\ORM\Persisters\Entity\EntityPersister $persister, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $metadata) { $region = $this->getRegion($metadata->cache); $usage = $metadata->cache['usage']; if ($usage === \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::CACHE_USAGE_READ_ONLY) { return new \MailPoetVendor\Doctrine\ORM\Cache\Persister\Entity\ReadOnlyCachedEntityPersister($persister, $region, $em, $metadata); } if ($usage === \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::CACHE_USAGE_NONSTRICT_READ_WRITE) { return new \MailPoetVendor\Doctrine\ORM\Cache\Persister\Entity\NonStrictReadWriteCachedEntityPersister($persister, $region, $em, $metadata); } if ($usage === \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::CACHE_USAGE_READ_WRITE) { return new \MailPoetVendor\Doctrine\ORM\Cache\Persister\Entity\ReadWriteCachedEntityPersister($persister, $region, $em, $metadata); } throw new \InvalidArgumentException(\sprintf("Unrecognized access strategy type [%s]", $usage)); } public function buildCachedCollectionPersister(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em, \MailPoetVendor\Doctrine\ORM\Persisters\Collection\CollectionPersister $persister, array $mapping) { $usage = $mapping['cache']['usage']; $region = $this->getRegion($mapping['cache']); if ($usage === \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::CACHE_USAGE_READ_ONLY) { return new \MailPoetVendor\Doctrine\ORM\Cache\Persister\Collection\ReadOnlyCachedCollectionPersister($persister, $region, $em, $mapping); } if ($usage === \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::CACHE_USAGE_NONSTRICT_READ_WRITE) { return new \MailPoetVendor\Doctrine\ORM\Cache\Persister\Collection\NonStrictReadWriteCachedCollectionPersister($persister, $region, $em, $mapping); } if ($usage === \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::CACHE_USAGE_READ_WRITE) { return new \MailPoetVendor\Doctrine\ORM\Cache\Persister\Collection\ReadWriteCachedCollectionPersister($persister, $region, $em, $mapping); } throw new \InvalidArgumentException(\sprintf("Unrecognized access strategy type [%s]", $usage)); } public function buildQueryCache(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em, $regionName = null) { return new \MailPoetVendor\Doctrine\ORM\Cache\DefaultQueryCache($em, $this->getRegion(['region' => $regionName ?: \MailPoetVendor\Doctrine\ORM\Cache::DEFAULT_QUERY_REGION_NAME, 'usage' => \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::CACHE_USAGE_NONSTRICT_READ_WRITE])); } public function buildCollectionHydrator(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em, array $mapping) { return new \MailPoetVendor\Doctrine\ORM\Cache\DefaultCollectionHydrator($em); } public function buildEntityHydrator(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $metadata) { return new \MailPoetVendor\Doctrine\ORM\Cache\DefaultEntityHydrator($em); } public function getRegion(array $cache) { if (isset($this->regions[$cache['region']])) { return $this->regions[$cache['region']]; } $name = $cache['region']; $cacheAdapter = $this->createRegionCache($name); $lifetime = $this->regionsConfig->getLifetime($cache['region']); $region = $cacheAdapter instanceof \MailPoetVendor\Doctrine\Common\Cache\MultiGetCache ? new \MailPoetVendor\Doctrine\ORM\Cache\Region\DefaultMultiGetRegion($name, $cacheAdapter, $lifetime) : new \MailPoetVendor\Doctrine\ORM\Cache\Region\DefaultRegion($name, $cacheAdapter, $lifetime); if ($cache['usage'] === \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::CACHE_USAGE_READ_WRITE) { if ('' === $this->fileLockRegionDirectory || null === $this->fileLockRegionDirectory) { throw new \LogicException('If you want to use a "READ_WRITE" cache an implementation of "MailPoetVendor\\Doctrine\\ORM\\Cache\\ConcurrentRegion" is required, ' . 'The default implementation provided by doctrine is "MailPoetVendor\\Doctrine\\ORM\\Cache\\Region\\FileLockRegion" if you want to use it please provide a valid directory, DefaultCacheFactory#setFileLockRegionDirectory(). '); } $directory = $this->fileLockRegionDirectory . \DIRECTORY_SEPARATOR . $cache['region']; $region = new \MailPoetVendor\Doctrine\ORM\Cache\Region\FileLockRegion($region, $directory, $this->regionsConfig->getLockLifetime($cache['region'])); } return $this->regions[$cache['region']] = $region; } private function createRegionCache($name) { $cacheAdapter = clone $this->cache; if (!$cacheAdapter instanceof \MailPoetVendor\Doctrine\Common\Cache\CacheProvider) { return $cacheAdapter; } $namespace = $cacheAdapter->getNamespace(); if ('' !== $namespace) { $namespace .= ':'; } $cacheAdapter->setNamespace($namespace . $name); return $cacheAdapter; } public function getTimestampRegion() { if ($this->timestampRegion === null) { $name = \MailPoetVendor\Doctrine\ORM\Cache::DEFAULT_TIMESTAMP_REGION_NAME; $lifetime = $this->regionsConfig->getLifetime($name); $this->timestampRegion = new \MailPoetVendor\Doctrine\ORM\Cache\Region\UpdateTimestampCache($name, clone $this->cache, $lifetime); } return $this->timestampRegion; } public function createCache(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em) { return new \MailPoetVendor\Doctrine\ORM\Cache\DefaultCache($em); } } 