<?php
 namespace MailPoetVendor\Carbon; if (!defined('ABSPATH')) exit; use MailPoetVendor\Carbon\Exceptions\BadFluentConstructorException; use MailPoetVendor\Carbon\Exceptions\BadFluentSetterException; use MailPoetVendor\Carbon\Exceptions\InvalidCastException; use MailPoetVendor\Carbon\Exceptions\InvalidIntervalException; use MailPoetVendor\Carbon\Exceptions\ParseErrorException; use MailPoetVendor\Carbon\Exceptions\UnitNotConfiguredException; use MailPoetVendor\Carbon\Exceptions\UnknownGetterException; use MailPoetVendor\Carbon\Exceptions\UnknownSetterException; use MailPoetVendor\Carbon\Exceptions\UnknownUnitException; use MailPoetVendor\Carbon\Traits\IntervalRounding; use MailPoetVendor\Carbon\Traits\IntervalStep; use MailPoetVendor\Carbon\Traits\Mixin; use MailPoetVendor\Carbon\Traits\Options; use Closure; use DateInterval; use Exception; use ReflectionException; use Throwable; class CarbonInterval extends \DateInterval implements \MailPoetVendor\Carbon\CarbonConverterInterface { use IntervalRounding; use IntervalStep; use Mixin { Mixin::mixin as baseMixin; } use Options; const PERIOD_PREFIX = 'P'; const PERIOD_YEARS = 'Y'; const PERIOD_MONTHS = 'M'; const PERIOD_DAYS = 'D'; const PERIOD_TIME_PREFIX = 'T'; const PERIOD_HOURS = 'H'; const PERIOD_MINUTES = 'M'; const PERIOD_SECONDS = 'S'; protected static $translator; protected static $cascadeFactors; protected static $formats = ['y' => 'y', 'Y' => 'y', 'o' => 'y', 'm' => 'm', 'n' => 'm', 'W' => 'weeks', 'd' => 'd', 'j' => 'd', 'z' => 'd', 'h' => 'h', 'g' => 'h', 'H' => 'h', 'G' => 'h', 'i' => 'i', 's' => 's', 'u' => 'micro', 'v' => 'milli']; private static $flipCascadeFactors; protected static $macros = []; protected $tzName; public function shiftTimezone($tzName) { $this->tzName = $tzName; return $this; } public static function getCascadeFactors() { return static::$cascadeFactors ?: ['milliseconds' => [\MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_MILLISECOND, 'microseconds'], 'seconds' => [\MailPoetVendor\Carbon\Carbon::MILLISECONDS_PER_SECOND, 'milliseconds'], 'minutes' => [\MailPoetVendor\Carbon\Carbon::SECONDS_PER_MINUTE, 'seconds'], 'hours' => [\MailPoetVendor\Carbon\Carbon::MINUTES_PER_HOUR, 'minutes'], 'dayz' => [\MailPoetVendor\Carbon\Carbon::HOURS_PER_DAY, 'hours'], 'weeks' => [\MailPoetVendor\Carbon\Carbon::DAYS_PER_WEEK, 'dayz'], 'months' => [\MailPoetVendor\Carbon\Carbon::WEEKS_PER_MONTH, 'weeks'], 'years' => [\MailPoetVendor\Carbon\Carbon::MONTHS_PER_YEAR, 'months']]; } private static function standardizeUnit($unit) { $unit = \rtrim($unit, 'sz') . 's'; return $unit === 'days' ? 'dayz' : $unit; } private static function getFlipCascadeFactors() { if (!self::$flipCascadeFactors) { self::$flipCascadeFactors = []; foreach (static::getCascadeFactors() as $to => [$factor, $from]) { self::$flipCascadeFactors[self::standardizeUnit($from)] = [self::standardizeUnit($to), $factor]; } } return self::$flipCascadeFactors; } public static function setCascadeFactors(array $cascadeFactors) { self::$flipCascadeFactors = null; static::$cascadeFactors = $cascadeFactors; } public function __construct($years = 1, $months = null, $weeks = null, $days = null, $hours = null, $minutes = null, $seconds = null, $microseconds = null) { if ($years instanceof \Closure) { $this->step = $years; $years = null; } if ($years instanceof \DateInterval) { parent::__construct(static::getDateIntervalSpec($years)); $this->f = $years->f; static::copyNegativeUnits($years, $this); return; } $spec = $years; if (!\is_string($spec) || \floatval($years) || \preg_match('/^[0-9.]/', $years)) { $spec = static::PERIOD_PREFIX; $spec .= $years > 0 ? $years . static::PERIOD_YEARS : ''; $spec .= $months > 0 ? $months . static::PERIOD_MONTHS : ''; $specDays = 0; $specDays += $weeks > 0 ? $weeks * static::getDaysPerWeek() : 0; $specDays += $days > 0 ? $days : 0; $spec .= $specDays > 0 ? $specDays . static::PERIOD_DAYS : ''; if ($hours > 0 || $minutes > 0 || $seconds > 0) { $spec .= static::PERIOD_TIME_PREFIX; $spec .= $hours > 0 ? $hours . static::PERIOD_HOURS : ''; $spec .= $minutes > 0 ? $minutes . static::PERIOD_MINUTES : ''; $spec .= $seconds > 0 ? $seconds . static::PERIOD_SECONDS : ''; } if ($spec === static::PERIOD_PREFIX) { $spec .= '0' . static::PERIOD_YEARS; } } parent::__construct($spec); if (!\is_null($microseconds)) { $this->f = $microseconds / \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_SECOND; } } public static function getFactor($source, $target) { $source = self::standardizeUnit($source); $target = self::standardizeUnit($target); $factors = static::getFlipCascadeFactors(); if (isset($factors[$source])) { [$to, $factor] = $factors[$source]; if ($to === $target) { return $factor; } return $factor * static::getFactor($to, $target); } return null; } public static function getDaysPerWeek() { return static::getFactor('dayz', 'weeks') ?: \MailPoetVendor\Carbon\Carbon::DAYS_PER_WEEK; } public static function getHoursPerDay() { return static::getFactor('hours', 'dayz') ?: \MailPoetVendor\Carbon\Carbon::HOURS_PER_DAY; } public static function getMinutesPerHour() { return static::getFactor('minutes', 'hours') ?: \MailPoetVendor\Carbon\Carbon::MINUTES_PER_HOUR; } public static function getSecondsPerMinute() { return static::getFactor('seconds', 'minutes') ?: \MailPoetVendor\Carbon\Carbon::SECONDS_PER_MINUTE; } public static function getMillisecondsPerSecond() { return static::getFactor('milliseconds', 'seconds') ?: \MailPoetVendor\Carbon\Carbon::MILLISECONDS_PER_SECOND; } public static function getMicrosecondsPerMillisecond() { return static::getFactor('microseconds', 'milliseconds') ?: \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_MILLISECOND; } public static function create($years = 1, $months = null, $weeks = null, $days = null, $hours = null, $minutes = null, $seconds = null, $microseconds = null) { return new static($years, $months, $weeks, $days, $hours, $minutes, $seconds, $microseconds); } public static function createFromFormat(string $format, ?string $interval) { $instance = new static(0); $length = \mb_strlen($format); if (\preg_match('/s([,.])([uv])$/', $format, $match)) { $interval = \explode($match[1], $interval); $index = \count($interval) - 1; $interval[$index] = \str_pad($interval[$index], $match[2] === 'v' ? 3 : 6, '0'); $interval = \implode($match[1], $interval); } for ($index = 0; $index < $length; $index++) { $expected = \mb_substr($format, $index, 1); $nextCharacter = \mb_substr($interval, 0, 1); $unit = static::$formats[$expected] ?? null; if ($unit) { if (!\preg_match('/^-?\\d+/', $interval, $match)) { throw new \MailPoetVendor\Carbon\Exceptions\ParseErrorException('number', $nextCharacter); } $interval = \mb_substr($interval, \mb_strlen($match[0])); $instance->{$unit} += \intval($match[0]); continue; } if ($nextCharacter !== $expected) { throw new \MailPoetVendor\Carbon\Exceptions\ParseErrorException("'{$expected}'", $nextCharacter, 'Allowed substitutes for interval formats are ' . \implode(', ', \array_keys(static::$formats)) . "\n" . 'See https://www.php.net/manual/en/function.date.php for their meaning'); } $interval = \mb_substr($interval, 1); } if ($interval !== '') { throw new \MailPoetVendor\Carbon\Exceptions\ParseErrorException('end of string', $interval); } return $instance; } public function copy() { $date = new static(0); $date->copyProperties($this); $date->step = $this->step; return $date; } public function clone() { return $this->copy(); } public static function __callStatic($method, $parameters) { try { $interval = new static(0); $localStrictModeEnabled = $interval->localStrictModeEnabled; $interval->localStrictModeEnabled = \true; $result = $interval->{$method}(...$parameters); $interval->localStrictModeEnabled = $localStrictModeEnabled; return $result; } catch (\MailPoetVendor\Carbon\Exceptions\BadFluentSetterException $exception) { if (\MailPoetVendor\Carbon\Carbon::isStrictModeEnabled()) { throw new \MailPoetVendor\Carbon\Exceptions\BadFluentConstructorException($method, 0, $exception); } return null; } } public static function fromString($intervalDefinition) { if (empty($intervalDefinition)) { return new static(0); } $years = 0; $months = 0; $weeks = 0; $days = 0; $hours = 0; $minutes = 0; $seconds = 0; $milliseconds = 0; $microseconds = 0; $pattern = '/(\\d+(?:\\.\\d+)?)\\h*([^\\d\\h]*)/i'; \preg_match_all($pattern, $intervalDefinition, $parts, \PREG_SET_ORDER); while ([$part, $value, $unit] = \array_shift($parts)) { $intValue = \intval($value); $fraction = \floatval($value) - $intValue; switch (\round($fraction, 6)) { case 1: $fraction = 0; $intValue++; break; case 0: $fraction = 0; break; } switch ($unit === 'µs' ? 'µs' : \strtolower($unit)) { case 'millennia': case 'millennium': $years += $intValue * \MailPoetVendor\Carbon\CarbonInterface::YEARS_PER_MILLENNIUM; break; case 'century': case 'centuries': $years += $intValue * \MailPoetVendor\Carbon\CarbonInterface::YEARS_PER_CENTURY; break; case 'decade': case 'decades': $years += $intValue * \MailPoetVendor\Carbon\CarbonInterface::YEARS_PER_DECADE; break; case 'year': case 'years': case 'y': $years += $intValue; break; case 'quarter': case 'quarters': $months += $intValue * \MailPoetVendor\Carbon\CarbonInterface::MONTHS_PER_QUARTER; break; case 'month': case 'months': case 'mo': $months += $intValue; break; case 'week': case 'weeks': case 'w': $weeks += $intValue; if ($fraction) { $parts[] = [null, $fraction * static::getDaysPerWeek(), 'd']; } break; case 'day': case 'days': case 'd': $days += $intValue; if ($fraction) { $parts[] = [null, $fraction * static::getHoursPerDay(), 'h']; } break; case 'hour': case 'hours': case 'h': $hours += $intValue; if ($fraction) { $parts[] = [null, $fraction * static::getMinutesPerHour(), 'm']; } break; case 'minute': case 'minutes': case 'm': $minutes += $intValue; if ($fraction) { $parts[] = [null, $fraction * static::getSecondsPerMinute(), 's']; } break; case 'second': case 'seconds': case 's': $seconds += $intValue; if ($fraction) { $parts[] = [null, $fraction * static::getMillisecondsPerSecond(), 'ms']; } break; case 'millisecond': case 'milliseconds': case 'milli': case 'ms': $milliseconds += $intValue; if ($fraction) { $microseconds += \round($fraction * static::getMicrosecondsPerMillisecond()); } break; case 'microsecond': case 'microseconds': case 'micro': case 'µs': $microseconds += $intValue; break; default: throw new \MailPoetVendor\Carbon\Exceptions\InvalidIntervalException(\sprintf('Invalid part %s in definition %s', $part, $intervalDefinition)); } } return new static($years, $months, $weeks, $days, $hours, $minutes, $seconds, $milliseconds * \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_MILLISECOND + $microseconds); } public static function parseFromLocale($interval, $locale = null) { return static::fromString(\MailPoetVendor\Carbon\Carbon::translateTimeString($interval, $locale ?: static::getLocale(), 'en')); } private static function castIntervalToClass(\DateInterval $interval, string $className) { $mainClass = \DateInterval::class; if (!\is_a($className, $mainClass, \true)) { throw new \MailPoetVendor\Carbon\Exceptions\InvalidCastException("{$className} is not a sub-class of {$mainClass}."); } $microseconds = $interval->f; $instance = new $className(static::getDateIntervalSpec($interval)); if ($microseconds) { $instance->f = $microseconds; } if ($interval instanceof self && \is_a($className, self::class, \true)) { $instance->setStep($interval->getStep()); } static::copyNegativeUnits($interval, $instance); return $instance; } private static function copyNegativeUnits(\DateInterval $from, \DateInterval $to) { $to->invert = $from->invert; foreach (['y', 'm', 'd', 'h', 'i', 's'] as $unit) { if ($from->{$unit} < 0) { $to->{$unit} *= -1; } } } public function cast(string $className) { return self::castIntervalToClass($this, $className); } public static function instance(\DateInterval $interval) { return self::castIntervalToClass($interval, static::class); } public static function make($interval, $unit = null) { if ($unit) { $interval = "{$interval} " . \MailPoetVendor\Carbon\Carbon::pluralUnit($unit); } if ($interval instanceof \DateInterval) { return static::instance($interval); } if ($interval instanceof \Closure) { return new static($interval); } if (!\is_string($interval)) { return null; } return static::makeFromString($interval); } protected static function makeFromString(string $interval) { $interval = \trim($interval); if (\preg_match('/^P[T0-9]/', $interval)) { return new static($interval); } if (\preg_match('/^(?:\\h*\\d+(?:\\.\\d+)?\\h*[a-z]+)+$/i', $interval)) { return static::fromString($interval); } $interval = static::createFromDateString($interval); return !$interval || $interval->isEmpty() ? null : $interval; } protected function resolveInterval($interval) { if (!$interval instanceof self) { return self::make($interval); } return $interval; } public static function createFromDateString($time) { $interval = @parent::createFromDateString(\strtr($time, [',' => ' ', ' and ' => ' '])); if ($interval instanceof \DateInterval) { $interval = static::instance($interval); } return $interval; } public function get($name) { if (\substr($name, 0, 5) === 'total') { return $this->total(\substr($name, 5)); } switch ($name) { case 'years': return $this->y; case 'months': return $this->m; case 'dayz': return $this->d; case 'hours': return $this->h; case 'minutes': return $this->i; case 'seconds': return $this->s; case 'milli': case 'milliseconds': return (int) (\round($this->f * \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_SECOND) / \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_MILLISECOND); case 'micro': case 'microseconds': return (int) \round($this->f * \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_SECOND); case 'microExcludeMilli': return (int) \round($this->f * \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_SECOND) % \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_MILLISECOND; case 'weeks': return (int) ($this->d / static::getDaysPerWeek()); case 'daysExcludeWeeks': case 'dayzExcludeWeeks': return $this->d % static::getDaysPerWeek(); case 'locale': return $this->getTranslatorLocale(); default: throw new \MailPoetVendor\Carbon\Exceptions\UnknownGetterException($name); } } public function __get($name) { return $this->get($name); } public function set($name, $value = null) { $properties = \is_array($name) ? $name : [$name => $value]; foreach ($properties as $key => $value) { switch (\MailPoetVendor\Carbon\Carbon::singularUnit(\rtrim($key, 'z'))) { case 'year': $this->y = $value; break; case 'month': $this->m = $value; break; case 'week': $this->d = $value * static::getDaysPerWeek(); break; case 'day': $this->d = $value; break; case 'daysexcludeweek': case 'dayzexcludeweek': $this->d = $this->weeks * static::getDaysPerWeek() + $value; break; case 'hour': $this->h = $value; break; case 'minute': $this->i = $value; break; case 'second': $this->s = $value; break; case 'milli': case 'millisecond': $this->microseconds = $value * \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_MILLISECOND + $this->microseconds % \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_MILLISECOND; break; case 'micro': case 'microsecond': $this->f = $value / \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_SECOND; break; default: if ($this->localStrictModeEnabled ?? \MailPoetVendor\Carbon\Carbon::isStrictModeEnabled()) { throw new \MailPoetVendor\Carbon\Exceptions\UnknownSetterException($key); } $this->{$key} = $value; } } return $this; } public function __set($name, $value) { $this->set($name, $value); } public function weeksAndDays($weeks, $days) { $this->dayz = $weeks * static::getDaysPerWeek() + $days; return $this; } public function isEmpty() { return $this->years === 0 && $this->months === 0 && $this->dayz === 0 && !$this->days && $this->hours === 0 && $this->minutes === 0 && $this->seconds === 0 && $this->microseconds === 0; } public static function macro($name, $macro) { static::$macros[$name] = $macro; } public static function mixin($mixin) { static::baseMixin($mixin); } public static function hasMacro($name) { return isset(static::$macros[$name]); } protected function callMacro($name, $parameters) { $macro = static::$macros[$name]; if ($macro instanceof \Closure) { $boundMacro = @$macro->bindTo($this, static::class) ?: @$macro->bindTo(null, static::class); return \call_user_func_array($boundMacro ?: $macro, $parameters); } return \call_user_func_array($macro, $parameters); } public function __call($method, $parameters) { if (static::hasMacro($method)) { return static::bindMacroContext($this, function () use(&$method, &$parameters) { return $this->callMacro($method, $parameters); }); } $roundedValue = $this->callRoundMethod($method, $parameters); if ($roundedValue !== null) { return $roundedValue; } try { $this->set($method, \count($parameters) === 0 ? 1 : $parameters[0]); } catch (\MailPoetVendor\Carbon\Exceptions\UnknownSetterException $exception) { if ($this->localStrictModeEnabled ?? \MailPoetVendor\Carbon\Carbon::isStrictModeEnabled()) { throw new \MailPoetVendor\Carbon\Exceptions\BadFluentSetterException($method, 0, $exception); } } return $this; } protected function getForHumansInitialVariables($syntax, $short) { if (\is_array($syntax)) { return $syntax; } if (\is_int($short)) { return ['parts' => $short, 'short' => \false]; } if (\is_bool($syntax)) { return ['short' => $syntax, 'syntax' => \MailPoetVendor\Carbon\CarbonInterface::DIFF_ABSOLUTE]; } return []; } protected function getForHumansParameters($syntax = null, $short = \false, $parts = -1, $options = null) { $optionalSpace = ' '; $default = $this->getTranslationMessage('list.0') ?? $this->getTranslationMessage('list') ?? ' '; $join = $default === '' ? '' : ' '; $altNumbers = \false; $aUnit = \false; $minimumUnit = 's'; \extract($this->getForHumansInitialVariables($syntax, $short)); if (\is_null($syntax)) { $syntax = \MailPoetVendor\Carbon\CarbonInterface::DIFF_ABSOLUTE; } if ($parts === -1) { $parts = \INF; } if (\is_null($options)) { $options = static::getHumanDiffOptions(); } if ($join === \false) { $join = ' '; } elseif ($join === \true) { $join = [$default, $this->getTranslationMessage('list.1') ?? $default]; } if ($altNumbers) { if ($altNumbers !== \true) { $language = new \MailPoetVendor\Carbon\Language($this->locale); $altNumbers = \in_array($language->getCode(), (array) $altNumbers); } } if (\is_array($join)) { [$default, $last] = $join; if ($default !== ' ') { $optionalSpace = ''; } $join = function ($list) use($default, $last) { if (\count($list) < 2) { return \implode('', $list); } $end = \array_pop($list); return \implode($default, $list) . $last . $end; }; } if (\is_string($join)) { if ($join !== ' ') { $optionalSpace = ''; } $glue = $join; $join = function ($list) use($glue) { return \implode($glue, $list); }; } $interpolations = [':optional-space' => $optionalSpace]; return [$syntax, $short, $parts, $options, $join, $aUnit, $altNumbers, $interpolations, $minimumUnit]; } protected static function getRoundingMethodFromOptions(int $options) : ?string { if ($options & \MailPoetVendor\Carbon\CarbonInterface::ROUND) { return 'round'; } if ($options & \MailPoetVendor\Carbon\CarbonInterface::CEIL) { return 'ceil'; } if ($options & \MailPoetVendor\Carbon\CarbonInterface::FLOOR) { return 'floor'; } return null; } public function toArray() { return ['years' => $this->years, 'months' => $this->months, 'weeks' => $this->weeks, 'days' => $this->daysExcludeWeeks, 'hours' => $this->hours, 'minutes' => $this->minutes, 'seconds' => $this->seconds, 'microseconds' => $this->microseconds]; } public function getNonZeroValues() { return \array_filter($this->toArray(), 'intval'); } public function getValuesSequence() { $nonZeroValues = $this->getNonZeroValues(); if ($nonZeroValues === []) { return []; } $keys = \array_keys($nonZeroValues); $firstKey = $keys[0]; $lastKey = $keys[\count($keys) - 1]; $values = []; $record = \false; foreach ($this->toArray() as $unit => $count) { if ($unit === $firstKey) { $record = \true; } if ($record) { $values[$unit] = $count; } if ($unit === $lastKey) { $record = \false; } } return $values; } public function forHumans($syntax = null, $short = \false, $parts = -1, $options = null) { [$syntax, $short, $parts, $options, $join, $aUnit, $altNumbers, $interpolations, $minimumUnit] = $this->getForHumansParameters($syntax, $short, $parts, $options); $interval = []; $syntax = (int) ($syntax === null ? \MailPoetVendor\Carbon\CarbonInterface::DIFF_ABSOLUTE : $syntax); $absolute = $syntax === \MailPoetVendor\Carbon\CarbonInterface::DIFF_ABSOLUTE; $relativeToNow = $syntax === \MailPoetVendor\Carbon\CarbonInterface::DIFF_RELATIVE_TO_NOW; $count = 1; $unit = $short ? 's' : 'second'; $isFuture = $this->invert === 1; $transId = $relativeToNow ? ($isFuture ? 'from_now' : 'ago') : ($isFuture ? 'after' : 'before'); $translator = $this->getLocalTranslator(); $handleDeclensions = function ($unit, $count) use($interpolations, $transId, $translator, $altNumbers, $absolute) { if (!$absolute) { $key = $unit . '_' . $transId; $result = $this->translate($key, $interpolations, $count, $translator, $altNumbers); if ($result !== $key) { return $result; } } $result = $this->translate($unit, $interpolations, $count, $translator, $altNumbers); if ($result !== $unit) { return $result; } return null; }; $intervalValues = $this; $method = static::getRoundingMethodFromOptions($options); if ($method) { while (\count($intervalValues->getNonZeroValues()) > $parts && ($count = \count($keys = \array_keys($intervalValues->getValuesSequence()))) > 1) { $intervalValues = $this->copy()->roundUnit($keys[$count - 2], 1, $method); } } $diffIntervalArray = [['value' => $intervalValues->years, 'unit' => 'year', 'unitShort' => 'y'], ['value' => $intervalValues->months, 'unit' => 'month', 'unitShort' => 'm'], ['value' => $intervalValues->weeks, 'unit' => 'week', 'unitShort' => 'w'], ['value' => $intervalValues->daysExcludeWeeks, 'unit' => 'day', 'unitShort' => 'd'], ['value' => $intervalValues->hours, 'unit' => 'hour', 'unitShort' => 'h'], ['value' => $intervalValues->minutes, 'unit' => 'minute', 'unitShort' => 'min'], ['value' => $intervalValues->seconds, 'unit' => 'second', 'unitShort' => 's'], ['value' => $intervalValues->milliseconds, 'unit' => 'millisecond', 'unitShort' => 'ms'], ['value' => $intervalValues->microExcludeMilli, 'unit' => 'microsecond', 'unitShort' => 'µs']]; $transChoice = function ($short, $unitData) use($absolute, $handleDeclensions, $translator, $aUnit, $altNumbers, $interpolations) { $count = $unitData['value']; if ($short) { $result = $handleDeclensions($unitData['unitShort'], $count); if ($result !== null) { return $result; } } elseif ($aUnit) { $result = $handleDeclensions('a_' . $unitData['unit'], $count); if ($result !== null) { return $result; } } if (!$absolute) { return $handleDeclensions($unitData['unit'], $count); } return $this->translate($unitData['unit'], $interpolations, $count, $translator, $altNumbers); }; $fallbackUnit = ['second', 's']; foreach ($diffIntervalArray as $diffIntervalData) { if ($diffIntervalData['value'] > 0) { $unit = $short ? $diffIntervalData['unitShort'] : $diffIntervalData['unit']; $count = $diffIntervalData['value']; $interval[] = $transChoice($short, $diffIntervalData); } elseif ($options & \MailPoetVendor\Carbon\CarbonInterface::SEQUENTIAL_PARTS_ONLY && \count($interval) > 0) { break; } if (\count($interval) >= $parts) { break; } if (\in_array($minimumUnit, [$diffIntervalData['unit'], $diffIntervalData['unitShort']])) { $fallbackUnit = [$diffIntervalData['unit'], $diffIntervalData['unitShort']]; break; } } if (\count($interval) === 0) { if ($relativeToNow && $options & \MailPoetVendor\Carbon\CarbonInterface::JUST_NOW) { $key = 'diff_now'; $translation = $this->translate($key, $interpolations, null, $translator); if ($translation !== $key) { return $translation; } } $count = $options & \MailPoetVendor\Carbon\CarbonInterface::NO_ZERO_DIFF ? 1 : 0; $unit = $fallbackUnit[$short ? 1 : 0]; $interval[] = $this->translate($unit, $interpolations, $count, $translator, $altNumbers); } $time = $join($interval); unset($diffIntervalArray, $interval); if ($absolute) { return $time; } $isFuture = $this->invert === 1; $transId = $relativeToNow ? ($isFuture ? 'from_now' : 'ago') : ($isFuture ? 'after' : 'before'); if ($parts === 1) { if ($relativeToNow && $unit === 'day') { if ($count === 1 && $options & \MailPoetVendor\Carbon\CarbonInterface::ONE_DAY_WORDS) { $key = $isFuture ? 'diff_tomorrow' : 'diff_yesterday'; $translation = $this->translate($key, $interpolations, null, $translator); if ($translation !== $key) { return $translation; } } if ($count === 2 && $options & \MailPoetVendor\Carbon\CarbonInterface::TWO_DAY_WORDS) { $key = $isFuture ? 'diff_after_tomorrow' : 'diff_before_yesterday'; $translation = $this->translate($key, $interpolations, null, $translator); if ($translation !== $key) { return $translation; } } } $aTime = $aUnit ? $handleDeclensions('a_' . $unit, $count) : null; $time = ($aTime ?: $handleDeclensions($unit, $count)) ?: $time; } $time = [':time' => $time]; return $this->translate($transId, \array_merge($time, $interpolations, $time), null, $translator); } public function __toString() { $format = $this->localToStringFormat; if ($format) { if ($format instanceof \Closure) { return $format($this); } return $this->format($format); } return $this->forHumans(); } public function toDateInterval() { return self::castIntervalToClass($this, \DateInterval::class); } public function toPeriod(...$params) { return \MailPoetVendor\Carbon\CarbonPeriod::create($this, ...$params); } public function invert($inverted = null) { $this->invert = (\func_num_args() === 0 ? !$this->invert : $inverted) ? 1 : 0; return $this; } protected function solveNegativeInterval() { if (!$this->isEmpty() && $this->years <= 0 && $this->months <= 0 && $this->dayz <= 0 && $this->hours <= 0 && $this->minutes <= 0 && $this->seconds <= 0 && $this->microseconds <= 0) { $this->years *= -1; $this->months *= -1; $this->dayz *= -1; $this->hours *= -1; $this->minutes *= -1; $this->seconds *= -1; $this->microseconds *= -1; $this->invert(); } return $this; } public function add($unit, $value = 1) { if (\is_numeric($unit)) { [$value, $unit] = [$unit, $value]; } if (\is_string($unit) && !\preg_match('/^\\s*\\d/', $unit)) { $unit = "{$value} {$unit}"; $value = 1; } $interval = static::make($unit); if (!$interval) { throw new \MailPoetVendor\Carbon\Exceptions\InvalidIntervalException('This type of data cannot be added/subtracted.'); } if ($value !== 1) { $interval->times($value); } $sign = ($this->invert === 1) !== ($interval->invert === 1) ? -1 : 1; $this->years += $interval->y * $sign; $this->months += $interval->m * $sign; $this->dayz += ($interval->days === \false ? $interval->d : $interval->days) * $sign; $this->hours += $interval->h * $sign; $this->minutes += $interval->i * $sign; $this->seconds += $interval->s * $sign; $this->microseconds += $interval->microseconds * $sign; $this->solveNegativeInterval(); return $this; } public function sub($unit, $value = 1) { if (\is_numeric($unit)) { [$value, $unit] = [$unit, $value]; } return $this->add($unit, -\floatval($value)); } public function subtract($unit, $value = 1) { return $this->sub($unit, $value); } public function times($factor) { if ($factor < 0) { $this->invert = $this->invert ? 0 : 1; $factor = -$factor; } $this->years = (int) \round($this->years * $factor); $this->months = (int) \round($this->months * $factor); $this->dayz = (int) \round($this->dayz * $factor); $this->hours = (int) \round($this->hours * $factor); $this->minutes = (int) \round($this->minutes * $factor); $this->seconds = (int) \round($this->seconds * $factor); $this->microseconds = (int) \round($this->microseconds * $factor); return $this; } public function shares($divider) { return $this->times(1 / $divider); } protected function copyProperties(self $interval, $ignoreSign = \false) { $this->years = $interval->years; $this->months = $interval->months; $this->dayz = $interval->dayz; $this->hours = $interval->hours; $this->minutes = $interval->minutes; $this->seconds = $interval->seconds; $this->microseconds = $interval->microseconds; if (!$ignoreSign) { $this->invert = $interval->invert; } return $this; } public function multiply($factor) { if ($factor < 0) { $this->invert = $this->invert ? 0 : 1; $factor = -$factor; } $yearPart = (int) \floor($this->years * $factor); if ($yearPart) { $this->years -= $yearPart / $factor; } return $this->copyProperties(static::create($yearPart)->microseconds(\abs($this->totalMicroseconds) * $factor)->cascade(), \true); } public function divide($divider) { return $this->multiply(1 / $divider); } public static function getDateIntervalSpec(\DateInterval $interval) { $date = \array_filter([static::PERIOD_YEARS => \abs($interval->y), static::PERIOD_MONTHS => \abs($interval->m), static::PERIOD_DAYS => \abs($interval->d)]); $time = \array_filter([static::PERIOD_HOURS => \abs($interval->h), static::PERIOD_MINUTES => \abs($interval->i), static::PERIOD_SECONDS => \abs($interval->s)]); $specString = static::PERIOD_PREFIX; foreach ($date as $key => $value) { $specString .= $value . $key; } if (\count($time) > 0) { $specString .= static::PERIOD_TIME_PREFIX; foreach ($time as $key => $value) { $specString .= $value . $key; } } return $specString === static::PERIOD_PREFIX ? 'PT0S' : $specString; } public function spec() { return static::getDateIntervalSpec($this); } public static function compareDateIntervals(\DateInterval $first, \DateInterval $second) { $current = \MailPoetVendor\Carbon\Carbon::now(); $passed = $current->copy()->add($second); $current->add($first); if ($current < $passed) { return -1; } if ($current > $passed) { return 1; } return 0; } public function compare(\DateInterval $interval) { return static::compareDateIntervals($this, $interval); } private function invertCascade(array $values) { return $this->set(\array_map(function ($value) { return -$value; }, $values))->doCascade(\true)->invert(); } private function doCascade(bool $deep) { $originalData = $this->toArray(); $originalData['milliseconds'] = (int) ($originalData['microseconds'] / static::getMicrosecondsPerMillisecond()); $originalData['microseconds'] = $originalData['microseconds'] % static::getMicrosecondsPerMillisecond(); $originalData['daysExcludeWeeks'] = $originalData['days']; unset($originalData['days']); $newData = $originalData; foreach (static::getFlipCascadeFactors() as $source => [$target, $factor]) { foreach (['source', 'target'] as $key) { if (${$key} === 'dayz') { ${$key} = 'daysExcludeWeeks'; } } $value = $newData[$source]; $modulo = ($factor + $value % $factor) % $factor; $newData[$source] = $modulo; $newData[$target] += ($value - $modulo) / $factor; } $positive = null; if (!$deep) { foreach ($newData as $value) { if ($value) { if ($positive === null) { $positive = $value > 0; continue; } if ($value > 0 !== $positive) { return $this->invertCascade($originalData)->solveNegativeInterval(); } } } } return $this->set($newData)->solveNegativeInterval(); } public function cascade() { return $this->doCascade(\false); } public function hasNegativeValues() : bool { foreach ($this->toArray() as $value) { if ($value < 0) { return \true; } } return \false; } public function hasPositiveValues() : bool { foreach ($this->toArray() as $value) { if ($value > 0) { return \true; } } return \false; } public function total($unit) { $realUnit = $unit = \strtolower($unit); if (\in_array($unit, ['days', 'weeks'])) { $realUnit = 'dayz'; } elseif (!\in_array($unit, ['microseconds', 'milliseconds', 'seconds', 'minutes', 'hours', 'dayz', 'months', 'years'])) { throw new \MailPoetVendor\Carbon\Exceptions\UnknownUnitException($unit); } $result = 0; $cumulativeFactor = 0; $unitFound = \false; $factors = static::getFlipCascadeFactors(); $daysPerWeek = static::getDaysPerWeek(); $values = ['years' => $this->years, 'months' => $this->months, 'weeks' => (int) ($this->d / $daysPerWeek), 'dayz' => (int) ($this->d % $daysPerWeek), 'hours' => $this->hours, 'minutes' => $this->minutes, 'seconds' => $this->seconds, 'milliseconds' => (int) ($this->microseconds / \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_MILLISECOND), 'microseconds' => (int) ($this->microseconds % \MailPoetVendor\Carbon\Carbon::MICROSECONDS_PER_MILLISECOND)]; if (isset($factors['dayz']) && $factors['dayz'][0] !== 'weeks') { $values['dayz'] += $values['weeks'] * $daysPerWeek; $values['weeks'] = 0; } foreach ($factors as $source => [$target, $factor]) { if ($source === $realUnit) { $unitFound = \true; $value = $values[$source]; $result += $value; $cumulativeFactor = 1; } if ($factor === \false) { if ($unitFound) { break; } $result = 0; $cumulativeFactor = 0; continue; } if ($target === $realUnit) { $unitFound = \true; } if ($cumulativeFactor) { $cumulativeFactor *= $factor; $result += $values[$target] * $cumulativeFactor; continue; } $value = $values[$source]; $result = ($result + $value) / $factor; } if (isset($target) && !$cumulativeFactor) { $result += $values[$target]; } if (!$unitFound) { throw new \MailPoetVendor\Carbon\Exceptions\UnitNotConfiguredException($unit); } if ($this->invert) { $result *= -1; } if ($unit === 'weeks') { return $result / $daysPerWeek; } return $result; } public function eq($interval) : bool { return $this->equalTo($interval); } public function equalTo($interval) : bool { $interval = $this->resolveInterval($interval); return $interval !== null && $this->totalMicroseconds === $interval->totalMicroseconds; } public function ne($interval) : bool { return $this->notEqualTo($interval); } public function notEqualTo($interval) : bool { return !$this->eq($interval); } public function gt($interval) : bool { return $this->greaterThan($interval); } public function greaterThan($interval) : bool { $interval = $this->resolveInterval($interval); return $interval === null || $this->totalMicroseconds > $interval->totalMicroseconds; } public function gte($interval) : bool { return $this->greaterThanOrEqualTo($interval); } public function greaterThanOrEqualTo($interval) : bool { return $this->greaterThan($interval) || $this->equalTo($interval); } public function lt($interval) : bool { return $this->lessThan($interval); } public function lessThan($interval) : bool { $interval = $this->resolveInterval($interval); return $interval !== null && $this->totalMicroseconds < $interval->totalMicroseconds; } public function lte($interval) : bool { return $this->lessThanOrEqualTo($interval); } public function lessThanOrEqualTo($interval) : bool { return $this->lessThan($interval) || $this->equalTo($interval); } public function between($interval1, $interval2, $equal = \true) : bool { return $equal ? $this->greaterThanOrEqualTo($interval1) && $this->lessThanOrEqualTo($interval2) : $this->greaterThan($interval1) && $this->lessThan($interval2); } public function betweenIncluded($interval1, $interval2) : bool { return $this->between($interval1, $interval2, \true); } public function betweenExcluded($interval1, $interval2) : bool { return $this->between($interval1, $interval2, \false); } public function isBetween($interval1, $interval2, $equal = \true) : bool { return $this->between($interval1, $interval2, $equal); } public function roundUnit($unit, $precision = 1, $function = 'round') { $base = \MailPoetVendor\Carbon\CarbonImmutable::parse('2000-01-01 00:00:00', 'UTC')->roundUnit($unit, $precision, $function); $next = $base->add($this); $inverted = $next < $base; if ($inverted) { $next = $base->sub($this); } $this->copyProperties($next->roundUnit($unit, $precision, $function)->diffAsCarbonInterval($base)); return $this->invert($inverted); } public function floorUnit($unit, $precision = 1) { return $this->roundUnit($unit, $precision, 'floor'); } public function ceilUnit($unit, $precision = 1) { return $this->roundUnit($unit, $precision, 'ceil'); } public function round($precision = 1, $function = 'round') { return $this->roundWith($precision, $function); } public function floor($precision = 1) { return $this->round($precision, 'floor'); } public function ceil($precision = 1) { return $this->round($precision, 'ceil'); } } 