<?php
 namespace Html2Text; if (!defined('ABSPATH')) exit; class Html2Text { public static function convert($html, $ignore_error = false) { $is_office_document = static::isOfficeDocument($html); if ($is_office_document) { $html = str_replace(array("<o:p>", "</o:p>"), "", $html); } $html = static::fixNewlines($html); if (mb_detect_encoding($html, "UTF-8", true)) { $html = mb_convert_encoding($html, "HTML-ENTITIES", "UTF-8"); } $doc = static::getDocument($html, $ignore_error); $output = static::iterateOverNode($doc, null, false, $is_office_document); $output = static::processWhitespaceNewlines($output); return $output; } static function fixNewlines($text) { $text = str_replace("\r\n", "\n", $text); $text = str_replace("\r", "\n", $text); return $text; } static function processWhitespaceNewlines($text) { $text = preg_replace("/ *\t */im", "\t", $text); $text = ltrim($text); $text = preg_replace("/\n[ \t]*/im", "\n", $text); $text = str_replace("\xc2\xa0", " ", $text); $text = rtrim($text); $text = preg_replace("/[ \t]*\n/im", "\n", $text); $text = static::fixNewLines($text); $text = preg_replace("/\n\n\n*/im", "\n\n", $text); return $text; } static function getDocument($html, $ignore_error = false) { $doc = new \DOMDocument(); $html = trim($html); if (!$html) { return $doc; } if ($html[0] !== '<') { $html = '<body>' . $html . '</body>'; } if ($ignore_error) { $doc->strictErrorChecking = false; $doc->recover = true; $doc->xmlStandalone = true; $old_internal_errors = libxml_use_internal_errors(true); $load_result = $doc->loadHTML($html, LIBXML_NOWARNING | LIBXML_NOERROR | LIBXML_NONET | LIBXML_PARSEHUGE); libxml_use_internal_errors($old_internal_errors); } else { $load_result = $doc->loadHTML($html); } if (!$load_result) { throw new Html2TextException("Could not load HTML - badly formed?", $html); } return $doc; } static function isOfficeDocument($html) { return strpos($html, "urn:schemas-microsoft-com:office") !== false; } static function isWhitespace($text) { return strlen(trim($text, "\n\r\t ")) === 0; } static function nextChildName($node) { $nextNode = $node->nextSibling; while ($nextNode != null) { if ($nextNode instanceof \DOMText) { if (!static::isWhitespace($nextNode->wholeText)) { break; } } if ($nextNode instanceof \DOMElement) { break; } $nextNode = $nextNode->nextSibling; } $nextName = null; if (($nextNode instanceof \DOMElement || $nextNode instanceof \DOMText) && $nextNode != null) { $nextName = strtolower($nextNode->nodeName); } return $nextName; } static function iterateOverNode($node, $prevName = null, $in_pre = false, $is_office_document = false) { if ($node instanceof \DOMText) { if ($in_pre) { $text = "\n" . trim($node->wholeText, "\n\r\t ") . "\n"; $text = preg_replace("/[ \t]*\n/im", "\n", $text); return str_replace("\n", "\r", $text); } else { $text = preg_replace("/[\\t\\n\\f\\r ]+/im", " ", $node->wholeText); if (!static::isWhitespace($text) && ($prevName == 'p' || $prevName == 'div')) { return "\n" . $text; } return $text; } } if ($node instanceof \DOMDocumentType) { return ""; } if ($node instanceof \DOMProcessingInstruction) { return ""; } $name = strtolower($node->nodeName); $nextName = static::nextChildName($node); switch ($name) { case "hr": $prefix = ''; if ($prevName != null) { $prefix = "\n"; } return $prefix . "---------------------------------------------------------------\n"; case "style": case "head": case "title": case "meta": case "script": return ""; case "h1": case "h2": case "h3": case "h4": case "h5": case "h6": case "ol": case "ul": case "pre": $output = "\n\n"; break; case "td": case "th": $output = "\t"; break; case "p": if ($is_office_document && $node->getAttribute('class') == 'MsoNormal') { $output = ""; $name = 'br'; break; } $output = "\n\n"; break; case "tr": $output = "\n"; break; case "div": $output = ""; if ($prevName !== null) { $output .= "\n"; } break; case "li": $output = "- "; break; default: $output = ""; break; } if (isset($node->childNodes)) { $n = $node->childNodes->item(0); $previousSiblingNames = array(); $previousSiblingName = null; $parts = array(); $trailing_whitespace = 0; while($n != null) { $text = static::iterateOverNode($n, $previousSiblingName, $in_pre || $name == 'pre', $is_office_document); if ($n instanceof \DOMDocumentType || $n instanceof \DOMProcessingInstruction || ($n instanceof \DOMText && static::isWhitespace($text))) { $trailing_whitespace++; } else { $previousSiblingName = strtolower($n->nodeName); $previousSiblingNames[] = $previousSiblingName; $trailing_whitespace = 0; } $node->removeChild($n); $n = $node->childNodes->item(0); $parts[] = $text; } while($trailing_whitespace-- > 0) { array_pop($parts); } $last_name = array_pop($previousSiblingNames); if ($last_name === 'br') { $last_name = array_pop($previousSiblingNames); if ($last_name === '#text') { array_pop($parts); } } $output .= implode('', $parts); } switch ($name) { case "h1": case "h2": case "h3": case "h4": case "h5": case "h6": case "pre": case "p": $output .= "\n\n"; break; case "br": $output .= "\n"; break; case "div": break; case "a": $href = $node->getAttribute("href"); $output = trim($output); if (substr($output, 0, 1) == "[" && substr($output, -1) == "]") { $output = substr($output, 1, strlen($output) - 2); if ($node->getAttribute("title")) { $output = $node->getAttribute("title"); } } if (!$output && $node->getAttribute("title")) { $output = $node->getAttribute("title"); } if ($href == null) { if ($node->getAttribute("name") != null) { $output = "[$output]"; } } else { if ($output) { $output = "[$output]($href)"; } else { $output = $href; } } switch ($nextName) { case "h1": case "h2": case "h3": case "h4": case "h5": case "h6": $output .= "\n"; break; } break; case "img": if ($node->getAttribute("title")) { $output = "[" . $node->getAttribute("title") . "]"; } elseif ($node->getAttribute("alt")) { $output = "[" . $node->getAttribute("alt") . "]"; } else { $output = ""; } break; case "li": $output .= "\n"; break; case "blockquote": $output = static::processWhitespaceNewlines($output); $output = "\n" . $output; $output = preg_replace("/\n/im", "\n> ", $output); $output = preg_replace("/\n> >/im", "\n>>", $output); $output = "\n" . $output . "\n\n"; break; default: } return $output; } } 