<?php


$colibriwp_theme_svg_icons = array(
    'fort-awesome'  => array(
        "name"    => "font-awesome/fort-awesome",
        "content" => "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"fort-awesome\" viewBox=\"0 0 1792 1896.0833\"><path d=\"M640 1008V784q0-16-16-16h-96q-16 0-16 16v224q0 16 16 16h96q16 0 16-16zm512 0V784q0-16-16-16h-96q-16 0-16 16v224q0 16 16 16h96q16 0 16-16zm512 32v752h-640v-320q0-80-56-136t-136-56-136 56-56 136v320H0v-752q0-16 16-16h96q16 0 16 16v112h128V528q0-16 16-16h96q16 0 16 16v112h128V528q0-16 16-16h96q16 0 16 16v112h128V528q0-6 2.5-9.5t8.5-5 9.5-2 11.5 0 9 .5V121q-32-15-32-50 0-23 16.5-39T832 16t38.5 16T887 71q0 35-32 50v17q45-10 83-10 21 0 59.5 7.5t54.5 7.5q17 0 47-7.5t37-7.5q16 0 16 16v210q0 15-35 21.5t-62 6.5q-18 0-54.5-7.5T945 367q-40 0-90 12v133q1 0 9-.5t11.5 0 9.5 2 8.5 5 2.5 9.5v112h128V528q0-16 16-16h96q16 0 16 16v112h128V528q0-16 16-16h96q16 0 16 16v624h128v-112q0-16 16-16h96q16 0 16 16z\"/></svg>",
    ),
    'phone'         => array(
        'name'    => 'font-awesome/phone',
        'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="phone" viewBox="0 0 1408 1896.0833"><path d="M1408 1240q0 27-10 70.5t-21 68.5q-21 50-122 106-94 51-186 51-27 0-53-3.5t-57.5-12.5-47-14.5T856 1485t-49-18q-98-35-175-83-127-79-264-216T152 904q-48-77-83-175-3-9-18-49t-20.5-55.5-14.5-47T3.5 520 0 467q0-92 51-186 56-101 106-122 25-11 68.5-21t70.5-10q14 0 21 3 18 6 53 76 11 19 30 54t35 63.5 31 53.5q3 4 17.5 25t21.5 35.5 7 28.5q0 20-28.5 50t-62 55-62 53-28.5 46q0 9 5 22.5t8.5 20.5 14 24 11.5 19q76 137 174 235t235 174q2 1 19 11.5t24 14 20.5 8.5 22.5 5q18 0 46-28.5t53-62 55-62 50-28.5q14 0 28.5 7t35.5 21.5 25 17.5q25 15 53.5 31t63.5 35 54 30q70 35 76 53 3 7 3 21z"/></svg>',
    ),
    'phone-square'  => array(
        'name'    => 'font-awesome/phone-square',
        'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="phone-square" viewBox="0 0 1536 1896.0833"><path d="M1280 1193q0-11-2-16t-18-16.5-40.5-25-47.5-26.5-45.5-25-28.5-15q-5-3-19-13t-25-15-21-5q-15 0-36.5 20.5t-39.5 45-38.5 45T885 1167q-7 0-16.5-3.5T853 1157t-17-9.5-14-8.5q-99-55-170-126.5T525 842q-2-3-8.5-14t-9.5-17-6.5-15.5T497 779q0-13 20.5-33.5t45-38.5 45-39.5T628 631q0-10-5-21t-15-25-13-19q-3-6-15-28.5T555 492t-26.5-47.5-25-40.5-16.5-18-16-2q-48 0-101 22-46 21-80 94.5T256 631q0 16 2.5 34t5 30.5 9 33 10 29.5 12.5 33 11 30q60 164 216.5 320.5T843 1358q6 2 30 11t33 12.5 29.5 10 33 9 30.5 5 34 2.5q57 0 130.5-34t94.5-80q22-53 22-101zm256-777v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z"></path></svg>',
    ),
    'map'           => array(
        'name'    => 'font-awesome/map-o',
        'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="map-o" viewBox="0 0 2048 1896.0833"><path d="M2020 11q28 20 28 53v1408q0 20-11 36t-29 23l-640 256q-24 11-48 0l-616-246-616 246q-10 5-24 5-19 0-36-11-28-20-28-53V320q0-20 11-36t29-23L680 5q24-11 48 0l616 246L1960 5q32-13 60 6zM736 146v1270l576 230V376zM128 363v1270l544-217V146zm1792 1066V159l-544 217v1270z"/></svg>',
    ),
    'map-marker'    => array(
        'name'    => 'font-awesome/map-marker',
        'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="map-marker" viewBox="0 0 1049.8953 1896.0833"><path d="M768 640q0-106-75-181t-181-75-181 75-75 181 75 181 181 75 181-75 75-181zm256 0q0 109-33 179l-364 774q-16 33-47.5 52t-67.5 19-67.5-19-46.5-52L33 819Q0 749 0 640q0-212 150-362t362-150 362 150 150 362z"></path></svg>',
    ),
    'envelope-open' => array(
        'name'    => 'font-awesome/envelope-open-o',
        'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="envelope-open-o" viewBox="0 0 1792 1896.0833"><path d="M1474 913l39 51q8 11 6.5 23.5T1508 1008q-43 34-126.5 98.5t-146.5 113-67 51.5q-39 32-60 48t-60.5 41-76.5 36.5-74 11.5h-2q-37 0-74-11.5t-76-36.5-61-41.5-60-47.5q-5-4-65-50.5t-143.5-111T293 1015q-11-8-12.5-20.5T287 971l37-52q8-11 21.5-13t24.5 7q94 73 306 236 5 4 43.5 35t60.5 46.5 56.5 32.5 58.5 17h2q24 0 58.5-17t56.5-32.5 60.5-46.5 43.5-35q258-198 313-242 11-8 24-6.5t21 12.5zm190 719V704q-90-83-159-139-91-74-389-304-3-2-43-35t-61-48-56-32.5-59-17.5h-2q-24 0-59 17.5T780 178t-61 48-43 35Q461 427 360.5 506.5T231 610.5 149 685q-14 12-21 19v928q0 13 9.5 22.5t22.5 9.5h1472q13 0 22.5-9.5t9.5-22.5zm128-928v928q0 66-47 113t-113 47H160q-66 0-113-47T0 1632V704q0-56 41-94 123-114 350-290.5T624 138q36-30 59-47.5t61.5-42 76-36.5T895 0h2q37 0 74.5 12t76 36.5 61.5 42 59 47.5q43 36 156 122t226 177 201 173q41 38 41 94z"/></svg>',
    ),
    'envelope'      => array(
        'name'    => 'font-awesome/envelope-open-o',
        'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="envelope" viewBox="0 0 1792 1896.0833"><path d="M1792 710v794q0 66-47 113t-113 47H160q-66 0-113-47T0 1504V710q44 49 101 87 362 246 497 345 57 42 92.5 65.5t94.5 48 110 24.5h2q51 0 110-24.5t94.5-48 92.5-65.5q170-123 498-345 57-39 100-87zm0-294q0 79-49 151t-122 123q-376 261-468 325-10 7-42.5 30.5t-54 38-52 32.5-57.5 27-50 9h-2q-23 0-50-9t-57.5-27-52-32.5-54-38T639 1015q-91-64-262-182.5T172 690q-62-42-117-115.5T0 438q0-78 41.5-130T160 256h1472q65 0 112.5 47t47.5 113z"></path></svg>',
    ),
    'facebook'      => array(
        'name'    => 'font-awesome/facebook-square',
        'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="facebook-square" viewBox="0 0 1536 1896.0833"><path d="M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664h-188v-595h199l30-232h-229V689q0-56 23.5-84t91.5-28l122-1V369q-63-9-178-9-136 0-217.5 80T820 666v171H620v232h200v595H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960z"/></svg>',
    ),
    'twitter'       => array(
        'name'    => 'font-awesome/twitter-square',
        'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="twitter-square" viewBox="0 0 1536 1896.0833"><path d="M1280 610q-56 25-121 34 68-40 93-117-65 38-134 51-61-66-153-66-87 0-148.5 61.5T755 722q0 29 5 48-129-7-242-65T326 550q-29 50-29 106 0 114 91 175-47-1-100-26v2q0 75 50 133.5t123 72.5q-29 8-51 8-13 0-39-4 21 63 74.5 104t121.5 42q-116 90-261 90-26 0-50-3 148 94 322 94 112 0 210-35.5t168-95 120.5-137 75-162T1176 746q0-18-1-27 63-45 105-109zm256-194v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z"/></svg>',
    ),
    'youtube'       => array(
        'name'    => 'font-awesome/youtube-square',
        'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="youtube-square" viewBox="0 0 1536 1896.0833">                                <path d="M919 1303v-157q0-50-29-50-17 0-33 16v224q16 16 33 16 29 0 29-49zm184-122h66v-34q0-51-33-51t-33 51v34zM532 915v70h-80v423h-74V985h-78v-70h232zm201 126v367h-67v-40q-39 45-76 45-33 0-42-28-6-17-6-54v-290h66v270q0 24 1 26 1 15 15 15 20 0 42-31v-280h67zm252 111v146q0 52-7 73-12 42-53 42-35 0-68-41v36h-67V915h67v161q32-40 68-40 41 0 53 42 7 21 7 74zm251 129v9q0 29-2 43-3 22-15 40-27 40-80 40-52 0-81-38-21-27-21-86v-129q0-59 20-86 29-38 80-38t78 38q21 29 21 86v76h-133v65q0 51 34 51 24 0 30-26 0-1 .5-7t.5-16.5V1281h68zM785 457v156q0 51-32 51t-32-51V457q0-52 32-52t32 52zm533 713q0-177-19-260-10-44-43-73.5t-76-34.5q-136-15-412-15-275 0-411 15-44 5-76.5 34.5T238 910q-20 87-20 260 0 176 20 260 10 43 42.5 73t75.5 35q137 15 412 15t412-15q43-5 75.5-35t42.5-73q20-84 20-260zM563 519l90-296h-75l-51 195-53-195h-78q7 23 23 69l24 69q35 103 46 158v201h74V519zm289 81V470q0-58-21-87-29-38-78-38-51 0-78 38-21 29-21 87v130q0 58 21 87 27 38 78 38 49 0 78-38 21-27 21-87zm181 120h67V350h-67v283q-22 31-42 31-15 0-16-16-1-2-1-26V350h-67v293q0 37 6 55 11 27 43 27 36 0 77-45v40zm503-304v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z"></path></svg>',
    ),
    'vimeo'         => array(
        'name'    => 'font-awesome/vimeo-square',
        'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="vimeo-square" viewBox="0 0 1536 1896.0833">                                <path d="M1292 638q10-216-161-222-231-8-312 261 44-19 82-19 85 0 74 96-4 57-74 167t-105 110q-43 0-82-169-13-54-45-255-30-189-160-177-59 7-164 100l-81 72-81 72 52 67q76-52 87-52 57 0 107 179 15 55 45 164.5t45 164.5q68 179 164 179 157 0 383-294 220-283 226-444zm244-222v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z"></path></svg>',
    ),
    'pinterest'     => array(
        'name'    => 'font-awesome/pinterest-square',
        'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="pinterest-square" viewBox="0 0 1536 1896.0833"><path d="M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664H523q85-122 108-210 9-34 53-209 21 39 73.5 67t112.5 28q181 0 295.5-147.5T1280 819q0-84-35-162.5t-96.5-139-152.5-97T799 384q-104 0-194.5 28.5t-153 76.5T344 598.5t-66.5 128T256 859q0 102 39.5 180T412 1149q13 5 23.5 0t14.5-19q10-44 15-61 6-23-11-42-50-62-50-150 0-150 103.5-256.5T778 514q149 0 232.5 81t83.5 210q0 168-67.5 286T853 1209q-60 0-97-43.5T733 1062q8-34 26.5-92.5t29.5-102 11-74.5q0-49-26.5-81.5T698 679q-61 0-103.5 56.5T552 875q0 72 24 121l-98 414q-24 100-7 254H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960z"/></svg>',
    ),
    'behance'       => array(
        'name'    => 'font-awesome/behance-square',
        'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="behance-square" viewBox="0 0 1536 1896.0833"><path d="M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960zM499 495H128v787h382q117 0 197-57.5t80-170.5q0-158-143-200 107-52 107-164 0-57-19.5-96.5T675 533t-79-29.5-97-8.5zm-22 318H301V629h163q119 0 119 90 0 94-106 94zm9 335H301V931h189q124 0 124 113 0 104-128 104zm650 32q-68 0-104-38t-36-107h411q1-10 1-30 0-132-74.5-220.5T1130 696q-128 0-210 86t-82 216q0 135 79 217t213 82q205 0 267-191h-138q-11 34-47.5 54t-75.5 20zm-10-366q113 0 124 122H996q4-56 39-89t91-33zM964 548h319v77H964v-77z"/></svg>',
    ),

    'logoNav'     => array(
        'name'    => 'logoNav',
        'content' => '<svg height="64" enable-background="new 0 0 67 67" viewBox="0 0 67 67" xmlns="http://www.w3.org/2000/svg"><path d="m66 32.5h-8c-.5 0-1 .4-1 1s.4 1 1 1h8c.5 0 1-.4 1-1s-.4-1-1-1z"/><path d="m55 32.5h-8c-.5 0-1 .4-1 1s.4 1 1 1h8c.5 0 1-.4 1-1s-.4-1-1-1z"/><path d="m44 32.5h-8c-.5 0-1 .4-1 1s.4 1 1 1h8c.5 0 1-.4 1-1s-.4-1-1-1z"/><path d="m27 25.5h-24c-1.7 0-3 1.4-3 3v10c0 1.7 1.3 3 3 3h24c1.7 0 3-1.4 3-3v-10c0-1.6-1.3-3-3-3zm2 13c0 1.1-.9 2-2 2h-24c-1.1 0-2-.9-2-2v-10c0-1.1.9-2 2-2h24c1.1 0 2 .9 2 2z"/><path d="m6.7 30.8h-1v5.7h3.5v-.8h-2.5z"/><path d="m13.4 31.1c-.4-.2-.8-.3-1.2-.3s-.9.1-1.2.3-.6.6-.8 1-.4.9-.4 1.4v.3c0 .5.1 1 .3 1.4s.5.7.8 1 .8.3 1.2.3c.5 0 .9-.1 1.2-.3s.6-.5.8-1 .3-.9.3-1.5v-.2c0-.6-.1-1-.3-1.5s-.3-.7-.7-.9zm.1 2.7c0 .6-.1 1.1-.4 1.5s-.6.5-1 .5-.8-.2-1-.5-.4-.8-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5.8.2 1 .5.4.8.4 1.4z"/><path d="m24.4 31.1c-.4-.2-.8-.3-1.2-.3s-.9.1-1.2.3-.6.6-.8 1-.4.9-.4 1.4v.3c0 .5.1 1 .3 1.4s.5.7.8 1 .8.3 1.2.3c.5 0 .9-.1 1.2-.3s.6-.5.8-1 .3-.9.3-1.5v-.2c0-.6-.1-1-.3-1.5s-.4-.7-.7-.9zm.1 2.7c0 .6-.1 1.1-.4 1.5s-.6.5-1 .5-.8-.2-1-.5-.4-.8-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5.8.2 1 .5.4.8.4 1.4z"/><path d="m17.7 34.3h1.2v1.1c-.2.2-.6.3-1.1.3s-.8-.2-1.1-.5-.4-.7-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5c.7 0 1.1.3 1.2 1h1c-.1-.6-.3-1-.7-1.4s-.9-.5-1.5-.5c-.7.1-1.3.4-1.7.9s-.6 1.2-.6 2v.4c0 .5.1 1 .3 1.4s.5.7.8.9.8.3 1.3.3.9-.1 1.2-.2.6-.3.9-.6v-2.1h-2.2z"/></svg>',
    ),
    'logoAbove'   => array(
        'name'    => 'logoAbove',
        'content' => '<svg height="64" enable-background="new 0 0 67 67" viewBox="0 0 67 67" xmlns="http://www.w3.org/2000/svg"><path d="m21.5 38h24c1.7 0 3-1.4 3-3v-10c0-1.7-1.3-3-3-3h-24c-1.7 0-3 1.4-3 3v10c0 1.6 1.3 3 3 3zm-2-13c0-1.1.9-2 2-2h24c1.1 0 2 .9 2 2v10c0 1.1-.9 2-2 2h-24c-1.1 0-2-.9-2-2z"/><path d="m29.5 32.7c.4.2.8.3 1.2.3.5 0 .9-.1 1.2-.3s.6-.5.8-1 .3-.9.3-1.5v-.2c0-.6-.1-1-.3-1.5s-.5-.7-.8-1-.8-.3-1.2-.3-.9.1-1.2.3-.6.6-.8 1-.4 1-.4 1.5v.3c0 .5.1 1 .3 1.4s.5.8.9 1zm-.2-2.7c0-.6.1-1.1.4-1.4s.6-.5 1-.5.8.2 1 .5.4.8.4 1.4v.3c0 .6-.1 1.1-.4 1.5s-.6.5-1 .5-.8-.2-1-.5-.4-.8-.4-1.4z"/><path d="m35 32.8c.4.2.8.3 1.3.3s.9-.1 1.2-.2.6-.3.9-.6v-2.2h-2.2v.8h1.2v1.1c-.2.2-.6.3-1.1.3s-.8-.2-1.1-.5-.4-.8-.4-1.5v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5c.7 0 1.1.3 1.2 1h1c-.1-.6-.3-1-.7-1.4s-.9-.5-1.5-.5c-.7.1-1.3.4-1.7.9s-.6 1.2-.6 2v.4c0 .5.1 1 .3 1.4s.4.7.8 1z"/><path d="m40.4 32.7c.4.2.8.3 1.2.3.5 0 .9-.1 1.2-.3s.6-.5.8-1 .3-.9.3-1.5v-.2c0-.6-.1-1-.3-1.5s-.5-.7-.8-1-.8-.3-1.2-.3-.9.1-1.2.3-.6.6-.8 1-.3 1-.3 1.5v.3c0 .5.1 1 .3 1.4s.5.8.8 1zm-.1-2.7c0-.6.1-1.1.4-1.4s.6-.5 1-.5.8.2 1 .5.4.8.4 1.4v.3c0 .6-.1 1.1-.4 1.5s-.6.5-1 .5-.8-.2-1-.5-.4-.8-.4-1.4z"/><path d="m27.7 32.2h-2.5v-4.9h-1v5.7h3.5z"/><path d="m48.5 43h-8c-.5 0-1 .4-1 1s.4 1 1 1h8c.5 0 1-.4 1-1s-.4-1-1-1z"/><path d="m37.5 43h-8c-.5 0-1 .4-1 1s.4 1 1 1h8c.5 0 1-.4 1-1s-.4-1-1-1z"/><path d="m26.5 43h-8c-.5 0-1 .4-1 1s.4 1 1 1h8c.5 0 1-.4 1-1s-.4-1-1-1z"/></svg>',
    ),
    'logoNavCta'  => array(
        'name'    => 'logoNavCta',
        'content' => '<svg height="64" enable-background="new 0 0 67 67" viewBox="0 0 67 67" xmlns="http://www.w3.org/2000/svg"><path d="m44 32.5h-8c-.6 0-1 .4-1 1s.4 1 1 1h8c.6 0 1-.4 1-1s-.4-1-1-1zm-8 1v-.5z"/><path d="m55 32.5h-8c-.6 0-1 .4-1 1s.4 1 1 1h8c.6 0 1-.4 1-1s-.4-1-1-1zm-8 1v-.5z"/><path d="m65 31.5h-6c-1.1 0-2 .9-2 2s.9 2 2 2h6c1.1 0 2-.9 2-2s-.9-2-2-2zm0 3h-6c-.6 0-1-.4-1-1s.4-1 1-1h6c.6 0 1 .4 1 1s-.4 1-1 1z"/><path d="m27 25.5h-24c-1.7 0-3 1.4-3 3v10c0 1.7 1.3 3 3 3h24c1.7 0 3-1.4 3-3v-10c0-1.6-1.3-3-3-3zm2 13c0 1.1-.9 2-2 2h-24c-1.1 0-2-.9-2-2v-10c0-1.1.9-2 2-2h24c1.1 0 2 .9 2 2z"/><path d="m6.7 30.8h-1v5.7h3.5v-.8h-2.5z"/><path d="m17.7 34.3h1.2v1.1c-.2.2-.6.3-1.1.3s-.8-.2-1.1-.5-.4-.7-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5c.7 0 1.1.3 1.2 1h1c-.1-.6-.3-1-.7-1.4s-.9-.5-1.5-.5c-.7.1-1.3.4-1.7.9s-.6 1.2-.6 2v.4c0 .5.1 1 .3 1.4s.5.7.8.9.8.3 1.3.3.9-.1 1.2-.2.6-.3.9-.6v-2.1h-2.2z"/><path d="m24.4 31.1c-.4-.2-.8-.3-1.2-.3s-.9.1-1.2.3-.6.6-.8 1-.4.9-.4 1.4v.3c0 .5.1 1 .3 1.4s.5.7.8 1 .8.3 1.2.3c.5 0 .9-.1 1.2-.3s.6-.5.8-1 .3-.9.3-1.5v-.2c0-.6-.1-1-.3-1.5s-.4-.7-.7-.9zm.1 2.7c0 .6-.1 1.1-.4 1.5s-.6.5-1 .5-.8-.2-1-.5-.4-.8-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5.8.2 1 .5.4.8.4 1.4z"/><path d="m13.4 31.1c-.4-.2-.8-.3-1.2-.3s-.9.1-1.2.3-.6.6-.8 1-.4.9-.4 1.4v.3c0 .5.1 1 .3 1.4s.5.7.8 1 .8.3 1.2.3c.5 0 .9-.1 1.2-.3s.6-.5.8-1 .3-.9.3-1.5v-.2c0-.6-.1-1-.3-1.5s-.3-.7-.7-.9zm.1 2.7c0 .6-.1 1.1-.4 1.5s-.6.5-1 .5-.8-.2-1-.5-.4-.8-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5.8.2 1 .5.4.8.4 1.4z"/></svg>',
    ),
    'navLogoCta'  => array(
        'name'    => 'navLogoCta',
        'content' => '<svg height="64" enable-background="new 0 0 67 67" viewBox="0 0 67 67" xmlns="http://www.w3.org/2000/svg"><path d="m9 32.5h-8c-.6 0-1 .4-1 1s.4 1 1 1h8c.6 0 1-.4 1-1s-.4-1-1-1zm-8 1v-.5zm19-1h-8c-.6 0-1 .4-1 1s.4 1 1 1h8c.6 0 1-.4 1-1s-.4-1-1-1zm-8 1v-.5zm53-2h-6c-1.1 0-2 .9-2 2s.9 2 2 2h6c1.1 0 2-.9 2-2s-.9-2-2-2zm0 3h-6c-.6 0-1-.4-1-1s.4-1 1-1h6c.6 0 1 .4 1 1s-.4 1-1 1zm-14-9h-24c-1.7 0-3 1.4-3 3v10c0 1.7 1.3 3 3 3h24c1.7 0 3-1.4 3-3v-10c0-1.6-1.3-3-3-3zm2 13c0 1.1-.9 2-2 2h-24c-1.1 0-2-.9-2-2v-10c0-1.1.9-2 2-2h24c1.1 0 2 .9 2 2z"/><path d="m37.4 31.1c-.4-.2-.8-.3-1.2-.3s-.9.1-1.2.3-.6.6-.8 1-.3.9-.3 1.5v.3c0 .5.1 1 .3 1.4s.5.7.8 1 .8.3 1.2.3c.5 0 .9-.1 1.2-.3s.6-.5.8-1 .3-.9.3-1.5v-.3c0-.6-.1-1-.3-1.5s-.4-.7-.8-.9zm.1 2.7c0 .6-.1 1.1-.4 1.5s-.6.5-1 .5-.8-.2-1-.5-.4-.8-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5.8.2 1 .5.4.8.4 1.4zm4.2.5h1.2v1.1c-.2.2-.6.3-1.1.3s-.8-.2-1.1-.5-.4-.8-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5c.7 0 1.1.3 1.2 1h1c-.1-.6-.3-1-.7-1.4s-.9-.5-1.5-.5c-.7 0-1.3.2-1.7.7s-.6 1.2-.6 2v.4c0 .5.1 1 .3 1.4s.5.7.8.9.8.3 1.3.3.9-.1 1.2-.2.6-.3.9-.6v-2.2h-2.2z"/><path d="m30.7 30.8h-1v5.7h3.5v-.8h-2.5z"/><path d="m48.4 31.1c-.4-.2-.8-.3-1.2-.3s-.9.1-1.2.3-.6.6-.8 1-.3.9-.3 1.5v.3c0 .5.1 1 .3 1.4s.5.7.8 1 .8.3 1.2.3c.5 0 .9-.1 1.2-.3s.6-.5.8-1 .3-.9.3-1.5v-.3c0-.6-.1-1-.3-1.5s-.5-.7-.8-.9zm.1 2.7c0 .6-.1 1.1-.4 1.5s-.6.5-1 .5-.8-.2-1-.5-.4-.8-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5.8.2 1 .5.4.8.4 1.4z"/></svg>',
    ),
    'logoNavCta2' => array(
        'name'    => 'logoNavCta2',
        'content' => '<svg height="64" enable-background="new 0 0 67 67" viewBox="0 0 67 67" xmlns="http://www.w3.org/2000/svg"><path d="m65 28h-6c-1.1 0-2 .9-2 2s.9 2 2 2h6c1.1 0 2-.9 2-2s-.9-2-2-2zm0 3h-6c-.6 0-1-.4-1-1s.4-1 1-1h6c.6 0 1 .4 1 1s-.4 1-1 1z"/><path d="m30 35v-10c0-1.7-1.3-3-3-3h-24c-1.7 0-3 1.4-3 3v10c0 1.7 1.3 3 3 3h24c1.7 0 3-1.4 3-3zm-1 0c0 1.1-.9 2-2 2h-24c-1.1 0-2-.9-2-2v-10c0-1.1.9-2 2-2h24c1.1 0 2 .9 2 2z"/><path d="m13.4 27.6c-.4-.2-.8-.3-1.2-.3s-.9.1-1.2.3-.6.6-.8 1-.4.9-.4 1.4v.3c0 .5.1 1 .3 1.4s.5.7.8 1 .8.3 1.2.3c.5 0 .9-.1 1.2-.3s.6-.5.8-1 .3-.9.3-1.5v-.2c0-.6-.1-1-.3-1.5s-.3-.7-.7-.9zm.1 2.7c0 .6-.1 1.1-.4 1.5s-.6.5-1 .5-.8-.2-1-.5-.4-.8-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5.8.2 1 .5.4.8.4 1.4z"/><path d="m17.7 30.8h1.2v1.1c-.2.2-.6.3-1.1.3s-.8-.2-1.1-.5-.4-.7-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5c.7 0 1.1.3 1.2 1h1c-.1-.6-.3-1-.7-1.4s-.9-.5-1.5-.5c-.7.1-1.3.4-1.7.9s-.6 1.2-.6 2v.4c0 .5.1 1 .3 1.4s.5.7.8.9.8.3 1.3.3.9-.1 1.2-.2.6-.3.9-.6v-2.1h-2.2z"/><path d="m6.7 27.3h-1v5.7h3.5v-.8h-2.5z"/><path d="m24.4 27.6c-.4-.2-.8-.3-1.2-.3s-.9.1-1.2.3-.6.6-.8 1-.4.9-.4 1.4v.3c0 .5.1 1 .3 1.4s.5.7.8 1 .8.3 1.2.3c.5 0 .9-.1 1.2-.3s.6-.5.8-1 .3-.9.3-1.5v-.2c0-.6-.1-1-.3-1.5s-.4-.7-.7-.9zm.1 2.7c0 .6-.1 1.1-.4 1.5s-.6.5-1 .5-.8-.2-1-.5-.4-.8-.4-1.4v-.4c0-.6.1-1.1.4-1.4s.6-.5 1-.5.8.2 1 .5.4.8.4 1.4z"/><path d="m48 43h-8c-.5 0-1 .4-1 1s.4 1 1 1h8c.5 0 1-.4 1-1s-.4-1-1-1z"/><path d="m37 43h-8c-.5 0-1 .4-1 1s.4 1 1 1h8c.5 0 1-.4 1-1s-.4-1-1-1z"/><path d="m26 43h-8c-.5 0-1 .4-1 1s.4 1 1 1h8c.5 0 1-.4 1-1s-.4-1-1-1z"/></svg>',
    ),
    'customLogo'  => array(
        'name'    => 'customLogo',
        'content' => '<svg height="14" enable-background="new 0 0 41 9" viewBox="0 0 41 9" xmlns="http://www.w3.org/2000/svg"><path d="m17.8 4.5c-.3-.2-.8-.4-1.3-.6s-1-.3-1.2-.5-.3-.4-.3-.6c0-.3.1-.6.3-.7s.5-.3.9-.3.8.1 1 .3.3.5.3.9h1.2c0-.4-.1-.8-.3-1.1s-.4-.7-.8-.8-.8-.3-1.3-.3c-.7 0-1.4.2-1.8.6-.5.4-.7.8-.7 1.4 0 .7.3 1.2 1 1.6.3.2.8.4 1.4.6s1 .3 1.2.5.3.4.3.7-.1.5-.3.7-.5.3-1 .3-.9-.1-1.1-.3-.4-.5-.4-.9h-1.2c0 .4.1.8.4 1.2s.6.6 1 .8.9.3 1.4.3c.8 0 1.4-.2 1.8-.5s.7-.8.7-1.4c0-.4-.1-.7-.2-1s-.6-.7-1-.9z"/><path d="m11.3 5.6c0 1-.5 1.5-1.4 1.5-.5 0-.8-.1-1.1-.4s-.3-.6-.3-1.1v-4.7h-1.3v4.7c0 .8.3 1.4.8 1.8s1.1.7 1.9.7 1.4-.2 1.9-.7.7-1 .7-1.8v-4.7h-1.2z"/><path d="m2.3 2.4c.3-.4.7-.6 1.2-.6s.8.1 1.1.3.4.6.4 1.1h1.2c0-.7-.3-1.3-.8-1.8s-1.1-.6-1.9-.6c-.6 0-1.1.1-1.5.4s-.8.7-1 1.2-.4 1.1-.4 1.8v.7c0 .7.1 1.2.4 1.7s.6.9 1 1.1.9.4 1.5.4c.8 0 1.5-.2 1.9-.6s.8-1 .8-1.8h-1.2c-.1.5-.2.9-.5 1.1s-.6.3-1 .3c-.5 0-.9-.2-1.2-.6s-.4-1-.4-1.8v-.6c-.1-.8.1-1.3.4-1.7z"/><path d="m38.6.9-2.1 5.4-2-5.4h-1.6v7.1h1.2v-2.3l-.1-3.2 2.1 5.5h.9l2.1-5.5-.2 3.2v2.3h1.3v-7.1z"/><path d="m19.4 1.9h2.2v6.1h1.2v-6.1h2.2v-1h-5.6z"/><path d="m30.2 1.2c-.4-.3-1-.4-1.5-.4s-1.1.1-1.5.4-.8.7-1 1.2-.4 1.1-.4 1.8v.4c0 .7.1 1.3.4 1.8s.6.9 1 1.2 1 .4 1.5.4c.6 0 1.1-.1 1.5-.4s.8-.7 1-1.2.4-1.1.4-1.8v-.4c0-.7-.1-1.3-.4-1.8s-.5-.9-1-1.2zm.2 3.4c0 .8-.1 1.4-.4 1.8s-.7.6-1.3.6c-.5 0-1-.2-1.3-.6s-.4-1-.4-1.8v-.4c0-.8.2-1.4.5-1.8s.7-.6 1.3-.6c.5 0 1 .2 1.3.6s.4 1 .4 1.8v.4z"/></svg>',
    ),

    'textWithMediaBelow'   => array(
        'name'    => 'textWithMediaBelow',
        'content' => '<svg height="42" enable-background="new 0 0 50 50" viewBox="0 0 50 50" xmlns="http://www.w3.org/2000/svg"><path d="m30.27 13.2h-10.94c-.43 0-.78.35-.78.78s.35.78.78.78h10.94c.43 0 .78-.35.78-.78s-.35-.78-.78-.78z"/><path d="m31.83 10.08h-14.06c-.43 0-.78.35-.78.78s.35.78.78.78h14.06c.43 0 .78-.35.78-.78s-.35-.78-.78-.78z"/><path d="m31.83 3.83h-14.06c-.43 0-.78.35-.78.78s.35.78.78.78h14.06c.43 0 .78-.35.78-.78s-.35-.78-.78-.78z"/><path d="m30.27 8.52c.43 0 .78-.35.78-.78s-.35-.78-.78-.78h-10.94c-.43 0-.78.35-.78.78s.35.78.78.78z"/><path d="m35.08 18.23h-20.57c-1.66 0-3 1.35-3 3.01v22.11c0 1.67 1.34 3.01 3 3.01h20.57c1.66 0 3-1.35 3-3.01v-22.11c0-1.67-1.34-3.01-3-3.01zm1 25.12c0 .56-.45 1.01-1 1.01h-20.57c-.56 0-1-.44-1-1.01v-22.11c0-.56.45-1.01 1-1.01h20.57c.56 0 1 .44 1 1.01z"/><path d="m33.03 39.29h-16.47c-.2 0-.36.18-.36.41s.16.41.36.41h16.47c.2 0 .36-.18.36-.41s-.16-.41-.36-.41z"/><path d="m20.38 28.6c1.11 0 2.03-.93 2.03-2.06s-.91-2.06-2.03-2.06-2.03.93-2.03 2.06.91 2.06 2.03 2.06zm0-3.29c.68 0 1.22.55 1.22 1.23s-.54 1.23-1.22 1.23-1.22-.55-1.22-1.23.54-1.23 1.22-1.23z"/><path d="m30.06 29.81c-.24-.29-.55-.39-.85-.39-.29 0-.54.17-.73.39l-4.29 5.18c-.19.24-.39.22-.57 0l-2.15-2.67c-.21-.27-.49-.43-.79-.43s-.58.17-.8.45l-3.57 4.6c-.34.39.19 1 .53.56l3.57-4.6c.25-.34.45-.13.56.01l2.15 2.67c.21.27.49.42.79.42s.57-.15.79-.42l4.29-5.18c.22-.26.44-.13.57 0l3.21 3.81c.34.41.86-.2.51-.59z"/></svg>',
    ),
    'customMedia'          => array(
        'name'    => 'customMedia',
        'content' => '<svg height="14" enable-background="new 0 0 41 9" viewBox="0 0 41 9" xmlns="http://www.w3.org/2000/svg"><path d="m17.8 4.5c-.3-.2-.8-.4-1.3-.6s-1-.3-1.2-.5-.3-.4-.3-.6c0-.3.1-.6.3-.7s.5-.3.9-.3.8.1 1 .3.3.5.3.9h1.2c0-.4-.1-.8-.3-1.1s-.4-.7-.8-.8-.8-.3-1.3-.3c-.7 0-1.4.2-1.8.6-.5.4-.7.8-.7 1.4 0 .7.3 1.2 1 1.6.3.2.8.4 1.4.6s1 .3 1.2.5.3.4.3.7-.1.5-.3.7-.5.3-1 .3-.9-.1-1.1-.3-.4-.5-.4-.9h-1.2c0 .4.1.8.4 1.2s.6.6 1 .8.9.3 1.4.3c.8 0 1.4-.2 1.8-.5s.7-.8.7-1.4c0-.4-.1-.7-.2-1s-.6-.7-1-.9z"/><path d="m11.3 5.6c0 1-.5 1.5-1.4 1.5-.5 0-.8-.1-1.1-.4s-.3-.6-.3-1.1v-4.7h-1.3v4.7c0 .8.3 1.4.8 1.8s1.1.7 1.9.7 1.4-.2 1.9-.7.7-1 .7-1.8v-4.7h-1.2z"/><path d="m2.3 2.4c.3-.4.7-.6 1.2-.6s.8.1 1.1.3.4.6.4 1.1h1.2c0-.7-.3-1.3-.8-1.8s-1.1-.6-1.9-.6c-.6 0-1.1.1-1.5.4s-.8.7-1 1.2-.4 1.1-.4 1.8v.7c0 .7.1 1.2.4 1.7s.6.9 1 1.1.9.4 1.5.4c.8 0 1.5-.2 1.9-.6s.8-1 .8-1.8h-1.2c-.1.5-.2.9-.5 1.1s-.6.3-1 .3c-.5 0-.9-.2-1.2-.6s-.4-1-.4-1.8v-.6c-.1-.8.1-1.3.4-1.7z"/><path d="m38.6.9-2.1 5.4-2-5.4h-1.6v7.1h1.2v-2.3l-.1-3.2 2.1 5.5h.9l2.1-5.5-.2 3.2v2.3h1.3v-7.1z"/><path d="m19.4 1.9h2.2v6.1h1.2v-6.1h2.2v-1h-5.6z"/><path d="m30.2 1.2c-.4-.3-1-.4-1.5-.4s-1.1.1-1.5.4-.8.7-1 1.2-.4 1.1-.4 1.8v.4c0 .7.1 1.3.4 1.8s.6.9 1 1.2 1 .4 1.5.4c.6 0 1.1-.1 1.5-.4s.8-.7 1-1.2.4-1.1.4-1.8v-.4c0-.7-.1-1.3-.4-1.8s-.5-.9-1-1.2zm.2 3.4c0 .8-.1 1.4-.4 1.8s-.7.6-1.3.6c-.5 0-1-.2-1.3-.6s-.4-1-.4-1.8v-.4c0-.8.2-1.4.5-1.8s.7-.6 1.3-.6c.5 0 1 .2 1.3.6s.4 1 .4 1.8v.4z"/></svg>',
    ),
    'textWithMediaOnLeft'  => array(
        'name'    => 'textWithMediaOnLeft',
        'content' => '<svg height="42" enable-background="new 0 0 50 50" viewBox="0 0 50 50" xmlns="http://www.w3.org/2000/svg"><path d="m48.84 28.91c.43 0 .78.35.78.78s-.35.78-.78.78h-10.93c-.43 0-.78-.35-.78-.78s.35-.78.78-.78z"/><path d="m48.84 25.78c.43 0 .78.35.78.78s-.35.78-.78.78h-14.06c-.43 0-.78-.35-.78-.78s.35-.78.78-.78z"/><path d="m48.84 19.53c.43 0 .78.35.78.78s-.35.78-.78.78h-14.06c-.43 0-.78-.35-.78-.78s.35-.78.78-.78z"/><path d="m48.84 22.66c.43 0 .78.35.78.78s-.35.78-.78.78h-10.93c-.43 0-.78-.35-.78-.78s.35-.78.78-.78z"/><path d="m24.5 10.94h-20.57c-1.66 0-3 1.35-3 3.01v22.11c0 1.67 1.34 3.01 3 3.01h20.57c1.66 0 3-1.35 3-3.01v-22.11c0-1.67-1.34-3.01-3-3.01zm1 25.11c0 .56-.45 1.01-1 1.01h-20.57c-.56 0-1-.44-1-1.01v-22.1c0-.56.45-1.01 1-1.01h20.57c.56 0 1 .44 1 1.01z"/><path d="m22.45 31.99h-16.47c-.2 0-.36.18-.36.41s.16.41.36.41h16.47c.2 0 .36-.18.36-.41s-.16-.41-.36-.41z"/><path d="m9.8 21.3c1.11 0 2.03-.93 2.03-2.06s-.91-2.06-2.03-2.06-2.03.93-2.03 2.06.91 2.06 2.03 2.06zm0-3.29c.68 0 1.22.55 1.22 1.23s-.54 1.23-1.22 1.23-1.22-.55-1.22-1.23.54-1.23 1.22-1.23z"/><path d="m19.48 22.52c-.24-.29-.55-.39-.85-.39-.29 0-.54.17-.73.39l-4.29 5.18c-.19.24-.39.22-.57 0l-2.15-2.67c-.21-.27-.49-.43-.79-.43s-.58.17-.8.45l-3.57 4.6c-.34.39.19 1 .53.56l3.57-4.6c.25-.34.45-.13.56.01l2.15 2.67c.21.27.49.42.79.42s.57-.15.79-.42l4.29-5.18c.22-.26.44-.13.57 0l3.21 3.81c.34.41.86-.2.51-.59z"/></svg>',
    ),
    'textWithMediaOnRight' => array(
        'name'    => 'textWithMediaOnRight',
        'content' => '<svg height="42" enable-background="new 0 0 50 50" viewBox="0 0 50 50" xmlns="http://www.w3.org/2000/svg"><path d="m15.84 28.91c.43 0 .78.35.78.78s-.35.78-.78.78h-10.93c-.43 0-.78-.35-.78-.78s.35-.78.78-.78z"/><path d="m15.84 25.78c.43 0 .78.35.78.78s-.35.78-.78.78h-14.06c-.43 0-.78-.35-.78-.78s.35-.78.78-.78z"/><path d="m15.84 19.53c.43 0 .78.35.78.78s-.35.78-.78.78h-14.06c-.43 0-.78-.35-.78-.78s.35-.78.78-.78z"/><path d="m15.84 22.66c.43 0 .78.35.78.78s-.35.78-.78.78h-10.93c-.43 0-.78-.35-.78-.78s.35-.78.78-.78z"/><path d="m46.5 10.94h-20.57c-1.66 0-3 1.35-3 3.01v22.11c0 1.67 1.34 3.01 3 3.01h20.57c1.66 0 3-1.35 3-3.01v-22.11c0-1.67-1.34-3.01-3-3.01zm1 25.11c0 .56-.45 1.01-1 1.01h-20.57c-.56 0-1-.44-1-1.01v-22.1c0-.56.45-1.01 1-1.01h20.57c.56 0 1 .44 1 1.01z"/><path d="m44.45 31.99h-16.47c-.2 0-.36.18-.36.41s.16.41.36.41h16.47c.2 0 .36-.18.36-.41s-.16-.41-.36-.41z"/><path d="m31.8 21.3c1.11 0 2.03-.93 2.03-2.06s-.91-2.06-2.03-2.06-2.03.93-2.03 2.06.91 2.06 2.03 2.06zm0-3.29c.68 0 1.22.55 1.22 1.23s-.54 1.23-1.22 1.23-1.22-.55-1.22-1.23.54-1.23 1.22-1.23z"/><path d="m41.48 22.52c-.24-.29-.55-.39-.85-.39-.29 0-.54.17-.73.39l-4.29 5.18c-.19.24-.39.22-.57 0l-2.15-2.67c-.21-.27-.49-.43-.79-.43s-.58.17-.8.45l-3.57 4.6c-.34.39.19 1 .53.56l3.57-4.6c.25-.34.45-.13.56.01l2.15 2.67c.21.27.49.42.79.42s.57-.15.79-.42l4.29-5.18c.22-.26.44-.13.57 0l3.21 3.81c.34.41.86-.2.51-.59z"/></svg>',
    ),
    'textOnly'             => array(
        'name'    => 'textOnly',
        'content' => '<svg height="42" enable-background="new 0 0 50 50" viewBox="0 0 50 50" xmlns="http://www.w3.org/2000/svg"><path d="m33.31 31.29h-16.62c-.66 0-1.19.45-1.19 1s.53 1 1.19 1h16.62c.66 0 1.19-.45 1.19-1s-.53-1-1.19-1z"/><path d="m35.8 26.43h-21.6c-.66 0-1.2.45-1.2 1s.54 1 1.2 1h21.6c.66 0 1.2-.45 1.2-1s-.54-1-1.2-1z"/><path d="m14.2 18.71h21.6c.66 0 1.2-.45 1.2-1s-.54-1-1.2-1h-21.6c-.66 0-1.2.45-1.2 1 0 .56.54 1 1.2 1z"/><path d="m16.69 21.57c-.66 0-1.19.45-1.19 1s.53 1 1.19 1h16.62c.66 0 1.19-.45 1.19-1s-.53-1-1.19-1z"/></svg>',
    ),
    'textWithMediaAbove'   => array(
        'name'    => 'textWithMediaAbove',
        'content' => '<svg height="42" enable-background="new 0 0 50 50" viewBox="0 0 50 50" xmlns="http://www.w3.org/2000/svg"><path d="m30.27 45.2h-10.94c-.43 0-.78.35-.78.78s.35.78.78.78h10.94c.43 0 .78-.35.78-.78s-.35-.78-.78-.78z"/><path d="m31.83 42.08h-14.06c-.43 0-.78.35-.78.78s.35.78.78.78h14.06c.43 0 .78-.35.78-.78s-.35-.78-.78-.78z"/><path d="m31.83 35.83h-14.06c-.43 0-.78.35-.78.78s.35.78.78.78h14.06c.43 0 .78-.35.78-.78s-.35-.78-.78-.78z"/><path d="m30.27 40.52c.43 0 .78-.35.78-.78s-.35-.78-.78-.78h-10.94c-.43 0-.78.35-.78.78s.35.78.78.78z"/><path d="m35.08 3.23h-20.57c-1.66 0-3 1.35-3 3.01v22.11c0 1.67 1.34 3.01 3 3.01h20.57c1.66 0 3-1.35 3-3.01v-22.11c0-1.67-1.34-3.01-3-3.01zm1 25.12c0 .56-.45 1.01-1 1.01h-20.57c-.56 0-1-.44-1-1.01v-22.11c0-.56.45-1.01 1-1.01h20.57c.56 0 1 .44 1 1.01z"/><path d="m33.03 24.29h-16.47c-.2 0-.36.18-.36.41s.16.41.36.41h16.47c.2 0 .36-.18.36-.41s-.16-.41-.36-.41z"/><path d="m20.38 13.6c1.11 0 2.03-.93 2.03-2.06s-.91-2.06-2.03-2.06-2.03.93-2.03 2.06.91 2.06 2.03 2.06zm0-3.29c.68 0 1.22.55 1.22 1.23s-.54 1.23-1.22 1.23-1.22-.55-1.22-1.23.54-1.23 1.22-1.23z"/><path d="m30.06 14.81c-.24-.29-.55-.39-.85-.39-.29 0-.54.17-.73.39l-4.29 5.18c-.19.24-.39.22-.57 0l-2.15-2.67c-.21-.27-.49-.43-.79-.43s-.58.17-.8.45l-3.57 4.6c-.34.39.19 1 .53.56l3.57-4.6c.25-.34.45-.13.56.01l2.15 2.67c.21.27.49.42.79.42s.57-.15.79-.42l4.29-5.18c.22-.26.44-.13.57 0l3.21 3.81c.34.41.86-.2.51-.59z"/></svg>',
    ),

);

$colibriwp_theme_divider_style = array(
    'arrow-negative'                 => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 10" preserveAspectRatio="none">	<path class="svg-white-bg" d="M360 0L350 9.9 340 0 0 0 0 10 700 10 700 0"/></svg>',
    'arrow'                          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 10" preserveAspectRatio="none">	<path class="svg-white-bg" d="M350,10L340,0h20L350,10z"/></svg>',
    'book-negative'                  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M806,94.7C619.5,90,500,20.3,500,1.7c-1,18.6-117.5,88.3-306,93C92,97.2,0,97.9,0,97.9v-0l0,0v2.3h1000v-2.3 C1000,97.7,920.3,97.6,806,94.7z M350,65.1L350,65.1L350,65.1L350,65.1z"/></svg>',
    'book'                           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M194,99c186.7,0.7,305-78.3,306-97.2c1,18.9,119.3,97.9,306,97.2c114.3-0.3,194,0.3,194,0.3s0-91.7,0-100c0,0,0,0,0-0 L0,0v99.3C0,99.3,79.7,98.7,194,99z"/></svg>',
    'clouds-negative'                => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 283.5 27.8" preserveAspectRatio="xMidYMax slice">	<path class="svg-white-bg" d="M265.8 3.5c-10.9 0-15.9 6.2-15.9 6.2s-3.6-3.5-9.2-.9c-9.1 4.1-4.4 13.4-4.4 13.4s-1.2.2-1.9.9c-.6.7-.5 1.9-.5 1.9s-1-.5-2.3-.2c-1.3.3-1.6 1.4-1.6 1.4s.4-3.4-1.5-5c-3.9-3.4-8.3-.2-8.3-.2s-.6-.7-.9-.9c-.4-.2-1.2-.2-1.2-.2s-4.4-3.6-11.5-2.6-10.4 7.9-10.4 7.9-.5-3.3-3.9-4.9c-4.8-2.4-7.4 0-7.4 0s2.4-4.1-1.9-6.4-6.2 1.2-6.2 1.2-.9-.5-2.1-.5-2.3 1.1-2.3 1.1.1-.7-1.1-1.1c-1.2-.4-2 0-2 0s3.6-6.8-3.5-8.9c-6-1.8-7.9 2.6-8.4 4-.1-.3-.4-.7-.9-1.1-1-.7-1.3-.5-1.3-.5s1-4-1.7-5.2c-2.7-1.2-4.2 1.1-4.2 1.1s-3.1-1-5.7 1.4-2.1 5.5-2.1 5.5-.9 0-2.1.7-1.4 1.7-1.4 1.7-1.7-1.2-4.3-1.2c-2.6 0-4.5 1.2-4.5 1.2s-.7-1.5-2.8-2.4c-2.1-.9-4 0-4 0s2.6-5.9-4.7-9c-7.3-3.1-12.6 3.3-12.6 3.3s-.9 0-1.9.2c-.9.2-1.5.9-1.5.9S99.4 3 94.9 3.9c-4.5.9-5.7 5.7-5.7 5.7s-2.8-5-12.3-3.9-11.1 6-11.1 6-1.2-1.4-4-.7c-.8.2-1.3.5-1.8.9-.9-2.1-2.7-4.9-6.2-4.4-3.2.4-4 2.2-4 2.2s-.5-.7-1.2-.7h-1.4s-.5-.9-1.7-1.4-2.4 0-2.4 0-2.4-1.2-4.7 0-3.1 4.1-3.1 4.1-1.7-1.4-3.6-.7c-1.9.7-1.9 2.8-1.9 2.8s-.5-.5-1.7-.2c-1.2.2-1.4.7-1.4.7s-.7-2.3-2.8-2.8c-2.1-.5-4.3.2-4.3.2s-1.7-5-11.1-6c-3.8-.4-6.6.2-8.5 1v21.2h283.5V11.1c-.9.2-1.6.4-1.6.4s-5.2-8-16.1-8z"/></svg>',
    'clouds'                         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 283.5 27.8" preserveAspectRatio="xMidYMax slice">  <path class="svg-white-bg" d="M0 0v6.7c1.9-.8 4.7-1.4 8.5-1 9.5 1.1 11.1 6 11.1 6s2.1-.7 4.3-.2c2.1.5 2.8 2.6 2.8 2.6s.2-.5 1.4-.7c1.2-.2 1.7.2 1.7.2s0-2.1 1.9-2.8c1.9-.7 3.6.7 3.6.7s.7-2.9 3.1-4.1 4.7 0 4.7 0 1.2-.5 2.4 0 1.7 1.4 1.7 1.4h1.4c.7 0 1.2.7 1.2.7s.8-1.8 4-2.2c3.5-.4 5.3 2.4 6.2 4.4.4-.4 1-.7 1.8-.9 2.8-.7 4 .7 4 .7s1.7-5 11.1-6c9.5-1.1 12.3 3.9 12.3 3.9s1.2-4.8 5.7-5.7c4.5-.9 6.8 1.8 6.8 1.8s.6-.6 1.5-.9c.9-.2 1.9-.2 1.9-.2s5.2-6.4 12.6-3.3c7.3 3.1 4.7 9 4.7 9s1.9-.9 4 0 2.8 2.4 2.8 2.4 1.9-1.2 4.5-1.2 4.3 1.2 4.3 1.2.2-1 1.4-1.7 2.1-.7 2.1-.7-.5-3.1 2.1-5.5 5.7-1.4 5.7-1.4 1.5-2.3 4.2-1.1c2.7 1.2 1.7 5.2 1.7 5.2s.3-.1 1.3.5c.5.4.8.8.9 1.1.5-1.4 2.4-5.8 8.4-4 7.1 2.1 3.5 8.9 3.5 8.9s.8-.4 2 0 1.1 1.1 1.1 1.1 1.1-1.1 2.3-1.1 2.1.5 2.1.5 1.9-3.6 6.2-1.2 1.9 6.4 1.9 6.4 2.6-2.4 7.4 0c3.4 1.7 3.9 4.9 3.9 4.9s3.3-6.9 10.4-7.9 11.5 2.6 11.5 2.6.8 0 1.2.2c.4.2.9.9.9.9s4.4-3.1 8.3.2c1.9 1.7 1.5 5 1.5 5s.3-1.1 1.6-1.4c1.3-.3 2.3.2 2.3.2s-.1-1.2.5-1.9 1.9-.9 1.9-.9-4.7-9.3 4.4-13.4c5.6-2.5 9.2.9 9.2.9s5-6.2 15.9-6.2 16.1 8.1 16.1 8.1.7-.2 1.6-.4V0H0z"/></svg>',
    'curve-asymmetrical-negative'    => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M615.2,96.7C240.2,97.8,0,18.9,0,0v100h1000V0C1000,19.2,989.8,96,615.2,96.7z"/></svg>',
    'curve-asymmetrical'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M0,0c0,0,0,6,0,6.7c0,18,240.2,93.6,615.2,92.6C989.8,98.5,1000,25,1000,6.7c0-0.7,0-6.7,0-6.7H0z"/></svg>',
    'curve-negative'                 => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M500,97C126.7,96.3,0.8,19.8,0,0v100l1000,0V1C1000,19.4,873.3,97.8,500,97z"/></svg>',
    'curve'                          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">    <path class="svg-white-bg" d="M1000,4.3V0H0v4.3C0.9,23.1,126.7,99.2,500,100S1000,22.7,1000,4.3z"/></svg>',
    'drops-negative'                 => '<svg xmlns="http://www.w3.org/2000/svg" height="100%" viewBox="0 0 283.5 27.8" preserveAspectRatio="xMidYMax slice">	<path class="svg-white-bg" d="M282.7 3.4c-2 3.8-2.2 6.6-1.8 10.8.3 3.3 2 8.5.4 11.6-1.4 2.6-4 2.5-5-.2-1.2-3.4.3-7.6.5-11.1.3-4.3-2.9-6.9-7.4-5.8-3.1.7-4.1 3.3-4.3 6.2-.2 2 1.2 8-.1 9.6-3.1 4.3-2.5-4.5-2.5-5.2.1-4-.1-9.6-4.1-11.6-4.5-2.3-6.1 1-5.5 5 .2 1.4 1.5 10.2-2.7 6.9-2.5-1.9.4-7.5-.9-10.3-.8-1.8-2.6-4.2-4.8-4.1-2.4.1-2.7 2.2-4 3.7-3.3 3.8-2.2-1.2-4.8-2.7-5.5-3.1-2 5.6-2.9 7.3-1.4 2.4-3.1.6-3.3-1.3-.1-1.5.5-3.1.4-4.6-.3-4.3-2.9-5.3-5.2-1.2-3.7 6.7-2.8-1.9-6.5-.4-3 1.1-.9 9.2-.6 11.1.7 4.1-2.2 5.2-2.7.8-.4-3.6 2.8-10.2.8-13.4-2.1-3.3-6.7-.1-7.9 2.4-2.1 4.2-.4 8.7 0 13.1.2 2-.8 8.9-3.8 4.8-3.1-4.3 2.5-11.6.2-16.3-1.1-2.2-5.8-3.5-7.2-1-.8 1.4 1 3.4.3 4.8s-2.2 1.2-2.8-.3c-.8-2.1 2.2-4.8-.1-6.5-1.3-.9-3.5.3-4.9.5-2.4-.1-3.3 0-4.5 2-.7 1.2-.4 3-2.3 2.1-1.9-.8-1.7-4.3-4.1-4.9-2.1-.6-4 1.3-5.1 2.9-.9 1.4-1.3 3-1.3 4.6 0 1.9 1.4 4.2.3 6-2.4 4.2-4.2-2.2-3.8-4.4.5-2.9 2-7.7-2.7-7.5-5.2.3-6.1 5.8-6.4 9.8-.1 1.3 1.5 10.4-2 8.4-1.8-1-.5-7.5-.6-9.1-.1-3.5-1.6-8.3-6.3-7.1-7.6 1.9 2.1 18.2-4.8 18.7-3.7.3-2.3-6.2-2-8.1.5-3.1.5-11.4-5.5-8.5-2.2 1.1-1 2.3-1.3 4.3-.2 1.8-1.3 3.2-2.3.8-1.1-2.5.8-6.7-3.9-6.6-8 .1-.7 16.4-4.8 15.8-2.8-.4-1-9.3-1.3-11.3-.6-3.5-3.5-7.8-7.8-6.9-4.4.9-1.4 6.5-1.4 9.1 0 3.1-3.4 5.9-4.4 1.7-.5-2.2.9-4.4.6-6.6-.3-1.9-1.5-4.1-3.2-5.2-5.3-3.4-4.9 5.2-8.1 4.5-1.4-.3-3-8.1-6.1-4.1-.7.9 2 10.3-2.2 8-2-1.1-.1-6.7-.7-8.9-1.8-6.2-4.7 2.3-6.1 3.1-2.9 1.7-4.6-6.2-6.3-.6-.5 1.7-.4 3.7-.2 5.4.2 1.6 1.5 4.6 1 6.1-.6 1.8-1.7 1.7-2.6.3-1-1.6-.4-4.5-.2-6.2.3-2.5 2.4-8.4-.2-10.3-3.1-2.1-6.8 2.1-7.7 4.5-1.5 4.3.3 8.7.5 13 .1 3.2-3 7.5-4.3 2.4-.6-2.4.2-5.1.6-7.4.4-2.3 1.2-6-.1-8.1-1.2-1.9-5.8-2.7-7-.5-.9 1.6 1.2 5.2-.6 5.6-2.4.6-2-2.3-1.8-3.4.3-1.5 1.1-3.2-.4-4.3-1.2-.9-4.7.3-5.9.5-2.4.5-2.5 1.4-3.6 3.3-1.2 2.1-1.4 1.7-3-.1-1.3-1.5-1.7-3.6-4-3.7-1.8-.1-3.4 1.7-4.2 3-1.4 2.2-1.3 4.1-1 6.5.2 1.4 1 3.8-.5 4.9-3.9 2.9-3.2-4.6-2.9-6.3.8-3.9-.4-8.1-5.4-5.6-3.8 1.9-4.1 6.7-4.1 10.5 0 1.6 1.2 5.8-.1 6.9-.8.7-1.8.3-2.4-.5-1.1-1.5.1-6.7 0-8.5-.1-3.5-.9-6.9-4.9-7.4-3.6-.6-6.7 1.2-6.8 4.9-.1 3.9 2 8.2.6 12-.9 2.4-2.9 2.9-4.6.9-2.4-2.8-.4-9 0-12.3.4-4.2.2-7-1.8-10.8C1.1 2.8.6 2.1 0 1.4v26.4h283.5V2.2c-.3.4-.6.8-.8 1.2z"/></svg>',
    'drops'                          => '<svg xmlns="http://www.w3.org/2000/svg" height="100%" viewBox="0 0 283.5 27.8" preserveAspectRatio="xMidYMax slice">	<path class="svg-white-bg" d="M0 0v1.4c.6.7 1.1 1.4 1.4 2 2 3.8 2.2 6.6 1.8 10.8-.3 3.3-2.4 9.4 0 12.3 1.7 2 3.7 1.4 4.6-.9 1.4-3.8-.7-8.2-.6-12 .1-3.7 3.2-5.5 6.9-4.9 4 .6 4.8 4 4.9 7.4.1 1.8-1.1 7 0 8.5.6.8 1.6 1.2 2.4.5 1.4-1.1.1-5.4.1-6.9.1-3.7.3-8.6 4.1-10.5 5-2.5 6.2 1.6 5.4 5.6-.4 1.7-1 9.2 2.9 6.3 1.5-1.1.7-3.5.5-4.9-.4-2.4-.4-4.3 1-6.5.9-1.4 2.4-3.1 4.2-3 2.4.1 2.7 2.2 4 3.7 1.5 1.8 1.8 2.2 3 .1 1.1-1.9 1.2-2.8 3.6-3.3 1.3-.3 4.8-1.4 5.9-.5 1.5 1.1.6 2.8.4 4.3-.2 1.1-.6 4 1.8 3.4 1.7-.4-.3-4.1.6-5.6 1.3-2.2 5.8-1.4 7 .5 1.3 2.1.5 5.8.1 8.1s-1.2 5-.6 7.4c1.3 5.1 4.4.9 4.3-2.4-.1-4.4-2-8.8-.5-13 .9-2.4 4.6-6.6 7.7-4.5 2.7 1.8.5 7.8.2 10.3-.2 1.7-.8 4.6.2 6.2.9 1.4 2 1.5 2.6-.3.5-1.5-.9-4.5-1-6.1-.2-1.7-.4-3.7.2-5.4 1.8-5.6 3.5 2.4 6.3.6 1.4-.9 4.3-9.4 6.1-3.1.6 2.2-1.3 7.8.7 8.9 4.2 2.3 1.5-7.1 2.2-8 3.1-4 4.7 3.8 6.1 4.1 3.1.7 2.8-7.9 8.1-4.5 1.7 1.1 2.9 3.3 3.2 5.2.4 2.2-1 4.5-.6 6.6 1 4.3 4.4 1.5 4.4-1.7 0-2.7-3-8.3 1.4-9.1 4.4-.9 7.3 3.5 7.8 6.9.3 2-1.5 10.9 1.3 11.3 4.1.6-3.2-15.7 4.8-15.8 4.7-.1 2.8 4.1 3.9 6.6 1 2.4 2.1 1 2.3-.8.3-1.9-.9-3.2 1.3-4.3 5.9-2.9 5.9 5.4 5.5 8.5-.3 2-1.7 8.4 2 8.1 6.9-.5-2.8-16.9 4.8-18.7 4.7-1.2 6.1 3.6 6.3 7.1.1 1.7-1.2 8.1.6 9.1 3.5 2 1.9-7 2-8.4.2-4 1.2-9.6 6.4-9.8 4.7-.2 3.2 4.6 2.7 7.5-.4 2.2 1.3 8.6 3.8 4.4 1.1-1.9-.3-4.1-.3-6 0-1.7.4-3.2 1.3-4.6 1-1.6 2.9-3.5 5.1-2.9 2.5.6 2.3 4.1 4.1 4.9 1.9.8 1.6-.9 2.3-2.1 1.2-2.1 2.1-2.1 4.4-2.4 1.4-.2 3.6-1.5 4.9-.5 2.3 1.7-.7 4.4.1 6.5.6 1.5 2.1 1.7 2.8.3.7-1.4-1.1-3.4-.3-4.8 1.4-2.5 6.2-1.2 7.2 1 2.3 4.8-3.3 12-.2 16.3 3 4.1 3.9-2.8 3.8-4.8-.4-4.3-2.1-8.9 0-13.1 1.3-2.5 5.9-5.7 7.9-2.4 2 3.2-1.3 9.8-.8 13.4.5 4.4 3.5 3.3 2.7-.8-.4-1.9-2.4-10 .6-11.1 3.7-1.4 2.8 7.2 6.5.4 2.2-4.1 4.9-3.1 5.2 1.2.1 1.5-.6 3.1-.4 4.6.2 1.9 1.8 3.7 3.3 1.3 1-1.6-2.6-10.4 2.9-7.3 2.6 1.5 1.6 6.5 4.8 2.7 1.3-1.5 1.7-3.6 4-3.7 2.2-.1 4 2.3 4.8 4.1 1.3 2.9-1.5 8.4.9 10.3 4.2 3.3 3-5.5 2.7-6.9-.6-3.9 1-7.2 5.5-5 4.1 2.1 4.3 7.7 4.1 11.6 0 .8-.6 9.5 2.5 5.2 1.2-1.7-.1-7.7.1-9.6.3-2.9 1.2-5.5 4.3-6.2 4.5-1 7.7 1.5 7.4 5.8-.2 3.5-1.8 7.7-.5 11.1 1 2.7 3.6 2.8 5 .2 1.6-3.1 0-8.3-.4-11.6-.4-4.2-.2-7 1.8-10.8 0 0-.1.1-.1.2-.2.4-.3.7-.4.8v.1c-.1.2-.1.2 0 0v-.1l.4-.8c0-.1.1-.1.1-.2.2-.4.5-.8.8-1.2V0H0zM282.7 3.4z"/></svg>',
    'mountains'                      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"/>	<path class="svg-white-bg" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"/>	<path class="svg-white-bg" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"/></svg>',
    'opacity-fan'                    => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 283.5 19.6" preserveAspectRatio="none">	<path class="svg-white-bg" opacity="0.33"  d="M0 0L0 18.8 141.8 4.1 283.5 18.8 283.5 0z"/>	<path class="svg-white-bg" opacity="0.33" d="M0 0L0 12.6 141.8 4 283.5 12.6 283.5 0z"/>	<path class="svg-white-bg" opacity="0.33" d="M0 0L0 6.4 141.8 4 283.5 6.4 283.5 0z"/>	<path class="svg-white-bg" d="M0 0L0 1.2 141.8 4 283.5 1.2 283.5 0z"/></svg>',
    'opacity-tilt'                   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 2600 131.1" preserveAspectRatio="none">	<path class="svg-white-bg" d="M0 0L2600 0 2600 69.1 0 0z"/>	<path class="svg-white-bg" opacity="0.5" d="M0 0L2600 0 2600 69.1 0 69.1z"/>	<path class="svg-white-bg" opacity="0.25" d="M2600 0L0 0 0 130.1 2600 69.1z"/></svg>',
    'pyramids-negative'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M761.9,40.6L643.1,24L333.9,93.8L0.1,1H0v99h1000V1"/></svg>',
    'pyramids'                       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M761.9,44.1L643.1,27.2L333.8,98L0,3.8V0l1000,0v3.9"/></svg>',
    'split-negative'                 => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 20" preserveAspectRatio="none">	<path class="svg-white-bg" d="M519.8,0.2c-11,0-19.8,8.5-19.8,19c0-10.4-8.8-19-19.8-19L0,0v20h1000V0.2H519.8z"/></svg>',
    'split'                          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 20" preserveAspectRatio="none">	<path class="svg-white-bg" d="M0,0v3c0,0,393.8,0,483.4,0c9.2,0,16.6,7.4,16.6,16.6c0-9.1,7.4-16.6,16.6-16.6C606.2,3,1000,3,1000,3V0H0z"/></svg>',
    'tilt-flipped'                   => '<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none"  viewBox="0 0 1000 100">  <path id="path2" d="M 1000,0 H 0 v 100 z" class="svg-white-bg" /></svg>',
    'tilt'                           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M-0 0L1000 0 1000 100z"/></svg>',
    'triangle-asymmetrical-negative' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M737.9,94.7L0,0v100h1000V0L737.9,94.7z"/></svg>',
    'triangle-asymmetrical'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M738,99l262-93V0H0v5.6L738,99z"/></svg>',
    'triangle-negative'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M500.2,94.7L0,0v100h1000V0L500.2,94.7z"/></svg>',
    'triangle'                       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M500,98.9L0,6.1V0h1000v6.1L500,98.9z"/></svg>',
    'wave-brush'                     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 283.5 27.8" preserveAspectRatio="none">	<path class="svg-white-bg" d="M283.5,9.7c0,0-7.3,4.3-14,4.6c-6.8,0.3-12.6,0-20.9-1.5c-11.3-2-33.1-10.1-44.7-5.7	s-12.1,4.6-18,7.4c-6.6,3.2-20,9.6-36.6,9.3C131.6,23.5,99.5,7.2,86.3,8c-1.4,0.1-6.6,0.8-10.5,2c-3.8,1.2-9.4,3.8-17,4.7	c-3.2,0.4-8.3,1.1-14.2,0.9c-1.5-0.1-6.3-0.4-12-1.6c-5.7-1.2-11-3.1-15.8-3.7C6.5,9.2,0,10.8,0,10.8V0h283.5V9.7z M260.8,11.3	c-0.7-1-2-0.4-4.3-0.4c-2.3,0-6.1-1.2-5.8-1.1c0.3,0.1,3.1,1.5,6,1.9C259.7,12.2,261.4,12.3,260.8,11.3z M242.4,8.6	c0,0-2.4-0.2-5.6-0.9c-3.2-0.8-10.3-2.8-15.1-3.5c-8.2-1.1-15.8,0-15.1,0.1c0.8,0.1,9.6-0.6,17.6,1.1c3.3,0.7,9.3,2.2,12.4,2.7	C239.9,8.7,242.4,8.6,242.4,8.6z M185.2,8.5c1.7-0.7-13.3,4.7-18.5,6.1c-2.1,0.6-6.2,1.6-10,2c-3.9,0.4-8.9,0.4-8.8,0.5	c0,0.2,5.8,0.8,11.2,0c5.4-0.8,5.2-1.1,7.6-1.6C170.5,14.7,183.5,9.2,185.2,8.5z M199.1,6.9c0.2,0-0.8-0.4-4.8,1.1	c-4,1.5-6.7,3.5-6.9,3.7c-0.2,0.1,3.5-1.8,6.6-3C197,7.5,199,6.9,199.1,6.9z M283,6c-0.1,0.1-1.9,1.1-4.8,2.5s-6.9,2.8-6.7,2.7	c0.2,0,3.5-0.6,7.4-2.5C282.8,6.8,283.1,5.9,283,6z M31.3,11.6c0.1-0.2-1.9-0.2-4.5-1.2s-5.4-1.6-7.8-2C15,7.6,7.3,8.5,7.7,8.6	C8,8.7,15.9,8.3,20.2,9.3c2.2,0.5,2.4,0.5,5.7,1.6S31.2,11.9,31.3,11.6z M73,9.2c0.4-0.1,3.5-1.6,8.4-2.6c4.9-1.1,8.9-0.5,8.9-0.8	c0-0.3-1-0.9-6.2-0.3S72.6,9.3,73,9.2z M71.6,6.7C71.8,6.8,75,5.4,77.3,5c2.3-0.3,1.9-0.5,1.9-0.6c0-0.1-1.1-0.2-2.7,0.2	C74.8,5.1,71.4,6.6,71.6,6.7z M93.6,4.4c0.1,0.2,3.5,0.8,5.6,1.8c2.1,1,1.8,0.6,1.9,0.5c0.1-0.1-0.8-0.8-2.4-1.3	C97.1,4.8,93.5,4.2,93.6,4.4z M65.4,11.1c-0.1,0.3,0.3,0.5,1.9-0.2s2.6-1.3,2.2-1.2s-0.9,0.4-2.5,0.8C65.3,10.9,65.5,10.8,65.4,11.1	z M34.5,12.4c-0.2,0,2.1,0.8,3.3,0.9c1.2,0.1,2,0.1,2-0.2c0-0.3-0.1-0.5-1.6-0.4C36.6,12.8,34.7,12.4,34.5,12.4z M152.2,21.1	c-0.1,0.1-2.4-0.3-7.5-0.3c-5,0-13.6-2.4-17.2-3.5c-3.6-1.1,10,3.9,16.5,4.1C150.5,21.6,152.3,21,152.2,21.1z"/>	<path class="svg-white-bg" d="M269.6,18c-0.1-0.1-4.6,0.3-7.2,0c-7.3-0.7-17-3.2-16.6-2.9c0.4,0.3,13.7,3.1,17,3.3	C267.7,18.8,269.7,18,269.6,18z"/>	<path class="svg-white-bg" d="M227.4,9.8c-0.2-0.1-4.5-1-9.5-1.2c-5-0.2-12.7,0.6-12.3,0.5c0.3-0.1,5.9-1.8,13.3-1.2	S227.6,9.9,227.4,9.8z"/>	<path class="svg-white-bg" d="M204.5,13.4c-0.1-0.1,2-1,3.2-1.1c1.2-0.1,2,0,2,0.3c0,0.3-0.1,0.5-1.6,0.4	C206.4,12.9,204.6,13.5,204.5,13.4z"/>	<path class="svg-white-bg" d="M201,10.6c0-0.1-4.4,1.2-6.3,2.2c-1.9,0.9-6.2,3.1-6.1,3.1c0.1,0.1,4.2-1.6,6.3-2.6	S201,10.7,201,10.6z"/>	<path class="svg-white-bg" d="M154.5,26.7c-0.1-0.1-4.6,0.3-7.2,0c-7.3-0.7-17-3.2-16.6-2.9c0.4,0.3,13.7,3.1,17,3.3	C152.6,27.5,154.6,26.8,154.5,26.7z"/>	<path class="svg-white-bg" d="M41.9,19.3c0,0,1.2-0.3,2.9-0.1c1.7,0.2,5.8,0.9,8.2,0.7c4.2-0.4,7.4-2.7,7-2.6	c-0.4,0-4.3,2.2-8.6,1.9c-1.8-0.1-5.1-0.5-6.7-0.4S41.9,19.3,41.9,19.3z"/>	<path class="svg-white-bg" d="M75.5,12.6c0.2,0.1,2-0.8,4.3-1.1c2.3-0.2,2.1-0.3,2.1-0.5c0-0.1-1.8-0.4-3.4,0	C76.9,11.5,75.3,12.5,75.5,12.6z"/>	<path class="svg-white-bg" d="M15.6,13.2c0-0.1,4.3,0,6.7,0.5c2.4,0.5,5,1.9,5,2c0,0.1-2.7-0.8-5.1-1.4	C19.9,13.7,15.7,13.3,15.6,13.2z"/></svg>',
    'waves-negative'                 => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M790.5,93.1c-59.3-5.3-116.8-18-192.6-50c-29.6-12.7-76.9-31-100.5-35.9c-23.6-4.9-52.6-7.8-75.5-5.3	c-10.2,1.1-22.6,1.4-50.1,7.4c-27.2,6.3-58.2,16.6-79.4,24.7c-41.3,15.9-94.9,21.9-134,22.6C72,58.2,0,25.8,0,25.8V100h1000V65.3	c0,0-51.5,19.4-106.2,25.7C839.5,97,814.1,95.2,790.5,93.1z"/></svg>',
    'waves-pattern'                  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1047.1 3.7" preserveAspectRatio="xMidYMin slice">	<path class="svg-white-bg" d="M1047.1,0C557,0,8.9,0,0,0v1.6c0,0,0.6-1.5,2.7-0.3C3.9,2,6.1,4.1,8.3,3.5c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3C13.8,2,16,4.1,18.2,3.5c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3C23.6,2,25.9,4.1,28,3.5c0.9-0.2,1.5-1.9,1.5-1.9	c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3C63,2,65.3,4.1,67.4,3.5	C68.3,3.3,69,1.6,69,1.6s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3	C82.7,2,85,4.1,87.1,3.5c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3C92.6,2,94.8,4.1,97,3.5c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9	c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9c0,0,0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2	c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.7-0.3	c1.2,0.7,3.5,2.8,5.6,2.2c0.9-0.2,1.5-1.9,1.5-1.9s0.6-1.5,2.6-0.4V0z M2.5,1.2C2.5,1.2,2.5,1.2,2.5,1.2C2.5,1.2,2.5,1.2,2.5,1.2z M2.7,1.4c0.1,0,0.1,0.1,0.1,0.1C2.8,1.4,2.8,1.4,2.7,1.4z"/></svg>',
    'waves'                          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M421.9,6.5c22.6-2.5,51.5,0.4,75.5,5.3c23.6,4.9,70.9,23.5,100.5,35.7c75.8,32.2,133.7,44.5,192.6,49.7	c23.6,2.1,48.7,3.5,103.4-2.5c54.7-6,106.2-25.6,106.2-25.6V0H0v30.3c0,0,72,32.6,158.4,30.5c39.2-0.7,92.8-6.7,134-22.4	c21.2-8.1,52.2-18.2,79.7-24.2C399.3,7.9,411.6,7.5,421.9,6.5z"/></svg>',
    'zigzag'                         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1800 5.8" preserveAspectRatio="none">  <path class="svg-white-bg" d="M5.4.4l5.4 5.3L16.5.4l5.4 5.3L27.5.4 33 5.7 38.6.4l5.5 5.4h.1L49.9.4l5.4 5.3L60.9.4l5.5 5.3L72 .4l5.5 5.3L83.1.4l5.4 5.3L94.1.4l5.5 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.4 5.3L161 .4l5.4 5.3L172 .4l5.5 5.3 5.6-5.3 5.4 5.3 5.7-5.3 5.4 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.5 5.3L261 .4l5.4 5.3L272 .4l5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1l5.7-5.4 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.7-5.3 5.4 5.4h.2l5.6-5.4 5.5 5.3L361 .4l5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1l5.7-5.4 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1l5.6-5.4 5.5 5.3L461 .4l5.5 5.3 5.6-5.3 5.4 5.3 5.7-5.3 5.4 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1L550 .4l5.4 5.3L561 .4l5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.4 5.3 5.7-5.3 5.4 5.3 5.6-5.3 5.5 5.4h.2L650 .4l5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.4h.2L750 .4l5.5 5.3 5.6-5.3 5.4 5.3 5.7-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1l5.7-5.4 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.4h.2L850 .4l5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.4 5.3 5.7-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1l5.7-5.4 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.4 5.3 5.7-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1l5.7-5.4 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1l5.7-5.4 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.7-5.3 5.4 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1l5.6-5.4 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.7-5.3 5.4 5.4h.2l5.6-5.4 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1l5.7-5.4 5.4 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.5 5.4h.1l5.6-5.4 5.5 5.3 5.6-5.3 5.5 5.3 5.6-5.3 5.4 5.3 5.7-5.3 5.4 5.3 5.6-5.3 5.5 5.4V0H-.2v5.8z"/></svg>',
);

$colibriwp_theme_click_pen_to_edit_title = __( 'Click the pencil icon to edit the text', 'colibri-wp' );

if ( apply_filters( 'colibri_page_builder/installed', false ) ) {
    $colibriwp_theme_click_pen_to_edit_title = __( 'Just click and start typing to change the site headline.',
        'colibri-wp' );
}

$colibriwp_theme_action_button = __( 'Action Button %d', 'colibri-wp' );

$colibriwp_lorem_ipsum = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enimnad minim veniam, quis nostrud exercitation ullamco laboris nisi.";

return array(
    'mobile_media'                      => '@media (max-width:767px)',
    'table_media'                       => '@media (min-width:768px) and (max-width:1023px)',
    'desktop_media'                     => '@media (min-width: 1024px)',
    'lorem_ipsum'                       => $colibriwp_lorem_ipsum,
    'blog_sidebar_enabled'              => 1,
    'blog_post_meta_enabled'            => 1,
    'blog_enable_masonry'               => 1,
    'blog_show_post_thumb_placeholder'  => false,
    'blog_show_post_featured_image'     => false,
    'show_single_item_title'            => 1,
    'blog_posts_per_row'                => 2,
    'blog_post_highlight_enabled'       => false,
    'blog_post_thumb_placeholder_color' => '#F79007',
    'assets_js_key'                     => "colibriFrontendData",
    'edit_this_text_in_customizer'      => $colibriwp_theme_click_pen_to_edit_title,
    'default_icon'                      => $colibriwp_theme_svg_icons['fort-awesome'],
    'icons'                             => $colibriwp_theme_svg_icons,
    'divider_style'                     => $colibriwp_theme_divider_style,
    "gradients"                         => array(
        'night_fade'  =>
            array(
                'name'  => 'night_fade',
                'angle' => '0',
                'steps' =>
                    array(
                        0 =>
                            array(
                                'color'    => '#a18cd1',
                                'position' => '0',
                            ),
                        1 =>
                            array(
                                'color'    => '#fbc2eb',
                                'position' => '100',
                            ),
                    ),
            ),
        'juicy_peach' =>
            array(
                'name'  => 'juicy_peach',
                'angle' => '90',
                'steps' =>
                    array(
                        0 =>
                            array(
                                'color'    => '#ffecd2',
                                'position' => '0',
                            ),
                        1 =>
                            array(
                                'color'    => '#fcb69f',
                                'position' => '100',
                            ),
                    ),
            ),
        'mean_fruit'  =>
            array(
                'name'  => 'mean_fruit',
                'angle' => '120',
                'steps' =>
                    array(
                        0 =>
                            array(
                                'color'    => '#fccb90',
                                'position' => '0',
                            ),
                        1 =>
                            array(
                                'color'    => '#d57eeb',
                                'position' => '100',
                            ),
                    ),
            ),

    ),

    // template-default override
    'header_front_page'                 => array(

        'navigation' => array(
            'props' => array(
                'showTopBar' => false,
            )
        ),

        'logo' => array(
            'props' => array(
                'layoutType' => 'text',
            ),
        ),

        "hero"         => array(
            "hero_column_width" => '80',
            "props"             => array(
                "heroSection" => array(
                    "layout" => "textOnly"
                )
            ),
            "style"             => array(
                'padding'         =>
                    array(
                        'top'    =>
                            array(
                                'value' => '200',
                                'unit'  => 'px',
                            ),
                        'bottom' =>
                            array(
                                'value' => '200',
                                'unit'  => 'px',
                            ),
                    ),
                'separatorBottom' => array(
                    'type'     => 'mountains',
                    'color'    => '#FFF',
                    'height'   => array( 'value' => 100 ),
                    'enabled'  => false,
                    'negative' => false
                ),
                "background"      => array(
                    'image'     =>
                        array(
                            0 =>
                                array(
                                    'source' =>
                                        array(
                                            'url' => get_template_directory_uri() . '/resources/images/aerial-background.jpg',
                                        )
                                )
                        ),
                    "slideshow" => array(
                        "duration" => array( "value" => 1500 ),
                        "speed"    => array( "value" => 500 ),
                        "slides"   => array(
                            array(
                                'url' => get_template_directory_uri() . "/resources/images/beach-landscape-sea-water-nature-sand-1061655-pxhere.com.jpg",
                            ),
                            array(
                                'url' => get_template_directory_uri() . "/resources/images/landscape-tree-water-nature-grass-outdoor-1327743-pxhere.com.jpg",
                            ),
                            array(
                                'url' => get_template_directory_uri() . "/resources/images/leaf-nature-water-green-freshness-dew-1440543-pxhere.com.jpg",
                            ),
                        )
                    ),

                    'overlay' => array(
                        'type'  => 'color',
                        'color' => array(
                            'opacity' => 40
                        ),
                        'shape' =>
                            array(
                                'value'  => 'none',
                                'isTile' => false,
                            ),
                    )

                )
            )
        ),
        "title"        => array(
            "show"  => true,
            "value" => $colibriwp_theme_click_pen_to_edit_title,
        ),
        "subtitle"     => array(
            "show"  => true,
            "value" => $colibriwp_lorem_ipsum,
        ),
        "social_icons" => array(
            "show"       => true,
            "localProps" => array(
                "icons" => json_encode( array(
                    array(
                        'icon'       => $colibriwp_theme_svg_icons['facebook'],
                        'link_value' => 'http://www.facebook.com/',
                        'index'      => 0,
                    ),
                    array(
                        'icon'       => $colibriwp_theme_svg_icons['twitter'],
                        'link_value' => 'http://www.facebook.com/',
                        'index'      => 1,
                    ),
                    array(
                        'icon'       => $colibriwp_theme_svg_icons['youtube'],
                        'link_value' => 'http://www.youtube.com/',
                        'index'      => 2,
                    ),
                    array(
                        'icon'       => $colibriwp_theme_svg_icons['vimeo'],
                        'link_value' => 'http://www.vimeo.com/',
                        'index'      => 3,
                    ),
                ) ),
            ),
        ),
        "icon_list"    => array(
            "show"       => true,
            "localProps" => array(
                "iconList" => json_encode( array(
                    array(
                        'icon'       => $colibriwp_theme_svg_icons['map-marker'],
                        'text'       => 'Location, State, Country',
                        'link_value' => 'https://maps.google.com/',
                        'index'      => 0,
                    ),
                    array(
                        'icon'       => $colibriwp_theme_svg_icons['phone-square'],
                        'text'       => '(000) 123 12345',
                        'link_value' => 'https://www.twitter.com/',
                        'index'      => 1,
                    ),
                    array(
                        'icon'       => $colibriwp_theme_svg_icons['envelope'],
                        'text'       => 'email@yoursite.com',
                        'link_value' => 'mailto:email@yoursite.com',
                        'index'      => 2,
                    ),
                ) ),
            ),
        ),
        "button_group" => array(
            "show"  => true,
            "value" => json_encode( array(
                array(
                    'label'       => sprintf( $colibriwp_theme_action_button, 1 ),
                    'url'         => '#',
                    'button_type' => '0',
                    'index'       => 0,
                ),
                array(
                    'label'       => sprintf( $colibriwp_theme_action_button, 2 ),
                    'url'         => '#',
                    'button_type' => '1',
                    'index'       => 1,
                ),
            ) ),
        ),

    ),
    'header_post'                       => array(

        'logo' => array(
            'props' => array(
                'layoutType' => 'text',
            ),
        ),

        "hero"  => array(
            "style" => array(
                "background" => array(
                    "slideshow" => array(
                        "duration" => array( "value" => 1500 ),
                        "speed"    => array( "value" => 500 ),
                        "slides"   => array(
                            array(
                                'url' => get_template_directory_uri() . "/resources/images/beach-landscape-sea-water-nature-sand-1061655-pxhere.com.jpg",
                            ),
                            array(
                                'url' => get_template_directory_uri() . "/resources/images/landscape-tree-water-nature-grass-outdoor-1327743-pxhere.com.jpg",
                            ),
                            array(
                                'url' => get_template_directory_uri() . "/resources/images/leaf-nature-water-green-freshness-dew-1440543-pxhere.com.jpg",
                            ),
                        )
                    ),

                    'overlay' => array(
                        'type'  => 'color',
                        'color' => array(
                            'opacity' => 0
                        ),
                        'shape' =>
                            array(
                                'value'  => 'none',
                                'isTile' => false,
                            ),
                    )

                ),


                'separatorBottom' => array(
                    'type'     => 'mountains',
                    'color'    => '#FFF',
                    'height'   => array( 'value' => 100 ),
                    'enabled'  => false,
                    'negative' => false
                ),
            )
        ),
        "title" => array(
            "show" => true,
        ),

        'navigation' => array(
            'props' => array(
                'showTopBar' => false,
            )
        )
    ),

    'front_page_designs' => array(

        array(
            'name'  => __( "Modern", 'colibri-wp' ),
            "index" => 3,
            "meta"  => array(
                "slug"    => "modern",
                "version" => "v2"
            )
        ),

        array(
            'name'    => __( "Modern", 'colibri-wp' ),
            "index"   => 3,
            "display" => false,
            "meta"    => array(
                "slug"    => "modern",
                "version" => "v1"
            )
        ),

        array(
            'name'  => __( "Classic", 'colibri-wp' ),
            "index" => 2,
            "meta"  => array(
                "slug"    => "classic",
                "version" => "v1"
            )
        ),

        array(
            'name'  => __( "Fullscreen", 'colibri-wp' ),
            "index" => 1,
            "meta"  => array(
                "slug"    => "fullscreen",
                "version" => "v1"
            )
        ),
    )
);
