<?php
/*-----------------------------------------------------------------------------------

	All custom functions for the theme.
	Please do not edit this file. Rather than modifying Swedish Greys theme files, 
	you should create a child theme. You have been warned! :)

-----------------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------
	We can remove the parent theme's hook only after it is attached, 
	which means we need to wait until setting up the child theme:

	<code>
	add_action( 'after_setup_theme', 'my_child_theme_setup' );
		function my_child_theme_setup() {
			// We are providing our own filter for excerpt_length (or using the unfiltered value)
			remove_filter( 'excerpt_length', 'ntp_framework_excerpt_length' );
			...
		}
	</code>

	For more information on hooks, actions, and filters, see http://codex.wordpress.org/Plugin_API.
-----------------------------------------------------------------------------------*/


/** --------------------------------------------------------------------------------
 * Set the $content_width for things such as video embeds.
 * ---------------------------------------------------------------------------------
 **/

if ( !isset( $content_width ) ) $content_width = 560;


/** ---------------------------------------------------------------------------------
 * Tell WordPress to run ntp_framework_setup() when the 'after_setup_theme' hook is run.
 * ---------------------------------------------------------------------------------
 **/

add_action( 'after_setup_theme', 'ntp_framework_setup' );
// To override ntp_framework_setup() in a child theme, add your own 
// ntp_framework_setup to your child theme's functions.php file.

function ntp_framework_setup() {

	// This theme styles the visual editor with editor-style.css to match the theme style.
	add_editor_style();
	
	// Add theme support for automatic feed links.
	add_theme_support( 'automatic-feed-links' );

	// Add theme support for post thumbnails (featured images).
	add_theme_support( 'post-thumbnails' );
	
	// Add theme support for Theme Layouts - script for creating dynamic layouts
	add_theme_support( 'theme-layouts', array( '1col-fixed', '2c-r-fixed', '2c-l-fixed', '3c-m-fixed' ) );
	require_once( get_template_directory() . '/includes/functions/layouts.php' );
	
	
	// Add theme support for custom backgrounds
	$defaults = array(
				'default-color'          => '',
				'default-image'          => '',
				'wp-head-callback'       => 'ntp_framework_custom_background_callback',
				'admin-head-callback'    => '',
				'admin-preview-callback' => ''
		);
	// We're making this backwards compatible (add_theme_support for custom background introduced in version 3.4).
	if ( function_exists( 'get_custom_header' ) ) {
		add_theme_support( 'custom-background', $defaults ); 
	} else {
		add_custom_background( 'ntp_framework_custom_background_callback' );
	}
	
	
	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'ntp_framework' ),
		'secondary' => __( 'Secondary Navigation', 'ntp_framework' )
	) );

	// ---------------------------------------------------------
	// Make theme available for translation
	// Translations can be filed in the /languages/ directory
	load_theme_textdomain( 'ntp_framework', get_template_directory() . '/languages' );
 
	$locale = get_locale();
	$locale_file = get_template_directory() . "/languages/$locale.php";
	if ( is_readable($locale_file) )
		require_once($locale_file);

	// --------------------------------------------------------- 
	// Get the page number
	function ntp_framework_get_page_number() {
	    if ( get_query_var('paged') ) {
	        print ' | ' . __( 'Page ' , 'ntp_framework') . get_query_var('paged');
	    }
	} // end ntp_framework_get_page_number
	
	// Add ntp_framework widgets to the 'widgets_init' action hook.
	add_action( 'widgets_init', 'ntp_framework_register_widgets' );
		
	
	// Widgets
	require_once( get_template_directory() . '/includes/widgets/social.php' );
	
	// Add shortcodes
	require_once( get_template_directory() . '/includes/functions/shortcodes.php' );
	
		
} // end ntp_framework_theme_setup


// ---------------------------------------------------------------------------------
// Custom Background Callback
// ---------------------------------------------------------------------------------
function ntp_framework_custom_background_callback() {

	/* Get the background image. */
	$image = get_background_image();

	/* If there's an image, just call the normal WordPress callback. We won't do anything here. */
	if ( !empty( $image ) ) {
		_custom_background_cb();
		return;
	}

	/* Get the background color. */
	$color = get_background_color();

	/* If no background color, return. */
	if ( empty( $color ) )
		return;

	/* Use 'background' instead of 'background-color'. */
	$style = "background: #{$color};";

?>
<style type="text/css">body { <?php echo trim( $style ); ?> }</style>
<?php

}


// ---------------------------------------------------------------------------------
// Add custom css-classes-dropdown in WordPress Editor
// ---------------------------------------------------------------------------------
add_filter( 'mce_buttons_2', 'ntp_framework_mce_buttons_2' );

function ntp_framework_mce_buttons_2( $buttons ) {
    array_unshift( $buttons, 'styleselect' );
    return $buttons;
}


add_filter( 'tiny_mce_before_init', 'ntp_framework_mce_before_init' );

function ntp_framework_mce_before_init( $settings ) {

    $style_formats = array(
    	array(
    		'title' => 'Gray Button',
    		'selector' => 'a',
    		'classes' => 'gray-button'
    	),
    	array(
    		'title' => 'Pink Button',
    		'selector' => 'a',
    		'classes' => 'pink-button'
    	),
		array(
    		'title' => 'Green Button',
    		'selector' => 'a',
    		'classes' => 'green-button'
    	),
    	array(
    		'title' => 'Blue Button',
    		'selector' => 'a',
    		'classes' => 'blue-button'
    	),
    	array(
    		'title' => 'Aqua Button',
    		'selector' => 'a',
    		'classes' => 'aqua-button'
    	),
        array(
        	'title' => 'Callout Box',
        	'block' => 'div',
        	'classes' => 'callout',
        	'wrapper' => true
        ),
        array(
        	'title' => 'Alert white',
        	'block' => 'div',
        	'classes' => 'alert white',
        	'wrapper' => true
        ),
        array(
        	'title' => 'Alert red',
        	'block' => 'div',
        	'classes' => 'alert red',
        	'wrapper' => true
        )

    );

    $settings['style_formats'] = json_encode( $style_formats );

    return $settings;

}


// ---------------------------------------------------------------------------------
// Register widgetized areas
// ---------------------------------------------------------------------------------

function ntp_framework_register_widgets() {
 	// Header widget
	register_sidebar( array (
	'name' => 'Header Widget Area',
	'id' => 'header_widget_area',
	'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
	'after_widget' => "</div>",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => '</h3>',
	) );

	// Area 1
	register_sidebar( array (
	'name' => 'Primary Widget Area',
	'id' => 'primary_widget_area',
	'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
	'after_widget' => "</li>",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => '</h3>',
	) );

	// Area 2
	register_sidebar( array (
	'name' => 'Secondary Widget Area',
	'id' => 'secondary_widget_area',
	'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
	'after_widget' => "</li>",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => '</h3>',
 	) );
 	 	
 	// Footer 1
	register_sidebar( array (
	'name' => 'Footer 1',
	'id' => 'footer1',
	'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
	'after_widget' => "</div>",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => '</h3>',
 	) );
 	
 	// Footer 2
	register_sidebar( array (
	'name' => 'Footer 2',
	'id' => 'footer2',
	'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
	'after_widget' => "</div>",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => '</h3>',
 	) );
 	
 	// Footer 3
	register_sidebar( array (
	'name' => 'Footer 3',
	'id' => 'footer3',
	'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
	'after_widget' => "</div>",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => '</h3>',
 	) );
 	
 	// Widgets Template
	register_sidebar( array (
	'name' => 'Widgets Template',
	'id' => 'widgets_template',
	'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
	'after_widget' => "</div>",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => '</h3>',
 	) );
  
} // end ntp_framework_register_widgets



// ---------------------------------------------------------------------------------
// Template for comments and pingbacks.
// To override this walker in a child theme without modifying the comments template
// simply create your own ntp_framework_comment(), and that function will be used instead.
// Used as a callback by wp_list_comments() for displaying the comments.
// ---------------------------------------------------------------------------------

if ( ! function_exists( 'ntp_framework_comment' ) ) :

function ntp_framework_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>">
		<div class="comment-author vcard">
			<?php echo get_avatar( $comment, 40 ); ?>
			<?php printf( __( '%s <span class="says">says:</span>', 'ntp_framework' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
		</div><!-- .comment-author .vcard -->
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em><?php _e( 'Your comment is awaiting moderation.', 'ntp_framework' ); ?></em>
			<br />
		<?php endif; ?>

		<div class="comment-meta commentmetadata"><a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
			<?php
				/* translators: 1: date, 2: time */
				printf( __( '%1$s at %2$s', 'ntp_framework' ), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( '(Edit)', 'ntp_framework' ), ' ' );
			?>
		</div><!-- .comment-meta .commentmetadata -->

		<div class="comment-body"><?php comment_text(); ?></div>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
		</div><!-- .reply -->
	</div><!-- #comment-##  -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'ntp_framework' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __('(Edit)', 'ntp_framework'), ' ' ); ?></p>
	<?php
			break;
	endswitch;
}
endif;


// ---------------------------------------------------------------------------------
//	Configure Excerpt String
// ---------------------------------------------------------------------------------

function ntp_framework_excerpt_more($output) {
	return '...';; 
}
add_filter('excerpt_more', 'ntp_framework_excerpt_more');


/*-----------------------------------------------------------------------------------*/
/*	Configure Excerpt Length
/*-----------------------------------------------------------------------------------*/
function ntp_framework_excerpt_length( $length ) {
	return 40;
}
add_filter( 'excerpt_length', 'ntp_framework_excerpt_length' );



/*-----------------------------------------------------------------------------------*/
/* Remove inline styles printed when the gallery shortcode is used.
 *
 * Galleries are styled by the theme in Swedish Greys style.css. This is just
 * a simple filter call that tells WordPress to not use the default styles.
 *
 * @since Swedish Greys 0.9.5
/*-----------------------------------------------------------------------------------*/
add_filter( 'use_default_gallery_style', '__return_false' );


/*-----------------------------------------------------------------------------------*/
/* Add Google fonts.
 *
 * @since Swedish Greys 0.9.6
/*-----------------------------------------------------------------------------------*/
function ntp_load_fonts() {
	wp_register_style('googleFonts', 'http://fonts.googleapis.com/css?family=Kreon');
	wp_enqueue_style( 'googleFonts');
}
 
add_action('wp_print_styles', 'ntp_load_fonts');



/*-----------------------------------------------------------------------------------*/
/*	Swedish Greys Custom Hooks
/*-----------------------------------------------------------------------------------*/

// Located in header.php
function ntp_framework_head() { do_action('ntp_framework_head'); } 						// in <head>, before wp_head
function ntp_framework_after_header() { do_action('ntp_framework_after_header'); } 		// between #header and #secondary-nav (if #secondary-nav is used)
function ntp_framework_before_main() { do_action('ntp_framework_before_main'); } 		// between #secondary-nav and #main

// Located in footer.php
function ntp_framework_before_footer() { do_action('ntp_framework_before_footer'); } 	// between #main and #footer
function ntp_framework_after_footer() { do_action('ntp_framework_after_footer'); } 		// #footer and #wrapper
function ntp_framework_after() { do_action('ntp_framework_after'); } 					// the very last thing before </body>


// Add author credits
add_action('ntp_framework_after','ntp_framework_about_text');
function ntp_framework_about_text() {
	?>
	 <div id="site-info">
	    <p><?php printf(__( 'Swedish Greys - a <a href="http://wordpress.org">WordPress</a> theme from <a href="http://nordicthemepark.com">Nordic Themepark</a>.', 'ntp_framework' )); ?></p>
	</div><!-- #site-info -->
	<?php
}



// ---------------------------------------------------------------------------------
//	Custom Body Classes for layout
// ---------------------------------------------------------------------------------
// add_filter('body_class','ntp_framework_body_class');
function ntp_framework_body_class($classes) {
	global $is_lynx, $is_gecko, $is_IE, $is_opera, $is_NS4, $is_safari, $is_chrome, $is_iphone;

	/* if($is_lynx) $classes[] = 'lynx';
	elseif($is_gecko) $classes[] = 'gecko';
	elseif($is_opera) $classes[] = 'opera';
	elseif($is_NS4) $classes[] = 'ns4';
	elseif($is_safari) $classes[] = 'safari';
	elseif($is_chrome) $classes[] = 'chrome';
	elseif($is_IE) $classes[] = 'ie';
	else $classes[] = 'unknown';

	if($is_iphone) $classes[] = 'iphone'; */
	$classes[] = of_get_option('themelayout', 'layout-2c-r-fixed');
	return $classes;
}




// ---------------------------------------------------------------------------------
// Load Theme Options
// ---------------------------------------------------------------------------------

if ( !function_exists( 'optionsframework_init' ) ) {

	/* Set the file path based on whether the Options Framework Theme is a parent theme or child theme */
	define('OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/includes/admin/');
	require_once dirname( __FILE__ ) . '/includes/admin/options-framework.php';

}
?>