<?php
/**
 * Header Template
 *
 * The header template is generally used on every page of your site. Nearly all other
 * templates call it somewhere near the top of the file. It is used mostly as an opening
 * wrapper, which is closed with the footer.php file. 
 *
 * @package Swedish Greys
 * @subpackage Template
 */
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php language_attributes(); ?>>
<?php
// Get theme options. 
$logo = of_get_option('logo', '');
$show_tagline = of_get_option('show_tagline', '');
$show_primarynav = of_get_option('show_primarynav', '');
$show_secondarynav = of_get_option('show_secondarynav', '1');
$favicon = of_get_option('favicon', get_template_directory_uri() . '/images/favicon.ico' );
?>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'ntp_framework' ), max( $paged, $page ) );

	?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />

<?php
// Favicon
if(isset($favicon) && $favicon != '') {
	?>
	<link rel="shortcut icon" href="<?php echo $favicon; ?>" />
<?php } else { ?>
	<link rel="shortcut icon" href="<?php echo get_template_directory_uri() . '/images/favicon.ico'; ?>" />
<?php } ?>
	
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<!--[if IE]>
        <link rel="stylesheet" id='ie-style-css' type="text/css" media='all' href="<?php get_template_directory_uri(); ?>/ie.css" />
<![endif]-->
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

<?php ntp_framework_head(); ?>

<?php
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();
?>
</head>

<body <?php body_class(); ?>>
<div id="wrapper" class="hfeed">
	<div id="header">
		<div class="wrapper">
 
			<div id="branding">
			
			<?php
    		// Show Primary Menu
    		// If one isn't filled out, no menu will show.  
			// The menu assiged to the secondary position is the one used.
			if(isset($show_primarynav) && $show_primarynav == '1') { ?>
				<div id="primary-nav">
					<?php wp_nav_menu( array( 'container_class' => 'menu-header', 'fallback_cb' => false, 'theme_location' => 'primary' ) ); ?>
				</div><!-- #primary-nav -->
			<?php } 
			
			
				// Show logo
				if(isset($logo) && $logo != '') { 
					?>
					<div id="site-title"><a href="<?php echo home_url() ?>/" title="<?php bloginfo( 'name' ) ?>" rel="home"><img src="<?php echo $logo;?>"/></a></div>
					<?php if ( is_home() || is_front_page() ) { ?>
        				<h1 id="blog-title"><a href="<?php echo home_url() ?>/" title="<?php bloginfo( 'name' ) ?>" rel="home"><?php bloginfo( 'name' ) ?></a></h1>
					<?php } else { ?>
        				<div id="blog-title"><a href="<?php echo home_url() ?>/" title="<?php bloginfo( 'name' ) ?>" rel="home"><?php bloginfo( 'name' ) ?></a></div>
					<?php } 
				
				} else {
					// Show text title
					?>
					
					<?php if ( is_home() || is_front_page() ) { ?>
        				<h1 id="site-title"><a href="<?php echo home_url() ?>/" title="<?php bloginfo( 'name' ) ?>" rel="home"><?php bloginfo( 'name' ) ?></a></h1>
					<?php } else { ?>
        				<div id="site-title"><a href="<?php echo home_url() ?>/" title="<?php bloginfo( 'name' ) ?>" rel="home"><?php bloginfo( 'name' ) ?></a></div>
					<?php } 
										
				}
				
				
				// Show header widget
				get_sidebar ('header'); 
				
				
				// Show Tagline
				if(isset($show_tagline) && $show_tagline == '1') { 
				?>
        			<div id="blog-description"><?php bloginfo( 'description' ) ?></div>
        		<?php } ?>
			
        		
        		
   			</div><!-- #branding -->
   			
		</div><!-- .wrapper -->
		
	</div><!-- #header -->
	
	<?php ntp_framework_after_header(); ?>	

	<?php
		// Show Secondary Menu	
		// If one isn't filled out, wp_nav_menu falls back to wp_page_menu.  
    	// The menu assiged to the primary position is the one used.  
    	// If none is assigned, the menu with the lowest ID is used.  
		if(isset($show_secondarynav) && $show_secondarynav == '1') { ?>
			<div id="secondary-nav">
				<?php wp_nav_menu( array( 'container_class' => 'menu-header', 'theme_location' => 'secondary' ) ); ?>
			</div><!-- #secondary-nav -->
	<?php } ?>
	
	<?php ntp_framework_before_main(); ?>
	
	<div id="main">
		<div class="wrapper">