<?php
/**
 * NTP Social Widget
 *
 *
 * @package Swedish Greys
 * @subpackage Functions
 */
 
// ---------------------------------------------------------------------------------
// Register Social Widget
// ---------------------------------------------------------------------------------

/**
 * Add function to widgets_init that'll load our widget.
 */
add_action( 'widgets_init', 'load_ntp_framework_widget_social', 0 );

/**
 * Register our widget.
 */
function load_ntp_framework_widget_social() {
	register_widget('ntp_framework_widget_social');
}

/**
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 */
class ntp_framework_widget_social extends WP_Widget {
	
	/**
	 * Widget setup.
	 */
	function ntp_framework_widget_social() {
		$widget_ops = array(
			'classname'    =>  'social_widget',
			'description'  =>  __( "Provide visitors with links to your social media profiles.", "ntp_framework" )
		);
		$this->WP_Widget('ntp_framework_widget_social', __('NTP Social', 'ntp_framework'), $widget_ops);
	}


// ---------------------------------------------------------------------------------
// Execute Social Widget
// ---------------------------------------------------------------------------------
	function widget($args, $instance) {
	extract($args);
	
	$icon_url = get_template_directory_uri() . '/images/social/';
	$rss = (isset($instance['rss'])) ? get_bloginfo('rss2_url') : '';
	$twitter = (isset($instance['twitter'])) ? 'http://twitter.com/' . $instance['twitter'] : '';
	$skype = (isset($instance['skype'])) ? 'skype:' . $instance['skype'] : '';
	$email = (isset($instance['email'])) ? 'mailto:' . $instance['email'] : '';
	$title = apply_filters('widget_title', $instance['title'] );
	
	$services = array(
		'rss'			=> $rss,
		'twitter'		=> $twitter,
		'facebook'		=> $instance['facebook'],
		'youtube'		=> $instance['youtube'],
		'vimeo'			=> $instance['vimeo'],
		'flickr'		=> $instance['flickr'],
		'delicious'		=> $instance['delicious'],
		'linkedin'		=> $instance['linkedin'],
		'digg'			=> $instance['digg'],
		'lastfm'		=> $instance['lastfm'],
		'soundcloud'	=> $instance['soundcloud'],
		'google_plus'	=> $instance['google_plus'],
		'pinterest'		=> $instance['pinterest'],
		'tumblr'		=> $instance['tumblr'],
		'skype'			=> $skype,
		'email'			=> $email
	);
	
	echo $before_widget;
	if ($title) { echo $before_title . $title . $after_title; }

	foreach ($services as $service => $url) {
		if ( isset($url) && $url != '' && $url != 'http://twitter.com/' && $url != 'skype:' && $url != 'mailto:' ) {
			if ( $service == 'rss' ) $text = apply_filters( 'ntp_framework_social_rss', __( 'Subscribe via RSS', 'ntp_framework') );
			
			elseif ( $service == 'comment_rss' ) $text = apply_filters( 'ntp_framework_social_comment_rss', __( 'Subscribe to Comments RSS', 'ntp_framework') );
			
			elseif ( $service == 'skype' ) $text = apply_filters( 'ntp_framework_social_skype', __( 'Contact via Skype', 'ntp_framework') );
			
			elseif ( $service == 'email' ) $text = apply_filters( 'ntp_framework_social_email', __( 'Contact via Email', 'ntp_framework') );
			
			else $text = apply_filters( "ntp_framework_social_{$service}", sprintf( __( 'Connect on %s', 'ntp_framework'), ucfirst($service) ), $instance );

			echo '<span class="listing listing-' . $service . '">';
			echo '<a href="' . $url . '" target="_blank" title="' . $text . '">';
			echo '<img src="' . $icon_url . $service . '.png" alt="' . $text . '" />';
			echo '</a></span>';
		}
	}

	echo $after_widget;
}


// ---------------------------------------------------------------------------------
// Update Social Widget Settings
// ---------------------------------------------------------------------------------
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['rss'] = $new_instance['rss'];
			$instance['comment_rss'] = $new_instance['comment_rss'];
			$instance['twitter'] = strip_tags( $new_instance['twitter'] );
			$instance['facebook'] = strip_tags( $new_instance['facebook'] );
			$instance['delicious'] = strip_tags( $new_instance['delicious'] );
			$instance['flickr'] = strip_tags( $new_instance['flickr'] );
			$instance['youtube'] = strip_tags( $new_instance['youtube'] );
			$instance['vimeo'] = strip_tags( $new_instance['vimeo'] );
			$instance['digg'] = strip_tags( $new_instance['digg'] );
			$instance['linkedin'] = strip_tags( $new_instance['linkedin'] );
			$instance['lastfm'] = strip_tags( $new_instance['lastfm'] );
			$instance['soundcloud'] = strip_tags( $new_instance['soundcloud'] );
			$instance['google_plus'] = strip_tags( $new_instance['google_plus'] );
			$instance['pinterest'] = strip_tags( $new_instance['pinterest'] );
			$instance['tumblr'] = strip_tags( $new_instance['tumblr'] );
			$instance['skype'] = strip_tags( $new_instance['skype'] );
			$instance['email'] = strip_tags( $new_instance['email'] );
		
		return $instance;
	}


// ---------------------------------------------------------------------------------
// Display Social Widget Settings
// ---------------------------------------------------------------------------------
	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	function form($instance) {
	/* Set up some default widget settings. */
		$defaults = array( 'title' => '', 'rss' => '', 'twitter' => '', 'facebook' => '', 'delicious' => '', 'flickr' => '', 'youtube' => '', 'vimeo' => '', 'digg' => '', 'linkedin' => '', 'lastfm' => '', 'soundcloud' => '', 'google_plus' => '', 'pinterest' => '', 'tumblr' => '', 'skype' => '', 'email' => '' );
		$instance = wp_parse_args( (array) $instance, $defaults );
	?>
	<p>
		<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="textarea" value="<?php echo $instance['title']; ?>" />
	</p>
				
	<p><?php _e( 'Fill in the links for the Social Media tabs you wish to activate, please include http:// on all links except Twitter, Skype and Email.', 'ntp_framework' ); ?></p>				
	<p>
		<input class="checkbox" type="checkbox" <?php checked( $instance['rss'], 'on' ); ?> id="<?php echo $this->get_field_id('rss'); ?>" name="<?php echo $this->get_field_name('rss'); ?>" />
		<label for="<?php echo $this->get_field_id('rss'); ?>"><?php _e( 'Display RSS Feed', 'ntp_framework' ) ?></label>
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id('twitter'); ?>"><?php _e( 'Twitter Username: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('twitter'); ?>" name="<?php echo $this->get_field_name('twitter'); ?>" type="text" value="<?php echo $instance['twitter']; ?>" />
		<span style="font-size:smaller"><?php _e( 'Username only, no web address.', 'ntp_framework' ) ?></span>
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id('facebook'); ?>"><?php _e( 'Facebook: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('facebook'); ?>" name="<?php echo $this->get_field_name('facebook'); ?>" type="text" value="<?php echo $instance['facebook']; ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id('delicious'); ?>"><?php _e( 'Delicious: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('delicious'); ?>" name="<?php echo $this->get_field_name('delicious'); ?>" type="text" value="<?php echo $instance['delicious']; ?>" />
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id('flickr'); ?>"><?php _e( 'Flickr: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('flickr'); ?>" name="<?php echo $this->get_field_name('flickr'); ?>" type="text" value="<?php echo $instance['flickr']; ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id('youtube'); ?>"><?php _e( 'YouTube: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('youtube'); ?>" name="<?php echo $this->get_field_name('youtube'); ?>" type="text" value="<?php echo $instance['youtube']; ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id('vimeo'); ?>"><?php _e( 'Vimeo: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('vimeo'); ?>" name="<?php echo $this->get_field_name('vimeo'); ?>" type="text" value="<?php echo $instance['vimeo']; ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id('digg'); ?>"><?php _e( 'Digg: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('digg'); ?>" name="<?php echo $this->get_field_name('digg'); ?>" type="text" value="<?php echo $instance['digg']; ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id('linkedin'); ?>"><?php _e( 'LinkedIn: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('linkedin'); ?>" name="<?php echo $this->get_field_name('linkedin'); ?>" type="text" value="<?php echo $instance['linkedin']; ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id('lastfm'); ?>"><?php _e( 'last.fm: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('lastfm'); ?>" name="<?php echo $this->get_field_name('lastfm'); ?>" type="text" value="<?php echo $instance['lastfm']; ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id('soundcloud'); ?>"><?php _e( 'SoundCloud: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('soundcloud'); ?>" name="<?php echo $this->get_field_name('soundcloud'); ?>" type="text" value="<?php echo $instance['soundcloud']; ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id('google_plus'); ?>"><?php _e( 'Google+: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('google_plus'); ?>" name="<?php echo $this->get_field_name('google_plus'); ?>" type="text" value="<?php echo $instance['google_plus']; ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id('pinterest'); ?>"><?php _e( 'Pinterest: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('pinterest'); ?>" name="<?php echo $this->get_field_name('pinterest'); ?>" type="text" value="<?php echo $instance['pinterest']; ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id('tumblr'); ?>"><?php _e( 'Tumblr: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('tumblr'); ?>" name="<?php echo $this->get_field_name('tumblr'); ?>" type="text" value="<?php echo $instance['tumblr']; ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id('skype'); ?>"><?php _e( 'Skype: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('skype'); ?>" name="<?php echo $this->get_field_name('skype'); ?>" type="text" value="<?php echo $instance['skype']; ?>" />
		<span style="font-size:smaller"><?php _e( 'Username only, no web address.', 'ntp_framework' ) ?></span>
	</p>
	<p>
		<label for="<?php echo $this->get_field_id('email'); ?>"><?php _e( 'Email: ', 'ntp_framework' ) ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('email'); ?>" name="<?php echo $this->get_field_name('email'); ?>" type="text" value="<?php echo $instance['email']; ?>" />
		<span style="font-size:smaller"><?php _e( 'Email address only, no web address.', 'ntp_framework' ) ?></span>
	</p>

	<?php
	}

} //End class ntp_framework_widget_social
?>