<?php
 namespace MailPoetVendor\Doctrine\DBAL; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\Common\EventManager; use MailPoetVendor\Doctrine\DBAL\Driver\DrizzlePDOMySql\Driver as DrizzlePDOMySQLDriver; use MailPoetVendor\Doctrine\DBAL\Driver\IBMDB2\DB2Driver; use MailPoetVendor\Doctrine\DBAL\Driver\Mysqli\Driver as MySQLiDriver; use MailPoetVendor\Doctrine\DBAL\Driver\OCI8\Driver as OCI8Driver; use MailPoetVendor\Doctrine\DBAL\Driver\PDOMySql\Driver as PDOMySQLDriver; use MailPoetVendor\Doctrine\DBAL\Driver\PDOOracle\Driver as PDOOCIDriver; use MailPoetVendor\Doctrine\DBAL\Driver\PDOPgSql\Driver as PDOPgSQLDriver; use MailPoetVendor\Doctrine\DBAL\Driver\PDOSqlite\Driver as PDOSQLiteDriver; use MailPoetVendor\Doctrine\DBAL\Driver\PDOSqlsrv\Driver as PDOSQLSrvDriver; use MailPoetVendor\Doctrine\DBAL\Driver\SQLAnywhere\Driver as SQLAnywhereDriver; use MailPoetVendor\Doctrine\DBAL\Driver\SQLSrv\Driver as SQLSrvDriver; use PDO; use function array_keys; use function array_map; use function array_merge; use function class_implements; use function in_array; use function is_subclass_of; use function parse_str; use function parse_url; use function preg_replace; use function str_replace; use function strpos; use function substr; final class DriverManager { private static $_driverMap = ['pdo_mysql' => \MailPoetVendor\Doctrine\DBAL\Driver\PDOMySql\Driver::class, 'pdo_sqlite' => \MailPoetVendor\Doctrine\DBAL\Driver\PDOSqlite\Driver::class, 'pdo_pgsql' => \MailPoetVendor\Doctrine\DBAL\Driver\PDOPgSql\Driver::class, 'pdo_oci' => \MailPoetVendor\Doctrine\DBAL\Driver\PDOOracle\Driver::class, 'oci8' => \MailPoetVendor\Doctrine\DBAL\Driver\OCI8\Driver::class, 'ibm_db2' => \MailPoetVendor\Doctrine\DBAL\Driver\IBMDB2\DB2Driver::class, 'pdo_sqlsrv' => \MailPoetVendor\Doctrine\DBAL\Driver\PDOSqlsrv\Driver::class, 'mysqli' => \MailPoetVendor\Doctrine\DBAL\Driver\Mysqli\Driver::class, 'drizzle_pdo_mysql' => \MailPoetVendor\Doctrine\DBAL\Driver\DrizzlePDOMySql\Driver::class, 'sqlanywhere' => \MailPoetVendor\Doctrine\DBAL\Driver\SQLAnywhere\Driver::class, 'sqlsrv' => \MailPoetVendor\Doctrine\DBAL\Driver\SQLSrv\Driver::class]; private static $driverSchemeAliases = [ 'db2' => 'ibm_db2', 'mssql' => 'pdo_sqlsrv', 'mysql' => 'pdo_mysql', 'mysql2' => 'pdo_mysql', 'postgres' => 'pdo_pgsql', 'postgresql' => 'pdo_pgsql', 'pgsql' => 'pdo_pgsql', 'sqlite' => 'pdo_sqlite', 'sqlite3' => 'pdo_sqlite', ]; private function __construct() { } public static function getConnection(array $params, ?\MailPoetVendor\Doctrine\DBAL\Configuration $config = null, ?\MailPoetVendor\Doctrine\Common\EventManager $eventManager = null) : \MailPoetVendor\Doctrine\DBAL\Connection { if (!$config) { $config = new \MailPoetVendor\Doctrine\DBAL\Configuration(); } if (!$eventManager) { $eventManager = new \MailPoetVendor\Doctrine\Common\EventManager(); } $params = self::parseDatabaseUrl($params); if (isset($params['master'])) { $params['master'] = self::parseDatabaseUrl($params['master']); } if (isset($params['slaves'])) { foreach ($params['slaves'] as $key => $slaveParams) { $params['slaves'][$key] = self::parseDatabaseUrl($slaveParams); } } if (isset($params['global'])) { $params['global'] = self::parseDatabaseUrl($params['global']); } if (isset($params['shards'])) { foreach ($params['shards'] as $key => $shardParams) { $params['shards'][$key] = self::parseDatabaseUrl($shardParams); } } if (isset($params['pdo']) && !$params['pdo'] instanceof \PDO) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::invalidPdoInstance(); } elseif (isset($params['pdo'])) { $params['pdo']->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION); $params['driver'] = 'pdo_' . $params['pdo']->getAttribute(\PDO::ATTR_DRIVER_NAME); } else { self::_checkParams($params); } $className = $params['driverClass'] ?? self::$_driverMap[$params['driver']]; $driver = new $className(); $wrapperClass = \MailPoetVendor\Doctrine\DBAL\Connection::class; if (isset($params['wrapperClass'])) { if (!\is_subclass_of($params['wrapperClass'], $wrapperClass)) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::invalidWrapperClass($params['wrapperClass']); } $wrapperClass = $params['wrapperClass']; } return new $wrapperClass($params, $driver, $config, $eventManager); } public static function getAvailableDrivers() : array { return \array_keys(self::$_driverMap); } private static function _checkParams(array $params) : void { if (!isset($params['driver']) && !isset($params['driverClass'])) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverRequired(); } if (isset($params['driver']) && !isset(self::$_driverMap[$params['driver']])) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::unknownDriver($params['driver'], \array_keys(self::$_driverMap)); } if (isset($params['driverClass']) && !\in_array(\MailPoetVendor\Doctrine\DBAL\Driver::class, \class_implements($params['driverClass'], \true))) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::invalidDriverClass($params['driverClass']); } } private static function normalizeDatabaseUrlPath(string $urlPath) : string { return \substr($urlPath, 1); } private static function parseDatabaseUrl(array $params) : array { if (!isset($params['url'])) { return $params; } $url = \preg_replace('#^((?:pdo_)?sqlite3?):///#', '$1://localhost/', $params['url']); $url = \parse_url($url); if ($url === \false) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException('Malformed parameter "url".'); } $url = \array_map('rawurldecode', $url); unset($params['pdo']); $params = self::parseDatabaseUrlScheme($url, $params); if (isset($url['host'])) { $params['host'] = $url['host']; } if (isset($url['port'])) { $params['port'] = $url['port']; } if (isset($url['user'])) { $params['user'] = $url['user']; } if (isset($url['pass'])) { $params['password'] = $url['pass']; } $params = self::parseDatabaseUrlPath($url, $params); $params = self::parseDatabaseUrlQuery($url, $params); return $params; } private static function parseDatabaseUrlPath(array $url, array $params) : array { if (!isset($url['path'])) { return $params; } $url['path'] = self::normalizeDatabaseUrlPath($url['path']); if (!isset($params['driver'])) { return self::parseRegularDatabaseUrlPath($url, $params); } if (\strpos($params['driver'], 'sqlite') !== \false) { return self::parseSqliteDatabaseUrlPath($url, $params); } return self::parseRegularDatabaseUrlPath($url, $params); } private static function parseDatabaseUrlQuery(array $url, array $params) : array { if (!isset($url['query'])) { return $params; } $query = []; \parse_str($url['query'], $query); return \array_merge($params, $query); } private static function parseRegularDatabaseUrlPath(array $url, array $params) : array { $params['dbname'] = $url['path']; return $params; } private static function parseSqliteDatabaseUrlPath(array $url, array $params) : array { if ($url['path'] === ':memory:') { $params['memory'] = \true; return $params; } $params['path'] = $url['path']; return $params; } private static function parseDatabaseUrlScheme(array $url, array $params) : array { if (isset($url['scheme'])) { unset($params['driverClass']); $driver = \str_replace('-', '_', $url['scheme']); $params['driver'] = self::$driverSchemeAliases[$driver] ?? $driver; return $params; } if (!isset($params['driverClass']) && !isset($params['driver'])) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverRequired($params['url']); } return $params; } } 