<?php
 namespace MailPoetVendor\Doctrine\DBAL\Platforms; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\DBALException; use MailPoetVendor\Doctrine\DBAL\Schema\Column; use MailPoetVendor\Doctrine\DBAL\Schema\Constraint; use MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint; use MailPoetVendor\Doctrine\DBAL\Schema\Identifier; use MailPoetVendor\Doctrine\DBAL\Schema\Index; use MailPoetVendor\Doctrine\DBAL\Schema\Table; use MailPoetVendor\Doctrine\DBAL\Schema\TableDiff; use MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel; use MailPoetVendor\Doctrine\DBAL\Types; use function array_merge; use function array_unique; use function array_values; use function implode; use function is_numeric; use function sprintf; use function sqrt; use function str_replace; use function strlen; use function strpos; use function strtolower; class SqlitePlatform extends \MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform { public function getRegexpExpression() { return 'REGEXP'; } public function getGuidExpression() { return "HEX(RANDOMBLOB(4)) || '-' || HEX(RANDOMBLOB(2)) || '-4' || " . "SUBSTR(HEX(RANDOMBLOB(2)), 2) || '-' || " . "SUBSTR('89AB', 1 + (ABS(RANDOM()) % 4), 1) || " . "SUBSTR(HEX(RANDOMBLOB(2)), 2) || '-' || HEX(RANDOMBLOB(6))"; } public function getNowExpression($type = 'timestamp') { switch ($type) { case 'time': return 'time(\'now\')'; case 'date': return 'date(\'now\')'; case 'timestamp': default: return 'datetime(\'now\')'; } } public function getTrimExpression($str, $pos = \MailPoetVendor\Doctrine\DBAL\Platforms\TrimMode::UNSPECIFIED, $char = \false) { $trimChar = $char !== \false ? ', ' . $char : ''; switch ($pos) { case \MailPoetVendor\Doctrine\DBAL\Platforms\TrimMode::LEADING: $trimFn = 'LTRIM'; break; case \MailPoetVendor\Doctrine\DBAL\Platforms\TrimMode::TRAILING: $trimFn = 'RTRIM'; break; default: $trimFn = 'TRIM'; } return $trimFn . '(' . $str . $trimChar . ')'; } public function getSubstringExpression($value, $position, $length = null) { if ($length !== null) { return 'SUBSTR(' . $value . ', ' . $position . ', ' . $length . ')'; } return 'SUBSTR(' . $value . ', ' . $position . ', LENGTH(' . $value . '))'; } public function getLocateExpression($str, $substr, $startPos = \false) { if ($startPos === \false) { return 'LOCATE(' . $str . ', ' . $substr . ')'; } return 'LOCATE(' . $str . ', ' . $substr . ', ' . $startPos . ')'; } protected function getDateArithmeticIntervalExpression($date, $operator, $interval, $unit) { switch ($unit) { case \MailPoetVendor\Doctrine\DBAL\Platforms\DateIntervalUnit::SECOND: case \MailPoetVendor\Doctrine\DBAL\Platforms\DateIntervalUnit::MINUTE: case \MailPoetVendor\Doctrine\DBAL\Platforms\DateIntervalUnit::HOUR: return 'DATETIME(' . $date . ",'" . $operator . $interval . ' ' . $unit . "')"; default: switch ($unit) { case \MailPoetVendor\Doctrine\DBAL\Platforms\DateIntervalUnit::WEEK: $interval *= 7; $unit = \MailPoetVendor\Doctrine\DBAL\Platforms\DateIntervalUnit::DAY; break; case \MailPoetVendor\Doctrine\DBAL\Platforms\DateIntervalUnit::QUARTER: $interval *= 3; $unit = \MailPoetVendor\Doctrine\DBAL\Platforms\DateIntervalUnit::MONTH; break; } if (!\is_numeric($interval)) { $interval = "' || " . $interval . " || '"; } return 'DATE(' . $date . ",'" . $operator . $interval . ' ' . $unit . "')"; } } public function getDateDiffExpression($date1, $date2) { return \sprintf("JULIANDAY(%s, 'start of day') - JULIANDAY(%s, 'start of day')", $date1, $date2); } protected function _getTransactionIsolationLevelSQL($level) { switch ($level) { case \MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel::READ_UNCOMMITTED: return 0; case \MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel::READ_COMMITTED: case \MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel::REPEATABLE_READ: case \MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel::SERIALIZABLE: return 1; default: return parent::_getTransactionIsolationLevelSQL($level); } } public function getSetTransactionIsolationSQL($level) { return 'PRAGMA read_uncommitted = ' . $this->_getTransactionIsolationLevelSQL($level); } public function prefersIdentityColumns() { return \true; } public function getBooleanTypeDeclarationSQL(array $field) { return 'BOOLEAN'; } public function getIntegerTypeDeclarationSQL(array $field) { return 'INTEGER' . $this->_getCommonIntegerTypeDeclarationSQL($field); } public function getBigIntTypeDeclarationSQL(array $field) { if (!empty($field['autoincrement'])) { return $this->getIntegerTypeDeclarationSQL($field); } return 'BIGINT' . $this->_getCommonIntegerTypeDeclarationSQL($field); } public function getTinyIntTypeDeclarationSql(array $field) { if (!empty($field['autoincrement'])) { return $this->getIntegerTypeDeclarationSQL($field); } return 'TINYINT' . $this->_getCommonIntegerTypeDeclarationSQL($field); } public function getSmallIntTypeDeclarationSQL(array $field) { if (!empty($field['autoincrement'])) { return $this->getIntegerTypeDeclarationSQL($field); } return 'SMALLINT' . $this->_getCommonIntegerTypeDeclarationSQL($field); } public function getMediumIntTypeDeclarationSql(array $field) { if (!empty($field['autoincrement'])) { return $this->getIntegerTypeDeclarationSQL($field); } return 'MEDIUMINT' . $this->_getCommonIntegerTypeDeclarationSQL($field); } public function getDateTimeTypeDeclarationSQL(array $fieldDeclaration) { return 'DATETIME'; } public function getDateTypeDeclarationSQL(array $fieldDeclaration) { return 'DATE'; } public function getTimeTypeDeclarationSQL(array $fieldDeclaration) { return 'TIME'; } protected function _getCommonIntegerTypeDeclarationSQL(array $columnDef) { if (!empty($columnDef['autoincrement'])) { return ' PRIMARY KEY AUTOINCREMENT'; } return !empty($columnDef['unsigned']) ? ' UNSIGNED' : ''; } public function getForeignKeyDeclarationSQL(\MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint $foreignKey) { return parent::getForeignKeyDeclarationSQL(new \MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint($foreignKey->getQuotedLocalColumns($this), \str_replace('.', '__', $foreignKey->getQuotedForeignTableName($this)), $foreignKey->getQuotedForeignColumns($this), $foreignKey->getName(), $foreignKey->getOptions())); } protected function _getCreateTableSQL($name, array $columns, array $options = []) { $name = \str_replace('.', '__', $name); $queryFields = $this->getColumnDeclarationListSQL($columns); if (isset($options['uniqueConstraints']) && !empty($options['uniqueConstraints'])) { foreach ($options['uniqueConstraints'] as $name => $definition) { $queryFields .= ', ' . $this->getUniqueConstraintDeclarationSQL($name, $definition); } } $queryFields .= $this->getNonAutoincrementPrimaryKeyDefinition($columns, $options); if (isset($options['foreignKeys'])) { foreach ($options['foreignKeys'] as $foreignKey) { $queryFields .= ', ' . $this->getForeignKeyDeclarationSQL($foreignKey); } } $query = ['CREATE TABLE ' . $name . ' (' . $queryFields . ')']; if (isset($options['alter']) && $options['alter'] === \true) { return $query; } if (isset($options['indexes']) && !empty($options['indexes'])) { foreach ($options['indexes'] as $indexDef) { $query[] = $this->getCreateIndexSQL($indexDef, $name); } } if (isset($options['unique']) && !empty($options['unique'])) { foreach ($options['unique'] as $indexDef) { $query[] = $this->getCreateIndexSQL($indexDef, $name); } } return $query; } private function getNonAutoincrementPrimaryKeyDefinition(array $columns, array $options) : string { if (empty($options['primary'])) { return ''; } $keyColumns = \array_unique(\array_values($options['primary'])); foreach ($keyColumns as $keyColumn) { if (isset($columns[$keyColumn]['autoincrement']) && !empty($columns[$keyColumn]['autoincrement'])) { return ''; } } return ', PRIMARY KEY(' . \implode(', ', $keyColumns) . ')'; } protected function getVarcharTypeDeclarationSQLSnippet($length, $fixed) { return $fixed ? $length ? 'CHAR(' . $length . ')' : 'CHAR(255)' : ($length ? 'VARCHAR(' . $length . ')' : 'TEXT'); } protected function getBinaryTypeDeclarationSQLSnippet($length, $fixed) { return 'BLOB'; } public function getBinaryMaxLength() { return 0; } public function getBinaryDefaultLength() { return 0; } public function getClobTypeDeclarationSQL(array $field) { return 'CLOB'; } public function getListTableConstraintsSQL($table) { $table = \str_replace('.', '__', $table); return \sprintf("SELECT sql FROM sqlite_master WHERE type='index' AND tbl_name = %s AND sql NOT NULL ORDER BY name", $this->quoteStringLiteral($table)); } public function getListTableColumnsSQL($table, $currentDatabase = null) { $table = \str_replace('.', '__', $table); return \sprintf('PRAGMA table_info(%s)', $this->quoteStringLiteral($table)); } public function getListTableIndexesSQL($table, $currentDatabase = null) { $table = \str_replace('.', '__', $table); return \sprintf('PRAGMA index_list(%s)', $this->quoteStringLiteral($table)); } public function getListTablesSQL() { return "SELECT name FROM sqlite_master WHERE type = 'table' AND name != 'sqlite_sequence' AND name != 'geometry_columns' AND name != 'spatial_ref_sys' " . 'UNION ALL SELECT name FROM sqlite_temp_master ' . "WHERE type = 'table' ORDER BY name"; } public function getListViewsSQL($database) { return "SELECT name, sql FROM sqlite_master WHERE type='view' AND sql NOT NULL"; } public function getCreateViewSQL($name, $sql) { return 'CREATE VIEW ' . $name . ' AS ' . $sql; } public function getDropViewSQL($name) { return 'DROP VIEW ' . $name; } public function getAdvancedForeignKeyOptionsSQL(\MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint $foreignKey) { $query = parent::getAdvancedForeignKeyOptionsSQL($foreignKey); $query .= ($foreignKey->hasOption('deferrable') && $foreignKey->getOption('deferrable') !== \false ? ' ' : ' NOT ') . 'DEFERRABLE'; $query .= ' INITIALLY ' . ($foreignKey->hasOption('deferred') && $foreignKey->getOption('deferred') !== \false ? 'DEFERRED' : 'IMMEDIATE'); return $query; } public function supportsIdentityColumns() { return \true; } public function supportsColumnCollation() { return \true; } public function supportsInlineColumnComments() { return \true; } public function getName() { return 'sqlite'; } public function getTruncateTableSQL($tableName, $cascade = \false) { $tableIdentifier = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($tableName); $tableName = \str_replace('.', '__', $tableIdentifier->getQuotedName($this)); return 'DELETE FROM ' . $tableName; } public static function udfSqrt($value) { return \sqrt($value); } public static function udfMod($a, $b) { return $a % $b; } public static function udfLocate($str, $substr, $offset = 0) { if ($offset > 0) { $offset -= 1; } $pos = \strpos($str, $substr, $offset); if ($pos !== \false) { return $pos + 1; } return 0; } public function getForUpdateSql() { return ''; } public function getInlineColumnCommentSQL($comment) { return '--' . \str_replace("\n", "\n--", $comment) . "\n"; } protected function initializeDoctrineTypeMappings() { $this->doctrineTypeMapping = ['boolean' => 'boolean', 'tinyint' => 'boolean', 'smallint' => 'smallint', 'mediumint' => 'integer', 'int' => 'integer', 'integer' => 'integer', 'serial' => 'integer', 'bigint' => 'bigint', 'bigserial' => 'bigint', 'clob' => 'text', 'tinytext' => 'text', 'mediumtext' => 'text', 'longtext' => 'text', 'text' => 'text', 'varchar' => 'string', 'longvarchar' => 'string', 'varchar2' => 'string', 'nvarchar' => 'string', 'image' => 'string', 'ntext' => 'string', 'char' => 'string', 'date' => 'date', 'datetime' => 'datetime', 'timestamp' => 'datetime', 'time' => 'time', 'float' => 'float', 'double' => 'float', 'double precision' => 'float', 'real' => 'float', 'decimal' => 'decimal', 'numeric' => 'decimal', 'blob' => 'blob']; } protected function getReservedKeywordsClass() { return \MailPoetVendor\Doctrine\DBAL\Platforms\Keywords\SQLiteKeywords::class; } protected function getPreAlterTableIndexForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { if (!$diff->fromTable instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException('Sqlite platform requires for alter table the table diff with reference to original table schema'); } $sql = []; foreach ($diff->fromTable->getIndexes() as $index) { if ($index->isPrimary()) { continue; } $sql[] = $this->getDropIndexSQL($index, $diff->name); } return $sql; } protected function getPostAlterTableIndexForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { if (!$diff->fromTable instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException('Sqlite platform requires for alter table the table diff with reference to original table schema'); } $sql = []; $tableName = $diff->newName ? $diff->getNewName() : $diff->getName($this); foreach ($this->getIndexesInAlteredTable($diff) as $index) { if ($index->isPrimary()) { continue; } $sql[] = $this->getCreateIndexSQL($index, $tableName->getQuotedName($this)); } return $sql; } protected function doModifyLimitQuery($query, $limit, $offset) { if ($limit === null && $offset > 0) { return $query . ' LIMIT -1 OFFSET ' . $offset; } return parent::doModifyLimitQuery($query, $limit, $offset); } public function getBlobTypeDeclarationSQL(array $field) { return 'BLOB'; } public function getTemporaryTableName($tableName) { $tableName = \str_replace('.', '__', $tableName); return $tableName; } public function canEmulateSchemas() { return \true; } public function supportsForeignKeyConstraints() { return \false; } public function getCreatePrimaryKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\Index $index, $table) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException('Sqlite platform does not support alter primary key.'); } public function getCreateForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint $foreignKey, $table) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException('Sqlite platform does not support alter foreign key.'); } public function getDropForeignKeySQL($foreignKey, $table) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException('Sqlite platform does not support alter foreign key.'); } public function getCreateConstraintSQL(\MailPoetVendor\Doctrine\DBAL\Schema\Constraint $constraint, $table) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException('Sqlite platform does not support alter constraint.'); } public function getCreateTableSQL(\MailPoetVendor\Doctrine\DBAL\Schema\Table $table, $createFlags = null) { $createFlags = $createFlags ?? self::CREATE_INDEXES | self::CREATE_FOREIGNKEYS; return parent::getCreateTableSQL($table, $createFlags); } public function getListTableForeignKeysSQL($table, $database = null) { $table = \str_replace('.', '__', $table); return \sprintf('PRAGMA foreign_key_list(%s)', $this->quoteStringLiteral($table)); } public function getAlterTableSQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $sql = $this->getSimpleAlterTableSQL($diff); if ($sql !== \false) { return $sql; } $fromTable = $diff->fromTable; if (!$fromTable instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException('Sqlite platform requires for alter table the table diff with reference to original table schema'); } $table = clone $fromTable; $columns = []; $oldColumnNames = []; $newColumnNames = []; $columnSql = []; foreach ($table->getColumns() as $columnName => $column) { $columnName = \strtolower($columnName); $columns[$columnName] = $column; $oldColumnNames[$columnName] = $newColumnNames[$columnName] = $column->getQuotedName($this); } foreach ($diff->removedColumns as $columnName => $column) { if ($this->onSchemaAlterTableRemoveColumn($column, $diff, $columnSql)) { continue; } $columnName = \strtolower($columnName); if (!isset($columns[$columnName])) { continue; } unset($columns[$columnName], $oldColumnNames[$columnName], $newColumnNames[$columnName]); } foreach ($diff->renamedColumns as $oldColumnName => $column) { if ($this->onSchemaAlterTableRenameColumn($oldColumnName, $column, $diff, $columnSql)) { continue; } $oldColumnName = \strtolower($oldColumnName); if (isset($columns[$oldColumnName])) { unset($columns[$oldColumnName]); } $columns[\strtolower($column->getName())] = $column; if (!isset($newColumnNames[$oldColumnName])) { continue; } $newColumnNames[$oldColumnName] = $column->getQuotedName($this); } foreach ($diff->changedColumns as $oldColumnName => $columnDiff) { if ($this->onSchemaAlterTableChangeColumn($columnDiff, $diff, $columnSql)) { continue; } if (isset($columns[$oldColumnName])) { unset($columns[$oldColumnName]); } $columns[\strtolower($columnDiff->column->getName())] = $columnDiff->column; if (!isset($newColumnNames[$oldColumnName])) { continue; } $newColumnNames[$oldColumnName] = $columnDiff->column->getQuotedName($this); } foreach ($diff->addedColumns as $columnName => $column) { if ($this->onSchemaAlterTableAddColumn($column, $diff, $columnSql)) { continue; } $columns[\strtolower($columnName)] = $column; } $sql = []; $tableSql = []; if (!$this->onSchemaAlterTable($diff, $tableSql)) { $dataTable = new \MailPoetVendor\Doctrine\DBAL\Schema\Table('__temp__' . $table->getName()); $newTable = new \MailPoetVendor\Doctrine\DBAL\Schema\Table($table->getQuotedName($this), $columns, $this->getPrimaryIndexInAlteredTable($diff), $this->getForeignKeysInAlteredTable($diff), 0, $table->getOptions()); $newTable->addOption('alter', \true); $sql = $this->getPreAlterTableIndexForeignKeySQL($diff); $sql[] = \sprintf('CREATE TEMPORARY TABLE %s AS SELECT %s FROM %s', $dataTable->getQuotedName($this), \implode(', ', $oldColumnNames), $table->getQuotedName($this)); $sql[] = $this->getDropTableSQL($fromTable); $sql = \array_merge($sql, $this->getCreateTableSQL($newTable)); $sql[] = \sprintf('INSERT INTO %s (%s) SELECT %s FROM %s', $newTable->getQuotedName($this), \implode(', ', $newColumnNames), \implode(', ', $oldColumnNames), $dataTable->getQuotedName($this)); $sql[] = $this->getDropTableSQL($dataTable); if ($diff->newName && $diff->newName !== $diff->name) { $renamedTable = $diff->getNewName(); $sql[] = 'ALTER TABLE ' . $newTable->getQuotedName($this) . ' RENAME TO ' . $renamedTable->getQuotedName($this); } $sql = \array_merge($sql, $this->getPostAlterTableIndexForeignKeySQL($diff)); } return \array_merge($sql, $tableSql, $columnSql); } private function getSimpleAlterTableSQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { foreach ($diff->changedColumns as $oldColumnName => $columnDiff) { if (!$columnDiff->fromColumn instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Column || !$columnDiff->column instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Column || !$columnDiff->column->getAutoincrement() || !$columnDiff->column->getType() instanceof \MailPoetVendor\Doctrine\DBAL\Types\IntegerType) { continue; } if (!$columnDiff->hasChanged('type') && $columnDiff->hasChanged('unsigned')) { unset($diff->changedColumns[$oldColumnName]); continue; } $fromColumnType = $columnDiff->fromColumn->getType(); if (!$fromColumnType instanceof \MailPoetVendor\Doctrine\DBAL\Types\SmallIntType && !$fromColumnType instanceof \MailPoetVendor\Doctrine\DBAL\Types\BigIntType) { continue; } unset($diff->changedColumns[$oldColumnName]); } if (!empty($diff->renamedColumns) || !empty($diff->addedForeignKeys) || !empty($diff->addedIndexes) || !empty($diff->changedColumns) || !empty($diff->changedForeignKeys) || !empty($diff->changedIndexes) || !empty($diff->removedColumns) || !empty($diff->removedForeignKeys) || !empty($diff->removedIndexes) || !empty($diff->renamedIndexes)) { return \false; } $table = new \MailPoetVendor\Doctrine\DBAL\Schema\Table($diff->name); $sql = []; $tableSql = []; $columnSql = []; foreach ($diff->addedColumns as $column) { if ($this->onSchemaAlterTableAddColumn($column, $diff, $columnSql)) { continue; } $field = \array_merge(['unique' => null, 'autoincrement' => null, 'default' => null], $column->toArray()); $type = $field['type']; switch (\true) { case isset($field['columnDefinition']) || $field['autoincrement'] || $field['unique']: case $type instanceof \MailPoetVendor\Doctrine\DBAL\Types\DateTimeType && $field['default'] === $this->getCurrentTimestampSQL(): case $type instanceof \MailPoetVendor\Doctrine\DBAL\Types\DateType && $field['default'] === $this->getCurrentDateSQL(): case $type instanceof \MailPoetVendor\Doctrine\DBAL\Types\TimeType && $field['default'] === $this->getCurrentTimeSQL(): return \false; } $field['name'] = $column->getQuotedName($this); if ($type instanceof \MailPoetVendor\Doctrine\DBAL\Types\StringType && $field['length'] === null) { $field['length'] = 255; } $sql[] = 'ALTER TABLE ' . $table->getQuotedName($this) . ' ADD COLUMN ' . $this->getColumnDeclarationSQL($field['name'], $field); } if (!$this->onSchemaAlterTable($diff, $tableSql)) { if ($diff->newName !== \false) { $newTable = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($diff->newName); $sql[] = 'ALTER TABLE ' . $table->getQuotedName($this) . ' RENAME TO ' . $newTable->getQuotedName($this); } } return \array_merge($sql, $tableSql, $columnSql); } private function getColumnNamesInAlteredTable(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $columns = []; foreach ($diff->fromTable->getColumns() as $columnName => $column) { $columns[\strtolower($columnName)] = $column->getName(); } foreach ($diff->removedColumns as $columnName => $column) { $columnName = \strtolower($columnName); if (!isset($columns[$columnName])) { continue; } unset($columns[$columnName]); } foreach ($diff->renamedColumns as $oldColumnName => $column) { $columnName = $column->getName(); $columns[\strtolower($oldColumnName)] = $columnName; $columns[\strtolower($columnName)] = $columnName; } foreach ($diff->changedColumns as $oldColumnName => $columnDiff) { $columnName = $columnDiff->column->getName(); $columns[\strtolower($oldColumnName)] = $columnName; $columns[\strtolower($columnName)] = $columnName; } foreach ($diff->addedColumns as $columnName => $column) { $columns[\strtolower($columnName)] = $columnName; } return $columns; } private function getIndexesInAlteredTable(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $indexes = $diff->fromTable->getIndexes(); $columnNames = $this->getColumnNamesInAlteredTable($diff); foreach ($indexes as $key => $index) { foreach ($diff->renamedIndexes as $oldIndexName => $renamedIndex) { if (\strtolower($key) !== \strtolower($oldIndexName)) { continue; } unset($indexes[$key]); } $changed = \false; $indexColumns = []; foreach ($index->getColumns() as $columnName) { $normalizedColumnName = \strtolower($columnName); if (!isset($columnNames[$normalizedColumnName])) { unset($indexes[$key]); continue 2; } else { $indexColumns[] = $columnNames[$normalizedColumnName]; if ($columnName !== $columnNames[$normalizedColumnName]) { $changed = \true; } } } if (!$changed) { continue; } $indexes[$key] = new \MailPoetVendor\Doctrine\DBAL\Schema\Index($index->getName(), $indexColumns, $index->isUnique(), $index->isPrimary(), $index->getFlags()); } foreach ($diff->removedIndexes as $index) { $indexName = \strtolower($index->getName()); if (!\strlen($indexName) || !isset($indexes[$indexName])) { continue; } unset($indexes[$indexName]); } foreach (\array_merge($diff->changedIndexes, $diff->addedIndexes, $diff->renamedIndexes) as $index) { $indexName = \strtolower($index->getName()); if (\strlen($indexName)) { $indexes[$indexName] = $index; } else { $indexes[] = $index; } } return $indexes; } private function getForeignKeysInAlteredTable(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $foreignKeys = $diff->fromTable->getForeignKeys(); $columnNames = $this->getColumnNamesInAlteredTable($diff); foreach ($foreignKeys as $key => $constraint) { $changed = \false; $localColumns = []; foreach ($constraint->getLocalColumns() as $columnName) { $normalizedColumnName = \strtolower($columnName); if (!isset($columnNames[$normalizedColumnName])) { unset($foreignKeys[$key]); continue 2; } else { $localColumns[] = $columnNames[$normalizedColumnName]; if ($columnName !== $columnNames[$normalizedColumnName]) { $changed = \true; } } } if (!$changed) { continue; } $foreignKeys[$key] = new \MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint($localColumns, $constraint->getForeignTableName(), $constraint->getForeignColumns(), $constraint->getName(), $constraint->getOptions()); } foreach ($diff->removedForeignKeys as $constraint) { $constraintName = \strtolower($constraint->getName()); if (!\strlen($constraintName) || !isset($foreignKeys[$constraintName])) { continue; } unset($foreignKeys[$constraintName]); } foreach (\array_merge($diff->changedForeignKeys, $diff->addedForeignKeys) as $constraint) { $constraintName = \strtolower($constraint->getName()); if (\strlen($constraintName)) { $foreignKeys[$constraintName] = $constraint; } else { $foreignKeys[] = $constraint; } } return $foreignKeys; } private function getPrimaryIndexInAlteredTable(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $primaryIndex = []; foreach ($this->getIndexesInAlteredTable($diff) as $index) { if (!$index->isPrimary()) { continue; } $primaryIndex = [$index->getName() => $index]; } return $primaryIndex; } } 