<?php
 namespace MailPoetVendor\Doctrine\DBAL; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Driver\Statement as DriverStatement; use MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform; use MailPoetVendor\Doctrine\DBAL\Types\Type; use IteratorAggregate; use PDO; use Throwable; use function is_array; use function is_string; class Statement implements \IteratorAggregate, \MailPoetVendor\Doctrine\DBAL\Driver\Statement { protected $sql; protected $params = []; protected $types = []; protected $stmt; protected $platform; protected $conn; public function __construct($sql, \MailPoetVendor\Doctrine\DBAL\Connection $conn) { $this->sql = $sql; $this->stmt = $conn->getWrappedConnection()->prepare($sql); $this->conn = $conn; $this->platform = $conn->getDatabasePlatform(); } public function bindValue($name, $value, $type = \MailPoetVendor\Doctrine\DBAL\ParameterType::STRING) { $this->params[$name] = $value; $this->types[$name] = $type; if ($type !== null) { if (\is_string($type)) { $type = \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($type); } if ($type instanceof \MailPoetVendor\Doctrine\DBAL\Types\Type) { $value = $type->convertToDatabaseValue($value, $this->platform); $bindingType = $type->getBindingType(); } else { $bindingType = $type; } return $this->stmt->bindValue($name, $value, $bindingType); } return $this->stmt->bindValue($name, $value); } public function bindParam($name, &$var, $type = \MailPoetVendor\Doctrine\DBAL\ParameterType::STRING, $length = null) { $this->params[$name] = $var; $this->types[$name] = $type; return $this->stmt->bindParam($name, $var, $type, $length); } public function execute($params = null) { if (\is_array($params)) { $this->params = $params; } $logger = $this->conn->getConfiguration()->getSQLLogger(); if ($logger) { $logger->startQuery($this->sql, $this->params, $this->types); } try { $stmt = $this->stmt->execute($params); } catch (\Throwable $ex) { if ($logger) { $logger->stopQuery(); } throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->conn->getDriver(), $ex, $this->sql, $this->conn->resolveParams($this->params, $this->types)); } if ($logger) { $logger->stopQuery(); } $this->params = []; $this->types = []; return $stmt; } public function closeCursor() { return $this->stmt->closeCursor(); } public function columnCount() { return $this->stmt->columnCount(); } public function errorCode() { return $this->stmt->errorCode(); } public function errorInfo() { return $this->stmt->errorInfo(); } public function setFetchMode($fetchMode, $arg2 = null, $arg3 = null) { if ($arg2 === null) { return $this->stmt->setFetchMode($fetchMode); } elseif ($arg3 === null) { return $this->stmt->setFetchMode($fetchMode, $arg2); } return $this->stmt->setFetchMode($fetchMode, $arg2, $arg3); } public function getIterator() { return $this->stmt; } public function fetch($fetchMode = null, $cursorOrientation = \PDO::FETCH_ORI_NEXT, $cursorOffset = 0) { return $this->stmt->fetch($fetchMode); } public function fetchAll($fetchMode = null, $fetchArgument = null, $ctorArgs = null) { if ($fetchArgument) { return $this->stmt->fetchAll($fetchMode, $fetchArgument); } return $this->stmt->fetchAll($fetchMode); } public function fetchColumn($columnIndex = 0) { return $this->stmt->fetchColumn($columnIndex); } public function rowCount() { return $this->stmt->rowCount(); } public function getWrappedStatement() { return $this->stmt; } } 