<?php
 namespace MailPoetVendor\Doctrine\DBAL\Types; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform; use const JSON_ERROR_NONE; use function is_resource; use function json_decode; use function json_encode; use function json_last_error; use function json_last_error_msg; use function stream_get_contents; class JsonType extends \MailPoetVendor\Doctrine\DBAL\Types\Type { public function getSQLDeclaration(array $fieldDeclaration, \MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform $platform) { return $platform->getJsonTypeDeclarationSQL($fieldDeclaration); } public function convertToDatabaseValue($value, \MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform $platform) { if ($value === null) { return null; } $encoded = \json_encode($value); if (\json_last_error() !== \JSON_ERROR_NONE) { throw \MailPoetVendor\Doctrine\DBAL\Types\ConversionException::conversionFailedSerialization($value, 'json', \json_last_error_msg()); } return $encoded; } public function convertToPHPValue($value, \MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform $platform) { if ($value === null || $value === '') { return null; } if (\is_resource($value)) { $value = \stream_get_contents($value); } $val = \json_decode($value, \true); if (\json_last_error() !== \JSON_ERROR_NONE) { throw \MailPoetVendor\Doctrine\DBAL\Types\ConversionException::conversionFailed($value, $this->getName()); } return $val; } public function getName() { return \MailPoetVendor\Doctrine\DBAL\Types\Type::JSON; } public function requiresSQLCommentHint(\MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform $platform) { return !$platform->hasNativeJsonType(); } } 