<?php
 namespace MailPoetVendor\Doctrine\ORM\Cache\Region; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\ORM\Cache\CollectionCacheEntry; use MailPoetVendor\Doctrine\ORM\Cache\Lock; use MailPoetVendor\Doctrine\ORM\Cache\Region; use MailPoetVendor\Doctrine\ORM\Cache\CacheKey; use MailPoetVendor\Doctrine\ORM\Cache\CacheEntry; use MailPoetVendor\Doctrine\ORM\Cache\ConcurrentRegion; class FileLockRegion implements \MailPoetVendor\Doctrine\ORM\Cache\ConcurrentRegion { const LOCK_EXTENSION = 'lock'; private $region; private $directory; private $lockLifetime; public function __construct(\MailPoetVendor\Doctrine\ORM\Cache\Region $region, $directory, $lockLifetime) { if (!\is_dir($directory) && !@\mkdir($directory, 0775, \true)) { throw new \InvalidArgumentException(\sprintf('The directory "%s" does not exist and could not be created.', $directory)); } if (!\is_writable($directory)) { throw new \InvalidArgumentException(\sprintf('The directory "%s" is not writable.', $directory)); } $this->region = $region; $this->directory = $directory; $this->lockLifetime = $lockLifetime; } private function isLocked(\MailPoetVendor\Doctrine\ORM\Cache\CacheKey $key, \MailPoetVendor\Doctrine\ORM\Cache\Lock $lock = null) { $filename = $this->getLockFileName($key); if (!\is_file($filename)) { return \false; } $time = $this->getLockTime($filename); $content = $this->getLockContent($filename); if (!$content || !$time) { @\unlink($filename); return \false; } if ($lock && $content === $lock->value) { return \false; } if ($time + $this->lockLifetime <= \time()) { @\unlink($filename); return \false; } return \true; } private function getLockFileName(\MailPoetVendor\Doctrine\ORM\Cache\CacheKey $key) { return $this->directory . \DIRECTORY_SEPARATOR . $key->hash . '.' . self::LOCK_EXTENSION; } private function getLockContent($filename) { return @\file_get_contents($filename); } private function getLockTime($filename) { return @\fileatime($filename); } public function getName() { return $this->region->getName(); } public function contains(\MailPoetVendor\Doctrine\ORM\Cache\CacheKey $key) { if ($this->isLocked($key)) { return \false; } return $this->region->contains($key); } public function get(\MailPoetVendor\Doctrine\ORM\Cache\CacheKey $key) { if ($this->isLocked($key)) { return null; } return $this->region->get($key); } public function getMultiple(\MailPoetVendor\Doctrine\ORM\Cache\CollectionCacheEntry $collection) { if (\array_filter(\array_map([$this, 'isLocked'], $collection->identifiers))) { return null; } return $this->region->getMultiple($collection); } public function put(\MailPoetVendor\Doctrine\ORM\Cache\CacheKey $key, \MailPoetVendor\Doctrine\ORM\Cache\CacheEntry $entry, \MailPoetVendor\Doctrine\ORM\Cache\Lock $lock = null) { if ($this->isLocked($key, $lock)) { return \false; } return $this->region->put($key, $entry); } public function evict(\MailPoetVendor\Doctrine\ORM\Cache\CacheKey $key) { if ($this->isLocked($key)) { @\unlink($this->getLockFileName($key)); } return $this->region->evict($key); } public function evictAll() { $filenames = \glob(\sprintf("%s/*.%s", $this->directory, self::LOCK_EXTENSION)); if ($filenames) { foreach ($filenames as $filename) { @\unlink($filename); } } return $this->region->evictAll(); } public function lock(\MailPoetVendor\Doctrine\ORM\Cache\CacheKey $key) { if ($this->isLocked($key)) { return null; } $lock = \MailPoetVendor\Doctrine\ORM\Cache\Lock::createLockRead(); $filename = $this->getLockFileName($key); if (!@\file_put_contents($filename, $lock->value, \LOCK_EX)) { return null; } \chmod($filename, 0664); return $lock; } public function unlock(\MailPoetVendor\Doctrine\ORM\Cache\CacheKey $key, \MailPoetVendor\Doctrine\ORM\Cache\Lock $lock) { if ($this->isLocked($key, $lock)) { return \false; } if (!@\unlink($this->getLockFileName($key))) { return \false; } return \true; } } 