<?php
 namespace MailPoetVendor\Egulias\EmailValidator; if (!defined('ABSPATH')) exit; use MailPoetVendor\Egulias\EmailValidator\Exception\ExpectingATEXT; use MailPoetVendor\Egulias\EmailValidator\Exception\NoLocalPart; use MailPoetVendor\Egulias\EmailValidator\Parser\DomainPart; use MailPoetVendor\Egulias\EmailValidator\Parser\LocalPart; use MailPoetVendor\Egulias\EmailValidator\Warning\EmailTooLong; class EmailParser { const EMAIL_MAX_LENGTH = 254; protected $warnings = []; protected $domainPart = ''; protected $localPart = ''; protected $lexer; protected $localPartParser; protected $domainPartParser; public function __construct(\MailPoetVendor\Egulias\EmailValidator\EmailLexer $lexer) { $this->lexer = $lexer; $this->localPartParser = new \MailPoetVendor\Egulias\EmailValidator\Parser\LocalPart($this->lexer); $this->domainPartParser = new \MailPoetVendor\Egulias\EmailValidator\Parser\DomainPart($this->lexer); } public function parse($str) { $this->lexer->setInput($str); if (!$this->hasAtToken()) { throw new \MailPoetVendor\Egulias\EmailValidator\Exception\NoLocalPart(); } $this->localPartParser->parse($str); $this->domainPartParser->parse($str); $this->setParts($str); if ($this->lexer->hasInvalidTokens()) { throw new \MailPoetVendor\Egulias\EmailValidator\Exception\ExpectingATEXT(); } return array('local' => $this->localPart, 'domain' => $this->domainPart); } public function getWarnings() { $localPartWarnings = $this->localPartParser->getWarnings(); $domainPartWarnings = $this->domainPartParser->getWarnings(); $this->warnings = \array_merge($localPartWarnings, $domainPartWarnings); $this->addLongEmailWarning($this->localPart, $this->domainPart); return $this->warnings; } public function getParsedDomainPart() { return $this->domainPart; } protected function setParts($email) { $parts = \explode('@', $email); $this->domainPart = $this->domainPartParser->getDomainPart(); $this->localPart = $parts[0]; } protected function hasAtToken() { $this->lexer->moveNext(); $this->lexer->moveNext(); if ($this->lexer->token['type'] === \MailPoetVendor\Egulias\EmailValidator\EmailLexer::S_AT) { return \false; } return \true; } protected function addLongEmailWarning($localPart, $parsedDomainPart) { if (\strlen($localPart . '@' . $parsedDomainPart) > self::EMAIL_MAX_LENGTH) { $this->warnings[\MailPoetVendor\Egulias\EmailValidator\Warning\EmailTooLong::CODE] = new \MailPoetVendor\Egulias\EmailValidator\Warning\EmailTooLong(); } } } 