<?php
 namespace MailPoetVendor\Symfony\Component\Validator\Constraints; if (!defined('ABSPATH')) exit; use MailPoetVendor\Symfony\Component\Intl\Countries; use MailPoetVendor\Symfony\Component\PropertyAccess\Exception\NoSuchPropertyException; use MailPoetVendor\Symfony\Component\PropertyAccess\PropertyAccess; use MailPoetVendor\Symfony\Component\PropertyAccess\PropertyAccessor; use MailPoetVendor\Symfony\Component\Validator\Constraint; use MailPoetVendor\Symfony\Component\Validator\ConstraintValidator; use MailPoetVendor\Symfony\Component\Validator\Exception\ConstraintDefinitionException; use MailPoetVendor\Symfony\Component\Validator\Exception\LogicException; use MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedTypeException; use MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedValueException; class BicValidator extends \MailPoetVendor\Symfony\Component\Validator\ConstraintValidator { private const BIC_COUNTRY_TO_IBAN_COUNTRY_MAP = [ 'GF' => 'FR', 'PF' => 'FR', 'TF' => 'FR', 'GP' => 'FR', 'MQ' => 'FR', 'YT' => 'FR', 'NC' => 'FR', 'RE' => 'FR', 'PM' => 'FR', 'WF' => 'FR', 'JE' => 'GB', 'IM' => 'GB', 'GG' => 'GB', 'VG' => 'GB', ]; private $propertyAccessor; public function __construct(\MailPoetVendor\Symfony\Component\PropertyAccess\PropertyAccessor $propertyAccessor = null) { $this->propertyAccessor = $propertyAccessor; } public function validate($value, \MailPoetVendor\Symfony\Component\Validator\Constraint $constraint) { if (!$constraint instanceof \MailPoetVendor\Symfony\Component\Validator\Constraints\Bic) { throw new \MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedTypeException($constraint, \MailPoetVendor\Symfony\Component\Validator\Constraints\Bic::class); } if (null === $value || '' === $value) { return; } if (!\is_scalar($value) && !(\is_object($value) && \method_exists($value, '__toString'))) { throw new \MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedValueException($value, 'string'); } $canonicalize = \str_replace(' ', '', $value); if (!\in_array(\strlen($canonicalize), [8, 11])) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Bic::INVALID_LENGTH_ERROR)->addViolation(); return; } if (!\ctype_alnum($canonicalize)) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Bic::INVALID_CHARACTERS_ERROR)->addViolation(); return; } if (!\ctype_alpha(\substr($canonicalize, 0, 4))) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Bic::INVALID_BANK_CODE_ERROR)->addViolation(); return; } if (\class_exists(\MailPoetVendor\Symfony\Component\Intl\Countries::class)) { $validCountryCode = \MailPoetVendor\Symfony\Component\Intl\Countries::exists(\substr($canonicalize, 4, 2)); } else { $validCountryCode = \ctype_alpha(\substr($canonicalize, 4, 2)); } if (!$validCountryCode) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Bic::INVALID_COUNTRY_CODE_ERROR)->addViolation(); return; } if (\strtoupper($canonicalize) !== $canonicalize) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Bic::INVALID_CASE_ERROR)->addViolation(); return; } $iban = $constraint->iban; $path = $constraint->ibanPropertyPath; if ($path && null !== ($object = $this->context->getObject())) { try { $iban = $this->getPropertyAccessor()->getValue($object, $path); } catch (\MailPoetVendor\Symfony\Component\PropertyAccess\Exception\NoSuchPropertyException $e) { throw new \MailPoetVendor\Symfony\Component\Validator\Exception\ConstraintDefinitionException(\sprintf('Invalid property path "%s" provided to "%s" constraint: ', $path, \get_class($constraint)) . $e->getMessage(), 0, $e); } } if (!$iban) { return; } $ibanCountryCode = \substr($iban, 0, 2); if (\ctype_alpha($ibanCountryCode) && !$this->bicAndIbanCountriesMatch(\substr($canonicalize, 4, 2), $ibanCountryCode)) { $this->context->buildViolation($constraint->ibanMessage)->setParameter('{{ value }}', $this->formatValue($value))->setParameter('{{ iban }}', $iban)->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Bic::INVALID_IBAN_COUNTRY_CODE_ERROR)->addViolation(); } } private function getPropertyAccessor() : \MailPoetVendor\Symfony\Component\PropertyAccess\PropertyAccessor { if (null === $this->propertyAccessor) { if (!\class_exists(\MailPoetVendor\Symfony\Component\PropertyAccess\PropertyAccess::class)) { throw new \MailPoetVendor\Symfony\Component\Validator\Exception\LogicException('Unable to use property path as the Symfony PropertyAccess component is not installed.'); } $this->propertyAccessor = \MailPoetVendor\Symfony\Component\PropertyAccess\PropertyAccess::createPropertyAccessor(); } return $this->propertyAccessor; } private function bicAndIbanCountriesMatch(string $bicCountryCode, string $ibanCountryCode) : bool { return $ibanCountryCode === $bicCountryCode || $ibanCountryCode === (self::BIC_COUNTRY_TO_IBAN_COUNTRY_MAP[$bicCountryCode] ?? null); } } 