<?php
 namespace MailPoetVendor\Symfony\Component\Validator\Constraints; if (!defined('ABSPATH')) exit; use MailPoetVendor\Symfony\Component\Validator\Constraint; use MailPoetVendor\Symfony\Component\Validator\ConstraintValidator; use MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedTypeException; class CardSchemeValidator extends \MailPoetVendor\Symfony\Component\Validator\ConstraintValidator { protected $schemes = [ 'AMEX' => ['/^3[47][0-9]{13}$/'], 'CHINA_UNIONPAY' => ['/^62[0-9]{14,17}$/'], 'DINERS' => ['/^3(?:0[0-5]|[68][0-9])[0-9]{11}$/'], 'DISCOVER' => ['/^6011[0-9]{12}$/', '/^64[4-9][0-9]{13}$/', '/^65[0-9]{14}$/', '/^622(12[6-9]|1[3-9][0-9]|[2-8][0-9][0-9]|91[0-9]|92[0-5])[0-9]{10}$/'], 'INSTAPAYMENT' => ['/^63[7-9][0-9]{13}$/'], 'JCB' => ['/^(?:2131|1800|35[0-9]{3})[0-9]{11}$/'], 'LASER' => ['/^(6304|670[69]|6771)[0-9]{12,15}$/'], 'MAESTRO' => ['/^(6759[0-9]{2})[0-9]{6,13}$/', '/^(50[0-9]{4})[0-9]{6,13}$/', '/^5[6-9][0-9]{10,17}$/', '/^6[0-9]{11,18}$/'], 'MASTERCARD' => ['/^5[1-5][0-9]{14}$/', '/^2(22[1-9][0-9]{12}|2[3-9][0-9]{13}|[3-6][0-9]{14}|7[0-1][0-9]{13}|720[0-9]{12})$/'], 'MIR' => ['/^220[0-4][0-9]{12}$/'], 'UATP' => ['/^1[0-9]{14}$/'], 'VISA' => ['/^4([0-9]{12}|[0-9]{15}|[0-9]{18})$/'], ]; public function validate($value, \MailPoetVendor\Symfony\Component\Validator\Constraint $constraint) { if (!$constraint instanceof \MailPoetVendor\Symfony\Component\Validator\Constraints\CardScheme) { throw new \MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedTypeException($constraint, \MailPoetVendor\Symfony\Component\Validator\Constraints\CardScheme::class); } if (null === $value || '' === $value) { return; } if (!\is_numeric($value)) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\CardScheme::NOT_NUMERIC_ERROR)->addViolation(); return; } $schemes = \array_flip((array) $constraint->schemes); $schemeRegexes = \array_intersect_key($this->schemes, $schemes); foreach ($schemeRegexes as $regexes) { foreach ($regexes as $regex) { if (\preg_match($regex, $value)) { return; } } } $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\CardScheme::INVALID_FORMAT_ERROR)->addViolation(); } } 