<?php
 namespace MailPoetVendor\Twig; if (!defined('ABSPATH')) exit; final class Token { private $value; private $type; private $lineno; const EOF_TYPE = -1; const TEXT_TYPE = 0; const BLOCK_START_TYPE = 1; const VAR_START_TYPE = 2; const BLOCK_END_TYPE = 3; const VAR_END_TYPE = 4; const NAME_TYPE = 5; const NUMBER_TYPE = 6; const STRING_TYPE = 7; const OPERATOR_TYPE = 8; const PUNCTUATION_TYPE = 9; const INTERPOLATION_START_TYPE = 10; const INTERPOLATION_END_TYPE = 11; const ARROW_TYPE = 12; public function __construct($type, $value, $lineno) { $this->type = $type; $this->value = $value; $this->lineno = $lineno; } public function __toString() { return \sprintf('%s(%s)', self::typeToString($this->type, \true), $this->value); } public function test($type, $values = null) { if (null === $values && !\is_int($type)) { $values = $type; $type = self::NAME_TYPE; } return $this->type === $type && (null === $values || \is_array($values) && \in_array($this->value, $values) || $this->value == $values); } public function getLine() { return $this->lineno; } public function getType() { return $this->type; } public function getValue() { return $this->value; } public static function typeToString($type, $short = \false) { switch ($type) { case self::EOF_TYPE: $name = 'EOF_TYPE'; break; case self::TEXT_TYPE: $name = 'TEXT_TYPE'; break; case self::BLOCK_START_TYPE: $name = 'BLOCK_START_TYPE'; break; case self::VAR_START_TYPE: $name = 'VAR_START_TYPE'; break; case self::BLOCK_END_TYPE: $name = 'BLOCK_END_TYPE'; break; case self::VAR_END_TYPE: $name = 'VAR_END_TYPE'; break; case self::NAME_TYPE: $name = 'NAME_TYPE'; break; case self::NUMBER_TYPE: $name = 'NUMBER_TYPE'; break; case self::STRING_TYPE: $name = 'STRING_TYPE'; break; case self::OPERATOR_TYPE: $name = 'OPERATOR_TYPE'; break; case self::PUNCTUATION_TYPE: $name = 'PUNCTUATION_TYPE'; break; case self::INTERPOLATION_START_TYPE: $name = 'INTERPOLATION_START_TYPE'; break; case self::INTERPOLATION_END_TYPE: $name = 'INTERPOLATION_END_TYPE'; break; case self::ARROW_TYPE: $name = 'ARROW_TYPE'; break; default: throw new \LogicException(\sprintf('Token of type "%s" does not exist.', $type)); } return $short ? $name : 'MailPoetVendor\\Twig\\Token::' . $name; } public static function typeToEnglish($type) { switch ($type) { case self::EOF_TYPE: return 'end of template'; case self::TEXT_TYPE: return 'text'; case self::BLOCK_START_TYPE: return 'begin of statement block'; case self::VAR_START_TYPE: return 'begin of print statement'; case self::BLOCK_END_TYPE: return 'end of statement block'; case self::VAR_END_TYPE: return 'end of print statement'; case self::NAME_TYPE: return 'name'; case self::NUMBER_TYPE: return 'number'; case self::STRING_TYPE: return 'string'; case self::OPERATOR_TYPE: return 'operator'; case self::PUNCTUATION_TYPE: return 'punctuation'; case self::INTERPOLATION_START_TYPE: return 'begin of string interpolation'; case self::INTERPOLATION_END_TYPE: return 'end of string interpolation'; case self::ARROW_TYPE: return 'arrow function'; default: throw new \LogicException(\sprintf('Token of type "%s" does not exist.', $type)); } } } \class_alias('MailPoetVendor\\Twig\\Token', 'MailPoetVendor\\Twig_Token'); 