<?php
/**
 * The loop that displays posts.
 *
 * The loop displays the posts and the post content.  See
 * http://codex.wordpress.org/The_Loop to understand it and
 * http://codex.wordpress.org/Template_Tags to understand
 * the tags used in it.
 *
 * This can be overridden in child themes with loop.php or
 * loop-template.php, where 'template' is the loop context
 * requested by a template. For example, loop-index.php would
 * be used if it exists and we ask for the loop with:
 * <code>get_template_part( 'loop', 'index' );</code>
 */
?>
<?php /* Display navigation to next/previous pages when applicable */ ?>
<?php if ( $wp_query->max_num_pages > 1 && of_get_option('display_postnav_above', '1')==1 ) : ?>
	<div id="nav-above" class="navigation">
		<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'ntp_framework' ) ); ?></div>
		<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'ntp_framework' ) ); ?></div>
	</div><!-- #nav-above -->
<?php endif; ?>

<?php /* If there are no posts to display, such as an empty archive page */ ?>
<?php if ( ! have_posts() ) : ?>
	<div id="post-0" class="post error404 not-found">
		<h1 class="entry-title"><?php _e( 'Not Found', 'ntp_framework' ); ?></h1>
		<div class="entry-content">
			<p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'ntp_framework' ); ?></p>
			<?php get_search_form(); ?>
		</div><!-- .entry-content -->
	</div><!-- #post-0 -->
<?php endif; ?>

<?php 
// The basic loop
while ( have_posts() ) : the_post(); ?>
	
<?php /* Create a div with a unique ID thanks to the_ID() and semantic classes with post_class() */ ?>  
    <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>    
<?php /* an h2 title */ ?>      
     <h2 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php printf( __('Permalink to %s', 'ntp_framework'), the_title_attribute('echo=0') ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
     
<?php /* Microformatted, translatable post meta */ ?>          
     <div class="entry-meta">
       
<?php /* The entry content */ ?>    
     <div class="entry-content">
     
	<?php // Post Thumbnail
	if (of_get_option('display_thumbnail', '') ==1) :
	    if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
	    	echo '<a href="' . get_permalink() . '">';
			the_post_thumbnail( of_get_option('display_thumbnail_size', 'thumbnail'), 'class=alignleft' );
			echo '</a>';
		} 
	endif;
	
	// Content or excerpt display
	if (of_get_option('blog_page_content_type', 'content') =='content') :
		the_content( __( 'Continue reading <span class="meta-nav">&raquo;</span>', 'ntp_framework' )  );
	else:	
		the_excerpt();
	endif;
	?>
	
	<?php wp_link_pages('before=<div class="page-link">' . __( 'Pages:', 'ntp_framework' ) . '&after=</div>') ?>
     </div><!-- .entry-content -->
 
<?php /* Microformatted category and tag links along with a comments link */ ?>    
        </div><!-- #post-<?php the_ID(); ?> -->

<?php 
// End the loop
endwhile; ?>

<?php /* Display navigation to next/previous pages when applicable */ ?>
<?php if (  $wp_query->max_num_pages > 1 && of_get_option('display_postnav_below', '1')==1 ) : ?>
				<div id="nav-below" class="navigation">
					<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'ntp_framework' ) ); ?></div>
					<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'ntp_framework' ) ); ?></div>
				</div><!-- #nav-below -->
<?php endif; ?>