<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 * 
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet (lowercase and without spaces)
	$themename = get_option( 'stylesheet' );
	$themename = preg_replace("/\W/", "", strtolower($themename) );
	
	$optionsframework_settings = get_option('optionsframework');
	$optionsframework_settings['id'] = $themename;
	update_option('optionsframework', $optionsframework_settings);
	
	// echo $themename;
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the "id" fields, make sure to use all lowercase and no spaces.
 *  
 */

function optionsframework_options() {
	
	// Test data
	$test_array = array("one" => "One","two" => "Two","three" => "Three","four" => "Four","five" => "Five");
	
	// Multicheck Array
	$multicheck_array = array("one" => "French Toast", "two" => "Pancake", "three" => "Omelette", "four" => "Crepe", "five" => "Waffle");
	
	// Multicheck Defaults
	$multicheck_defaults = array("one" => "true","five" => "true");
	
	// Background Defaults
	
	$background_defaults = array('color' => '', 'image' => '', 'repeat' => 'repeat','position' => 'top center','attachment'=>'scroll');
	
	
	// Pull all the categories into an array
	$options_categories = array();  
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
    	$options_categories[$category->cat_ID] = $category->cat_name;
	}
	
	// Pull all the pages into an array
	$options_pages = array();  
	$options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	$options_pages['false'] = 'Select a page:';
	foreach ($options_pages_obj as $page) {
    	$options_pages[$page->ID] = $page->post_title;
	}
		
	// If using image radio buttons, define a directory path
	$imagepath =  get_template_directory_uri() . '/includes/admin/images/';
		
	$options = array();
		
	$options[] = array( "name" => "Basic Settings",
						"type" => "heading");
	
	$options[] = array( "name" => __( 'Logo', 'ntp_framework' ),
						"desc" => __( 'This image will be used instead of the site title.', 'ntp_framework' ),
						"id" => "logo",
						"type" => "upload");
						
	$options[] = array( "name" => __( 'Favicon', 'ntp_framework' ),
						"desc" => __( 'You can use a ico, png or gif image.', 'ntp_framework' ),
						"id" => "favicon",
						"type" => "upload");
	
	$options[] = array( "name" => __( 'Show Site Tagline', 'ntp_framework' ),
						"desc" => __( 'You can set your site Tagline in Settings > General.', 'ntp_framework' ),
						"id" => "show_tagline",
						"std" => "true",
						"type" => "checkbox");
						
	$options[] = array( "name" => __( 'Remove Comments on pages', 'ntp_framework' ),
						"desc" => __( 'Comments and Trackbacks can also be disabled on a per post/page basis when creating/editing posts/pages.', 'ntp_framework' ),
						"id" => "remove_comments",
						"std" => "true",
						"type" => "checkbox");
						
	$options[] = array( "name" => __( 'Include Primary Navigation Menu (above site title)', 'ntp_framework' ),
						"desc" => __( 'In order to use the navigation menus, you must build a custom menu, then assign it to the proper Menu Location.', 'ntp_framework' ),
						"id" => "show_primarynav",
						"std" => "",
						"type" => "checkbox");
						
	$options[] = array( "name" => __( 'Include Secondary Navigation Menu (below site title)', 'ntp_framework' ),
						"desc" => __( 'In order to use the navigation menus, you must build a custom menu, then assign it to the proper Menu Location.', 'ntp_framework' ),
						"id" => "show_secondarynav",
						"std" => "1",
						"type" => "checkbox");
						
	$options[] = array( "name" => __( 'Default Layout', 'ntp_framework' ),
						"desc" => __( 'Set the default layout of the site here. This can be changed on individual pages.', 'ntp_framework' ),
						"id" => "themelayout",
						"std" => "2c-r-fixed",
						"type" => "images",
						"options" => array(
							'1col-fixed' => $imagepath . '1col.png',
							'2c-r-fixed' => $imagepath . '2cr.png',
							'2c-l-fixed' => $imagepath . '2cl.png',
							'3c-m-fixed' => $imagepath . '3cm.png')
						);
						
	$options[] = array( "name" => "Post Settings",
						"type" => "heading");
						
	$options[] = array( "name" => __( 'Content to display on blog page', 'ntp_framework' ),
						"desc" => __( 'You can choose between showing full posts or excerpts', 'ntp_framework' ),
						"id" => "blog_page_content_type",
						"std" => "content",
						"type" => "select",
						"options" => array(
							'content' => 'Content',
							'excerpt' => 'Excerpt')
						);
	
	$options[] = array( "name" =>  __( 'Post Header Meta', 'ntp_framework' ),
						"desc" => __( 'Control the meta information displayed on each post. You can use the shortcodes: [author], [categories], [comments], [date], [time], [tags] and [edit].', 'ntp_framework' ),
						"id" => "post_header_meta",
						"std" => __( 'By', 'ntp_framework' ) . ' [author] ' .  __( 'Published', 'ntp_framework' ) . ' [date]',
						"type" => "text");
						
	$options[] = array( "name" =>  __( 'Post Footer Meta', 'ntp_framework' ),
						"desc" => __( 'Control the meta information displayed on each post. You can use the shortcodes: [author], [categories], [comments], [date], [time], [tags] and [edit].', 'ntp_framework' ),
						"id" => "post_footer_meta",
						"std" => __( 'Posted in', 'ntp_framework' ) . ' [categories] [tags] | [comments]',
						"type" => "text");
						
	$options[] = array( "name" => __( 'Display Post navigation above posts', 'ntp_framework' ),
						"desc" => __( 'Check the box if you want to show navigation for prev/next post above content on your Blog page.', 'ntp_framework' ),
						"id" => "display_postnav_above",
						"std" => "1",
						"type" => "checkbox");
						
	$options[] = array( "name" => __( 'Display Post navigation below posts', 'ntp_framework' ),
						"desc" => __( 'Check the box if you want to show navigation for prev/next post below content on your Blog page.', 'ntp_framework' ),
						"id" => "display_postnav_below",
						"std" => "1",
						"type" => "checkbox");
	
	$options[] = array( "name" => __( 'Display Post Thumbnail on Blog page', 'ntp_framework' ),
						"desc" => __( 'Check the box if you want to use Post Thumbnail on your Blog page.', 'ntp_framework' ),
						"id" => "display_thumbnail",
						"std" => "",
						"type" => "checkbox");
						
						
	$options[] = array( "name" => __( 'Post Thumbnail size on Blog page', 'ntp_framework' ),
						"desc" => __( 'Choose size of the Post Thumbnail image', 'ntp_framework' ),
						"id" => "display_thumbnail_size",
						"std" => "thumbnail",
						"type" => "select",
						"options" => array(
							'thumbnail' => 'Thumbnail',
							'medium' => 'Medium',
							'large' => 'Large',
							'full' => 'Full')
						);
						
	
	return $options;
}